/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LabelFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class LabeledStatement
extends Statement {
    public Statement statement;
    public char[] label;
    public Label targetLabel;
    public int a = -1;

    public LabeledStatement(char[] cArray, Statement statement, int n2, int n3) {
        this.statement = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
        this.label = cArray;
        this.sourceStart = n2;
        this.sourceEnd = n3;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.statement == null) {
            return flowInfo;
        }
        this.targetLabel = new Label();
        LabelFlowContext labelFlowContext = new LabelFlowContext(flowContext, this, this.label, this.targetLabel, blockScope);
        UnconditionalFlowInfo unconditionalFlowInfo = this.statement.analyseCode(blockScope, labelFlowContext, flowInfo).mergedWith(labelFlowContext.initsOnBreak);
        this.a = blockScope.methodScope().recordInitializationStates(unconditionalFlowInfo);
        return unconditionalFlowInfo;
    }

    public ASTNode concreteStatement() {
        return this.statement;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n2 = codeStream.position;
        if (this.targetLabel != null) {
            this.targetLabel.initialize(codeStream);
            if (this.statement != null) {
                this.statement.generateCode(blockScope, codeStream);
            }
            this.targetLabel.place();
        }
        if (this.a != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.a);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.a);
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public StringBuffer printStatement(int n2, StringBuffer stringBuffer) {
        LabeledStatement.printIndent(n2, stringBuffer).append(this.label).append(": ");
        if (this.statement == null) {
            stringBuffer.append(';');
        } else {
            this.statement.printStatement(0, stringBuffer);
        }
        return stringBuffer;
    }

    public void resolve(BlockScope blockScope) {
        if (this.statement != null) {
            this.statement.resolve(blockScope);
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.statement != null) {
            this.statement.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

