/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class ForeachStatement
extends Statement {
    public LocalDeclaration elementVariable;
    public int elementVariableImplicitWidening = -1;
    public Expression collection;
    public Statement action;
    private int kind;
    private static final int ARRAY = 0;
    private static final int RAW_ITERABLE = 1;
    private static final int GENERIC_ITERABLE = 2;
    private TypeBinding iteratorReceiverType;
    private TypeBinding collectionElementType;
    private Label breakLabel;
    private Label continueLabel;
    public BlockScope scope;
    public LocalVariableBinding indexVariable;
    public LocalVariableBinding collectionVariable;
    public LocalVariableBinding maxVariable;
    private static final char[] SecretIndexVariableName = " index".toCharArray();
    private static final char[] SecretCollectionVariableName = " collection".toCharArray();
    private static final char[] SecretMaxVariableName = " max".toCharArray();
    public int b = -1;
    public int a = -1;

    public ForeachStatement(LocalDeclaration localDeclaration, Expression expression, int n2) {
        this.elementVariable = localDeclaration;
        this.collection = expression;
        this.sourceStart = n2;
        this.kind = -1;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo flowInfo2;
        this.breakLabel = new Label();
        this.continueLabel = new Label();
        flowInfo = this.elementVariable.analyseCode(this.scope, flowContext, flowInfo);
        FlowInfo flowInfo3 = flowInfo.copy().unconditionalInits().discardNullRelatedInitializations();
        flowInfo3 = this.collection.analyseCode(this.scope, flowContext, flowInfo3);
        flowInfo3.markAsDefinitelyAssigned(this.elementVariable.binding);
        this.b = blockScope.methodScope().recordInitializationStates(flowInfo3);
        LoopingFlowContext loopingFlowContext = new LoopingFlowContext(flowContext, this, this.breakLabel, this.continueLabel, this.scope);
        FlowInfo flowInfo4 = flowInfo3.initsWhenTrue().copy();
        if (!(this.action == null || this.action.isEmptyBlock() && blockScope.compilerOptions().complianceLevel <= 0x2F0000L)) {
            if (!this.action.complainIfUnreachable(flowInfo4, this.scope, false)) {
                flowInfo4 = this.action.analyseCode(this.scope, loopingFlowContext, flowInfo4);
            }
            flowInfo2 = flowInfo3.initsWhenFalse();
            flowInfo2.addInitializationsFrom(flowInfo);
            if (!flowInfo4.isReachable() && !loopingFlowContext.initsOnContinue.isReachable()) {
                this.continueLabel = null;
            } else {
                flowInfo4 = flowInfo4.mergedWith(loopingFlowContext.initsOnContinue.unconditionalInits());
                loopingFlowContext.complainOnDeferredChecks(this.scope, flowInfo4);
                flowInfo2.addPotentialInitializationsFrom(flowInfo4.unconditionalInits());
            }
        } else {
            flowInfo2 = flowInfo3.initsWhenFalse();
        }
        if (this.action != null && !this.action.isEmptyBlock() && (this.action.bits & 1) == 0) {
            switch (this.kind) {
                case 0: {
                    this.collectionVariable.useFlag = 1;
                    this.indexVariable.useFlag = 1;
                    this.maxVariable.useFlag = 1;
                    break;
                }
                case 1: 
                case 2: {
                    this.indexVariable.useFlag = 1;
                }
            }
        }
        FlowInfo flowInfo5 = FlowInfo.mergedOptimizedBranches(loopingFlowContext.initsOnBreak, false, flowInfo2, false, true);
        this.a = blockScope.methodScope().recordInitializationStates(flowInfo5);
        return flowInfo5;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        Object object;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n2 = codeStream.position;
        if (this.action == null || this.action.isEmptyBlock() || (this.action.bits & 1) != 0) {
            codeStream.exitUserScope(this.scope);
            if (this.a != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.a);
                codeStream.addDefinitelyAssignedVariables(blockScope, this.a);
            }
            codeStream.recordPositionsFrom(n2, this.sourceStart);
            return;
        }
        switch (this.kind) {
            case 0: {
                this.collection.generateCode(this.scope, codeStream, true);
                codeStream.store(this.collectionVariable, false);
                codeStream.iconst_0();
                codeStream.store(this.indexVariable, false);
                codeStream.load(this.collectionVariable);
                codeStream.arraylength();
                codeStream.store(this.maxVariable, false);
                break;
            }
            case 1: 
            case 2: {
                this.collection.generateCode(this.scope, codeStream, true);
                object = new MethodBinding(1, "iterator".toCharArray(), this.scope.getJavaUtilIterator(), TypeConstants.NoParameters, TypeConstants.NoExceptions, (ReferenceBinding)this.iteratorReceiverType.erasure());
                if (this.iteratorReceiverType.isInterface()) {
                    codeStream.invokeinterface((MethodBinding)object);
                } else {
                    codeStream.invokevirtual((MethodBinding)object);
                }
                codeStream.store(this.indexVariable, false);
            }
        }
        object = new Label(codeStream);
        Label label = new Label(codeStream);
        this.breakLabel.initialize(codeStream);
        if (this.continueLabel != null) {
            this.continueLabel.initialize(codeStream);
        }
        codeStream.goto_(label);
        ((Label)object).place();
        if (this.elementVariable.binding.resolvedPosition != -1) {
            switch (this.kind) {
                case 0: {
                    codeStream.load(this.collectionVariable);
                    codeStream.load(this.indexVariable);
                    codeStream.arrayAt(this.collectionElementType.id);
                    if (this.elementVariableImplicitWidening != -1) {
                        codeStream.generateImplicitConversion(this.elementVariableImplicitWidening);
                    }
                    codeStream.store(this.elementVariable.binding, false);
                    break;
                }
                case 1: 
                case 2: {
                    codeStream.load(this.indexVariable);
                    codeStream.invokeJavaUtilIteratorNext();
                    if (this.elementVariable.binding.type.id != 1) {
                        if (this.elementVariableImplicitWidening != -1) {
                            codeStream.checkcast(this.collectionElementType);
                            codeStream.generateImplicitConversion(this.elementVariableImplicitWidening);
                        } else {
                            codeStream.checkcast(this.elementVariable.binding.type);
                        }
                    }
                    codeStream.store(this.elementVariable.binding, false);
                }
            }
            codeStream.addVisibleLocalVariable(this.elementVariable.binding);
            if (this.b != -1) {
                codeStream.addDefinitelyAssignedVariables(blockScope, this.b);
            }
        } else {
            switch (this.kind) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: {
                    codeStream.load(this.indexVariable);
                    codeStream.invokeJavaUtilIteratorNext();
                    codeStream.pop();
                }
            }
        }
        this.action.generateCode(this.scope, codeStream);
        int n3 = codeStream.position;
        if (this.continueLabel != null) {
            this.continueLabel.place();
            switch (this.kind) {
                case 0: {
                    codeStream.iinc(this.indexVariable.resolvedPosition, 1);
                    break;
                }
            }
        }
        label.place();
        if (this.b != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.b);
        }
        switch (this.kind) {
            case 0: {
                codeStream.load(this.indexVariable);
                codeStream.load(this.maxVariable);
                codeStream.if_icmplt((Label)object);
                break;
            }
            case 1: 
            case 2: {
                codeStream.load(this.indexVariable);
                codeStream.invokeJavaUtilIteratorHasNext();
                codeStream.ifne((Label)object);
            }
        }
        codeStream.recordPositionsFrom(n3, this.elementVariable.sourceStart);
        this.breakLabel.place();
        codeStream.exitUserScope(this.scope);
        if (this.a != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.a);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.a);
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public StringBuffer printStatement(int n2, StringBuffer stringBuffer) {
        ForeachStatement.printIndent(n2, stringBuffer).append("for (");
        this.elementVariable.print(0, stringBuffer);
        stringBuffer.append(" : ");
        this.collection.print(0, stringBuffer).append(") ");
        if (this.action == null) {
            stringBuffer.append(';');
        } else {
            stringBuffer.append('\n');
            this.action.printStatement(n2 + 1, stringBuffer);
        }
        return stringBuffer;
    }

    public void resolve(BlockScope blockScope) {
        boolean bl2;
        this.scope = new BlockScope(blockScope);
        this.elementVariable.resolve(this.scope);
        TypeBinding typeBinding = this.elementVariable.type.resolvedType;
        TypeBinding typeBinding2 = this.collection.resolveType(this.scope);
        boolean bl3 = bl2 = typeBinding == null || typeBinding2 == null;
        if (!bl2) {
            block32: {
                ReferenceBinding referenceBinding;
                if (typeBinding2.isArrayType()) {
                    this.kind = 0;
                    this.collection.computeConversion(this.scope, typeBinding2, typeBinding2);
                    this.collectionElementType = ((ArrayBinding)typeBinding2).elementsType();
                    if (!this.collectionElementType.isCompatibleWith(typeBinding) && !this.scope.isBoxingCompatibleWith(this.collectionElementType, typeBinding)) {
                        this.scope.problemReporter().notCompatibleTypesErrorInForeach(this.collection, this.collectionElementType, typeBinding);
                    }
                    int n2 = this.collectionElementType.id;
                    if (typeBinding.isBaseType()) {
                        if (!this.collectionElementType.isBaseType()) {
                            n2 = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                            this.elementVariableImplicitWidening = 1024;
                            if (typeBinding.isBaseType()) {
                                this.elementVariableImplicitWidening |= (typeBinding.id << 4) + n2;
                                this.scope.problemReporter().autoboxing(this.collection, this.collectionElementType, typeBinding);
                            }
                        } else {
                            this.elementVariableImplicitWidening = (typeBinding.id << 4) + n2;
                        }
                    } else if (this.collectionElementType.isBaseType()) {
                        int n3 = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                        this.elementVariableImplicitWidening = 0x200 | n2 << 4 | n2;
                        n2 = n3;
                        this.scope.problemReporter().autoboxing(this.collection, this.collectionElementType, typeBinding);
                    }
                } else if (typeBinding2 instanceof ReferenceBinding && (referenceBinding = ((ReferenceBinding)typeBinding2).findSuperTypeErasingTo(38, false)) != null) {
                    this.iteratorReceiverType = typeBinding2.erasure();
                    if (((ReferenceBinding)this.iteratorReceiverType).findSuperTypeErasingTo(38, false) == null) {
                        this.iteratorReceiverType = referenceBinding;
                        this.collection.computeConversion(this.scope, referenceBinding, typeBinding2);
                    } else {
                        this.collection.computeConversion(this.scope, typeBinding2, typeBinding2);
                    }
                    TypeBinding[] typeBindingArray = null;
                    switch (referenceBinding.kind()) {
                        case 1028: {
                            this.kind = 1;
                            this.collectionElementType = this.scope.getJavaLangObject();
                            if (!this.collectionElementType.isCompatibleWith(typeBinding) && !this.scope.isBoxingCompatibleWith(this.collectionElementType, typeBinding)) {
                                this.scope.problemReporter().notCompatibleTypesErrorInForeach(this.collection, this.collectionElementType, typeBinding);
                            }
                            break block32;
                        }
                        case 2052: {
                            typeBindingArray = referenceBinding.typeVariables();
                            break;
                        }
                        case 260: {
                            typeBindingArray = ((ParameterizedTypeBinding)referenceBinding).arguments;
                            break;
                        }
                        default: {
                            break block32;
                        }
                    }
                    if (typeBindingArray.length == 1) {
                        this.kind = 2;
                        this.collectionElementType = typeBindingArray[0];
                        if (!this.collectionElementType.isCompatibleWith(typeBinding) && !this.scope.isBoxingCompatibleWith(this.collectionElementType, typeBinding)) {
                            this.scope.problemReporter().notCompatibleTypesErrorInForeach(this.collection, this.collectionElementType, typeBinding);
                        }
                        int n4 = this.collectionElementType.id;
                        if (typeBinding.isBaseType()) {
                            if (!this.collectionElementType.isBaseType()) {
                                n4 = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                                this.elementVariableImplicitWidening = 1024;
                                if (typeBinding.isBaseType()) {
                                    this.elementVariableImplicitWidening |= (typeBinding.id << 4) + n4;
                                }
                            } else {
                                this.elementVariableImplicitWidening = (typeBinding.id << 4) + n4;
                            }
                        } else if (this.collectionElementType.isBaseType()) {
                            int n5 = this.scope.environment().computeBoxingType((TypeBinding)this.collectionElementType).id;
                            this.elementVariableImplicitWidening = 0x200 | n4 << 4 | n4;
                            n4 = n5;
                        }
                    }
                }
            }
            switch (this.kind) {
                case 0: {
                    this.indexVariable = new LocalVariableBinding(SecretIndexVariableName, (TypeBinding)IntBinding, 0, false);
                    this.scope.addLocalVariable(this.indexVariable);
                    this.indexVariable.setConstant(NotAConstant);
                    this.maxVariable = new LocalVariableBinding(SecretMaxVariableName, (TypeBinding)IntBinding, 0, false);
                    this.scope.addLocalVariable(this.maxVariable);
                    this.maxVariable.setConstant(NotAConstant);
                    this.collectionVariable = new LocalVariableBinding(SecretCollectionVariableName, typeBinding2, 0, false);
                    this.scope.addLocalVariable(this.collectionVariable);
                    this.collectionVariable.setConstant(NotAConstant);
                    break;
                }
                case 1: 
                case 2: {
                    this.indexVariable = new LocalVariableBinding(SecretIndexVariableName, (TypeBinding)this.scope.getJavaUtilIterator(), 0, false);
                    this.scope.addLocalVariable(this.indexVariable);
                    this.indexVariable.setConstant(NotAConstant);
                    break;
                }
                default: {
                    this.scope.problemReporter().invalidTypeForCollection(this.collection);
                }
            }
        }
        if (this.action != null) {
            this.action.resolve(this.scope);
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.elementVariable.traverse(aSTVisitor, this.scope);
            this.collection.traverse(aSTVisitor, this.scope);
            if (this.action != null) {
                this.action.traverse(aSTVisitor, this.scope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

