/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;

public class CompilationUnitDeclaration
extends ASTNode
implements ProblemSeverities,
ReferenceContext {
    public ImportReference currentPackage;
    public ImportReference[] imports;
    public TypeDeclaration[] types;
    public int[][] comments;
    public boolean ignoreFurtherInvestigation = false;
    public boolean ignoreMethodBodies = false;
    public CompilationUnitScope scope;
    public ProblemReporter problemReporter;
    public CompilationResult compilationResult;
    public LocalTypeBinding[] localTypes;
    public int localTypeCount = 0;
    public boolean isPropagatingInnerClassEmulation;
    public Javadoc javadoc;

    public CompilationUnitDeclaration(ProblemReporter problemReporter, CompilationResult compilationResult, int n2) {
        this.problemReporter = problemReporter;
        this.compilationResult = compilationResult;
        this.sourceStart = 0;
        this.sourceEnd = n2 - 1;
    }

    public void abort(int n2, IProblem iProblem) {
        switch (n2) {
            case 8: {
                throw new AbortType(this.compilationResult, iProblem);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult, iProblem);
            }
        }
        throw new AbortCompilationUnit(this.compilationResult, iProblem);
    }

    public void analyseCode() {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (this.types != null) {
                int n2 = 0;
                int n3 = this.types.length;
                while (n2 < n3) {
                    this.types[n2].analyseCode(this.scope);
                    ++n2;
                }
            }
            this.propagateInnerEmulationForAllLocalTypes();
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void cleanUp() {
        int n2;
        if (this.types != null) {
            int n3 = 0;
            n2 = this.types.length;
            while (n3 < n2) {
                this.cleanUp(this.types[n3]);
                ++n3;
            }
            n3 = 0;
            n2 = this.localTypeCount;
            while (n3 < n2) {
                LocalTypeBinding localTypeBinding = this.localTypes[n3];
                localTypeBinding.scope = null;
                localTypeBinding.enclosingCase = null;
                ++n3;
            }
        }
        ClassFile[] classFileArray = this.compilationResult.getClassFiles();
        n2 = 0;
        int n4 = classFileArray.length;
        while (n2 < n4) {
            ClassFile classFile = classFileArray[n2];
            classFile.referenceBinding = null;
            classFile.codeStream = null;
            classFile.innerClassesBindings = null;
            ++n2;
        }
    }

    private void cleanUp(TypeDeclaration typeDeclaration) {
        if (typeDeclaration.memberTypes != null) {
            int n2 = 0;
            int n3 = typeDeclaration.memberTypes.length;
            while (n2 < n3) {
                this.cleanUp(typeDeclaration.memberTypes[n2]);
                ++n2;
            }
        }
        if (typeDeclaration.binding != null) {
            typeDeclaration.binding.scope = null;
        }
    }

    public void checkUnusedImports() {
        if (this.scope.imports != null) {
            int n2 = 0;
            int n3 = this.scope.imports.length;
            while (n2 < n3) {
                ImportBinding importBinding = this.scope.imports[n2];
                ImportReference importReference = importBinding.reference;
                if (importReference != null && !importReference.used) {
                    this.scope.problemReporter().unusedImport(importReference);
                }
                ++n2;
            }
        }
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public TypeDeclaration declarationOfType(char[][] cArray) {
        int n2 = 0;
        while (n2 < this.types.length) {
            TypeDeclaration typeDeclaration = this.types[n2].declarationOfType(cArray);
            if (typeDeclaration != null) {
                return typeDeclaration;
            }
            ++n2;
        }
        return null;
    }

    public void generateCode() {
        if (this.ignoreFurtherInvestigation) {
            if (this.types != null) {
                int n2 = 0;
                int n3 = this.types.length;
                while (n2 < n3) {
                    this.types[n2].ignoreFurtherInvestigation = true;
                    this.types[n2].generateCode(this.scope);
                    ++n2;
                }
            }
            return;
        }
        if (this.isPackageInfo() && this.types != null && this.currentPackage.annotations != null) {
            this.types[0].annotations = this.currentPackage.annotations;
        }
        try {
            if (this.types != null) {
                int n4 = 0;
                int n5 = this.types.length;
                while (n4 < n5) {
                    this.types[n4].generateCode(this.scope);
                    ++n4;
                }
            }
        }
        catch (AbortCompilationUnit abortCompilationUnit) {}
    }

    public char[] getFileName() {
        return this.compilationResult.getFileName();
    }

    public char[] getMainTypeName() {
        if (this.compilationResult.compilationUnit == null) {
            int n2;
            char[] cArray = this.compilationResult.getFileName();
            int n3 = CharOperation.lastIndexOf('/', cArray) + 1;
            if (n3 == 0 || n3 < CharOperation.lastIndexOf('\\', cArray)) {
                n3 = CharOperation.lastIndexOf('\\', cArray) + 1;
            }
            if ((n2 = CharOperation.lastIndexOf('.', cArray)) == -1) {
                n2 = cArray.length;
            }
            return CharOperation.subarray(cArray, n3, n2);
        }
        return this.compilationResult.compilationUnit.getMainTypeName();
    }

    public boolean isEmpty() {
        return this.currentPackage == null && this.imports == null && this.types == null;
    }

    public boolean isPackageInfo() {
        return CharOperation.equals(this.getMainTypeName(), TypeConstants.PACKAGE_INFO_NAME) && this.currentPackage != null && (this.currentPackage.annotations != null || this.javadoc != null);
    }

    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public StringBuffer print(int n2, StringBuffer stringBuffer) {
        int n3;
        if (this.currentPackage != null) {
            CompilationUnitDeclaration.printIndent(n2, stringBuffer).append("package ");
            this.currentPackage.print(0, stringBuffer, false).append(";\n");
        }
        if (this.imports != null) {
            n3 = 0;
            while (n3 < this.imports.length) {
                CompilationUnitDeclaration.printIndent(n2, stringBuffer).append("import ");
                this.imports[n3].print(0, stringBuffer).append(";\n");
                ++n3;
            }
        }
        if (this.types != null) {
            n3 = 0;
            while (n3 < this.types.length) {
                this.types[n3].print(n2, stringBuffer).append("\n");
                ++n3;
            }
        }
        return stringBuffer;
    }

    public void propagateInnerEmulationForAllLocalTypes() {
        this.isPropagatingInnerClassEmulation = true;
        int n2 = 0;
        int n3 = this.localTypeCount;
        while (n2 < n3) {
            LocalTypeBinding localTypeBinding = this.localTypes[n2];
            if ((localTypeBinding.scope.referenceType().bits & Integer.MIN_VALUE) != 0) {
                localTypeBinding.updateInnerEmulationDependents();
            }
            ++n2;
        }
    }

    public void record(LocalTypeBinding localTypeBinding) {
        if (this.localTypeCount == 0) {
            this.localTypes = new LocalTypeBinding[5];
        } else if (this.localTypeCount == this.localTypes.length) {
            this.localTypes = new LocalTypeBinding[this.localTypeCount * 2];
            System.arraycopy(this.localTypes, 0, this.localTypes, 0, this.localTypeCount);
        }
        this.localTypes[this.localTypeCount++] = localTypeBinding;
    }

    public void resolve() {
        int n2 = 0;
        boolean bl2 = this.isPackageInfo();
        if (this.types != null && bl2) {
            TypeDeclaration typeDeclaration = this.types[0];
            typeDeclaration.javadoc = new Javadoc(typeDeclaration.declarationSourceStart, typeDeclaration.declarationSourceStart);
            typeDeclaration.resolve(this.scope);
            if (this.currentPackage.annotations != null) {
                CompilationUnitDeclaration.resolveAnnotations(typeDeclaration.staticInitializerScope, this.currentPackage.annotations, this.scope.fPackage);
            }
            if (this.javadoc != null) {
                this.javadoc.resolve(typeDeclaration.staticInitializerScope);
            }
            n2 = 1;
        }
        if (this.currentPackage != null && this.currentPackage.annotations != null && !bl2) {
            this.scope.problemReporter().invalidFileNameForPackageAnnotations(this.currentPackage.annotations[0]);
        }
        try {
            if (this.types != null) {
                int n3 = n2;
                int n4 = this.types.length;
                while (n3 < n4) {
                    this.types[n3].resolve(this.scope);
                    ++n3;
                }
            }
            if (!this.compilationResult.hasErrors()) {
                this.checkUnusedImports();
            }
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (aSTVisitor.visit(this, this.scope)) {
                int n2;
                int n3;
                if (this.currentPackage != null) {
                    this.currentPackage.traverse(aSTVisitor, this.scope);
                }
                if (this.imports != null) {
                    n3 = this.imports.length;
                    n2 = 0;
                    while (n2 < n3) {
                        this.imports[n2].traverse(aSTVisitor, this.scope);
                        ++n2;
                    }
                }
                if (this.types != null) {
                    n3 = this.types.length;
                    n2 = 0;
                    while (n2 < n3) {
                        this.types[n2].traverse(aSTVisitor, this.scope);
                        ++n2;
                    }
                }
            }
            aSTVisitor.endVisit(this, this.scope);
        }
        catch (AbortCompilationUnit abortCompilationUnit) {}
    }
}

