/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ClassLiteralAccess
extends Expression {
    public TypeReference type;
    public TypeBinding targetType;
    public FieldBinding a;

    public ClassLiteralAccess(int n2, TypeReference typeReference) {
        this.type = typeReference;
        this.sourceStart = typeReference.sourceStart;
        this.sourceEnd = n2;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        SourceTypeBinding sourceTypeBinding = blockScope.outerMostMethodScope().enclosingSourceType();
        if (!sourceTypeBinding.isInterface() && !sourceTypeBinding.isBaseType() && blockScope.compilerOptions().sourceLevel <= 0x310000L) {
            this.a = sourceTypeBinding.addSyntheticFieldForClassLiteral(this.targetType, blockScope);
        }
        return flowInfo;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl2) {
        int n2 = codeStream.position;
        if (bl2) {
            codeStream.generateClassLiteralAccessForType(this.type.resolvedType, this.a);
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        return this.type.print(0, stringBuffer).append(".class");
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        ReferenceBinding referenceBinding;
        this.constant = NotAConstant;
        this.targetType = this.type.resolveType(blockScope, true);
        if (this.targetType == null) {
            return null;
        }
        if (this.targetType.isArrayType() && ((ArrayBinding)this.targetType).leafComponentType == VoidBinding) {
            blockScope.problemReporter().cannotAllocateVoidArray(this);
            return null;
        }
        if (this.targetType.isTypeVariable()) {
            blockScope.problemReporter().illegalClassLiteralForTypeVariable((TypeVariableBinding)this.targetType, this);
        }
        if ((referenceBinding = blockScope.getJavaLangClass()).isGenericType()) {
            TypeBinding typeBinding = null;
            if (this.targetType.id == 6) {
                typeBinding = blockScope.environment().getType(JAVA_LANG_VOID);
                if (typeBinding == null) {
                    typeBinding = new ProblemReferenceBinding(JAVA_LANG_VOID, null, 1);
                }
            } else {
                typeBinding = blockScope.boxing(this.targetType);
            }
            this.resolvedType = blockScope.environment().createParameterizedType(referenceBinding, new TypeBinding[]{typeBinding}, null);
        } else {
            this.resolvedType = referenceBinding;
        }
        return this.resolvedType;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.type.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

