/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class CastExpression
extends Expression {
    public Expression expression;
    public Expression type;
    public TypeBinding expectedType;

    public CastExpression(Expression expression, Expression expression2) {
        this.expression = expression;
        this.type = expression2;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
    }

    public static void checkNeedForEnclosingInstanceCast(BlockScope blockScope, Expression expression, TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (blockScope.compilerOptions().getSeverity(0x4000000L) == -1) {
            return;
        }
        TypeBinding typeBinding3 = ((CastExpression)expression).expression.resolvedType;
        if (typeBinding3 == null) {
            return;
        }
        if (typeBinding3 == typeBinding) {
            blockScope.problemReporter().unnecessaryCast((CastExpression)expression);
        } else {
            if (typeBinding3 == NullBinding) {
                return;
            }
            TypeBinding typeBinding4 = typeBinding3;
            if (typeBinding3.isBaseType() || typeBinding3.isArrayType()) {
                return;
            }
            if (typeBinding2 == blockScope.getMemberType(typeBinding2.sourceName(), (ReferenceBinding)typeBinding4)) {
                blockScope.problemReporter().unnecessaryCast((CastExpression)expression);
            }
        }
    }

    public static void checkNeedForArgumentCast(BlockScope blockScope, int n2, int n3, Expression expression, int n4) {
        if (blockScope.compilerOptions().getSeverity(0x4000000L) == -1) {
            return;
        }
        int n5 = n4;
        if ((expression.bits & 0x4000) == 0 && expression.resolvedType.isBaseType()) {
            return;
        }
        TypeBinding typeBinding = ((CastExpression)expression).expression.resolvedType;
        if (typeBinding == null) {
            return;
        }
        n5 = typeBinding.id;
        if (n5 == n4) {
            blockScope.problemReporter().unnecessaryCast((CastExpression)expression);
            return;
        }
        if (n5 == 12) {
            n5 = n4;
            return;
        }
    }

    public static void checkNeedForArgumentCasts(BlockScope blockScope, Expression expression, TypeBinding typeBinding, MethodBinding methodBinding, Expression[] expressionArray, TypeBinding[] typeBindingArray, InvocationSite invocationSite) {
        if (blockScope.compilerOptions().getSeverity(0x4000000L) == -1) {
            return;
        }
        int n2 = typeBindingArray.length;
        TypeBinding[] typeBindingArray2 = typeBindingArray;
        int n3 = 0;
        while (n3 < n2) {
            Expression expression2 = expressionArray[n3];
            if (expression2 instanceof CastExpression && ((expression2.bits & 0x4000) != 0 || !expression2.resolvedType.isBaseType())) {
                TypeBinding typeBinding2 = ((CastExpression)expression2).expression.resolvedType;
                if (typeBinding2 == null) {
                    return;
                }
                if (typeBinding2 == typeBindingArray[n3]) {
                    blockScope.problemReporter().unnecessaryCast((CastExpression)expression2);
                } else if (typeBinding2 != NullBinding) {
                    if (typeBindingArray2 == typeBindingArray) {
                        TypeBinding[] typeBindingArray3 = typeBindingArray2;
                        typeBindingArray2 = new TypeBinding[n2];
                        System.arraycopy(typeBindingArray3, 0, typeBindingArray2, 0, n2);
                    }
                    typeBindingArray2[n3] = typeBinding2;
                }
            }
            ++n3;
        }
        if (typeBindingArray2 != typeBindingArray) {
            CastExpression.checkAlternateBinding(blockScope, expression, typeBinding, methodBinding, expressionArray, typeBindingArray, typeBindingArray2, invocationSite);
        }
    }

    public static void checkNeedForArgumentCasts(BlockScope blockScope, int n2, int n3, Expression expression, int n4, boolean bl2, Expression expression2, int n5, boolean bl3) {
        if (blockScope.compilerOptions().getSeverity(0x4000000L) == -1) {
            return;
        }
        int n6 = n4;
        if (bl2) {
            if ((expression.bits & 0x4000) == 0 && expression.resolvedType.isBaseType()) {
                bl2 = false;
            } else {
                TypeBinding typeBinding = ((CastExpression)expression).expression.resolvedType;
                if (typeBinding == null) {
                    return;
                }
                n6 = typeBinding.id;
                if (n6 == n4) {
                    blockScope.problemReporter().unnecessaryCast((CastExpression)expression);
                    bl2 = false;
                } else if (n6 == 12) {
                    n6 = n4;
                    bl2 = false;
                }
            }
        }
        int n7 = n5;
        if (bl3) {
            if ((expression2.bits & 0x4000) == 0 && expression2.resolvedType.isBaseType()) {
                bl3 = false;
            } else {
                TypeBinding typeBinding = ((CastExpression)expression2).expression.resolvedType;
                if (typeBinding == null) {
                    return;
                }
                n7 = typeBinding.id;
                if (n7 == n5) {
                    blockScope.problemReporter().unnecessaryCast((CastExpression)expression2);
                    bl3 = false;
                } else if (n7 == 12) {
                    n7 = n5;
                    bl3 = false;
                }
            }
        }
        if (bl2 || bl3) {
            int n8;
            if (n6 > 15 || n7 > 15) {
                if (n6 == 11) {
                    n7 = 1;
                } else if (n7 == 11) {
                    n6 = 1;
                } else {
                    return;
                }
            }
            if ((n3 & 0xF0F0F) == ((n8 = OperatorExpression.OperatorSignatures[n2][(n6 << 4) + n7]) & 0xF0F0F)) {
                if (bl2) {
                    blockScope.problemReporter().unnecessaryCast((CastExpression)expression);
                }
                if (bl3) {
                    blockScope.problemReporter().unnecessaryCast((CastExpression)expression2);
                }
            }
        }
    }

    private static void checkAlternateBinding(BlockScope blockScope, Expression expression, TypeBinding typeBinding, MethodBinding methodBinding, Expression[] expressionArray, TypeBinding[] typeBindingArray, TypeBinding[] typeBindingArray2, InvocationSite invocationSite) {
        MethodBinding methodBinding2;
        InvocationSite invocationSite2 = new InvocationSite(invocationSite){
            private final InvocationSite val$invocationSite;
            {
                this.val$invocationSite = invocationSite;
            }

            public TypeBinding[] genericTypeArguments() {
                return null;
            }

            public boolean isSuperAccess() {
                return this.val$invocationSite.isSuperAccess();
            }

            public boolean isTypeAccess() {
                return this.val$invocationSite.isTypeAccess();
            }

            public void setActualReceiverType(ReferenceBinding referenceBinding) {
            }

            public void setDepth(int n2) {
            }

            public void setFieldIndex(int n2) {
            }

            public int sourceStart() {
                return 0;
            }

            public int sourceEnd() {
                return 0;
            }
        };
        if (methodBinding.isConstructor()) {
            methodBinding2 = blockScope.getConstructor((ReferenceBinding)typeBinding, typeBindingArray2, invocationSite2);
        } else {
            MethodBinding methodBinding3 = methodBinding2 = expression.isImplicitThis() ? blockScope.getImplicitMethod(methodBinding.selector, typeBindingArray2, invocationSite2) : blockScope.getMethod(typeBinding, methodBinding.selector, typeBindingArray2, invocationSite2);
        }
        if (methodBinding2 == methodBinding) {
            int n2;
            int n3 = typeBindingArray.length;
            if (methodBinding.isVarargs() && (n2 = methodBinding.parameters.length) == n3) {
                int n4 = n2 - 1;
                ArrayBinding arrayBinding = (ArrayBinding)methodBinding.parameters[n4];
                TypeBinding typeBinding2 = typeBindingArray2[n4];
                if (arrayBinding.dimensions == typeBinding2.dimensions() && arrayBinding.leafComponentType != typeBinding2.leafComponentType()) {
                    return;
                }
            }
            n2 = 0;
            while (n2 < n3) {
                if (typeBindingArray[n2] != typeBindingArray2[n2]) {
                    blockScope.problemReporter().unnecessaryCast((CastExpression)expressionArray[n2]);
                }
                ++n2;
            }
        }
    }

    public boolean checkUnsafeCast(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2, TypeBinding typeBinding3, boolean bl2) {
        if (typeBinding3 == typeBinding) {
            if (!bl2 && typeBinding == this.resolvedType.leafComponentType()) {
                this.tagAsUnnecessaryCast(scope, typeBinding);
            }
            return true;
        }
        if (typeBinding3 != null && (typeBinding.isBoundParameterizedType() || typeBinding.isGenericType() || typeBinding2.isBoundParameterizedType() || typeBinding2.isGenericType())) {
            if (typeBinding3.isProvablyDistinctFrom(bl2 ? typeBinding2 : typeBinding, 0)) {
                return false;
            }
            if (bl2 ? !typeBinding2.isEquivalentTo(typeBinding3) : !typeBinding3.isEquivalentTo(typeBinding)) {
                this.bits |= 0x80;
                return true;
            }
            if ((typeBinding.tagBits & 0x40000000L) == 0L && (!typeBinding3.isParameterizedType() && !typeBinding3.isGenericType() || typeBinding2.isRawType())) {
                this.bits |= 0x80;
                return true;
            }
        } else if (bl2) {
            TypeBinding typeBinding4 = typeBinding.leafComponentType();
            if (typeBinding2.id == 1 && typeBinding.isArrayType() && (typeBinding4.isBoundParameterizedType() || typeBinding4.isGenericType())) {
                this.bits |= 0x80;
                return true;
            }
            if (typeBinding4.isTypeVariable()) {
                this.bits |= 0x80;
                return true;
            }
        }
        if (!bl2 && typeBinding == this.resolvedType.leafComponentType()) {
            this.tagAsUnnecessaryCast(scope, typeBinding);
        }
        return true;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl2) {
        boolean bl3;
        int n2 = codeStream.position;
        boolean bl4 = bl3 = (this.bits & 0x40) != 0;
        if (this.constant != NotAConstant) {
            if (bl2 || bl3) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
                if (bl3) {
                    codeStream.checkcast(this.resolvedType);
                    if (bl2) {
                        codeStream.generateImplicitConversion(this.implicitConversion);
                    } else {
                        codeStream.pop();
                    }
                }
            }
            codeStream.recordPositionsFrom(n2, this.sourceStart);
            return;
        }
        this.expression.generateCode(blockScope, codeStream, bl2 || bl3);
        if (bl3) {
            codeStream.checkcast(this.resolvedType);
            if (bl2) {
                codeStream.generateImplicitConversion(this.implicitConversion);
            } else {
                codeStream.pop();
            }
        } else if (bl2) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public Expression innermostCastedExpression() {
        Expression expression = this.expression;
        while (expression instanceof CastExpression) {
            expression = ((CastExpression)expression).expression;
        }
        return expression;
    }

    public LocalVariableBinding localVariableBinding() {
        return this.expression.localVariableBinding();
    }

    public int nullStatus(FlowInfo flowInfo) {
        return this.expression.nullStatus(flowInfo);
    }

    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        stringBuffer.append('(');
        this.type.print(0, stringBuffer).append(") ");
        return this.expression.printExpression(0, stringBuffer);
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        this.constant = Constant.NotAConstant;
        this.implicitConversion = 0;
        if (this.type instanceof TypeReference || this.type instanceof NameReference && (this.type.bits & 0x1FE00000) >> 21 == 0) {
            this.resolvedType = this.type.resolveType(blockScope);
            TypeBinding typeBinding = this.expression.resolveType(blockScope);
            if (this.resolvedType != null && typeBinding != null) {
                boolean bl2 = this.checkCastTypesCompatibility(blockScope, this.resolvedType, typeBinding, this.expression);
                if (bl2) {
                    this.expression.computeConversion(blockScope, this.resolvedType, typeBinding);
                    if ((this.bits & 0x80) != 0) {
                        blockScope.problemReporter().unsafeCast(this, blockScope);
                    } else if ((this.bits & 0x4020) == 16384 && !this.isIndirectlyUsed()) {
                        blockScope.problemReporter().unnecessaryCast(this);
                    }
                    this.resolvedType = this.resolvedType.capture(blockScope, this.sourceEnd);
                } else {
                    blockScope.problemReporter().typeCastError(this, this.resolvedType, typeBinding);
                }
            }
            return this.resolvedType;
        }
        TypeBinding typeBinding = this.expression.resolveType(blockScope);
        if (typeBinding == null) {
            return null;
        }
        blockScope.problemReporter().invalidTypeReference(this.type);
        return null;
    }

    public void setExpectedType(TypeBinding typeBinding) {
        this.expectedType = typeBinding;
    }

    private boolean isIndirectlyUsed() {
        MethodBinding methodBinding;
        if (this.expression instanceof MessageSend && (methodBinding = ((MessageSend)this.expression).binding) instanceof ParameterizedGenericMethodBinding && ((ParameterizedGenericMethodBinding)methodBinding).inferredReturnType) {
            if (this.expectedType == null) {
                return true;
            }
            if (this.resolvedType != this.expectedType) {
                return true;
            }
        }
        return this.expectedType != null && this.resolvedType.isBaseType() && !this.resolvedType.isCompatibleWith(this.expectedType);
    }

    public void tagAsNeedCheckCast() {
        this.bits |= 0x40;
    }

    public void tagAsUnnecessaryCast(Scope scope, TypeBinding typeBinding) {
        if (this.expression.resolvedType == null) {
            return;
        }
        this.bits |= 0x4000;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.type.traverse(aSTVisitor, blockScope);
            this.expression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

