/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.codegen.CaseLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class CaseStatement
extends Statement {
    public Expression constantExpression;
    public CaseLabel targetLabel;
    public boolean isEnumConstant;

    public CaseStatement(Expression expression, int n2, int n3) {
        this.constantExpression = expression;
        this.sourceEnd = n2;
        this.sourceStart = n3;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.constantExpression != null) {
            if (!this.isEnumConstant && this.constantExpression.constant == NotAConstant) {
                blockScope.problemReporter().caseExpressionMustBeConstant(this.constantExpression);
            }
            this.constantExpression.analyseCode(blockScope, flowContext, flowInfo);
        }
        return flowInfo;
    }

    public StringBuffer printStatement(int n2, StringBuffer stringBuffer) {
        CaseStatement.printIndent(n2, stringBuffer);
        if (this.constantExpression == null) {
            stringBuffer.append("default : ");
        } else {
            stringBuffer.append("case ");
            this.constantExpression.printExpression(0, stringBuffer).append(" : ");
        }
        return stringBuffer.append(';');
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n2 = codeStream.position;
        this.targetLabel.place();
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public void resolve(BlockScope blockScope) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Constant resolveCase(BlockScope blockScope, TypeBinding typeBinding, SwitchStatement switchStatement) {
        TypeBinding typeBinding2;
        blockScope.enclosingCase = this;
        if (this.constantExpression == null) {
            if (switchStatement.defaultCase != null) {
                blockScope.problemReporter().duplicateDefaultCase(this);
            }
            switchStatement.defaultCase = this;
            return NotAConstant;
        }
        switchStatement.cases[switchStatement.caseCount++] = this;
        if (typeBinding.isEnum() && this.constantExpression instanceof SingleNameReference) {
            ((SingleNameReference)this.constantExpression).setActualReceiverType((ReferenceBinding)typeBinding);
        }
        if ((typeBinding2 = this.constantExpression.resolveType(blockScope)) == null || typeBinding == null) {
            return NotAConstant;
        }
        if (this.constantExpression.isConstantValueOfTypeAssignableToType(typeBinding2, typeBinding) || typeBinding2.isCompatibleWith(typeBinding)) {
            if (!typeBinding2.isEnum()) return this.constantExpression.constant;
            this.isEnumConstant = true;
            if (this.constantExpression instanceof NameReference && (this.constantExpression.bits & 7) == 1) {
                NameReference nameReference = (NameReference)this.constantExpression;
                FieldBinding fieldBinding = nameReference.fieldBinding();
                if ((fieldBinding.modifiers & 0x4000) == 0) {
                    blockScope.problemReporter().enumSwitchCannotTargetField(nameReference, fieldBinding);
                    return Constant.fromValue(fieldBinding.original().id);
                } else {
                    if (!(nameReference instanceof QualifiedNameReference)) return Constant.fromValue(fieldBinding.original().id);
                    blockScope.problemReporter().cannotUseQualifiedEnumConstantInCaseLabel(nameReference, fieldBinding);
                }
                return Constant.fromValue(fieldBinding.original().id);
            }
        } else if (blockScope.isBoxingCompatibleWith(typeBinding2, typeBinding)) {
            this.constantExpression.computeConversion(blockScope, typeBinding2, typeBinding);
            return this.constantExpression.constant;
        }
        blockScope.problemReporter().typeMismatchError(typeBinding2, typeBinding, this.constantExpression);
        return NotAConstant;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.constantExpression != null) {
            this.constantExpression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

