/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class Block
extends Statement {
    public Statement[] statements;
    public int explicitDeclarations;
    public BlockScope scope;

    public Block(int n2) {
        this.explicitDeclarations = n2;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.statements == null) {
            return flowInfo;
        }
        boolean bl2 = false;
        int n2 = 0;
        int n3 = this.statements.length;
        while (n2 < n3) {
            Statement statement = this.statements[n2];
            if (!statement.complainIfUnreachable(flowInfo, this.scope, bl2)) {
                flowInfo = statement.analyseCode(this.scope, flowContext, flowInfo);
            } else {
                bl2 = true;
            }
            ++n2;
        }
        return flowInfo;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n2 = codeStream.position;
        if (this.statements != null) {
            int n3 = 0;
            int n4 = this.statements.length;
            while (n3 < n4) {
                this.statements[n3].generateCode(this.scope, codeStream);
                ++n3;
            }
        }
        if (this.scope != blockScope) {
            codeStream.exitUserScope(this.scope);
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public boolean isEmptyBlock() {
        return this.statements == null;
    }

    public StringBuffer printBody(int n2, StringBuffer stringBuffer) {
        if (this.statements == null) {
            return stringBuffer;
        }
        int n3 = 0;
        while (n3 < this.statements.length) {
            this.statements[n3].printStatement(n2 + 1, stringBuffer);
            stringBuffer.append('\n');
            ++n3;
        }
        return stringBuffer;
    }

    public StringBuffer printStatement(int n2, StringBuffer stringBuffer) {
        Block.printIndent(n2, stringBuffer);
        stringBuffer.append("{\n");
        this.printBody(n2, stringBuffer);
        return Block.printIndent(n2, stringBuffer).append('}');
    }

    public void resolve(BlockScope blockScope) {
        if ((this.bits & 8) != 0) {
            blockScope.problemReporter().undocumentedEmptyBlock(this.sourceStart, this.sourceEnd);
        }
        if (this.statements != null) {
            this.scope = this.explicitDeclarations == 0 ? blockScope : new BlockScope(blockScope, this.explicitDeclarations);
            int n2 = 0;
            int n3 = this.statements.length;
            while (n2 < n3) {
                this.statements[n2].resolve(this.scope);
                ++n2;
            }
        }
    }

    public void resolveUsing(BlockScope blockScope) {
        if ((this.bits & 8) != 0) {
            blockScope.problemReporter().undocumentedEmptyBlock(this.sourceStart, this.sourceEnd);
        }
        this.scope = blockScope;
        if (this.statements != null) {
            int n2 = 0;
            int n3 = this.statements.length;
            while (n2 < n3) {
                this.statements[n2].resolve(this.scope);
                ++n2;
            }
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.statements != null) {
            int n2 = 0;
            int n3 = this.statements.length;
            while (n2 < n3) {
                this.statements[n2].traverse(aSTVisitor, this.scope);
                ++n2;
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void branchChainTo(Label label) {
        if (this.statements != null) {
            this.statements[this.statements.length - 1].branchChainTo(label);
        }
    }
}

