/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.PostfixExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class Assignment
extends Expression {
    public Expression lhs;
    public Expression expression;

    public Assignment(Expression expression, Expression expression2, int n2) {
        this.lhs = expression;
        expression.bits |= 0x2000;
        this.expression = expression2;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = n2;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        LocalVariableBinding localVariableBinding = this.lhs.localVariableBinding();
        int n2 = this.expression.nullStatus(flowInfo);
        if (localVariableBinding != null && n2 == 1) {
            flowContext.recordUsingNullReference(blockScope, localVariableBinding, this.lhs, -1, flowInfo);
        }
        flowInfo = ((Reference)this.lhs).analyseAssignment(blockScope, flowContext, flowInfo, this, false).unconditionalInits();
        if (localVariableBinding != null) {
            switch (n2) {
                case 1: {
                    flowInfo.markAsDefinitelyNull(localVariableBinding);
                    break;
                }
                case -1: {
                    flowInfo.markAsDefinitelyNonNull(localVariableBinding);
                }
            }
        }
        return flowInfo;
    }

    public void a(BlockScope blockScope) {
        Binding binding = this.b(this.lhs);
        if (binding != null && binding == this.b(this.expression)) {
            blockScope.problemReporter().assignmentHasNoEffect(this, binding.shortReadableName());
            this.bits |= 0x20000000;
        }
    }

    public void a(BlockScope blockScope, TypeBinding typeBinding, TypeBinding typeBinding2) {
        FieldBinding fieldBinding = this.a(this.lhs);
        if (fieldBinding != null && typeBinding2 != NullBinding && typeBinding.isWildcard() && ((WildcardBinding)typeBinding).boundKind != 2) {
            blockScope.problemReporter().wildcardAssignment(typeBinding, typeBinding2, this.expression);
        } else if (fieldBinding != null && fieldBinding.declaringClass != null && fieldBinding.declaringClass.isRawType()) {
            blockScope.problemReporter().unsafeRawFieldAssignment(fieldBinding, typeBinding2, this.lhs);
        } else if (typeBinding2.needsUncheckedConversion(typeBinding)) {
            blockScope.problemReporter().unsafeTypeConversion(this.expression, typeBinding2, typeBinding);
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl2) {
        int n2 = codeStream.position;
        if ((this.bits & 0x20000000) != 0) {
            if (bl2) {
                this.expression.generateCode(blockScope, codeStream, true);
            }
        } else {
            ((Reference)this.lhs).generateAssignment(blockScope, codeStream, this, bl2);
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public Binding b(Expression expression) {
        if (expression instanceof SingleNameReference) {
            return ((SingleNameReference)expression).binding;
        }
        if (expression instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)expression;
            if (fieldReference.receiver.isThis() && !(fieldReference.receiver instanceof QualifiedThisReference)) {
                return fieldReference.binding;
            }
        } else if (expression instanceof PostfixExpression) {
            return this.b(((PostfixExpression)expression).lhs);
        }
        return null;
    }

    public FieldBinding a(Expression expression) {
        if (expression instanceof SingleNameReference) {
            if ((expression.bits & 7) == 1) {
                return (FieldBinding)((SingleNameReference)expression).binding;
            }
        } else {
            if (expression instanceof FieldReference) {
                return ((FieldReference)expression).binding;
            }
            if (expression instanceof QualifiedNameReference) {
                QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)expression;
                if (qualifiedNameReference.otherBindings == null && (expression.bits & 7) == 1) {
                    return (FieldBinding)qualifiedNameReference.binding;
                }
                return qualifiedNameReference.otherBindings[qualifiedNameReference.otherBindings.length - 1];
            }
        }
        return null;
    }

    public int nullStatus(FlowInfo flowInfo) {
        return this.expression.nullStatus(flowInfo);
    }

    public StringBuffer print(int n2, StringBuffer stringBuffer) {
        Assignment.printIndent(n2, stringBuffer);
        return this.printExpressionNoParenthesis(n2, stringBuffer);
    }

    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        stringBuffer.append('(');
        return this.printExpressionNoParenthesis(0, stringBuffer).append(')');
    }

    public StringBuffer printExpressionNoParenthesis(int n2, StringBuffer stringBuffer) {
        this.lhs.printExpression(n2, stringBuffer).append(" = ");
        return this.expression.printExpression(0, stringBuffer);
    }

    public StringBuffer printStatement(int n2, StringBuffer stringBuffer) {
        return this.print(n2, stringBuffer).append(';');
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        this.constant = NotAConstant;
        if (!(this.lhs instanceof Reference) || this.lhs.isThis()) {
            blockScope.problemReporter().expressionShouldBeAVariable(this.lhs);
            return null;
        }
        TypeBinding typeBinding = this.lhs.resolveType(blockScope);
        this.expression.setExpectedType(typeBinding);
        if (typeBinding != null) {
            this.resolvedType = typeBinding.capture(blockScope, this.sourceEnd);
        }
        TypeBinding typeBinding2 = this.expression.resolveType(blockScope);
        if (typeBinding == null || typeBinding2 == null) {
            return null;
        }
        this.a(blockScope);
        if (typeBinding != typeBinding2) {
            blockScope.compilationUnitScope().recordTypeConversion(typeBinding, typeBinding2);
        }
        if (this.expression.isConstantValueOfTypeAssignableToType(typeBinding2, typeBinding) || typeBinding.isBaseType() && BaseTypeBinding.isWidening(typeBinding.id, typeBinding2.id) || typeBinding2.isCompatibleWith(typeBinding)) {
            this.expression.computeConversion(blockScope, typeBinding, typeBinding2);
            this.a(blockScope, typeBinding, typeBinding2);
            return this.resolvedType;
        }
        if (blockScope.isBoxingCompatibleWith(typeBinding2, typeBinding) || typeBinding2.isBaseType() && blockScope.compilerOptions().sourceLevel >= 0x310000L && !typeBinding.isBaseType() && this.expression.isConstantValueOfTypeAssignableToType(typeBinding2, blockScope.environment().computeBoxingType(typeBinding))) {
            this.expression.computeConversion(blockScope, typeBinding, typeBinding2);
            return this.resolvedType;
        }
        blockScope.problemReporter().typeMismatchError(typeBinding2, typeBinding, this.expression);
        return typeBinding;
    }

    public TypeBinding resolveTypeExpecting(BlockScope blockScope, TypeBinding typeBinding) {
        TypeBinding typeBinding2 = super.resolveTypeExpecting(blockScope, typeBinding);
        if (typeBinding2 == null) {
            return null;
        }
        TypeBinding typeBinding3 = this.resolvedType;
        TypeBinding typeBinding4 = this.expression.resolvedType;
        if (typeBinding == BooleanBinding && typeBinding3 == BooleanBinding && (this.lhs.bits & 0x2000) != 0) {
            blockScope.problemReporter().possibleAccidentalBooleanAssignment(this);
        }
        this.a(blockScope, typeBinding3, typeBinding4);
        return typeBinding2;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.lhs.traverse(aSTVisitor, blockScope);
            this.expression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

