/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.parser.Parser;

public class AnnotationMethodDeclaration
extends MethodDeclaration {
    public Expression defaultValue;
    public int extendedDimensions;

    public AnnotationMethodDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public void generateCode(ClassFile classFile) {
        classFile.generateMethodInfoHeader(this.binding);
        int n2 = classFile.contentsOffset;
        int n3 = classFile.generateMethodInfoAttribute(this.binding, this);
        classFile.completeMethodInfo(n2, n3);
    }

    public boolean isAnnotationMethod() {
        return true;
    }

    public boolean isMethod() {
        return false;
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration compilationUnitDeclaration) {
    }

    public StringBuffer print(int n2, StringBuffer stringBuffer) {
        int n3;
        TypeParameter[] typeParameterArray;
        AnnotationMethodDeclaration.printIndent(n2, stringBuffer);
        AnnotationMethodDeclaration.printModifiers(this.modifiers, stringBuffer);
        if (this.annotations != null) {
            AnnotationMethodDeclaration.printAnnotations(this.annotations, stringBuffer);
        }
        if ((typeParameterArray = this.typeParameters()) != null) {
            stringBuffer.append('<');
            n3 = typeParameterArray.length - 1;
            int n4 = 0;
            while (n4 < n3) {
                typeParameterArray[n4].print(0, stringBuffer);
                stringBuffer.append(", ");
                ++n4;
            }
            typeParameterArray[n3].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        this.printReturnType(0, stringBuffer).append(this.selector).append('(');
        if (this.arguments != null) {
            n3 = 0;
            while (n3 < this.arguments.length) {
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n3].print(0, stringBuffer);
                ++n3;
            }
        }
        stringBuffer.append(')');
        if (this.thrownExceptions != null) {
            stringBuffer.append(" throws ");
            n3 = 0;
            while (n3 < this.thrownExceptions.length) {
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
                this.thrownExceptions[n3].print(0, stringBuffer);
                ++n3;
            }
        }
        if (this.defaultValue != null) {
            stringBuffer.append(" default ");
            this.defaultValue.print(0, stringBuffer);
        }
        this.printBody(n2 + 1, stringBuffer);
        return stringBuffer;
    }

    public void resolveStatements() {
        block8: {
            TypeIds typeIds;
            TypeBinding typeBinding;
            block10: {
                block9: {
                    super.resolveStatements();
                    if (this.arguments != null) {
                        this.scope.problemReporter().annotationMembersCannotHaveParameters(this);
                    }
                    if (this.typeParameters != null) {
                        this.scope.problemReporter().annotationMembersCannotHaveTypeParameters(this);
                    }
                    if (this.extendedDimensions != 0) {
                        this.scope.problemReporter().illegalExtendedDimensions(this);
                    }
                    if (this.binding == null) {
                        return;
                    }
                    typeBinding = this.binding.returnType;
                    if (typeBinding == null) break block8;
                    typeIds = typeBinding.leafComponentType();
                    if (typeBinding.dimensions() > 1) break block9;
                    switch (((TypeBinding)typeIds).erasure().id) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 16: {
                            break block10;
                        }
                        default: {
                            if (((TypeBinding)typeIds).isEnum() || ((TypeBinding)typeIds).isAnnotationType()) break block10;
                        }
                    }
                }
                this.scope.problemReporter().invalidAnnotationMemberType(this);
            }
            if (this.defaultValue != null) {
                typeIds = new MemberValuePair(this.selector, this.sourceStart, this.sourceEnd, this.defaultValue);
                ((MemberValuePair)typeIds).binding = this.binding;
                ((MemberValuePair)typeIds).resolveTypeExpecting(this.scope, typeBinding);
            }
        }
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            if (this.annotations != null) {
                int n2 = this.annotations.length;
                int n3 = 0;
                while (n3 < n2) {
                    this.annotations[n3].traverse(aSTVisitor, this.scope);
                    ++n3;
                }
            }
            if (this.returnType != null) {
                this.returnType.traverse(aSTVisitor, this.scope);
            }
            if (this.defaultValue != null) {
                this.defaultValue.traverse(aSTVisitor, this.scope);
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

