/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class AllocationExpression
extends Expression
implements InvocationSite {
    public TypeReference type;
    public Expression[] arguments;
    public MethodBinding binding;
    public MethodBinding codegenBinding;
    public MethodBinding a;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;
    public FieldDeclaration enumConstant;

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.checkCapturedLocalInitializationIfNecessary((ReferenceBinding)this.binding.declaringClass.erasure(), blockScope, flowInfo);
        if (this.arguments != null) {
            int n2 = 0;
            int n3 = this.arguments.length;
            while (n2 < n3) {
                flowInfo = this.arguments[n2].analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                ++n2;
            }
        }
        TypeBinding[] typeBindingArray = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions.length != 0) {
            flowContext.checkExceptionHandlers(typeBindingArray, (ASTNode)this, flowInfo, blockScope);
        }
        this.manageEnclosingInstanceAccessIfNecessary(blockScope, flowInfo);
        this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
        return flowInfo;
    }

    public void checkCapturedLocalInitializationIfNecessary(ReferenceBinding referenceBinding, BlockScope blockScope, FlowInfo flowInfo) {
        NestedTypeBinding nestedTypeBinding;
        SyntheticArgumentBinding[] syntheticArgumentBindingArray;
        if (referenceBinding.isLocalType() && !referenceBinding.isAnonymousType() && !blockScope.isDefinedInType(referenceBinding) && (syntheticArgumentBindingArray = (nestedTypeBinding = (NestedTypeBinding)referenceBinding).syntheticOuterLocalVariables()) != null) {
            int n2 = 0;
            int n3 = syntheticArgumentBindingArray.length;
            while (n2 < n3) {
                SyntheticArgumentBinding syntheticArgumentBinding = syntheticArgumentBindingArray[n2];
                LocalVariableBinding localVariableBinding = syntheticArgumentBinding.actualOuterLocalVariable;
                if (localVariableBinding != null && localVariableBinding.declaration != null && !flowInfo.isDefinitelyAssigned(localVariableBinding)) {
                    blockScope.problemReporter().uninitializedLocalVariable(localVariableBinding, this);
                }
                ++n2;
            }
        }
    }

    public Expression enclosingInstance() {
        return null;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl2) {
        int n2 = codeStream.position;
        ReferenceBinding referenceBinding = this.codegenBinding.declaringClass;
        codeStream.new_(referenceBinding);
        if (bl2) {
            codeStream.dup();
        }
        if (this.type != null) {
            codeStream.recordPositionsFrom(n2, this.type.sourceStart);
        } else {
            codeStream.ldc(String.valueOf(this.enumConstant.name));
            codeStream.generateInlinedValue(this.enumConstant.binding.id);
        }
        if (referenceBinding.isNestedType()) {
            codeStream.generateSyntheticEnclosingInstanceValues(blockScope, referenceBinding, this.enclosingInstance(), this);
        }
        this.generateArguments(this.binding, this.arguments, blockScope, codeStream);
        if (referenceBinding.isNestedType()) {
            codeStream.generateSyntheticOuterArgumentValues(blockScope, referenceBinding, this);
        }
        if (this.a == null) {
            codeStream.invokespecial(this.codegenBinding);
        } else {
            int n3 = 0;
            int n4 = this.a.parameters.length - this.codegenBinding.parameters.length;
            while (n3 < n4) {
                codeStream.aconst_null();
                ++n3;
            }
            codeStream.invokespecial(this.a);
        }
        codeStream.generateImplicitConversion(this.implicitConversion);
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    public boolean isSuperAccess() {
        return false;
    }

    public boolean isTypeAccess() {
        return true;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding.declaringClass.erasure();
        if (referenceBinding.isNestedType() && blockScope.enclosingSourceType().isLocalType()) {
            if (referenceBinding.isLocalType()) {
                ((LocalTypeBinding)referenceBinding).addInnerEmulationDependent(blockScope, false);
            } else {
                blockScope.propagateInnerEmulation(referenceBinding, false);
            }
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        this.codegenBinding = this.binding.original();
        if (this.codegenBinding.isPrivate() && blockScope.enclosingSourceType() != this.codegenBinding.declaringClass) {
            if (blockScope.compilerOptions().isPrivateConstructorAccessChangingVisibility) {
                this.codegenBinding.tagForClearingPrivateModifier();
            } else {
                this.a = ((SourceTypeBinding)this.codegenBinding.declaringClass).addSyntheticMethod(this.codegenBinding, this.isSuperAccess());
                blockScope.problemReporter().needToEmulateMethodAccess(this.codegenBinding, this);
            }
        }
    }

    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        int n3;
        if (this.type != null) {
            stringBuffer.append("new ");
        }
        if (this.typeArguments != null) {
            stringBuffer.append('<');
            n3 = this.typeArguments.length - 1;
            int n4 = 0;
            while (n4 < n3) {
                this.typeArguments[n4].print(0, stringBuffer);
                stringBuffer.append(", ");
                ++n4;
            }
            this.typeArguments[n3].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        if (this.type != null) {
            this.type.printExpression(0, stringBuffer);
        }
        stringBuffer.append('(');
        if (this.arguments != null) {
            n3 = 0;
            while (n3 < this.arguments.length) {
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n3].printExpression(0, stringBuffer);
                ++n3;
            }
        }
        return stringBuffer.append(')');
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        int n2;
        TypeBinding[] typeBindingArray;
        this.constant = NotAConstant;
        if (this.type == null) {
            this.resolvedType = blockScope.enclosingSourceType();
        } else {
            this.resolvedType = this.type.resolveType(blockScope, true);
            if (this.type instanceof ParameterizedQualifiedTypeReference) {
                ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
                if (referenceBinding == null) {
                    return null;
                }
                block0: while ((referenceBinding.modifiers & 8) == 0 && !referenceBinding.isRawType()) {
                    if ((referenceBinding = referenceBinding.enclosingType()) != null) continue;
                    typeBindingArray = (ParameterizedQualifiedTypeReference)this.type;
                    n2 = typeBindingArray.typeArguments.length - 2;
                    while (n2 >= 0) {
                        if (typeBindingArray.typeArguments[n2] != null) {
                            blockScope.problemReporter().illegalQualifiedParameterizedTypeAllocation(this.type, this.resolvedType);
                            break block0;
                        }
                        --n2;
                    }
                    break block0;
                }
            }
        }
        if (this.typeArguments != null) {
            int n3 = this.typeArguments.length;
            boolean bl2 = false;
            this.genericTypeArguments = new TypeBinding[n3];
            n2 = 0;
            while (n2 < n3) {
                this.genericTypeArguments[n2] = this.typeArguments[n2].resolveType(blockScope, true);
                if (this.genericTypeArguments[n2] == null) {
                    bl2 = true;
                }
                ++n2;
            }
            if (bl2) {
                return null;
            }
        }
        boolean bl3 = false;
        typeBindingArray = NoParameters;
        if (this.arguments != null) {
            n2 = 0;
            int n4 = this.arguments.length;
            typeBindingArray = new TypeBinding[n4];
            int n5 = 0;
            while (n5 < n4) {
                Expression expression = this.arguments[n5];
                if (expression instanceof CastExpression) {
                    expression.bits |= 0x20;
                    bl3 = true;
                }
                if ((typeBindingArray[n5] = expression.resolveType(blockScope)) == null) {
                    n2 = 1;
                }
                ++n5;
            }
            if (n2 != 0) {
                return this.resolvedType;
            }
        }
        if (this.resolvedType == null) {
            return null;
        }
        if (this.type != null && !this.resolvedType.canBeInstantiated()) {
            blockScope.problemReporter().cannotInstantiate(this.type, this.resolvedType);
            return this.resolvedType;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
        this.binding = blockScope.getConstructor(referenceBinding, typeBindingArray, this);
        if (!this.binding.isValidBinding()) {
            if (this.binding.declaringClass == null) {
                this.binding.declaringClass = referenceBinding;
            }
            blockScope.problemReporter().invalidConstructor(this, this.binding);
            return this.resolvedType;
        }
        if (this.isMethodUseDeprecated(this.binding, blockScope)) {
            blockScope.problemReporter().deprecatedMethod(this.binding, this);
        }
        AllocationExpression.checkInvocationArguments(blockScope, null, referenceBinding, this.binding, this.arguments, typeBindingArray, bl3, this);
        return referenceBinding;
    }

    public void setActualReceiverType(ReferenceBinding referenceBinding) {
    }

    public void setDepth(int n2) {
    }

    public void setFieldIndex(int n2) {
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n2;
            int n3;
            if (this.typeArguments != null) {
                n3 = 0;
                n2 = this.typeArguments.length;
                while (n3 < n2) {
                    this.typeArguments[n3].traverse(aSTVisitor, blockScope);
                    ++n3;
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
            if (this.arguments != null) {
                n3 = 0;
                n2 = this.arguments.length;
                while (n3 < n2) {
                    this.arguments[n3].traverse(aSTVisitor, blockScope);
                    ++n3;
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

