/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class ConfigurableOption {
    private String componentName;
    private String optionName;
    private int id;
    private String category;
    private String name;
    private String description;
    private int currentValueIndex;
    private int defaultValueIndex;
    private String[] possibleValues;
    public static final String[] NoDiscreteValue = new String[0];

    public ConfigurableOption(String string, String string2, Locale locale, int n2) {
        Object object;
        this.componentName = string;
        this.optionName = string2;
        this.currentValueIndex = n2;
        ResourceBundle resourceBundle = null;
        try {
            object = string.substring(0, string.lastIndexOf(46));
            resourceBundle = ResourceBundle.getBundle(String.valueOf(object) + ".options", locale);
        }
        catch (MissingResourceException missingResourceException) {
            this.category = "Missing ressources entries for" + string + " options";
            this.name = "Missing ressources entries for" + string + " options";
            this.description = "Missing ressources entries for" + string + " options";
            this.possibleValues = new String[0];
            this.id = -1;
        }
        if (resourceBundle == null) {
            return;
        }
        try {
            this.id = Integer.parseInt(resourceBundle.getString(String.valueOf(string2) + ".number"));
        }
        catch (MissingResourceException missingResourceException) {
            this.id = -1;
        }
        catch (NumberFormatException numberFormatException) {
            this.id = -1;
        }
        try {
            this.category = resourceBundle.getString(String.valueOf(string2) + ".category");
        }
        catch (MissingResourceException missingResourceException) {
            this.category = "Missing ressources entries for" + string + " options";
        }
        try {
            this.name = resourceBundle.getString(String.valueOf(string2) + ".name");
        }
        catch (MissingResourceException missingResourceException) {
            this.name = "Missing ressources entries for" + string + " options";
        }
        try {
            object = new StringTokenizer(resourceBundle.getString(String.valueOf(string2) + ".possibleValues"), "|");
            int n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
            if (n3 == -1) {
                this.possibleValues = NoDiscreteValue;
            } else {
                this.possibleValues = new String[n3];
                int n4 = 0;
                while (((StringTokenizer)object).hasMoreTokens()) {
                    this.possibleValues[n4] = ((StringTokenizer)object).nextToken();
                    ++n4;
                }
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.possibleValues = new String[0];
        }
        catch (NoSuchElementException noSuchElementException) {
            this.possibleValues = new String[0];
        }
        catch (NumberFormatException numberFormatException) {
            this.possibleValues = new String[0];
        }
        try {
            this.description = resourceBundle.getString(String.valueOf(string2) + ".description");
        }
        catch (MissingResourceException missingResourceException) {
            this.description = "Missing ressources entries for" + string + " options";
        }
    }

    public String getCategory() {
        return this.category;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public int getCurrentValueIndex() {
        return this.currentValueIndex;
    }

    public int getDefaultValueIndex() {
        return this.defaultValueIndex;
    }

    public String getDescription() {
        return this.description;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String[] getPossibleValues() {
        return this.possibleValues;
    }

    public void setValueIndex(int n2) {
        this.currentValueIndex = n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Configurable option for ");
        stringBuffer.append(this.componentName).append("\n");
        stringBuffer.append("- category:\t\t\t").append(this.category).append("\n");
        stringBuffer.append("- name:\t\t\t\t").append(this.name).append("\n");
        stringBuffer.append("- current value:\t");
        if (this.possibleValues == NoDiscreteValue) {
            stringBuffer.append(this.currentValueIndex);
        } else {
            stringBuffer.append(this.possibleValues[this.currentValueIndex]);
        }
        stringBuffer.append("\n");
        if (this.possibleValues != NoDiscreteValue) {
            stringBuffer.append("- possible values:\t[");
            int n2 = 0;
            int n3 = this.possibleValues.length;
            while (n2 < n3) {
                if (n2 != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.possibleValues[n2]);
                ++n2;
            }
            stringBuffer.append("]\n");
            stringBuffer.append("- curr. val. index:\t").append(this.currentValueIndex).append("\n");
        }
        stringBuffer.append("- description:\t\t").append(this.description).append("\n");
        return stringBuffer.toString();
    }

    public String getOptionName() {
        return this.optionName;
    }
}

