/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class CompilationResult {
    public IProblem[] problems;
    public IProblem[] tasks;
    public int problemCount;
    public int taskCount;
    public ICompilationUnit compilationUnit;
    private Map problemsMap;
    private Set firstErrors;
    private int maxProblemPerUnit;
    public char[][][] qualifiedReferences;
    public char[][] simpleNameReferences;
    public int[] lineSeparatorPositions;
    public Map compiledTypes = new Hashtable(11);
    public int unitIndex;
    public int totalUnitsKnown;
    public boolean hasBeenAccepted = false;
    public char[] fileName;
    public boolean hasInconsistentToplevelHierarchies = false;
    public boolean hasSyntaxError = false;
    public long[] c;
    public long[] b;
    public int a;

    public CompilationResult(char[] cArray, int n2, int n3, int n4) {
        this.fileName = cArray;
        this.unitIndex = n2;
        this.totalUnitsKnown = n3;
        this.maxProblemPerUnit = n4;
    }

    public CompilationResult(ICompilationUnit iCompilationUnit, int n2, int n3, int n4) {
        this.fileName = iCompilationUnit.getFileName();
        this.compilationUnit = iCompilationUnit;
        this.unitIndex = n2;
        this.totalUnitsKnown = n3;
        this.maxProblemPerUnit = n4;
    }

    private int computePriority(IProblem iProblem) {
        ReferenceContext referenceContext;
        int n2 = 10000 - iProblem.getSourceLineNumber();
        if (n2 < 0) {
            n2 = 0;
        }
        if (iProblem.isError()) {
            n2 += 100000;
        }
        ReferenceContext referenceContext2 = referenceContext = this.problemsMap == null ? null : (ReferenceContext)this.problemsMap.get(iProblem);
        if (referenceContext != null) {
            if (referenceContext instanceof AbstractMethodDeclaration) {
                AbstractMethodDeclaration abstractMethodDeclaration = (AbstractMethodDeclaration)referenceContext;
                if (abstractMethodDeclaration.isStatic()) {
                    n2 += 10000;
                }
            } else {
                n2 += 40000;
            }
            if (this.firstErrors.contains(iProblem)) {
                n2 += 20000;
            }
        } else {
            n2 += 40000;
        }
        return n2;
    }

    public void discardSuppressedWarnings() {
        IProblem iProblem;
        if (this.a == 0) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = this.problemCount;
        while (n3 < n4) {
            iProblem = this.problems[n3];
            if (iProblem.isWarning()) {
                int n5 = iProblem.getSourceStart();
                int n6 = iProblem.getSourceEnd();
                int n7 = iProblem.getID();
                int n8 = 0;
                int n9 = this.a;
                while (n8 < n9) {
                    long l2 = this.b[n8];
                    int n10 = (int)(l2 >>> 32);
                    int n11 = (int)l2;
                    if (n5 >= n10 && n6 <= n11 && (ProblemReporter.getIrritant(n7) & this.c[n8]) != 0L) {
                        ++n2;
                        this.problems[n3] = null;
                        if (this.problemsMap != null) {
                            this.problemsMap.remove(iProblem);
                        }
                        if (this.firstErrors == null) break;
                        this.firstErrors.remove(iProblem);
                        break;
                    }
                    ++n8;
                }
            }
            ++n3;
        }
        if (n2 > 0) {
            n3 = 0;
            n4 = 0;
            while (n3 < this.problemCount) {
                iProblem = this.problems[n3];
                if (iProblem != null) {
                    if (n3 > n4) {
                        this.problems[n4++] = iProblem;
                    } else {
                        ++n4;
                    }
                }
                ++n3;
            }
            this.problemCount -= n2;
        }
    }

    public IProblem[] getAllProblems() {
        int n2;
        IProblem[] iProblemArray = this.getProblems();
        int n3 = iProblemArray != null ? iProblemArray.length : 0;
        IProblem[] iProblemArray2 = this.getTasks();
        int n4 = n2 = iProblemArray2 != null ? iProblemArray2.length : 0;
        if (n2 == 0) {
            return iProblemArray;
        }
        if (n3 == 0) {
            return iProblemArray2;
        }
        int n5 = n3 + n2;
        IProblem[] iProblemArray3 = new IProblem[n5];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n7 + n8 < n5) {
            IProblem iProblem = null;
            IProblem iProblem2 = null;
            if (n7 < n2) {
                iProblem = iProblemArray2[n7];
            }
            if (n8 < n3) {
                iProblem2 = iProblemArray[n8];
            }
            IProblem iProblem3 = null;
            if (iProblem2 != null) {
                if (iProblem != null) {
                    if (iProblem2.getSourceStart() < iProblem.getSourceStart()) {
                        iProblem3 = iProblem2;
                        ++n8;
                    } else {
                        iProblem3 = iProblem;
                        ++n7;
                    }
                } else {
                    iProblem3 = iProblem2;
                    ++n8;
                }
            } else if (iProblem != null) {
                iProblem3 = iProblem;
                ++n7;
            }
            iProblemArray3[n6++] = iProblem3;
        }
        return iProblemArray3;
    }

    public ClassFile[] getClassFiles() {
        ClassFile[] classFileArray = new ClassFile[this.compiledTypes.size()];
        this.compiledTypes.values().toArray(classFileArray);
        return classFileArray;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public IProblem[] getErrors() {
        IProblem[] iProblemArray = this.getProblems();
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.problemCount) {
            if (iProblemArray[n3].isError()) {
                ++n2;
            }
            ++n3;
        }
        if (n2 == this.problemCount) {
            return iProblemArray;
        }
        IProblem[] iProblemArray2 = new IProblem[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.problemCount) {
            if (iProblemArray[n5].isError()) {
                iProblemArray2[n4++] = iProblemArray[n5];
            }
            ++n5;
        }
        return iProblemArray2;
    }

    public IProblem[] getProblems() {
        if (this.problems != null) {
            this.discardSuppressedWarnings();
            if (this.problemCount != this.problems.length) {
                this.problems = new IProblem[this.problemCount];
                System.arraycopy(this.problems, 0, this.problems, 0, this.problemCount);
            }
            if (this.maxProblemPerUnit > 0 && this.problemCount > this.maxProblemPerUnit) {
                this.quickPrioritize(this.problems, 0, this.problemCount - 1);
                this.problemCount = this.maxProblemPerUnit;
                this.problems = new IProblem[this.problemCount];
                System.arraycopy(this.problems, 0, this.problems, 0, this.problemCount);
            }
            CompilationResult.quickSort(this.problems, 0, this.problems.length - 1);
        }
        return this.problems;
    }

    public IProblem[] getTasks() {
        if (this.tasks != null) {
            if (this.taskCount != this.tasks.length) {
                this.tasks = new IProblem[this.taskCount];
                System.arraycopy(this.tasks, 0, this.tasks, 0, this.taskCount);
            }
            CompilationResult.quickSort(this.tasks, 0, this.tasks.length - 1);
        }
        return this.tasks;
    }

    public boolean hasErrors() {
        if (this.problems != null) {
            int n2 = 0;
            while (n2 < this.problemCount) {
                if (this.problems[n2].isError()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean hasProblems() {
        return this.problemCount != 0;
    }

    public boolean hasTasks() {
        return this.taskCount != 0;
    }

    public boolean hasWarnings() {
        if (this.problems != null) {
            int n2 = 0;
            while (n2 < this.problemCount) {
                if (this.problems[n2].isWarning()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static void quickSort(IProblem[] iProblemArray, int n2, int n3) {
        if (n2 >= n3) {
            return;
        }
        int n4 = n2;
        int n5 = n3;
        int n6 = iProblemArray[(n2 + n3) / 2].getSourceStart();
        while (true) {
            if (iProblemArray[n2].getSourceStart() < n6) {
                ++n2;
                continue;
            }
            while (n6 < iProblemArray[n3].getSourceStart()) {
                --n3;
            }
            if (n2 <= n3) {
                IProblem iProblem = iProblemArray[n2];
                iProblemArray[n2] = iProblemArray[n3];
                iProblemArray[n3] = iProblem;
                ++n2;
                --n3;
            }
            if (n2 > n3) break;
        }
        if (n4 < n3) {
            CompilationResult.quickSort(iProblemArray, n4, n3);
        }
        if (n2 < n5) {
            CompilationResult.quickSort(iProblemArray, n2, n5);
        }
    }

    private void quickPrioritize(IProblem[] iProblemArray, int n2, int n3) {
        if (n2 >= n3) {
            return;
        }
        int n4 = n2;
        int n5 = n3;
        int n6 = this.computePriority(iProblemArray[(n2 + n3) / 2]);
        while (true) {
            if (this.computePriority(iProblemArray[n3]) < n6) {
                --n3;
                continue;
            }
            while (n6 < this.computePriority(iProblemArray[n2])) {
                ++n2;
            }
            if (n2 <= n3) {
                IProblem iProblem = iProblemArray[n2];
                iProblemArray[n2] = iProblemArray[n3];
                iProblemArray[n3] = iProblem;
                ++n2;
                --n3;
            }
            if (n2 > n3) break;
        }
        if (n4 < n3) {
            this.quickPrioritize(iProblemArray, n4, n3);
        }
        if (n2 < n5) {
            this.quickPrioritize(iProblemArray, n2, n5);
        }
    }

    public void record(char[] cArray, ClassFile classFile) {
        SourceTypeBinding sourceTypeBinding = classFile.referenceBinding;
        if (!sourceTypeBinding.isLocalType() && sourceTypeBinding.isHierarchyInconsistent()) {
            this.hasInconsistentToplevelHierarchies = true;
        }
        this.compiledTypes.put(cArray, classFile);
    }

    public void record(IProblem iProblem, ReferenceContext referenceContext) {
        if (iProblem.getID() == 536871362) {
            this.recordTask(iProblem);
            return;
        }
        if (this.problemCount == 0) {
            this.problems = new IProblem[5];
        } else if (this.problemCount == this.problems.length) {
            this.problems = new IProblem[this.problemCount * 2];
            System.arraycopy(this.problems, 0, this.problems, 0, this.problemCount);
        }
        this.problems[this.problemCount++] = iProblem;
        if (referenceContext != null) {
            if (this.problemsMap == null) {
                this.problemsMap = new HashMap(5);
            }
            if (this.firstErrors == null) {
                this.firstErrors = new HashSet(5);
            }
            if (iProblem.isError() && !referenceContext.hasErrors()) {
                this.firstErrors.add(iProblem);
            }
            this.problemsMap.put(iProblem, referenceContext);
        }
        if ((iProblem.getID() & 0x40000000) != 0 && iProblem.isError()) {
            this.hasSyntaxError = true;
        }
    }

    public void recordSuppressWarnings(long l2, int n2, int n3) {
        if (this.c == null) {
            this.c = new long[3];
            this.b = new long[3];
        } else if (this.c.length == this.a) {
            this.c = new long[2 * this.a];
            System.arraycopy(this.c, 0, this.c, 0, this.a);
            this.b = new long[2 * this.a];
            System.arraycopy(this.b, 0, this.b, 0, this.a);
        }
        this.c[this.a] = l2;
        this.b[this.a++] = ((long)n2 << 32) + (long)n3;
    }

    private void recordTask(IProblem iProblem) {
        if (this.taskCount == 0) {
            this.tasks = new IProblem[5];
        } else if (this.taskCount == this.tasks.length) {
            this.tasks = new IProblem[this.taskCount * 2];
            System.arraycopy(this.tasks, 0, this.tasks, 0, this.taskCount);
        }
        this.tasks[this.taskCount++] = iProblem;
    }

    public CompilationResult tagAsAccepted() {
        this.hasBeenAccepted = true;
        this.problemsMap = null;
        this.firstErrors = null;
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fileName != null) {
            stringBuffer.append("Filename : ").append(this.fileName).append('\n');
        }
        if (this.compiledTypes != null) {
            stringBuffer.append("COMPILED type(s)\t\n");
            Iterator iterator = this.compiledTypes.keySet().iterator();
            while (iterator.hasNext()) {
                char[] cArray = (char[])iterator.next();
                stringBuffer.append("\t - ").append(cArray).append('\n');
            }
        } else {
            stringBuffer.append("No COMPILED type\n");
        }
        if (this.problems != null) {
            stringBuffer.append(this.problemCount).append(" PROBLEM(s) detected \n");
            int n2 = 0;
            while (n2 < this.problemCount) {
                stringBuffer.append("\t - ").append(this.problems[n2]).append('\n');
                ++n2;
            }
        } else {
            stringBuffer.append("No PROBLEM\n");
        }
        return stringBuffer.toString();
    }
}

