/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;

public class UnionPattern
extends Expression {
    private StepPattern[] m_patterns;

    public void fixupVariables(Vector vector, int n2) {
        int n3 = 0;
        while (n3 < this.m_patterns.length) {
            this.m_patterns[n3].fixupVariables(vector, n2);
            ++n3;
        }
    }

    public boolean canTraverseOutsideSubtree() {
        if (null != this.m_patterns) {
            int n2 = this.m_patterns.length;
            int n3 = 0;
            while (n3 < n2) {
                if (this.m_patterns[n3].canTraverseOutsideSubtree()) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public void setPatterns(StepPattern[] stepPatternArray) {
        this.m_patterns = stepPatternArray;
        if (null != stepPatternArray) {
            int n2 = 0;
            while (n2 < stepPatternArray.length) {
                stepPatternArray[n2].exprSetParent(this);
                ++n2;
            }
        }
    }

    public StepPattern[] getPatterns() {
        return this.m_patterns;
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        XObject xObject = null;
        int n2 = this.m_patterns.length;
        int n3 = 0;
        while (n3 < n2) {
            XObject xObject2 = this.m_patterns[n3].execute(xPathContext);
            if (xObject2 != NodeTest.SCORE_NONE) {
                if (null == xObject) {
                    xObject = xObject2;
                } else if (xObject2.num() > xObject.num()) {
                    xObject = xObject2;
                }
            }
            ++n3;
        }
        if (null == xObject) {
            xObject = NodeTest.SCORE_NONE;
        }
        return xObject;
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        xPathVisitor.visitUnionPattern(expressionOwner, this);
        if (null != this.m_patterns) {
            int n2 = this.m_patterns.length;
            int n3 = 0;
            while (n3 < n2) {
                this.m_patterns[n3].callVisitors(new UnionPathPartOwner(this, n3), xPathVisitor);
                ++n3;
            }
        }
    }

    public boolean deepEquals(Expression expression) {
        if (!this.isSameClass(expression)) {
            return false;
        }
        UnionPattern unionPattern = (UnionPattern)expression;
        if (null != this.m_patterns) {
            int n2 = this.m_patterns.length;
            if (null == unionPattern.m_patterns || unionPattern.m_patterns.length != n2) {
                return false;
            }
            int n3 = 0;
            while (n3 < n2) {
                if (!this.m_patterns[n3].deepEquals(unionPattern.m_patterns[n3])) {
                    return false;
                }
                ++n3;
            }
        } else if (unionPattern.m_patterns != null) {
            return false;
        }
        return true;
    }

    public static StepPattern[] a(UnionPattern unionPattern) {
        return unionPattern.m_patterns;
    }

    public class UnionPathPartOwner
    implements ExpressionOwner {
        public int a;
        private final UnionPattern this$0;

        public UnionPathPartOwner(UnionPattern unionPattern, int n2) {
            this.this$0 = unionPattern;
            this.a = n2;
        }

        public Expression getExpression() {
            return UnionPattern.a(this.this$0)[this.a];
        }

        public void setExpression(Expression expression) {
            expression.exprSetParent(this.this$0);
            UnionPattern.a((UnionPattern)this.this$0)[this.a] = (StepPattern)expression;
        }
    }
}

