/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;

public class StepPattern
extends NodeTest
implements SubContextList,
ExpressionOwner {
    public int m_axis;
    public String b;
    public StepPattern e;
    public Expression[] d;
    private static final boolean DEBUG_MATCHES = false;

    public StepPattern(int n2, String string, String string2, int n3, int n4) {
        super(n2, string, string2);
        this.m_axis = n3;
    }

    public StepPattern(int n2, int n3, int n4) {
        super(n2);
        this.m_axis = n3;
    }

    public void calcTargetString() {
        int n2 = this.getWhatToShow();
        switch (n2) {
            case 128: {
                this.b = "#comment";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                this.b = "#text";
                break;
            }
            case -1: {
                this.b = "*";
                break;
            }
            case 256: 
            case 1280: {
                this.b = "/";
                break;
            }
            case 1: {
                if ("*" == this.m_name) {
                    this.b = "*";
                    break;
                }
                this.b = this.m_name;
                break;
            }
            default: {
                this.b = "*";
            }
        }
    }

    public String getTargetString() {
        return this.b;
    }

    public void fixupVariables(Vector vector, int n2) {
        super.fixupVariables(vector, n2);
        if (null != this.d) {
            int n3 = 0;
            while (n3 < this.d.length) {
                this.d[n3].fixupVariables(vector, n2);
                ++n3;
            }
        }
        if (null != this.e) {
            this.e.fixupVariables(vector, n2);
        }
    }

    public void setRelativePathPattern(StepPattern stepPattern) {
        this.e = stepPattern;
        stepPattern.exprSetParent(this);
        this.calcScore();
    }

    public StepPattern getRelativePathPattern() {
        return this.e;
    }

    public Expression[] getPredicates() {
        return this.d;
    }

    public boolean canTraverseOutsideSubtree() {
        int n2 = this.getPredicateCount();
        int n3 = 0;
        while (n3 < n2) {
            if (this.getPredicate(n3).canTraverseOutsideSubtree()) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public Expression getPredicate(int n2) {
        return this.d[n2];
    }

    public final int getPredicateCount() {
        return null == this.d ? 0 : this.d.length;
    }

    public void setPredicates(Expression[] expressionArray) {
        this.d = expressionArray;
        if (null != expressionArray) {
            int n2 = 0;
            while (n2 < expressionArray.length) {
                expressionArray[n2].exprSetParent(this);
                ++n2;
            }
        }
        this.calcScore();
    }

    public void calcScore() {
        if (this.getPredicateCount() > 0 || null != this.e) {
            this.c = NodeTest.SCORE_OTHER;
        } else {
            super.calcScore();
        }
        if (null == this.b) {
            this.calcTargetString();
        }
    }

    public XObject execute(XPathContext xPathContext, int n2) throws TransformerException {
        DTM dTM = xPathContext.getDTM(n2);
        if (dTM != null) {
            int n3 = dTM.getExpandedTypeID(n2);
            return this.execute(xPathContext, n2, dTM, n3);
        }
        return NodeTest.SCORE_NONE;
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        return this.execute(xPathContext, xPathContext.getCurrentNode());
    }

    public XObject execute(XPathContext xPathContext, int n2, DTM dTM, int n3) throws TransformerException {
        if (this.m_whatToShow == 65536) {
            if (null != this.e) {
                return this.e.execute(xPathContext);
            }
            return NodeTest.SCORE_NONE;
        }
        XObject xObject = super.execute(xPathContext, n2, dTM, n3);
        if (xObject == NodeTest.SCORE_NONE) {
            return NodeTest.SCORE_NONE;
        }
        if (this.getPredicateCount() != 0 && !this.executePredicates(xPathContext, dTM, n2)) {
            return NodeTest.SCORE_NONE;
        }
        if (null != this.e) {
            return this.e.executeRelativePathPattern(xPathContext, dTM, n2);
        }
        return xObject;
    }

    private final boolean checkProximityPosition(XPathContext xPathContext, int n2, DTM dTM, int n3, int n4) {
        try {
            DTMAxisTraverser dTMAxisTraverser = dTM.getAxisTraverser(12);
            int n5 = dTMAxisTraverser.first(n3);
            while (-1 != n5) {
                Object var18_15;
                try {
                    xPathContext.pushCurrentNode(n5);
                    if (NodeTest.SCORE_NONE != super.execute(xPathContext, n5)) {
                        Object var16_14;
                        int n6;
                        boolean bl2 = true;
                        try {
                            xPathContext.pushSubContextList(this);
                            n6 = 0;
                            while (n6 < n2) {
                                Object var14_13;
                                xPathContext.pushPredicatePos(n6);
                                try {
                                    Object var12_12;
                                    XObject xObject;
                                    block16: {
                                        xObject = this.d[n6].execute(xPathContext);
                                        try {
                                            if (2 == xObject.getType()) {
                                                throw new Error("Why: Should never have been called");
                                            }
                                            if (xObject.boolWithSideEffects()) break block16;
                                            bl2 = false;
                                            var12_12 = null;
                                            xObject.detach();
                                        }
                                        catch (Throwable throwable) {
                                            var12_12 = null;
                                            xObject.detach();
                                            throw throwable;
                                        }
                                        var14_13 = null;
                                        xPathContext.popPredicatePos();
                                        {
                                            break;
                                        }
                                    }
                                    var12_12 = null;
                                    xObject.detach();
                                    {
                                    }
                                }
                                catch (Throwable throwable) {
                                    var14_13 = null;
                                    xPathContext.popPredicatePos();
                                    throw throwable;
                                }
                                var14_13 = null;
                                xPathContext.popPredicatePos();
                                ++n6;
                            }
                            var16_14 = null;
                            xPathContext.popSubContextList();
                        }
                        catch (Throwable throwable) {
                            var16_14 = null;
                            xPathContext.popSubContextList();
                            throw throwable;
                        }
                        if (bl2) {
                            --n4;
                        }
                        if (n4 < 1) {
                            n6 = 0;
                            var18_15 = null;
                            xPathContext.popCurrentNode();
                            return n6 != 0;
                        }
                    }
                    var18_15 = null;
                    xPathContext.popCurrentNode();
                }
                catch (Throwable throwable) {
                    var18_15 = null;
                    xPathContext.popCurrentNode();
                    throw throwable;
                }
                n5 = dTMAxisTraverser.next(n3, n5);
            }
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException.getMessage());
        }
        return n4 == 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int getProximityPosition(XPathContext xPathContext, int n2, boolean bl2) {
        int n3 = 0;
        int n4 = xPathContext.getCurrentNode();
        DTM dTM = xPathContext.getDTM(n4);
        int n5 = dTM.getParent(n4);
        try {
            DTMAxisTraverser dTMAxisTraverser = dTM.getAxisTraverser(3);
            int n6 = dTMAxisTraverser.first(n5);
            while (true) {
                Object var20_17;
                if (-1 == n6) {
                    return n3;
                }
                try {
                    xPathContext.pushCurrentNode(n6);
                    if (NodeTest.SCORE_NONE != super.execute(xPathContext, n6)) {
                        Object var18_16;
                        int n7;
                        boolean bl3 = true;
                        try {
                            xPathContext.pushSubContextList(this);
                            n7 = 0;
                            while (true) {
                                Object var16_15;
                                block22: {
                                    block21: {
                                        if (n7 >= n2) {
                                            break;
                                        }
                                        xPathContext.pushPredicatePos(n7);
                                        try {
                                            Object var14_14;
                                            XObject xObject;
                                            block18: {
                                                block20: {
                                                    block19: {
                                                        xObject = this.d[n7].execute(xPathContext);
                                                        try {
                                                            if (2 == xObject.getType()) {
                                                                if (n3 + 1 == (int)xObject.numWithSideEffects()) break block18;
                                                                bl3 = false;
                                                                var14_14 = null;
                                                                xObject.detach();
                                                                break block19;
                                                            }
                                                            if (xObject.boolWithSideEffects()) break block18;
                                                            bl3 = false;
                                                            break block20;
                                                        }
                                                        catch (Throwable throwable) {
                                                            var14_14 = null;
                                                            xObject.detach();
                                                            throw throwable;
                                                        }
                                                    }
                                                    var16_15 = null;
                                                    xPathContext.popPredicatePos();
                                                    break;
                                                }
                                                var14_14 = null;
                                                xObject.detach();
                                                break block21;
                                            }
                                            var14_14 = null;
                                            xObject.detach();
                                            break block22;
                                        }
                                        catch (Throwable throwable) {
                                            var16_15 = null;
                                            xPathContext.popPredicatePos();
                                            throw throwable;
                                        }
                                    }
                                    var16_15 = null;
                                    xPathContext.popPredicatePos();
                                    break;
                                }
                                var16_15 = null;
                                xPathContext.popPredicatePos();
                                ++n7;
                            }
                            var18_16 = null;
                            xPathContext.popSubContextList();
                        }
                        catch (Throwable throwable) {
                            var18_16 = null;
                            xPathContext.popSubContextList();
                            throw throwable;
                        }
                        if (bl3) {
                            ++n3;
                        }
                        if (!bl2 && n6 == n4) {
                            n7 = n3;
                            var20_17 = null;
                            xPathContext.popCurrentNode();
                            return n7;
                        }
                    }
                    var20_17 = null;
                    xPathContext.popCurrentNode();
                }
                catch (Throwable throwable) {
                    var20_17 = null;
                    xPathContext.popCurrentNode();
                    throw throwable;
                }
                n6 = dTMAxisTraverser.next(n5, n6);
            }
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException.getMessage());
        }
    }

    public int getProximityPosition(XPathContext xPathContext) {
        return this.getProximityPosition(xPathContext, xPathContext.getPredicatePos(), false);
    }

    public int getLastPos(XPathContext xPathContext) {
        return this.getProximityPosition(xPathContext, xPathContext.getPredicatePos(), true);
    }

    public final XObject executeRelativePathPattern(XPathContext xPathContext, DTM dTM, int n2) throws TransformerException {
        XObject xObject = NodeTest.SCORE_NONE;
        int n3 = n2;
        DTMAxisTraverser dTMAxisTraverser = dTM.getAxisTraverser(this.m_axis);
        int n4 = dTMAxisTraverser.first(n3);
        while (-1 != n4) {
            Object var9_8;
            try {
                xPathContext.pushCurrentNode(n4);
                xObject = this.execute(xPathContext);
                if (xObject != NodeTest.SCORE_NONE) {
                    var9_8 = null;
                    xPathContext.popCurrentNode();
                    break;
                }
                var9_8 = null;
                xPathContext.popCurrentNode();
            }
            catch (Throwable throwable) {
                var9_8 = null;
                xPathContext.popCurrentNode();
                throw throwable;
            }
            n4 = dTMAxisTraverser.next(n3, n4);
        }
        return xObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean executePredicates(XPathContext xPathContext, DTM dTM, int n2) throws TransformerException {
        boolean bl2 = true;
        boolean bl3 = false;
        int n3 = this.getPredicateCount();
        try {
            xPathContext.pushSubContextList(this);
            int n4 = 0;
            while (true) {
                Object var13_11;
                block16: {
                    block15: {
                        block14: {
                            if (n4 >= n3) {
                                break;
                            }
                            xPathContext.pushPredicatePos(n4);
                            try {
                                Object var11_10;
                                XObject xObject;
                                block11: {
                                    block13: {
                                        block12: {
                                            block10: {
                                                xObject = this.d[n4].execute(xPathContext);
                                                try {
                                                    if (2 == xObject.getType()) {
                                                        int n5 = (int)xObject.num();
                                                        if (bl3) {
                                                            bl2 = n5 == 1;
                                                            var11_10 = null;
                                                            xObject.detach();
                                                            break block10;
                                                        }
                                                        bl3 = true;
                                                        if (this.checkProximityPosition(xPathContext, n4, dTM, n2, n5)) break block11;
                                                        bl2 = false;
                                                        break block12;
                                                    }
                                                    if (xObject.boolWithSideEffects()) break block11;
                                                    bl2 = false;
                                                    break block13;
                                                }
                                                catch (Throwable throwable) {
                                                    var11_10 = null;
                                                    xObject.detach();
                                                    throw throwable;
                                                }
                                            }
                                            var13_11 = null;
                                            xPathContext.popPredicatePos();
                                            break;
                                        }
                                        var11_10 = null;
                                        xObject.detach();
                                        break block14;
                                    }
                                    var11_10 = null;
                                    xObject.detach();
                                    break block15;
                                }
                                var11_10 = null;
                                xObject.detach();
                                break block16;
                            }
                            catch (Throwable throwable) {
                                var13_11 = null;
                                xPathContext.popPredicatePos();
                                throw throwable;
                            }
                        }
                        var13_11 = null;
                        xPathContext.popPredicatePos();
                        break;
                    }
                    var13_11 = null;
                    xPathContext.popPredicatePos();
                    break;
                }
                var13_11 = null;
                xPathContext.popPredicatePos();
                ++n4;
            }
            Object var15_14 = null;
            xPathContext.popSubContextList();
            return bl2;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            xPathContext.popSubContextList();
            throw throwable;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StepPattern stepPattern = this;
        while (stepPattern != null) {
            if (stepPattern != this) {
                stringBuffer.append("/");
            }
            stringBuffer.append(Axis.names[stepPattern.m_axis]);
            stringBuffer.append("::");
            if (20480 == stepPattern.m_whatToShow) {
                stringBuffer.append("doc()");
            } else if (65536 == stepPattern.m_whatToShow) {
                stringBuffer.append("function()");
            } else if (-1 == stepPattern.m_whatToShow) {
                stringBuffer.append("node()");
            } else if (4 == stepPattern.m_whatToShow) {
                stringBuffer.append("text()");
            } else if (64 == stepPattern.m_whatToShow) {
                stringBuffer.append("processing-instruction(");
                if (null != stepPattern.m_name) {
                    stringBuffer.append(stepPattern.m_name);
                }
                stringBuffer.append(")");
            } else if (128 == stepPattern.m_whatToShow) {
                stringBuffer.append("comment()");
            } else if (null != stepPattern.m_name) {
                if (2 == stepPattern.m_whatToShow) {
                    stringBuffer.append("@");
                }
                if (null != stepPattern.a) {
                    stringBuffer.append("{");
                    stringBuffer.append(stepPattern.a);
                    stringBuffer.append("}");
                }
                stringBuffer.append(stepPattern.m_name);
            } else if (2 == stepPattern.m_whatToShow) {
                stringBuffer.append("@");
            } else if (1280 == stepPattern.m_whatToShow) {
                stringBuffer.append("doc-root()");
            } else {
                stringBuffer.append("?" + Integer.toHexString(stepPattern.m_whatToShow));
            }
            if (null != stepPattern.d) {
                int n2 = 0;
                while (n2 < stepPattern.d.length) {
                    stringBuffer.append("[");
                    stringBuffer.append(stepPattern.d[n2]);
                    stringBuffer.append("]");
                    ++n2;
                }
            }
            stepPattern = stepPattern.e;
        }
        return stringBuffer.toString();
    }

    public double getMatchScore(XPathContext xPathContext, int n2) throws TransformerException {
        xPathContext.pushCurrentNode(n2);
        xPathContext.pushCurrentExpressionNode(n2);
        try {
            XObject xObject = this.execute(xPathContext);
            double d2 = xObject.num();
            Object var7_5 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            return d2;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            xPathContext.popCurrentNode();
            xPathContext.popCurrentExpressionNode();
            throw throwable;
        }
    }

    public void setAxis(int n2) {
        this.m_axis = n2;
    }

    public int getAxis() {
        return this.m_axis;
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        if (xPathVisitor.visitMatchPattern(expressionOwner, this)) {
            this.callSubtreeVisitors(xPathVisitor);
        }
    }

    public void callSubtreeVisitors(XPathVisitor xPathVisitor) {
        if (null != this.d) {
            int n2 = this.d.length;
            int n3 = 0;
            while (n3 < n2) {
                PredOwner predOwner = new PredOwner(this, n3);
                if (xPathVisitor.visitPredicate(predOwner, this.d[n3])) {
                    this.d[n3].callVisitors(predOwner, xPathVisitor);
                }
                ++n3;
            }
        }
        if (null != this.e) {
            this.e.callVisitors(this, xPathVisitor);
        }
    }

    public Expression getExpression() {
        return this.e;
    }

    public void setExpression(Expression expression) {
        expression.exprSetParent(this);
        this.e = (StepPattern)expression;
    }

    public boolean deepEquals(Expression expression) {
        if (!super.deepEquals(expression)) {
            return false;
        }
        StepPattern stepPattern = (StepPattern)expression;
        if (null != this.d) {
            int n2 = this.d.length;
            if (null == stepPattern.d || stepPattern.d.length != n2) {
                return false;
            }
            int n3 = 0;
            while (n3 < n2) {
                if (!this.d[n3].deepEquals(stepPattern.d[n3])) {
                    return false;
                }
                ++n3;
            }
        } else if (null != stepPattern.d) {
            return false;
        }
        return !(null != this.e ? !this.e.deepEquals(stepPattern.e) : stepPattern.e != null);
    }

    public class PredOwner
    implements ExpressionOwner {
        public int a;
        private final StepPattern this$0;

        public PredOwner(StepPattern stepPattern, int n2) {
            this.this$0 = stepPattern;
            this.a = n2;
        }

        public Expression getExpression() {
            return this.this$0.d[this.a];
        }

        public void setExpression(Expression expression) {
            expression.exprSetParent(this.this$0);
            this.this$0.d[this.a] = expression;
        }
    }
}

