/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.ref.DTMNodeIterator;
import org.apache.xml.dtm.ref.DTMNodeList;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLString;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.axes.NodeSequence;
import org.apache.xpath.objects.Comparator;
import org.apache.xpath.objects.EqualComparator;
import org.apache.xpath.objects.GreaterThanComparator;
import org.apache.xpath.objects.GreaterThanOrEqualComparator;
import org.apache.xpath.objects.LessThanComparator;
import org.apache.xpath.objects.LessThanOrEqualComparator;
import org.apache.xpath.objects.NotEqualComparator;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XNodeSet
extends NodeSequence {
    public static LessThanComparator d = new LessThanComparator();
    public static LessThanOrEqualComparator a = new LessThanOrEqualComparator();
    public static GreaterThanComparator e = new GreaterThanComparator();
    public static GreaterThanOrEqualComparator b = new GreaterThanOrEqualComparator();
    public static EqualComparator f = new EqualComparator();
    public static NotEqualComparator c = new NotEqualComparator();

    public XNodeSet() {
    }

    public XNodeSet(DTMIterator dTMIterator) {
        if (dTMIterator instanceof XNodeSet) {
            this.setIter(((XNodeSet)dTMIterator).m_iter);
            this.m_dtmMgr = ((XNodeSet)dTMIterator).m_dtmMgr;
            this.m_last = ((XNodeSet)dTMIterator).m_last;
            if (!((XNodeSet)dTMIterator).hasCache()) {
                ((XNodeSet)dTMIterator).setShouldCacheNodes(true);
            }
            this.m_obj = ((XNodeSet)dTMIterator).m_obj;
        } else {
            this.setIter(dTMIterator);
        }
    }

    public XNodeSet(XNodeSet xNodeSet) {
        this.setIter(xNodeSet.m_iter);
        this.m_dtmMgr = xNodeSet.m_dtmMgr;
        this.m_last = xNodeSet.m_last;
        if (!xNodeSet.hasCache()) {
            xNodeSet.setShouldCacheNodes(true);
        }
        this.m_obj = xNodeSet.m_obj;
    }

    public XNodeSet(DTMManager dTMManager) {
        this(-1, dTMManager);
    }

    public XNodeSet(int n2, DTMManager dTMManager) {
        super(new NodeSetDTM(dTMManager));
        this.m_dtmMgr = dTMManager;
        if (-1 != n2) {
            ((NodeSetDTM)this.m_obj).addNode(n2);
            this.m_last = 1;
        } else {
            this.m_last = 0;
        }
    }

    public int getType() {
        return 4;
    }

    public String getTypeString() {
        return "#NODESET";
    }

    public double getNumberFromNode(int n2) {
        XMLString xMLString = this.m_dtmMgr.getDTM(n2).getStringValue(n2);
        return xMLString.toDouble();
    }

    public double num() {
        int n2 = this.item(0);
        return n2 != -1 ? this.getNumberFromNode(n2) : Double.NaN;
    }

    public double numWithSideEffects() {
        int n2 = this.nextNode();
        return n2 != -1 ? this.getNumberFromNode(n2) : Double.NaN;
    }

    public boolean bool() {
        return this.item(0) != -1;
    }

    public boolean boolWithSideEffects() {
        return this.nextNode() != -1;
    }

    public XMLString getStringFromNode(int n2) {
        if (-1 != n2) {
            return this.m_dtmMgr.getDTM(n2).getStringValue(n2);
        }
        return XString.EMPTYSTRING;
    }

    public void dispatchCharactersEvents(ContentHandler contentHandler) throws SAXException {
        int n2 = this.item(0);
        if (n2 != -1) {
            this.m_dtmMgr.getDTM(n2).dispatchCharactersEvents(n2, contentHandler, false);
        }
    }

    public XMLString xstr() {
        int n2 = this.item(0);
        return n2 != -1 ? this.getStringFromNode(n2) : XString.EMPTYSTRING;
    }

    public void appendToFsb(FastStringBuffer fastStringBuffer) {
        XString xString = (XString)this.xstr();
        xString.appendToFsb(fastStringBuffer);
    }

    public String str() {
        int n2 = this.item(0);
        return n2 != -1 ? this.getStringFromNode(n2).toString() : "";
    }

    public Object object() {
        if (null == this.m_obj) {
            return this;
        }
        return this.m_obj;
    }

    public NodeIterator nodeset() throws TransformerException {
        return new DTMNodeIterator(this.iter());
    }

    public NodeList nodelist() throws TransformerException {
        DTMNodeList dTMNodeList = new DTMNodeList(this);
        XNodeSet xNodeSet = (XNodeSet)dTMNodeList.getDTMIterator();
        this.SetVector(xNodeSet.getVector());
        return dTMNodeList;
    }

    public DTMIterator iterRaw() {
        return this;
    }

    public void release(DTMIterator dTMIterator) {
    }

    public DTMIterator iter() {
        try {
            if (this.hasCache()) {
                return this.cloneWithReset();
            }
            return this;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.getMessage());
        }
    }

    public XObject getFresh() {
        try {
            if (this.hasCache()) {
                return (XObject)((Object)this.cloneWithReset());
            }
            return this;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.getMessage());
        }
    }

    public NodeSetDTM mutableNodeset() {
        NodeSetDTM nodeSetDTM;
        if (this.m_obj instanceof NodeSetDTM) {
            nodeSetDTM = (NodeSetDTM)this.m_obj;
        } else {
            nodeSetDTM = new NodeSetDTM(this.iter());
            this.m_obj = nodeSetDTM;
            this.setCurrentPos(0);
        }
        return nodeSetDTM;
    }

    public boolean compare(XObject xObject, Comparator comparator) throws TransformerException {
        boolean bl2 = false;
        int n2 = xObject.getType();
        if (4 == n2) {
            int n3;
            DTMIterator dTMIterator = this.iterRaw();
            DTMIterator dTMIterator2 = ((XNodeSet)xObject).iterRaw();
            Vector<XMLString> vector = null;
            block0: while (-1 != (n3 = dTMIterator.nextNode())) {
                int n4;
                XMLString xMLString = this.getStringFromNode(n3);
                if (null == vector) {
                    while (-1 != (n4 = dTMIterator2.nextNode())) {
                        XMLString xMLString2 = this.getStringFromNode(n4);
                        if (comparator.a(xMLString, xMLString2)) {
                            bl2 = true;
                            continue block0;
                        }
                        if (null == vector) {
                            vector = new Vector<XMLString>();
                        }
                        vector.addElement(xMLString2);
                    }
                    continue;
                }
                n4 = vector.size();
                int n5 = 0;
                while (n5 < n4) {
                    if (comparator.a(xMLString, (XMLString)vector.elementAt(n5))) {
                        bl2 = true;
                        continue block0;
                    }
                    ++n5;
                }
            }
            dTMIterator.reset();
            dTMIterator2.reset();
        } else if (1 == n2) {
            double d2 = this.bool() ? 1.0 : 0.0;
            double d3 = xObject.num();
            bl2 = comparator.a(d2, d3);
        } else if (2 == n2) {
            int n6;
            DTMIterator dTMIterator = this.iterRaw();
            double d4 = xObject.num();
            while (-1 != (n6 = dTMIterator.nextNode())) {
                double d5 = this.getNumberFromNode(n6);
                if (!comparator.a(d5, d4)) continue;
                bl2 = true;
                break;
            }
            dTMIterator.reset();
        } else if (5 == n2) {
            int n7;
            XMLString xMLString = xObject.xstr();
            DTMIterator dTMIterator = this.iterRaw();
            while (-1 != (n7 = dTMIterator.nextNode())) {
                XMLString xMLString3 = this.getStringFromNode(n7);
                if (!comparator.a(xMLString3, xMLString)) continue;
                bl2 = true;
                break;
            }
            dTMIterator.reset();
        } else if (3 == n2) {
            int n8;
            XMLString xMLString = xObject.xstr();
            DTMIterator dTMIterator = this.iterRaw();
            while (-1 != (n8 = dTMIterator.nextNode())) {
                XMLString xMLString4 = this.getStringFromNode(n8);
                if (!comparator.a(xMLString4, xMLString)) continue;
                bl2 = true;
                break;
            }
            dTMIterator.reset();
        } else {
            bl2 = comparator.a(this.num(), xObject.num());
        }
        return bl2;
    }

    public boolean lessThan(XObject xObject) throws TransformerException {
        return this.compare(xObject, d);
    }

    public boolean lessThanOrEqual(XObject xObject) throws TransformerException {
        return this.compare(xObject, a);
    }

    public boolean greaterThan(XObject xObject) throws TransformerException {
        return this.compare(xObject, e);
    }

    public boolean greaterThanOrEqual(XObject xObject) throws TransformerException {
        return this.compare(xObject, b);
    }

    public boolean equals(XObject xObject) {
        try {
            return this.compare(xObject, f);
        }
        catch (TransformerException transformerException) {
            throw new WrappedRuntimeException(transformerException);
        }
    }

    public boolean notEquals(XObject xObject) throws TransformerException {
        return this.compare(xObject, c);
    }
}

