/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.functions;

import java.util.Vector;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.functions.Function3Args;
import org.apache.xpath.functions.WrongNumberArgsException;
import org.apache.xpath.res.XPATHMessages;

public class FunctionMultiArgs
extends Function3Args {
    public Expression[] d;

    public Expression[] getArgs() {
        return this.d;
    }

    public void setArg(Expression expression, int n2) throws WrongNumberArgsException {
        if (n2 < 3) {
            super.setArg(expression, n2);
        } else {
            if (null == this.d) {
                this.d = new Expression[1];
                this.d[0] = expression;
            } else {
                Expression[] expressionArray = new Expression[this.d.length + 1];
                System.arraycopy(this.d, 0, expressionArray, 0, this.d.length);
                expressionArray[this.d.length] = expression;
                this.d = expressionArray;
            }
            expression.exprSetParent(this);
        }
    }

    public void fixupVariables(Vector vector, int n2) {
        super.fixupVariables(vector, n2);
        if (null != this.d) {
            int n3 = 0;
            while (n3 < this.d.length) {
                this.d[n3].fixupVariables(vector, n2);
                ++n3;
            }
        }
    }

    public void checkNumberArgs(int n2) throws WrongNumberArgsException {
    }

    public void reportWrongNumberArgs() throws WrongNumberArgsException {
        String string = XPATHMessages.createXPATHMessage("ER_INCORRECT_PROGRAMMER_ASSERTION", new Object[]{"Programmer's assertion:  the method FunctionMultiArgs.reportWrongNumberArgs() should never be called."});
        throw new RuntimeException(string);
    }

    public boolean canTraverseOutsideSubtree() {
        if (super.canTraverseOutsideSubtree()) {
            return true;
        }
        int n2 = this.d.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.d[n3].canTraverseOutsideSubtree()) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public void callArgVisitors(XPathVisitor xPathVisitor) {
        super.callArgVisitors(xPathVisitor);
        if (null != this.d) {
            int n2 = this.d.length;
            int n3 = 0;
            while (n3 < n2) {
                this.d[n3].callVisitors(new ArgMultiOwner(this, n3), xPathVisitor);
                ++n3;
            }
        }
    }

    public boolean deepEquals(Expression expression) {
        if (!super.deepEquals(expression)) {
            return false;
        }
        FunctionMultiArgs functionMultiArgs = (FunctionMultiArgs)expression;
        if (null != this.d) {
            int n2 = this.d.length;
            if (null == functionMultiArgs || functionMultiArgs.d.length != n2) {
                return false;
            }
            int n3 = 0;
            while (n3 < n2) {
                if (!this.d[n3].deepEquals(functionMultiArgs.d[n3])) {
                    return false;
                }
                ++n3;
            }
        } else if (null != functionMultiArgs.d) {
            return false;
        }
        return true;
    }

    public class ArgMultiOwner
    implements ExpressionOwner {
        public int a;
        private final FunctionMultiArgs this$0;

        public ArgMultiOwner(FunctionMultiArgs functionMultiArgs, int n2) {
            this.this$0 = functionMultiArgs;
            this.a = n2;
        }

        public Expression getExpression() {
            return this.this$0.d[this.a];
        }

        public void setExpression(Expression expression) {
            expression.exprSetParent(this.this$0);
            this.this$0.d[this.a] = expression;
        }
    }
}

