/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.functions;

import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.functions.WrongNumberArgsException;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.res.XPATHMessages;

public abstract class Function
extends Expression {
    public void setArg(Expression expression, int n2) throws WrongNumberArgsException {
        this.reportWrongNumberArgs();
    }

    public void checkNumberArgs(int n2) throws WrongNumberArgsException {
        if (n2 != 0) {
            this.reportWrongNumberArgs();
        }
    }

    public void reportWrongNumberArgs() throws WrongNumberArgsException {
        throw new WrongNumberArgsException(XPATHMessages.createXPATHMessage("zero", null));
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        System.out.println("Error! Function.execute should not be called!");
        return null;
    }

    public void callArgVisitors(XPathVisitor xPathVisitor) {
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        if (xPathVisitor.visitFunction(expressionOwner, this)) {
            this.callArgVisitors(xPathVisitor);
        }
    }

    public boolean deepEquals(Expression expression) {
        return this.isSameClass(expression);
    }

    public void postCompileStep(Compiler compiler) {
    }
}

