/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.domapi;

import javax.xml.transform.TransformerException;
import org.apache.xpath.domapi.XPathNamespaceImpl;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.res.XPATHMessages;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.xpath.XPathException;
import org.w3c.dom.xpath.XPathResult;

public class XPathResultImpl
implements XPathResult,
EventListener {
    private XObject m_resultObj;
    private short m_resultType = 0;
    private boolean m_isInvalidIteratorState = false;
    private Node m_contextNode;
    private NodeIterator m_iterator = null;
    private NodeList m_list = null;

    public XPathResultImpl(short s2, XObject xObject, Node node) {
        if (!XPathResultImpl.isValidType(s2)) {
            String string = XPATHMessages.createXPATHMessage("ER_INVALID_XPATH_TYPE", new Object[]{new Integer(s2)});
            throw new XPathException(2, string);
        }
        if (null == xObject) {
            String string = XPATHMessages.createXPATHMessage("ER_EMPTY_XPATH_RESULT", null);
            throw new XPathException(1, string);
        }
        this.m_resultObj = xObject;
        this.m_contextNode = node;
        this.m_resultType = s2 == 0 ? this.getTypeFromXObject(xObject) : s2;
        if ((this.m_resultType == 5 || this.m_resultType == 4) && node instanceof EventTarget) {
            ((EventTarget)((Object)node)).addEventListener("MutationEvents", this, true);
        }
        if (this.m_resultType == 5 || this.m_resultType == 4 || this.m_resultType == 8 || this.m_resultType == 9) {
            try {
                this.m_iterator = this.m_resultObj.nodeset();
            }
            catch (TransformerException transformerException) {
                String string = XPATHMessages.createXPATHMessage("ER_INCOMPATIBLE_TYPES", new Object[]{this.getTypeString(this.getTypeFromXObject(this.m_resultObj)), this.getTypeString(this.m_resultType)});
                throw new XPathException(2, string);
            }
        }
        if (this.m_resultType == 6 || this.m_resultType == 7) {
            try {
                this.m_list = this.m_resultObj.nodelist();
            }
            catch (TransformerException transformerException) {
                String string = XPATHMessages.createXPATHMessage("ER_INCOMPATIBLE_TYPES", new Object[]{this.getTypeString(this.getTypeFromXObject(this.m_resultObj)), this.getTypeString(this.m_resultType)});
                throw new XPathException(2, string);
            }
        }
    }

    public short getResultType() {
        return this.m_resultType;
    }

    public double getNumberValue() throws XPathException {
        if (this.getResultType() != 1) {
            String string = XPATHMessages.createXPATHMessage("ER_CANT_CONVERT_TO_NUMBER", new Object[]{this.getTypeString(this.m_resultType)});
            throw new XPathException(2, string);
        }
        try {
            return this.m_resultObj.num();
        }
        catch (Exception exception) {
            throw new XPathException(2, exception.getMessage());
        }
    }

    public String getStringValue() throws XPathException {
        if (this.getResultType() != 2) {
            String string = XPATHMessages.createXPATHMessage("ER_CANT_CONVERT_TO_STRING", new Object[]{this.m_resultObj.getTypeString()});
            throw new XPathException(2, string);
        }
        try {
            return this.m_resultObj.str();
        }
        catch (Exception exception) {
            throw new XPathException(2, exception.getMessage());
        }
    }

    public boolean getBooleanValue() throws XPathException {
        if (this.getResultType() != 3) {
            String string = XPATHMessages.createXPATHMessage("ER_CANT_CONVERT_TO_BOOLEAN", new Object[]{this.getTypeString(this.m_resultType)});
            throw new XPathException(2, string);
        }
        try {
            return this.m_resultObj.bool();
        }
        catch (TransformerException transformerException) {
            throw new XPathException(2, transformerException.getMessage());
        }
    }

    public Node getSingleNodeValue() throws XPathException {
        if (this.m_resultType != 8 && this.m_resultType != 9) {
            String string = XPATHMessages.createXPATHMessage("ER_CANT_CONVERT_TO_SINGLENODE", new Object[]{this.getTypeString(this.m_resultType)});
            throw new XPathException(2, string);
        }
        NodeIterator nodeIterator = null;
        try {
            nodeIterator = this.m_resultObj.nodeset();
        }
        catch (TransformerException transformerException) {
            throw new XPathException(2, transformerException.getMessage());
        }
        if (null == nodeIterator) {
            return null;
        }
        Node node = nodeIterator.nextNode();
        if (this.isNamespaceNode(node)) {
            return new XPathNamespaceImpl(node);
        }
        return node;
    }

    public boolean getInvalidIteratorState() {
        return this.m_isInvalidIteratorState;
    }

    public int getSnapshotLength() throws XPathException {
        if (this.m_resultType != 6 && this.m_resultType != 7) {
            String string = XPATHMessages.createXPATHMessage("ER_CANT_GET_SNAPSHOT_LENGTH", new Object[]{this.getTypeString(this.m_resultType)});
            throw new XPathException(2, string);
        }
        return this.m_list.getLength();
    }

    public Node iterateNext() throws XPathException, DOMException {
        if (this.m_resultType != 4 && this.m_resultType != 5) {
            String string = XPATHMessages.createXPATHMessage("ER_NON_ITERATOR_TYPE", new Object[]{this.getTypeString(this.m_resultType)});
            throw new XPathException(2, string);
        }
        if (this.getInvalidIteratorState()) {
            String string = XPATHMessages.createXPATHMessage("ER_DOC_MUTATED", null);
            throw new DOMException(11, string);
        }
        Node node = this.m_iterator.nextNode();
        if (this.isNamespaceNode(node)) {
            return new XPathNamespaceImpl(node);
        }
        return node;
    }

    public Node snapshotItem(int n2) throws XPathException {
        if (this.m_resultType != 6 && this.m_resultType != 7) {
            String string = XPATHMessages.createXPATHMessage("ER_NON_SNAPSHOT_TYPE", new Object[]{this.getTypeString(this.m_resultType)});
            throw new XPathException(2, string);
        }
        Node node = this.m_list.item(n2);
        if (this.isNamespaceNode(node)) {
            return new XPathNamespaceImpl(node);
        }
        return node;
    }

    public static boolean isValidType(short s2) {
        switch (s2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public void handleEvent(Event event) {
        if (event.getType().equals("MutationEvents")) {
            this.m_isInvalidIteratorState = true;
            ((EventTarget)((Object)this.m_contextNode)).removeEventListener("MutationEvents", this, true);
        }
    }

    public String getTypeString(int n2) {
        switch (n2) {
            case 0: {
                return "ANY_TYPE";
            }
            case 8: {
                return "ANY_UNORDERED_NODE_TYPE";
            }
            case 3: {
                return "BOOLEAN";
            }
            case 9: {
                return "FIRST_ORDERED_NODE_TYPE";
            }
            case 1: {
                return "NUMBER_TYPE";
            }
            case 5: {
                return "ORDERED_NODE_ITERATOR_TYPE";
            }
            case 7: {
                return "ORDERED_NODE_SNAPSHOT_TYPE";
            }
            case 2: {
                return "STRING_TYPE";
            }
            case 4: {
                return "UNORDERED_NODE_ITERATOR_TYPE";
            }
            case 6: {
                return "UNORDERED_NODE_SNAPSHOT_TYPE";
            }
        }
        return "#UNKNOWN";
    }

    private short getTypeFromXObject(XObject xObject) {
        switch (xObject.getType()) {
            case 1: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 5: {
                return 4;
            }
            case -1: {
                return 0;
            }
        }
        return 0;
    }

    private boolean isNamespaceNode(Node node) {
        return null != node && node.getNodeType() == 2 && (node.getNodeName().startsWith("xmlns:") || node.getNodeName().equals("xmlns"));
    }
}

