/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.compiler;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPathProcessorException;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.Keywords;
import org.apache.xpath.compiler.Lexer;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XString;
import org.apache.xpath.res.XPATHMessages;

public class XPathParser {
    public static final String CONTINUE_AFTER_FATAL_ERROR = "CONTINUE_AFTER_FATAL_ERROR";
    private OpMap m_ops;
    public transient String e;
    public transient char d = '\u0000';
    public int b = 0;
    public static final int FILTER_MATCH_FAILED = 0;
    public static final int FILTER_MATCH_PRIMARY = 1;
    public static final int FILTER_MATCH_PREDICATES = 2;
    public PrefixResolver c;
    private ErrorListener m_errorListener;
    public SourceLocator a;

    public XPathParser(ErrorListener errorListener, SourceLocator sourceLocator) {
        this.m_errorListener = errorListener;
        this.a = sourceLocator;
    }

    public void initXPath(Compiler compiler, String string, PrefixResolver prefixResolver) throws TransformerException {
        this.m_ops = compiler;
        this.c = prefixResolver;
        Lexer lexer = new Lexer(compiler, prefixResolver, this);
        lexer.b(string);
        this.m_ops.setOp(0, 1);
        this.m_ops.setOp(1, 2);
        try {
            this.nextToken();
            this.Expr();
            if (null != this.e) {
                String string2 = "";
                while (null != this.e) {
                    string2 = string2 + "'" + this.e + "'";
                    this.nextToken();
                    if (null == this.e) continue;
                    string2 = string2 + ", ";
                }
                this.a("ER_EXTRA_ILLEGAL_TOKENS", new Object[]{string2});
            }
        }
        catch (XPathProcessorException xPathProcessorException) {
            if (CONTINUE_AFTER_FATAL_ERROR.equals(xPathProcessorException.getMessage())) {
                this.initXPath(compiler, "/..", prefixResolver);
            }
            throw xPathProcessorException;
        }
        compiler.a();
    }

    public void initMatchPattern(Compiler compiler, String string, PrefixResolver prefixResolver) throws TransformerException {
        this.m_ops = compiler;
        this.c = prefixResolver;
        Lexer lexer = new Lexer(compiler, prefixResolver, this);
        lexer.b(string);
        this.m_ops.setOp(0, 30);
        this.m_ops.setOp(1, 2);
        this.nextToken();
        this.Pattern();
        if (null != this.e) {
            String string2 = "";
            while (null != this.e) {
                string2 = string2 + "'" + this.e + "'";
                this.nextToken();
                if (null == this.e) continue;
                string2 = string2 + ", ";
            }
            this.a("ER_EXTRA_ILLEGAL_TOKENS", new Object[]{string2});
        }
        this.m_ops.setOp(this.m_ops.getOp(1), -1);
        this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
        this.m_ops.a();
    }

    public void setErrorHandler(ErrorListener errorListener) {
        this.m_errorListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.m_errorListener;
    }

    public final boolean b(String string) {
        return this.e != null ? this.e.equals(string) : string == null;
    }

    public final boolean a(char c2) {
        return this.e != null ? this.d == c2 : false;
    }

    public final boolean a(char c2, int n2) {
        String string;
        int n3 = this.b + n2;
        boolean bl2 = n3 <= this.m_ops.getTokenQueueSize() && n3 > 0 && this.m_ops.getTokenQueueSize() != 0 ? ((string = (String)this.m_ops.c.elementAt(n3 - 1)).length() == 1 ? string.charAt(0) == c2 : false) : false;
        return bl2;
    }

    private final boolean lookbehind(char c2, int n2) {
        boolean bl2;
        int n3 = this.b - (n2 + 1);
        if (n3 >= 0) {
            String string = (String)this.m_ops.c.elementAt(n3);
            if (string.length() == 1) {
                char c3;
                char c4 = c3 = string == null ? (char)'|' : (char)string.charAt(0);
                bl2 = c3 == '|' ? false : c3 == c2;
            } else {
                bl2 = false;
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    private final boolean lookbehindHasToken(int n2) {
        boolean bl2;
        if (this.b - n2 > 0) {
            String string = (String)this.m_ops.c.elementAt(this.b - (n2 - 1));
            int n3 = string == null ? 124 : (int)string.charAt(0);
            bl2 = n3 != 124;
        } else {
            bl2 = false;
        }
        return bl2;
    }

    private final boolean lookahead(String string, int n2) {
        String string2;
        boolean bl2 = this.b + n2 <= this.m_ops.getTokenQueueSize() ? ((string2 = (String)this.m_ops.c.elementAt(this.b + (n2 - 1))) != null ? string2.equals(string) : string == null) : null == string;
        return bl2;
    }

    private final void nextToken() {
        if (this.b < this.m_ops.getTokenQueueSize()) {
            this.e = (String)this.m_ops.c.elementAt(this.b++);
            this.d = this.e.charAt(0);
        } else {
            this.e = null;
            this.d = '\u0000';
        }
    }

    private final String getTokenRelative(int n2) {
        int n3 = this.b + n2;
        String string = n3 > 0 && n3 < this.m_ops.getTokenQueueSize() ? (String)this.m_ops.c.elementAt(n3) : null;
        return string;
    }

    private final void prevToken() {
        if (this.b > 0) {
            --this.b;
            this.e = (String)this.m_ops.c.elementAt(this.b);
            this.d = this.e.charAt(0);
        } else {
            this.e = null;
            this.d = '\u0000';
        }
    }

    private final void consumeExpected(String string) throws TransformerException {
        if (!this.b(string)) {
            this.a("ER_EXPECTED_BUT_FOUND", new Object[]{string, this.e});
            throw new XPathProcessorException(CONTINUE_AFTER_FATAL_ERROR);
        }
        this.nextToken();
    }

    private final void consumeExpected(char c2) throws TransformerException {
        if (!this.a(c2)) {
            this.a("ER_EXPECTED_BUT_FOUND", new Object[]{String.valueOf(c2), this.e});
            throw new XPathProcessorException(CONTINUE_AFTER_FATAL_ERROR);
        }
        this.nextToken();
    }

    private void assertion(boolean bl2, String string) {
        if (!bl2) {
            String string2 = XPATHMessages.createXPATHMessage("ER_INCORRECT_PROGRAMMER_ASSERTION", new Object[]{string});
            throw new RuntimeException(string2);
        }
    }

    public void a(String string, Object[] objectArray) throws TransformerException {
        String string2 = XPATHMessages.createXPATHMessage(string, objectArray);
        ErrorListener errorListener = this.getErrorListener();
        TransformerException transformerException = new TransformerException(string2, this.a);
        if (null == errorListener) {
            throw transformerException;
        }
        errorListener.fatalError(transformerException);
    }

    public String dumpRemainingTokenQueue() {
        String string;
        int n2 = this.b;
        if (n2 < this.m_ops.getTokenQueueSize()) {
            String string2 = "\n Remaining tokens: (";
            while (n2 < this.m_ops.getTokenQueueSize()) {
                String string3 = (String)this.m_ops.c.elementAt(n2++);
                string2 = string2 + " '" + string3 + "'";
            }
            string = string2 + ")";
        } else {
            string = "";
        }
        return string;
    }

    public final int a(String string) {
        int n2;
        try {
            n2 = (Integer)Keywords.a.get(string);
        }
        catch (NullPointerException nullPointerException) {
            n2 = -1;
        }
        catch (ClassCastException classCastException) {
            n2 = -1;
        }
        return n2;
    }

    public void a(int n2, int n3, int n4) {
        int n5 = this.m_ops.getOp(1);
        int n6 = n5 - 1;
        while (n6 >= n2) {
            this.m_ops.setOp(n6 + n3, this.m_ops.getOp(n6));
            --n6;
        }
        this.m_ops.setOp(n2, n4);
        this.m_ops.setOp(1, n5 + n3);
    }

    public void a(int n2, int n3) {
        int n4 = this.m_ops.getOp(1);
        this.m_ops.setOp(n4, n3);
        this.m_ops.setOp(n4 + 1, n2);
        this.m_ops.setOp(1, n4 + n2);
    }

    public void Expr() throws TransformerException {
        this.OrExpr();
    }

    public void OrExpr() throws TransformerException {
        int n2 = this.m_ops.getOp(1);
        this.AndExpr();
        if (null != this.e && this.b("or")) {
            this.nextToken();
            this.a(n2, 2, 2);
            this.OrExpr();
            this.m_ops.setOp(n2 + 1, this.m_ops.getOp(1) - n2);
        }
    }

    public void AndExpr() throws TransformerException {
        int n2 = this.m_ops.getOp(1);
        this.EqualityExpr(-1);
        if (null != this.e && this.b("and")) {
            this.nextToken();
            this.a(n2, 2, 3);
            this.AndExpr();
            this.m_ops.setOp(n2 + 1, this.m_ops.getOp(1) - n2);
        }
    }

    public int EqualityExpr(int n2) throws TransformerException {
        int n3 = this.m_ops.getOp(1);
        if (-1 == n2) {
            n2 = n3;
        }
        this.RelationalExpr(-1);
        if (null != this.e) {
            if (this.a('!') && this.a('=', 1)) {
                this.nextToken();
                this.nextToken();
                this.a(n2, 2, 4);
                int n4 = this.m_ops.getOp(1) - n2;
                n2 = this.EqualityExpr(n2);
                this.m_ops.setOp(n2 + 1, this.m_ops.getOp(n2 + n4 + 1) + n4);
                n2 += 2;
            } else if (this.a('=')) {
                this.nextToken();
                this.a(n2, 2, 5);
                int n5 = this.m_ops.getOp(1) - n2;
                n2 = this.EqualityExpr(n2);
                this.m_ops.setOp(n2 + 1, this.m_ops.getOp(n2 + n5 + 1) + n5);
                n2 += 2;
            }
        }
        return n2;
    }

    public int RelationalExpr(int n2) throws TransformerException {
        int n3 = this.m_ops.getOp(1);
        if (-1 == n2) {
            n2 = n3;
        }
        this.AdditiveExpr(-1);
        if (null != this.e) {
            if (this.a('<')) {
                this.nextToken();
                if (this.a('=')) {
                    this.nextToken();
                    this.a(n2, 2, 6);
                } else {
                    this.a(n2, 2, 7);
                }
                int n4 = this.m_ops.getOp(1) - n2;
                n2 = this.RelationalExpr(n2);
                this.m_ops.setOp(n2 + 1, this.m_ops.getOp(n2 + n4 + 1) + n4);
                n2 += 2;
            } else if (this.a('>')) {
                this.nextToken();
                if (this.a('=')) {
                    this.nextToken();
                    this.a(n2, 2, 8);
                } else {
                    this.a(n2, 2, 9);
                }
                int n5 = this.m_ops.getOp(1) - n2;
                n2 = this.RelationalExpr(n2);
                this.m_ops.setOp(n2 + 1, this.m_ops.getOp(n2 + n5 + 1) + n5);
                n2 += 2;
            }
        }
        return n2;
    }

    public int AdditiveExpr(int n2) throws TransformerException {
        int n3 = this.m_ops.getOp(1);
        if (-1 == n2) {
            n2 = n3;
        }
        this.MultiplicativeExpr(-1);
        if (null != this.e) {
            if (this.a('+')) {
                this.nextToken();
                this.a(n2, 2, 10);
                int n4 = this.m_ops.getOp(1) - n2;
                n2 = this.AdditiveExpr(n2);
                this.m_ops.setOp(n2 + 1, this.m_ops.getOp(n2 + n4 + 1) + n4);
                n2 += 2;
            } else if (this.a('-')) {
                this.nextToken();
                this.a(n2, 2, 11);
                int n5 = this.m_ops.getOp(1) - n2;
                n2 = this.AdditiveExpr(n2);
                this.m_ops.setOp(n2 + 1, this.m_ops.getOp(n2 + n5 + 1) + n5);
                n2 += 2;
            }
        }
        return n2;
    }

    public int MultiplicativeExpr(int n2) throws TransformerException {
        int n3 = this.m_ops.getOp(1);
        if (-1 == n2) {
            n2 = n3;
        }
        this.UnaryExpr();
        if (null != this.e) {
            if (this.a('*')) {
                this.nextToken();
                this.a(n2, 2, 12);
                int n4 = this.m_ops.getOp(1) - n2;
                n2 = this.MultiplicativeExpr(n2);
                this.m_ops.setOp(n2 + 1, this.m_ops.getOp(n2 + n4 + 1) + n4);
                n2 += 2;
            } else if (this.b("div")) {
                this.nextToken();
                this.a(n2, 2, 13);
                int n5 = this.m_ops.getOp(1) - n2;
                n2 = this.MultiplicativeExpr(n2);
                this.m_ops.setOp(n2 + 1, this.m_ops.getOp(n2 + n5 + 1) + n5);
                n2 += 2;
            } else if (this.b("mod")) {
                this.nextToken();
                this.a(n2, 2, 14);
                int n6 = this.m_ops.getOp(1) - n2;
                n2 = this.MultiplicativeExpr(n2);
                this.m_ops.setOp(n2 + 1, this.m_ops.getOp(n2 + n6 + 1) + n6);
                n2 += 2;
            } else if (this.b("quo")) {
                this.nextToken();
                this.a(n2, 2, 15);
                int n7 = this.m_ops.getOp(1) - n2;
                n2 = this.MultiplicativeExpr(n2);
                this.m_ops.setOp(n2 + 1, this.m_ops.getOp(n2 + n7 + 1) + n7);
                n2 += 2;
            }
        }
        return n2;
    }

    public void UnaryExpr() throws TransformerException {
        int n2 = this.m_ops.getOp(1);
        boolean bl2 = false;
        if (this.d == '-') {
            this.nextToken();
            this.a(2, 16);
            bl2 = true;
        }
        this.UnionExpr();
        if (bl2) {
            this.m_ops.setOp(n2 + 1, this.m_ops.getOp(1) - n2);
        }
    }

    public void StringExpr() throws TransformerException {
        int n2 = this.m_ops.getOp(1);
        this.a(2, 17);
        this.Expr();
        this.m_ops.setOp(n2 + 1, this.m_ops.getOp(1) - n2);
    }

    public void BooleanExpr() throws TransformerException {
        int n2 = this.m_ops.getOp(1);
        this.a(2, 18);
        this.Expr();
        int n3 = this.m_ops.getOp(1) - n2;
        if (n3 == 2) {
            this.a("ER_BOOLEAN_ARG_NO_LONGER_OPTIONAL", null);
        }
        this.m_ops.setOp(n2 + 1, n3);
    }

    public void NumberExpr() throws TransformerException {
        int n2 = this.m_ops.getOp(1);
        this.a(2, 19);
        this.Expr();
        this.m_ops.setOp(n2 + 1, this.m_ops.getOp(1) - n2);
    }

    public void UnionExpr() throws TransformerException {
        int n2 = this.m_ops.getOp(1);
        boolean bl2 = true;
        boolean bl3 = false;
        do {
            this.PathExpr();
            if (!this.a('|')) break;
            if (!bl3) {
                bl3 = true;
                this.a(n2, 2, 20);
            }
            this.nextToken();
        } while (bl2);
        this.m_ops.setOp(n2 + 1, this.m_ops.getOp(1) - n2);
    }

    public void PathExpr() throws TransformerException {
        int n2 = this.m_ops.getOp(1);
        int n3 = this.FilterExpr();
        if (n3 != 0) {
            boolean bl2;
            boolean bl3 = bl2 = n3 == 2;
            if (this.a('/')) {
                this.nextToken();
                if (!bl2) {
                    this.a(n2, 2, 28);
                    bl2 = true;
                }
                if (!this.RelativeLocationPath()) {
                    this.a("ER_EXPECTED_REL_LOC_PATH", null);
                }
            }
            if (bl2) {
                this.m_ops.setOp(this.m_ops.getOp(1), -1);
                this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
                this.m_ops.setOp(n2 + 1, this.m_ops.getOp(1) - n2);
            }
        } else {
            this.LocationPath();
        }
    }

    public int FilterExpr() throws TransformerException {
        int n2;
        int n3 = this.m_ops.getOp(1);
        if (this.PrimaryExpr()) {
            if (this.a('[')) {
                this.a(n3, 2, 28);
                while (this.a('[')) {
                    this.Predicate();
                }
                n2 = 2;
            } else {
                n2 = 1;
            }
        } else {
            n2 = 0;
        }
        return n2;
    }

    public boolean PrimaryExpr() throws TransformerException {
        boolean bl2;
        int n2 = this.m_ops.getOp(1);
        if (this.d == '\'' || this.d == '\"') {
            this.a(2, 21);
            this.Literal();
            this.m_ops.setOp(n2 + 1, this.m_ops.getOp(1) - n2);
            bl2 = true;
        } else if (this.d == '$') {
            this.nextToken();
            this.a(2, 22);
            this.QName();
            this.m_ops.setOp(n2 + 1, this.m_ops.getOp(1) - n2);
            bl2 = true;
        } else if (this.d == '(') {
            this.nextToken();
            this.a(2, 23);
            this.Expr();
            this.consumeExpected(')');
            this.m_ops.setOp(n2 + 1, this.m_ops.getOp(1) - n2);
            bl2 = true;
        } else if (null != this.e && ('.' == this.d && this.e.length() > 1 && Character.isDigit(this.e.charAt(1)) || Character.isDigit(this.d))) {
            this.a(2, 27);
            this.Number();
            this.m_ops.setOp(n2 + 1, this.m_ops.getOp(1) - n2);
            bl2 = true;
        } else {
            bl2 = this.a('(', 1) || this.a(':', 1) && this.a('(', 3) ? this.FunctionCall() : false;
        }
        return bl2;
    }

    public void Argument() throws TransformerException {
        int n2 = this.m_ops.getOp(1);
        this.a(2, 26);
        this.Expr();
        this.m_ops.setOp(n2 + 1, this.m_ops.getOp(1) - n2);
    }

    public boolean FunctionCall() throws TransformerException {
        int n2 = this.m_ops.getOp(1);
        if (this.a(':', 1)) {
            this.a(4, 24);
            this.m_ops.setOp(n2 + 1 + 1, this.b - 1);
            this.nextToken();
            this.consumeExpected(':');
            this.m_ops.setOp(n2 + 1 + 2, this.b - 1);
            this.nextToken();
        } else {
            int n3 = this.a(this.e);
            if (-1 == n3) {
                this.a("ER_COULDNOT_FIND_FUNCTION", new Object[]{this.e});
            }
            switch (n3) {
                case 1030: 
                case 1031: 
                case 1032: 
                case 1033: {
                    return false;
                }
            }
            this.a(3, 25);
            this.m_ops.setOp(n2 + 1 + 1, n3);
            this.nextToken();
        }
        this.consumeExpected('(');
        while (!this.a(')') && this.e != null) {
            if (this.a(',')) {
                this.a("ER_FOUND_COMMA_BUT_NO_PRECEDING_ARG", null);
            }
            this.Argument();
            if (this.a(')')) continue;
            this.consumeExpected(',');
            if (!this.a(')')) continue;
            this.a("ER_FOUND_COMMA_BUT_NO_FOLLOWING_ARG", null);
        }
        this.consumeExpected(')');
        this.m_ops.setOp(this.m_ops.getOp(1), -1);
        this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
        this.m_ops.setOp(n2 + 1, this.m_ops.getOp(1) - n2);
        return true;
    }

    public void LocationPath() throws TransformerException {
        int n2 = this.m_ops.getOp(1);
        this.a(2, 28);
        boolean bl2 = this.a('/');
        if (bl2) {
            this.a(4, 50);
            this.m_ops.setOp(this.m_ops.getOp(1) - 2, 4);
            this.m_ops.setOp(this.m_ops.getOp(1) - 1, 35);
            this.nextToken();
        }
        if (this.e != null && !this.RelativeLocationPath() && !bl2) {
            this.a("ER_EXPECTED_LOC_PATH", new Object[]{this.e});
        }
        this.m_ops.setOp(this.m_ops.getOp(1), -1);
        this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
        this.m_ops.setOp(n2 + 1, this.m_ops.getOp(1) - n2);
    }

    /*
     * Unable to fully structure code
     */
    public boolean RelativeLocationPath() throws TransformerException {
        if (this.Step()) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            this.nextToken();
            if (this.Step()) continue;
            this.a("ER_EXPECTED_LOC_STEP", null);
lbl6:
            // 3 sources

            ** while (this.a((char)'/'))
        }
lbl7:
        // 1 sources

        return true;
    }

    public boolean Step() throws TransformerException {
        int n2 = this.m_ops.getOp(1);
        boolean bl2 = this.a('/');
        if (bl2) {
            this.nextToken();
            this.a(2, 42);
            this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
            this.m_ops.setOp(this.m_ops.getOp(1), 1033);
            this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
            this.m_ops.setOp(n2 + 1 + 1, this.m_ops.getOp(1) - n2);
            this.m_ops.setOp(n2 + 1, this.m_ops.getOp(1) - n2);
            n2 = this.m_ops.getOp(1);
        }
        if (this.b(".")) {
            this.nextToken();
            if (this.a('[')) {
                this.a("ER_PREDICATE_ILLEGAL_SYNTAX", null);
            }
            this.a(4, 48);
            this.m_ops.setOp(this.m_ops.getOp(1) - 2, 4);
            this.m_ops.setOp(this.m_ops.getOp(1) - 1, 1033);
        } else if (this.b("..")) {
            this.nextToken();
            this.a(4, 45);
            this.m_ops.setOp(this.m_ops.getOp(1) - 2, 4);
            this.m_ops.setOp(this.m_ops.getOp(1) - 1, 1033);
        } else if (this.a('*') || this.a('@') || this.a('_') || this.e != null && Character.isLetter(this.e.charAt(0))) {
            this.Basis();
            while (this.a('[')) {
                this.Predicate();
            }
            this.m_ops.setOp(n2 + 1, this.m_ops.getOp(1) - n2);
        } else {
            if (bl2) {
                this.a("ER_EXPECTED_LOC_STEP", null);
            }
            return false;
        }
        return true;
    }

    public void Basis() throws TransformerException {
        int n2;
        int n3 = this.m_ops.getOp(1);
        if (this.lookahead("::", 1)) {
            n2 = this.AxisName();
            this.nextToken();
            this.nextToken();
        } else if (this.a('@')) {
            n2 = 39;
            this.a(2, n2);
            this.nextToken();
        } else {
            n2 = 40;
            this.a(2, n2);
        }
        this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
        this.NodeTest(n2);
        this.m_ops.setOp(n3 + 1 + 1, this.m_ops.getOp(1) - n3);
    }

    public int AxisName() throws TransformerException {
        Object v2 = Keywords.d.get(this.e);
        if (null == v2) {
            this.a("ER_ILLEGAL_AXIS_NAME", new Object[]{this.e});
        }
        int n2 = (Integer)v2;
        this.a(2, n2);
        return n2;
    }

    public void NodeTest(int n2) throws TransformerException {
        if (this.a('(', 1)) {
            Object v2 = Keywords.c.get(this.e);
            if (null == v2) {
                this.a("ER_UNKNOWN_NODETYPE", new Object[]{this.e});
            } else {
                this.nextToken();
                int n3 = (Integer)v2;
                this.m_ops.setOp(this.m_ops.getOp(1), n3);
                this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
                this.consumeExpected('(');
                if (1032 == n3 && !this.a(')')) {
                    this.Literal();
                }
                this.consumeExpected(')');
            }
        } else {
            this.m_ops.setOp(this.m_ops.getOp(1), 34);
            this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
            if (this.a(':', 1)) {
                if (this.a('*')) {
                    this.m_ops.setOp(this.m_ops.getOp(1), -3);
                } else {
                    this.m_ops.setOp(this.m_ops.getOp(1), this.b - 1);
                    if (!Character.isLetter(this.d) && !this.a('_')) {
                        this.a("ER_EXPECTED_NODE_TEST", null);
                    }
                }
                this.nextToken();
                this.consumeExpected(':');
            } else {
                this.m_ops.setOp(this.m_ops.getOp(1), -2);
            }
            this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
            if (this.a('*')) {
                this.m_ops.setOp(this.m_ops.getOp(1), -3);
            } else {
                if (49 == n2) {
                    String string = (String)this.m_ops.c.elementAt(this.b - 1);
                    String string2 = this.c.getNamespaceForPrefix(string);
                    this.m_ops.c.setElementAt(string2, this.b - 1);
                }
                this.m_ops.setOp(this.m_ops.getOp(1), this.b - 1);
                if (!Character.isLetter(this.d) && !this.a('_')) {
                    this.a("ER_EXPECTED_NODE_TEST", null);
                }
            }
            this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
            this.nextToken();
        }
    }

    public void Predicate() throws TransformerException {
        if (this.a('[')) {
            this.nextToken();
            this.PredicateExpr();
            this.consumeExpected(']');
        }
    }

    public void PredicateExpr() throws TransformerException {
        int n2 = this.m_ops.getOp(1);
        this.a(2, 29);
        this.Expr();
        this.m_ops.setOp(this.m_ops.getOp(1), -1);
        this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
        this.m_ops.setOp(n2 + 1, this.m_ops.getOp(1) - n2);
    }

    public void QName() throws TransformerException {
        if (this.a(':', 1)) {
            this.m_ops.setOp(this.m_ops.getOp(1), this.b - 1);
            this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
            this.nextToken();
            this.consumeExpected(':');
        } else {
            this.m_ops.setOp(this.m_ops.getOp(1), -2);
            this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
        }
        this.m_ops.setOp(this.m_ops.getOp(1), this.b - 1);
        this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
        this.nextToken();
    }

    public void NCName() {
        this.m_ops.setOp(this.m_ops.getOp(1), this.b - 1);
        this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
        this.nextToken();
    }

    public void Literal() throws TransformerException {
        int n2 = this.e.length() - 1;
        char c2 = this.d;
        char c3 = this.e.charAt(n2);
        if (c2 == '\"' && c3 == '\"' || c2 == '\'' && c3 == '\'') {
            int n3 = this.b - 1;
            this.m_ops.c.setElementAt(null, n3);
            XString xString = new XString(this.e.substring(1, n2));
            this.m_ops.c.setElementAt(xString, n3);
            this.m_ops.setOp(this.m_ops.getOp(1), n3);
            this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
            this.nextToken();
        } else {
            this.a("ER_PATTERN_LITERAL_NEEDS_BE_QUOTED", new Object[]{this.e});
        }
    }

    public void Number() throws TransformerException {
        if (null != this.e) {
            double d2;
            try {
                if (this.e.indexOf(101) > -1 || this.e.indexOf(69) > -1) {
                    throw new NumberFormatException();
                }
                d2 = Double.valueOf(this.e);
            }
            catch (NumberFormatException numberFormatException) {
                d2 = 0.0;
                this.a("ER_COULDNOT_BE_FORMATTED_TO_NUMBER", new Object[]{this.e});
            }
            this.m_ops.c.setElementAt(new XNumber(d2), this.b - 1);
            this.m_ops.setOp(this.m_ops.getOp(1), this.b - 1);
            this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
            this.nextToken();
        }
    }

    public void Pattern() throws TransformerException {
        while (true) {
            this.LocationPathPattern();
            if (!this.a('|')) break;
            this.nextToken();
        }
    }

    public void LocationPathPattern() throws TransformerException {
        int n2 = this.m_ops.getOp(1);
        boolean bl2 = false;
        boolean bl3 = true;
        int n3 = 2;
        int n4 = 0;
        this.a(2, 31);
        if (this.a('(', 1) && (this.b("id") || this.b("key"))) {
            this.IdKeyPattern();
            if (this.a('/')) {
                this.nextToken();
                if (this.a('/')) {
                    this.a(4, 52);
                    this.nextToken();
                } else {
                    this.a(4, 53);
                }
                this.m_ops.setOp(this.m_ops.getOp(1) - 2, 4);
                this.m_ops.setOp(this.m_ops.getOp(1) - 1, 1034);
                n4 = 2;
            }
        } else if (this.a('/')) {
            if (this.a('/', 1)) {
                this.a(4, 52);
                this.nextToken();
                n4 = 2;
            } else {
                this.a(4, 50);
                n4 = 1;
            }
            this.m_ops.setOp(this.m_ops.getOp(1) - 2, 4);
            this.m_ops.setOp(this.m_ops.getOp(1) - 1, 35);
            this.nextToken();
        } else {
            n4 = 2;
        }
        if (n4 != 0) {
            if (!this.a('|') && null != this.e) {
                this.RelativePathPattern();
            } else if (n4 == 2) {
                this.a("ER_EXPECTED_REL_PATH_PATTERN", null);
            }
        }
        this.m_ops.setOp(this.m_ops.getOp(1), -1);
        this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
        this.m_ops.setOp(n2 + 1, this.m_ops.getOp(1) - n2);
    }

    public void IdKeyPattern() throws TransformerException {
        this.FunctionCall();
    }

    public void RelativePathPattern() throws TransformerException {
        boolean bl2 = this.StepPattern(false);
        while (this.a('/')) {
            this.nextToken();
            bl2 = this.StepPattern(!bl2);
        }
    }

    public boolean StepPattern(boolean bl2) throws TransformerException {
        return this.AbbreviatedNodeTestStep(bl2);
    }

    public boolean AbbreviatedNodeTestStep(boolean bl2) throws TransformerException {
        boolean bl3;
        int n2;
        int n3 = this.m_ops.getOp(1);
        int n4 = -1;
        if (this.a('@')) {
            n2 = 51;
            this.a(2, n2);
            this.nextToken();
        } else if (this.lookahead("::", 1)) {
            if (this.b("attribute")) {
                n2 = 51;
                this.a(2, n2);
            } else if (this.b("child")) {
                n4 = this.m_ops.getOp(1);
                n2 = 53;
                this.a(2, n2);
            } else {
                n2 = -1;
                this.a("ER_AXES_NOT_ALLOWED", new Object[]{this.e});
            }
            this.nextToken();
            this.nextToken();
        } else if (this.a('/')) {
            if (!bl2) {
                this.a("ER_EXPECTED_STEP_PATTERN", null);
            }
            n2 = 52;
            this.a(2, n2);
            this.nextToken();
        } else {
            n4 = this.m_ops.getOp(1);
            n2 = 53;
            this.a(2, n2);
        }
        this.m_ops.setOp(1, this.m_ops.getOp(1) + 1);
        this.NodeTest(n2);
        this.m_ops.setOp(n3 + 1 + 1, this.m_ops.getOp(1) - n3);
        while (this.a('[')) {
            this.Predicate();
        }
        if (n4 > -1 && this.a('/') && this.a('/', 1)) {
            this.m_ops.setOp(n4, 52);
            this.nextToken();
            bl3 = true;
        } else {
            bl3 = false;
        }
        this.m_ops.setOp(n3 + 1, this.m_ops.getOp(1) - n3);
        return bl3;
    }
}

