/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

public class SuballocatedByteVector {
    public int m_blocksize;
    public int m_numblocks = 32;
    public byte[][] m_map;
    public int m_firstFree = 0;
    public byte[] m_map0;

    public SuballocatedByteVector() {
        this(2048);
    }

    public SuballocatedByteVector(int n2) {
        this.m_blocksize = n2;
        this.m_map0 = new byte[n2];
        this.m_map = new byte[this.m_numblocks][];
        this.m_map[0] = this.m_map0;
    }

    public SuballocatedByteVector(int n2, int n3) {
        this(n2);
    }

    public int size() {
        return this.m_firstFree;
    }

    private void setSize(int n2) {
        if (this.m_firstFree < n2) {
            this.m_firstFree = n2;
        }
    }

    public void addElement(byte by2) {
        if (this.m_firstFree < this.m_blocksize) {
            this.m_map0[this.m_firstFree++] = by2;
        } else {
            byte[] byArray;
            int n2 = this.m_firstFree / this.m_blocksize;
            int n3 = this.m_firstFree % this.m_blocksize;
            ++this.m_firstFree;
            if (n2 >= this.m_map.length) {
                int n4 = n2 + this.m_numblocks;
                byte[][] byArrayArray = new byte[n4][];
                System.arraycopy(this.m_map, 0, byArrayArray, 0, this.m_map.length);
                this.m_map = byArrayArray;
            }
            if (null == (byArray = this.m_map[n2])) {
                this.m_map[n2] = new byte[this.m_blocksize];
                byArray = this.m_map[n2];
            }
            byArray[n3] = by2;
        }
    }

    private void addElements(byte by2, int n2) {
        if (this.m_firstFree + n2 < this.m_blocksize) {
            int n3 = 0;
            while (n3 < n2) {
                this.m_map0[this.m_firstFree++] = by2;
                ++n3;
            }
        } else {
            int n4 = this.m_firstFree / this.m_blocksize;
            int n5 = this.m_firstFree % this.m_blocksize;
            this.m_firstFree += n2;
            while (n2 > 0) {
                byte[] byArray;
                if (n4 >= this.m_map.length) {
                    int n6 = n4 + this.m_numblocks;
                    byte[][] byArrayArray = new byte[n6][];
                    System.arraycopy(this.m_map, 0, byArrayArray, 0, this.m_map.length);
                    this.m_map = byArrayArray;
                }
                if (null == (byArray = this.m_map[n4])) {
                    this.m_map[n4] = new byte[this.m_blocksize];
                    byArray = this.m_map[n4];
                }
                int n7 = this.m_blocksize - n5 < n2 ? this.m_blocksize - n5 : n2;
                n2 -= n7;
                while (n7-- > 0) {
                    byArray[n5++] = by2;
                }
                ++n4;
                n5 = 0;
            }
        }
    }

    private void addElements(int n2) {
        int n3 = this.m_firstFree + n2;
        if (n3 > this.m_blocksize) {
            int n4 = this.m_firstFree % this.m_blocksize;
            int n5 = (this.m_firstFree + n2) % this.m_blocksize;
            int n6 = n4 + 1;
            while (n6 <= n5) {
                this.m_map[n6] = new byte[this.m_blocksize];
                ++n6;
            }
        }
        this.m_firstFree = n3;
    }

    private void insertElementAt(byte by2, int n2) {
        if (n2 == this.m_firstFree) {
            this.addElement(by2);
        } else if (n2 > this.m_firstFree) {
            byte[] byArray;
            int n3 = n2 / this.m_blocksize;
            if (n3 >= this.m_map.length) {
                int n4 = n3 + this.m_numblocks;
                byte[][] byArrayArray = new byte[n4][];
                System.arraycopy(this.m_map, 0, byArrayArray, 0, this.m_map.length);
                this.m_map = byArrayArray;
            }
            if (null == (byArray = this.m_map[n3])) {
                this.m_map[n3] = new byte[this.m_blocksize];
                byArray = this.m_map[n3];
            }
            int n5 = n2 % this.m_blocksize;
            byArray[n5] = by2;
            this.m_firstFree = n5 + 1;
        } else {
            int n6 = n2 / this.m_blocksize;
            int n7 = this.m_firstFree + 1 / this.m_blocksize;
            ++this.m_firstFree;
            int n8 = n2 % this.m_blocksize;
            while (n6 <= n7) {
                byte by3;
                int n9 = this.m_blocksize - n8 - 1;
                byte[] byArray = this.m_map[n6];
                if (null == byArray) {
                    by3 = 0;
                    this.m_map[n6] = new byte[this.m_blocksize];
                    byArray = this.m_map[n6];
                } else {
                    by3 = byArray[this.m_blocksize - 1];
                    System.arraycopy(byArray, n8, byArray, n8 + 1, n9);
                }
                byArray[n8] = by2;
                by2 = by3;
                n8 = 0;
                ++n6;
            }
        }
    }

    public void removeAllElements() {
        this.m_firstFree = 0;
    }

    private boolean removeElement(byte by2) {
        int n2 = this.indexOf(by2, 0);
        if (n2 < 0) {
            return false;
        }
        this.removeElementAt(n2);
        return true;
    }

    private void removeElementAt(int n2) {
        if (n2 < this.m_firstFree) {
            int n3 = n2 / this.m_blocksize;
            int n4 = this.m_firstFree / this.m_blocksize;
            int n5 = n2 % this.m_blocksize;
            while (n3 <= n4) {
                int n6 = this.m_blocksize - n5 - 1;
                byte[] byArray = this.m_map[n3];
                if (null == byArray) {
                    this.m_map[n3] = new byte[this.m_blocksize];
                    byArray = this.m_map[n3];
                } else {
                    System.arraycopy(byArray, n5 + 1, byArray, n5, n6);
                }
                if (n3 < n4) {
                    byte[] byArray2 = this.m_map[n3 + 1];
                    if (byArray2 != null) {
                        byArray[this.m_blocksize - 1] = byArray2 != null ? byArray2[0] : (byte)0;
                    }
                } else {
                    byArray[this.m_blocksize - 1] = 0;
                }
                n5 = 0;
                ++n3;
            }
        }
        --this.m_firstFree;
    }

    public void setElementAt(byte by2, int n2) {
        byte[] byArray;
        if (n2 < this.m_blocksize) {
            this.m_map0[n2] = by2;
            return;
        }
        int n3 = n2 / this.m_blocksize;
        int n4 = n2 % this.m_blocksize;
        if (n3 >= this.m_map.length) {
            int n5 = n3 + this.m_numblocks;
            byte[][] byArrayArray = new byte[n5][];
            System.arraycopy(this.m_map, 0, byArrayArray, 0, this.m_map.length);
            this.m_map = byArrayArray;
        }
        if (null == (byArray = this.m_map[n3])) {
            this.m_map[n3] = new byte[this.m_blocksize];
            byArray = this.m_map[n3];
        }
        byArray[n4] = by2;
        if (n2 >= this.m_firstFree) {
            this.m_firstFree = n2 + 1;
        }
    }

    public byte elementAt(int n2) {
        if (n2 < this.m_blocksize) {
            return this.m_map0[n2];
        }
        return this.m_map[n2 / this.m_blocksize][n2 % this.m_blocksize];
    }

    private boolean contains(byte by2) {
        return this.indexOf(by2, 0) >= 0;
    }

    public int indexOf(byte by2, int n2) {
        int n3;
        byte[] byArray;
        if (n2 >= this.m_firstFree) {
            return -1;
        }
        int n4 = n2 / this.m_blocksize;
        int n5 = n2 % this.m_blocksize;
        int n6 = this.m_firstFree / this.m_blocksize;
        while (n4 < n6) {
            byArray = this.m_map[n4];
            if (byArray != null) {
                n3 = n5;
                while (n3 < this.m_blocksize) {
                    if (byArray[n3] == by2) {
                        return n3 + n4 * this.m_blocksize;
                    }
                    ++n3;
                }
            }
            n5 = 0;
            ++n4;
        }
        n3 = this.m_firstFree % this.m_blocksize;
        byArray = this.m_map[n6];
        int n7 = n5;
        while (n7 < n3) {
            if (byArray[n7] == by2) {
                return n7 + n6 * this.m_blocksize;
            }
            ++n7;
        }
        return -1;
    }

    public int indexOf(byte by2) {
        return this.indexOf(by2, 0);
    }

    private int lastIndexOf(byte by2) {
        int n2 = this.m_firstFree % this.m_blocksize;
        int n3 = this.m_firstFree / this.m_blocksize;
        while (n3 >= 0) {
            byte[] byArray = this.m_map[n3];
            if (byArray != null) {
                int n4 = n2;
                while (n4 >= 0) {
                    if (byArray[n4] == by2) {
                        return n4 + n3 * this.m_blocksize;
                    }
                    --n4;
                }
            }
            n2 = 0;
            --n3;
        }
        return -1;
    }
}

