/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ListingErrorHandler
implements ErrorHandler,
ErrorListener {
    public PrintWriter m_pw = null;
    public boolean throwOnWarning = false;
    public boolean throwOnError = true;
    public boolean throwOnFatalError = true;

    public ListingErrorHandler(PrintWriter printWriter) {
        if (null == printWriter) {
            throw new NullPointerException(XMLMessages.createXMLMessage("ER_ERRORHANDLER_CREATED_WITH_NULL_PRINTWRITER", null));
        }
        this.m_pw = printWriter;
    }

    public ListingErrorHandler() {
        this.m_pw = new PrintWriter(System.err, true);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        ListingErrorHandler.logExceptionLocation(this.m_pw, sAXParseException);
        this.m_pw.println("warning: " + sAXParseException.getMessage());
        this.m_pw.flush();
        if (this.getThrowOnWarning()) {
            throw sAXParseException;
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        ListingErrorHandler.logExceptionLocation(this.m_pw, sAXParseException);
        this.m_pw.println("error: " + sAXParseException.getMessage());
        this.m_pw.flush();
        if (this.getThrowOnError()) {
            throw sAXParseException;
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        ListingErrorHandler.logExceptionLocation(this.m_pw, sAXParseException);
        this.m_pw.println("fatalError: " + sAXParseException.getMessage());
        this.m_pw.flush();
        if (this.getThrowOnFatalError()) {
            throw sAXParseException;
        }
    }

    public void warning(TransformerException transformerException) throws TransformerException {
        ListingErrorHandler.logExceptionLocation(this.m_pw, transformerException);
        this.m_pw.println("warning: " + transformerException.getMessage());
        this.m_pw.flush();
        if (this.getThrowOnWarning()) {
            throw transformerException;
        }
    }

    public void error(TransformerException transformerException) throws TransformerException {
        ListingErrorHandler.logExceptionLocation(this.m_pw, transformerException);
        this.m_pw.println("error: " + transformerException.getMessage());
        this.m_pw.flush();
        if (this.getThrowOnError()) {
            throw transformerException;
        }
    }

    public void fatalError(TransformerException transformerException) throws TransformerException {
        ListingErrorHandler.logExceptionLocation(this.m_pw, transformerException);
        this.m_pw.println("error: " + transformerException.getMessage());
        this.m_pw.flush();
        if (this.getThrowOnError()) {
            throw transformerException;
        }
    }

    public static void logExceptionLocation(PrintWriter printWriter, Throwable throwable) {
        Object object;
        if (null == printWriter) {
            printWriter = new PrintWriter(System.err, true);
        }
        SourceLocator sourceLocator = null;
        Throwable throwable2 = throwable;
        do {
            if (throwable2 instanceof SAXParseException) {
                sourceLocator = new SAXSourceLocator((SAXParseException)throwable2);
                continue;
            }
            if (!(throwable2 instanceof TransformerException) || null == (object = ((TransformerException)throwable2).getLocator())) continue;
            sourceLocator = object;
        } while (null != (throwable2 = throwable2 instanceof TransformerException ? ((TransformerException)throwable2).getCause() : (throwable2 instanceof WrappedRuntimeException ? ((WrappedRuntimeException)throwable2).getException() : (throwable2 instanceof SAXException ? ((SAXException)throwable2).getException() : null))));
        if (null != sourceLocator) {
            object = sourceLocator.getPublicId() != sourceLocator.getPublicId() ? sourceLocator.getPublicId() : (null != sourceLocator.getSystemId() ? sourceLocator.getSystemId() : "SystemId-Unknown");
            printWriter.print((String)object + ":Line=" + sourceLocator.getLineNumber() + ";Column=" + sourceLocator.getColumnNumber() + ": ");
            printWriter.println("exception:" + throwable.getMessage());
            printWriter.println("root-cause:" + (null != throwable2 ? throwable2.getMessage() : "null"));
            ListingErrorHandler.logSourceLine(printWriter, sourceLocator);
        } else {
            printWriter.print("SystemId-Unknown:locator-unavailable: ");
            printWriter.println("exception:" + throwable.getMessage());
            printWriter.println("root-cause:" + (null != throwable2 ? throwable2.getMessage() : "null"));
        }
    }

    public static void logSourceLine(PrintWriter printWriter, SourceLocator sourceLocator) {
        String string;
        if (null == sourceLocator) {
            return;
        }
        if (null == printWriter) {
            printWriter = new PrintWriter(System.err, true);
        }
        if (null == (string = sourceLocator.getSystemId())) {
            printWriter.println("line: (No systemId; cannot read file)");
            printWriter.println();
            return;
        }
        try {
            int n2 = sourceLocator.getLineNumber();
            int n3 = sourceLocator.getColumnNumber();
            printWriter.println("line: " + ListingErrorHandler.getSourceLine(string, n2));
            StringBuffer stringBuffer = new StringBuffer("line: ");
            int n4 = 1;
            while (n4 < n3) {
                stringBuffer.append(' ');
                ++n4;
            }
            stringBuffer.append('^');
            printWriter.println(stringBuffer.toString());
        }
        catch (Exception exception) {
            printWriter.println("line: logSourceLine unavailable due to: " + exception.getMessage());
            printWriter.println();
        }
    }

    public static String getSourceLine(String string, int n2) throws Exception {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            int n3 = string.indexOf(58);
            int n4 = string.indexOf(47);
            if (n3 != -1 && n4 != -1 && n3 < n4) {
                throw malformedURLException;
            }
            uRL = new URL(SystemIDResolver.getAbsoluteURI(string));
        }
        String string2 = null;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            int n5 = 1;
            while (n5 <= n2) {
                string2 = bufferedReader.readLine();
                ++n5;
            }
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            bufferedReader.close();
            inputStream.close();
            throw throwable;
        }
        bufferedReader.close();
        inputStream.close();
        return string2;
    }

    public void setThrowOnWarning(boolean bl2) {
        this.throwOnWarning = bl2;
    }

    public boolean getThrowOnWarning() {
        return this.throwOnWarning;
    }

    public void setThrowOnError(boolean bl2) {
        this.throwOnError = bl2;
    }

    public boolean getThrowOnError() {
        return this.throwOnError;
    }

    public void setThrowOnFatalError(boolean bl2) {
        this.throwOnFatalError = bl2;
    }

    public boolean getThrowOnFatalError() {
        return this.throwOnFatalError;
    }
}

