/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.Transformer;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.serializer.CharInfo;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.OutputPropertyUtils;
import org.apache.xml.serializer.SerializerBase;
import org.apache.xml.serializer.SerializerTraceWriter;
import org.apache.xml.serializer.WriterToASCI;
import org.apache.xml.serializer.WriterToUTF8Buffered;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.DOM2Helper;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.TreeWalker;
import org.apache.xml.utils.WrappedRuntimeException;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class ToStream
extends SerializerBase {
    private static final String COMMENT_BEGIN = "<!--";
    private static final String COMMENT_END = "-->";
    public BoolStack m_disableOutputEscapingStates = new BoolStack();
    public boolean b = false;
    public Method e;
    public Object g = null;
    public BoolStack m_preserves = new BoolStack();
    public boolean m_ispreserve = false;
    public boolean m_isprevtext = false;
    public int m_maxCharacter = Encodings.getLastPrintable();
    public final char[] m_lineSep = System.getProperty("line.separator").toCharArray();
    public boolean m_lineSepUse = true;
    public final int m_lineSepLen = this.m_lineSep.length;
    public CharInfo m_charInfo;
    public boolean d = true;
    public boolean m_spaceBeforeClose = false;
    public boolean f;
    public boolean m_inDoctype = false;
    public boolean c = false;
    public Properties m_format;
    public boolean m_cdataStartCalled = false;
    private boolean m_escaping = true;

    public void closeCDATA() throws SAXException {
        try {
            this.m_writer.write("]]>");
            this.m_cdataTagOpen = false;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void serialize(Node node) throws IOException {
        try {
            TreeWalker treeWalker = new TreeWalker(this, new DOM2Helper());
            treeWalker.traverse(node);
        }
        catch (SAXException sAXException) {
            throw new WrappedRuntimeException(sAXException);
        }
    }

    public static final boolean a(char c2) {
        return (c2 & 0xFC00) == 55296;
    }

    public final void flushWriter() throws SAXException {
        Writer writer = this.m_writer;
        if (null != writer) {
            try {
                if (writer instanceof WriterToUTF8Buffered) {
                    if (this.d) {
                        ((WriterToUTF8Buffered)writer).flush();
                    } else {
                        ((WriterToUTF8Buffered)writer).flushBuffer();
                    }
                }
                if (writer instanceof WriterToASCI) {
                    if (this.d) {
                        writer.flush();
                    }
                } else {
                    writer.flush();
                }
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
    }

    public OutputStream getOutputStream() {
        if (this.m_writer instanceof WriterToUTF8Buffered) {
            return ((WriterToUTF8Buffered)this.m_writer).getOutputStream();
        }
        if (this.m_writer instanceof WriterToASCI) {
            return ((WriterToASCI)this.m_writer).getOutputStream();
        }
        return null;
    }

    public void elementDecl(String string, String string2) throws SAXException {
        if (this.m_inExternalDTD) {
            return;
        }
        try {
            Writer writer = this.m_writer;
            if (this.a) {
                this.a(this.m_elemContext.e, false);
                this.a = false;
            }
            if (this.m_inDoctype) {
                writer.write(" [");
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                this.m_inDoctype = false;
            }
            writer.write("<!ELEMENT ");
            writer.write(string);
            writer.write(32);
            writer.write(string2);
            writer.write(62);
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
        if (this.m_inExternalDTD) {
            return;
        }
        try {
            if (this.a) {
                this.a(this.m_elemContext.e, false);
                this.a = false;
            }
            if (this.m_inDoctype) {
                Writer writer = this.m_writer;
                writer.write(" [");
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                this.m_inDoctype = false;
            }
            this.a(string, string2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void a(String string, String string2) throws IOException {
        Writer writer = this.m_writer;
        writer.write("<!ENTITY ");
        writer.write(string);
        writer.write(" \"");
        writer.write(string2);
        writer.write("\">");
        writer.write(this.m_lineSep, 0, this.m_lineSepLen);
    }

    public final void outputLineSep() throws IOException {
        this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
    }

    public void setOutputFormat(Properties properties) {
        boolean bl2 = this.d;
        this.init(this.m_writer, properties, false, false);
        this.d = bl2;
    }

    private synchronized void init(Writer writer, Properties properties, boolean bl2, boolean bl3) {
        String string;
        this.d = bl3;
        this.m_writer = this.m_tracer != null && !(writer instanceof SerializerTraceWriter) ? new SerializerTraceWriter(writer, this.m_tracer) : writer;
        this.m_format = properties;
        this.setCdataSectionElements("cdata-section-elements", properties);
        this.setIndentAmount(OutputPropertyUtils.getIntProperty("{http://xml.apache.org/xalan}indent-amount", properties));
        this.setIndent(OutputPropertyUtils.getBooleanProperty("indent", properties));
        boolean bl4 = OutputPropertyUtils.getBooleanProperty("omit-xml-declaration", properties);
        this.setOmitXMLDeclaration(bl4);
        this.setDoctypeSystem(properties.getProperty("doctype-system"));
        String string2 = properties.getProperty("doctype-public");
        this.setDoctypePublic(string2);
        if (((Hashtable)properties).get("standalone") != null) {
            string = properties.getProperty("standalone");
            if (bl2) {
                this.setStandaloneInternal(string);
            } else {
                this.setStandalone(string);
            }
        }
        this.setMediaType(properties.getProperty("media-type"));
        if (null != string2 && string2.startsWith("-//W3C//DTD XHTML")) {
            this.m_spaceBeforeClose = true;
        }
        if (null == (string = this.getEncoding())) {
            string = Encodings.getMimeEncoding(properties.getProperty("encoding"));
            this.setEncoding(string);
        }
        this.c = string.equals("UTF-8");
        this.m_maxCharacter = Encodings.getLastPrintable(string);
        String string3 = (String)((Hashtable)properties).get("{http://xml.apache.org/xalan}entities");
        if (null != string3) {
            String string4 = (String)((Hashtable)properties).get("method");
            this.m_charInfo = CharInfo.getCharInfo(string3, string4);
        }
    }

    private synchronized void init(Writer writer, Properties properties) {
        this.init(writer, properties, false, false);
    }

    public synchronized void init(OutputStream outputStream, Properties properties, boolean bl2) throws UnsupportedEncodingException {
        String string = this.getEncoding();
        if (string == null) {
            string = Encodings.getMimeEncoding(properties.getProperty("encoding"));
            this.setEncoding(string);
        }
        if (string.equalsIgnoreCase("UTF-8")) {
            this.c = true;
            this.init(new WriterToUTF8Buffered(outputStream), properties, bl2, true);
        } else if (string.equals("WINDOWS-1250") || string.equals("US-ASCII") || string.equals("ASCII")) {
            this.init(new WriterToASCI(outputStream), properties, bl2, true);
        } else {
            Writer writer;
            try {
                writer = Encodings.getWriter(outputStream, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println("Warning: encoding \"" + string + "\" not supported" + ", using " + "UTF-8");
                string = "UTF-8";
                this.setEncoding(string);
                writer = Encodings.getWriter(outputStream, string);
            }
            this.m_maxCharacter = Encodings.getLastPrintable(string);
            this.init(writer, properties, bl2, true);
        }
    }

    public Properties getOutputFormat() {
        return this.m_format;
    }

    public void setWriter(Writer writer) {
        this.m_writer = this.m_tracer != null && !(writer instanceof SerializerTraceWriter) ? new SerializerTraceWriter(writer, this.m_tracer) : writer;
    }

    public boolean setLineSepUse(boolean bl2) {
        boolean bl3 = this.m_lineSepUse;
        this.m_lineSepUse = bl2;
        return bl3;
    }

    public void setOutputStream(OutputStream outputStream) {
        try {
            Properties properties = null == this.m_format ? OutputPropertiesFactory.getDefaultMethodProperties("xml") : this.m_format;
            this.init(outputStream, properties, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public boolean setEscaping(boolean bl2) {
        boolean bl3 = this.m_escaping;
        this.m_escaping = bl2;
        return bl3;
    }

    public void indent(int n2) throws IOException {
        if (this.f) {
            this.outputLineSep();
        }
        if (this.m_indentAmount > 0) {
            this.printSpace(n2 * this.m_indentAmount);
        }
    }

    public void indent() throws IOException {
        this.indent(this.m_elemContext.h);
    }

    private void printSpace(int n2) throws IOException {
        Writer writer = this.m_writer;
        int n3 = 0;
        while (n3 < n2) {
            writer.write(32);
            ++n3;
        }
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (this.m_inExternalDTD) {
            return;
        }
        try {
            Writer writer = this.m_writer;
            if (this.a) {
                this.a(this.m_elemContext.e, false);
                this.a = false;
            }
            if (this.m_inDoctype) {
                writer.write(" [");
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                this.m_inDoctype = false;
            }
            writer.write("<!ATTLIST ");
            writer.write(string);
            writer.write(32);
            writer.write(string2);
            writer.write(32);
            writer.write(string3);
            if (string4 != null) {
                writer.write(32);
                writer.write(string4);
            }
            writer.write(62);
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public Writer getWriter() {
        return this.m_writer;
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
    }

    public boolean escapingNotNeeded(char c2) {
        Constable constable;
        Object[] objectArray;
        if (c2 < '\u007f') {
            return c2 >= ' ' || '\n' == c2 || '\r' == c2 || '\t' == c2;
        }
        if (null == this.g && !this.b) {
            this.b = true;
            try {
                this.g = Encodings.getCharToByteConverter(this.getEncoding());
                if (null != this.g) {
                    objectArray = new Class[]{Character.TYPE};
                    constable = this.g.getClass();
                    this.e = ((Class)constable).getMethod("canConvert", (Class<?>[])objectArray);
                }
            }
            catch (Exception exception) {
                System.err.println("Warning: " + exception.getMessage());
            }
        }
        if (null != this.g) {
            try {
                objectArray = new Object[]{new Character(c2)};
                constable = (Boolean)this.e.invoke(this.g, objectArray);
                return ((Boolean)constable).booleanValue() ? !Character.isISOControl(c2) : false;
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("Warning: InvocationTargetException in canConvert!");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("Warning: IllegalAccessException in canConvert!");
            }
        }
        return c2 <= this.m_maxCharacter;
    }

    public void writeUTF16Surrogate(char c2, char[] cArray, int n2, int n3) throws IOException {
        int n4 = this.a(c2, cArray, n2, n3);
        Writer writer = this.m_writer;
        writer.write(38);
        writer.write(35);
        writer.write(Integer.toString(n4));
        writer.write(59);
    }

    public int a(char c2, char[] cArray, int n2, int n3) throws IOException {
        int n4;
        if (n2 + 1 >= n3) {
            throw new IOException(XMLMessages.createXMLMessage("ER_INVALID_UTF16_SURROGATE", new Object[]{Integer.toHexString(c2)}));
        }
        if (56320 > (n4 = cArray[++n2]) || n4 >= 57344) {
            throw new IOException(XMLMessages.createXMLMessage("ER_INVALID_UTF16_SURROGATE", new Object[]{Integer.toHexString(c2) + " " + Integer.toHexString(n4)}));
        }
        n4 = (c2 - 55296 << 10) + n4 - 56320 + 65536;
        return n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int accumDefaultEntity(Writer writer, char c2, int n2, char[] cArray, int n3, boolean bl2, boolean bl3) throws IOException {
        if (!bl3 && '\n' == c2) {
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            return n2 + 1;
        } else {
            if ((!bl2 || !this.m_charInfo.isSpecialTextChar(c2)) && (bl2 || !this.m_charInfo.isSpecialAttrChar(c2))) return n2;
            String string = this.m_charInfo.getEntityNameForChar(c2);
            if (null == string) return n2;
            writer.write(38);
            writer.write(string);
            writer.write(59);
        }
        return n2 + 1;
    }

    public void a(char[] cArray, int n2, int n3, boolean bl2, boolean bl3) throws IOException, SAXException {
        Writer writer = this.m_writer;
        int n4 = n2 + n3;
        int n5 = n2;
        while (n5 < n4) {
            String string;
            char c2 = cArray[n5];
            if ('\n' == c2 && bl3) {
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            } else if (bl2 && !this.escapingNotNeeded(c2)) {
                if (this.m_cdataTagOpen) {
                    this.closeCDATA();
                }
                if (ToStream.a(c2)) {
                    this.writeUTF16Surrogate(c2, cArray, n5, n4);
                    ++n5;
                } else {
                    writer.write("&#");
                    string = Integer.toString(c2);
                    writer.write(string);
                    writer.write(59);
                }
            } else if (bl2 && n5 < n4 - 2 && ']' == c2 && ']' == cArray[n5 + 1] && '>' == cArray[n5 + 2]) {
                writer.write("]]]]><![CDATA[>");
                n5 += 2;
            } else if (this.escapingNotNeeded(c2)) {
                if (bl2 && !this.m_cdataTagOpen) {
                    writer.write("<![CDATA[");
                    this.m_cdataTagOpen = true;
                }
                writer.write(c2);
            } else if (ToStream.a(c2)) {
                if (this.m_cdataTagOpen) {
                    this.closeCDATA();
                }
                this.writeUTF16Surrogate(c2, cArray, n5, n4);
                ++n5;
            } else {
                if (this.m_cdataTagOpen) {
                    this.closeCDATA();
                }
                writer.write("&#");
                string = Integer.toString(c2);
                writer.write(string);
                writer.write(59);
            }
            ++n5;
        }
    }

    public void endNonEscaping() throws SAXException {
        this.m_disableOutputEscapingStates.pop();
    }

    public void startNonEscaping() throws SAXException {
        this.m_disableOutputEscapingStates.push(true);
    }

    public void cdata(char[] cArray, int n2, int n3) throws SAXException {
        try {
            boolean bl2;
            int n4 = n2;
            if (this.m_elemContext.d) {
                this.closeStartTag();
                this.m_elemContext.d = false;
            }
            this.m_ispreserve = true;
            if (this.shouldIndent()) {
                this.indent();
            }
            boolean bl3 = bl2 = n3 >= 1 && this.escapingNotNeeded(cArray[n2]);
            if (bl2 && !this.m_cdataTagOpen) {
                this.m_writer.write("<![CDATA[");
                this.m_cdataTagOpen = true;
            }
            if (this.isEscapingDisabled()) {
                this.charactersRaw(cArray, n2, n3);
            } else {
                this.a(cArray, n2, n3, true, this.m_lineSepUse);
            }
            if (bl2 && cArray[n2 + n3 - 1] == ']') {
                this.closeCDATA();
            }
            if (this.m_tracer != null) {
                super.fireCDATAEvent(cArray, n4, n3);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(XMLMessages.createXMLMessage("ER_OIERROR", null), iOException);
        }
    }

    private boolean isEscapingDisabled() {
        return this.m_disableOutputEscapingStates.peekOrFalse();
    }

    public void charactersRaw(char[] cArray, int n2, int n3) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        try {
            if (this.m_elemContext.d) {
                this.closeStartTag();
                this.m_elemContext.d = false;
            }
            this.m_ispreserve = true;
            this.m_writer.write(cArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void characters(char[] var1_1, int var2_2, int var3_3) throws SAXException {
        if (this.m_elemContext.d) {
            this.closeStartTag();
            this.m_elemContext.d = false;
        } else if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
        }
        if (this.m_cdataStartCalled || this.m_elemContext.i) {
            this.cdata(var1_1, var2_2, var3_3);
            return;
        }
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        if (this.m_disableOutputEscapingStates.peekOrFalse() || !this.m_escaping) {
            this.charactersRaw(var1_1, var2_2, var3_3);
            if (this.m_tracer != null) {
                super.fireCharEvent(var1_1, var2_2, var3_3);
            }
            return;
        }
        if (this.m_elemContext.d) {
            this.closeStartTag();
            this.m_elemContext.d = false;
        }
        try {
            var7_4 = var2_2 + var3_3;
            var8_5 = var2_2 - 1;
            var4_6 = var2_2;
            while (var4_6 < var7_4 && ((var5_8 = var1_1[var4_6]) == ' ' || var5_8 == '\n' && this.m_lineSepUse || var5_8 == '\r' || var5_8 == '\t')) {
                if (!this.m_charInfo.isTextASCIIClean(var5_8)) {
                    var4_6 = var8_5 = this.processDirty(var1_1, var7_4, var4_6, var5_8, var8_5, true);
                }
                ++var4_6;
            }
            if (var4_6 >= var7_4) ** GOTO lbl40
            this.m_ispreserve = true;
            ** GOTO lbl40
            {
                ++var4_6;
                do {
                    if (var4_6 < var7_4 && (var9_9 = var1_1[var4_6]) < '\u007f' && this.m_charInfo.isTextASCIIClean(var9_9)) continue block3;
                    if (var4_6 == var7_4) break block3;
                    var9_9 = var1_1[var4_6];
                    if ((!this.escapingNotNeeded(var9_9) || this.m_charInfo.isSpecialTextChar(var9_9)) && '\"' != var9_9) {
                        var4_6 = var8_5 = this.processDirty(var1_1, var7_4, var4_6, var9_9, var8_5, true);
                    }
                    ++var4_6;
lbl40:
                    // 3 sources

                } while (var4_6 < var7_4);
            }
            if (var4_6 > (var6_10 = var8_5 + 1)) {
                var9_9 = var4_6 - var6_10;
                this.m_writer.write(var1_1, var6_10, (int)var9_9);
            }
            this.m_isprevtext = true;
        }
        catch (IOException var4_7) {
            throw new SAXException(var4_7);
        }
        if (this.m_tracer != null) {
            super.fireCharEvent(var1_1, var2_2, var3_3);
        }
    }

    private int processDirty(char[] cArray, int n2, int n3, char c2, int n4, boolean bl2) throws IOException {
        int n5 = n4 + 1;
        if (n3 > n5) {
            int n6 = n3 - n5;
            this.m_writer.write(cArray, n5, n6);
        }
        if ('\n' == c2 && bl2) {
            this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        } else {
            n5 = this.accumDefaultEscape(this.m_writer, c2, n3, cArray, n2, bl2, false);
            n3 = n5 - 1;
        }
        return n3;
    }

    public void characters(String string) throws SAXException {
        int n2 = string.length();
        if (n2 > this.m_charsBuff.length) {
            this.m_charsBuff = new char[n2 * 2 + 1];
        }
        string.getChars(0, n2, this.m_charsBuff, 0);
        this.characters(this.m_charsBuff, 0, n2);
    }

    public int accumDefaultEscape(Writer writer, char c2, int n2, char[] cArray, int n3, boolean bl2, boolean bl3) throws IOException {
        int n4 = this.accumDefaultEntity(writer, c2, n2, cArray, n3, bl2, bl3);
        if (n2 == n4) {
            if ('\ud800' <= c2 && c2 < '\udc00') {
                int n5;
                if (n2 + 1 >= n3) {
                    throw new IOException(XMLMessages.createXMLMessage("ER_INVALID_UTF16_SURROGATE", new Object[]{Integer.toHexString(c2)}));
                }
                if (56320 > (n5 = cArray[++n2]) || n5 >= 57344) {
                    throw new IOException(XMLMessages.createXMLMessage("ER_INVALID_UTF16_SURROGATE", new Object[]{Integer.toHexString(c2) + " " + Integer.toHexString(n5)}));
                }
                n5 = (c2 - 55296 << 10) + n5 - 56320 + 65536;
                writer.write("&#");
                writer.write(Integer.toString(n5));
                writer.write(59);
                n4 += 2;
            } else {
                if (!this.escapingNotNeeded(c2) || bl2 && this.m_charInfo.isSpecialTextChar(c2) || !bl2 && this.m_charInfo.isSpecialAttrChar(c2)) {
                    writer.write("&#");
                    writer.write(Integer.toString(c2));
                    writer.write(59);
                } else {
                    writer.write(c2);
                }
                ++n4;
            }
        }
        return n4;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        } else if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        try {
            if (this.a && null != this.getDoctypeSystem()) {
                this.a(string3, true);
            }
            this.a = false;
            if (this.m_elemContext.d) {
                this.closeStartTag();
                this.m_elemContext.d = false;
            }
            if (string != null) {
                this.b(string, string3);
            }
            this.m_ispreserve = false;
            if (this.shouldIndent() && this.f) {
                this.indent();
            }
            this.f = true;
            Writer writer = this.m_writer;
            writer.write(60);
            writer.write(string3);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (attributes != null) {
            this.addAttributes(attributes);
        }
        this.m_elemContext = this.m_elemContext.a(string, string2, string3);
        this.m_isprevtext = false;
        if (this.m_tracer != null) {
            this.firePseudoAttributes();
        }
    }

    public void startElement(String string, String string2, String string3) throws SAXException {
        this.startElement(string, string2, string3, null);
    }

    public void startElement(String string) throws SAXException {
        this.startElement(null, null, string, null);
    }

    public void a(String string, boolean bl2) throws SAXException {
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        try {
            boolean bl3;
            String string2;
            Writer writer = this.m_writer;
            writer.write("<!DOCTYPE ");
            writer.write(string);
            String string3 = this.getDoctypePublic();
            if (null != string3) {
                writer.write(" PUBLIC \"");
                writer.write(string3);
                writer.write(34);
            }
            if (null != (string2 = this.getDoctypeSystem())) {
                if (null == string3) {
                    writer.write(" SYSTEM \"");
                } else {
                    writer.write(" \"");
                }
                writer.write(string2);
                if (bl2) {
                    writer.write("\">");
                    writer.write(this.m_lineSep, 0, this.m_lineSepLen);
                    bl2 = false;
                } else {
                    writer.write(34);
                }
            }
            if ((bl3 = false) && bl2) {
                writer.write(62);
                writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void processAttributes(Writer writer, int n2) throws IOException, SAXException {
        String string = this.getEncoding();
        int n3 = 0;
        while (n3 < n2) {
            String string2 = this.m_attributes.getQName(n3);
            String string3 = this.m_attributes.getValue(n3);
            writer.write(32);
            writer.write(string2);
            writer.write("=\"");
            this.writeAttrString(writer, string3, string);
            writer.write(34);
            ++n3;
        }
    }

    public void writeAttrString(Writer writer, String string, String string2) throws IOException {
        int n2 = string.length();
        if (n2 > this.m_attrBuff.length) {
            this.m_attrBuff = new char[n2 * 2 + 1];
        }
        string.getChars(0, n2, this.m_attrBuff, 0);
        char[] cArray = this.m_attrBuff;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = cArray[n3];
            if (this.escapingNotNeeded(c2) && !this.m_charInfo.isSpecialAttrChar(c2)) {
                writer.write(c2);
            } else {
                this.accumDefaultEscape(writer, c2, n3, cArray, n2, false, true);
            }
            ++n3;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.m_inEntityRef) {
            return;
        }
        this.m_prefixMap.popNamespaces(this.m_elemContext.h, null);
        try {
            Writer writer = this.m_writer;
            if (this.m_elemContext.d) {
                int n2;
                if (this.m_tracer != null) {
                    super.fireStartElem(this.m_elemContext.e);
                }
                if ((n2 = this.m_attributes.getLength()) > 0) {
                    this.processAttributes(this.m_writer, n2);
                    this.m_attributes.clear();
                }
                if (this.m_spaceBeforeClose) {
                    writer.write(" />");
                } else {
                    writer.write("/>");
                }
            } else {
                if (this.m_cdataTagOpen) {
                    this.closeCDATA();
                }
                if (this.shouldIndent()) {
                    this.indent(this.m_elemContext.h - 1);
                }
                writer.write(60);
                writer.write(47);
                writer.write(string3);
                writer.write(62);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        if (!this.m_elemContext.d && this.m_doIndent) {
            this.m_ispreserve = this.m_preserves.isEmpty() ? false : this.m_preserves.pop();
        }
        this.m_isprevtext = false;
        if (this.m_tracer != null) {
            super.fireEndElem(string3);
        }
        this.m_elemContext = this.m_elemContext.f;
    }

    public void endElement(String string) throws SAXException {
        this.endElement(null, null, string);
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.startPrefixMapping(string, string2, true);
    }

    public boolean startPrefixMapping(String string, String string2, boolean bl2) throws SAXException {
        int n2;
        if (bl2) {
            this.flushPending();
            n2 = this.m_elemContext.h + 1;
        } else {
            n2 = this.m_elemContext.h;
        }
        boolean bl3 = this.m_prefixMap.pushNamespace(string, string2, n2);
        if (bl3) {
            if ("".equals(string)) {
                String string3 = "xmlns";
                this.addAttributeAlways("http://www.w3.org/2000/xmlns/", string, string3, "CDATA", string2);
            } else if (!"".equals(string2)) {
                String string4 = "xmlns:" + string;
                this.addAttributeAlways("http://www.w3.org/2000/xmlns/", string, string4, "CDATA", string2);
            }
        }
        return bl3;
    }

    public void comment(char[] cArray, int n2, int n3) throws SAXException {
        int n4 = n2;
        if (this.m_inEntityRef) {
            return;
        }
        if (this.m_elemContext.d) {
            this.closeStartTag();
            this.m_elemContext.d = false;
        } else if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        }
        try {
            if (this.shouldIndent()) {
                this.indent();
            }
            int n5 = n2 + n3;
            boolean bl2 = false;
            if (this.m_cdataTagOpen) {
                this.closeCDATA();
            }
            Writer writer = this.m_writer;
            writer.write(COMMENT_BEGIN);
            int n6 = n2;
            while (n6 < n5) {
                if (bl2 && cArray[n6] == '-') {
                    writer.write(cArray, n2, n6 - n2);
                    writer.write(" -");
                    n2 = n6 + 1;
                }
                bl2 = cArray[n6] == '-';
                ++n6;
            }
            if (n3 > 0) {
                int n7 = n5 - n2;
                if (n7 > 0) {
                    writer.write(cArray, n2, n7);
                }
                if (cArray[n5 - 1] == '-') {
                    writer.write(32);
                }
            }
            writer.write(COMMENT_END);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        this.f = true;
        if (this.m_tracer != null) {
            super.fireCommentEvent(cArray, n4, n3);
        }
    }

    public void endCDATA() throws SAXException {
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        this.m_cdataStartCalled = false;
    }

    public void endDTD() throws SAXException {
        try {
            if (this.a) {
                this.a(this.m_elemContext.e, false);
                this.a = false;
            }
            Writer writer = this.m_writer;
            if (!this.m_inDoctype) {
                writer.write("]>");
            } else {
                writer.write(62);
            }
            writer.write(this.m_lineSep, 0, this.m_lineSepLen);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        if (0 == n3) {
            return;
        }
        this.characters(cArray, n2, n3);
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.m_cdataStartCalled = true;
    }

    public void startEntity(String string) throws SAXException {
        if (string.equals("[dtd]")) {
            this.m_inExternalDTD = true;
        }
        this.m_inEntityRef = true;
    }

    public void closeStartTag() throws SAXException {
        if (this.m_elemContext.d) {
            try {
                int n2;
                if (this.m_tracer != null) {
                    super.fireStartElem(this.m_elemContext.e);
                }
                if ((n2 = this.m_attributes.getLength()) > 0) {
                    this.processAttributes(this.m_writer, n2);
                    this.m_attributes.clear();
                }
                this.m_writer.write(62);
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
            if (this.m_cdataSectionElements != null) {
                this.m_elemContext.i = this.isCdataSection();
            }
            if (this.m_doIndent) {
                this.m_isprevtext = false;
                this.m_preserves.push(this.m_ispreserve);
            }
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.setDoctypeSystem(string3);
        this.setDoctypePublic(string2);
        this.m_elemContext.e = string;
        this.m_inDoctype = true;
    }

    public int getIndentAmount() {
        return this.m_indentAmount;
    }

    public void setIndentAmount(int n2) {
        this.m_indentAmount = n2;
    }

    public boolean shouldIndent() {
        return this.m_doIndent && !this.m_ispreserve && !this.m_isprevtext;
    }

    private void setCdataSectionElements(String string, Properties properties) {
        block6: {
            String string2 = properties.getProperty(string);
            if (null == string2) break block6;
            Vector vector = new Vector();
            int n2 = string2.length();
            boolean bl2 = false;
            FastStringBuffer fastStringBuffer = new FastStringBuffer();
            int n3 = 0;
            while (n3 < n2) {
                block9: {
                    char c2;
                    block8: {
                        block7: {
                            c2 = string2.charAt(n3);
                            if (!Character.isWhitespace(c2)) break block7;
                            if (bl2) break block8;
                            if (fastStringBuffer.length() > 0) {
                                this.addCdataSectionElement(fastStringBuffer.toString(), vector);
                                fastStringBuffer.reset();
                            }
                            break block9;
                        }
                        if ('{' == c2) {
                            bl2 = true;
                        } else if ('}' == c2) {
                            bl2 = false;
                        }
                    }
                    fastStringBuffer.append(c2);
                }
                ++n3;
            }
            if (fastStringBuffer.length() > 0) {
                this.addCdataSectionElement(fastStringBuffer.toString(), vector);
                fastStringBuffer.reset();
            }
            this.setCdataSectionElements(vector);
        }
    }

    private void addCdataSectionElement(String string, Vector vector) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{}", false);
        String string3 = stringTokenizer.nextToken();
        String string4 = string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
        if (null == string2) {
            vector.addElement(null);
            vector.addElement(string3);
        } else {
            vector.addElement(string3);
            vector.addElement(string2);
        }
    }

    public void setCdataSectionElements(Vector vector) {
        this.m_cdataSectionElements = vector;
    }

    public String ensureAttributesNamespaceIsDeclared(String string, String string2, String string3) throws SAXException {
        if (string != null && string.length() > 0) {
            String string4;
            int n2 = 0;
            n2 = string3.indexOf(":");
            String string5 = string4 = n2 < 0 ? "" : string3.substring(0, n2);
            if (n2 > 0) {
                String string6 = this.m_prefixMap.lookupNamespace(string4);
                if (string6 != null && string6.equals(string)) {
                    return null;
                }
                this.startPrefixMapping(string4, string, false);
                this.addAttribute("http://www.w3.org/2000/xmlns/", string4, "xmlns:" + string4, "CDATA", string);
                return string4;
            }
            String string7 = this.m_prefixMap.lookupPrefix(string);
            if (string7 == null) {
                string7 = this.m_prefixMap.generateNextPrefix();
                this.startPrefixMapping(string7, string, false);
                this.addAttribute("http://www.w3.org/2000/xmlns/", string7, "xmlns:" + string7, "CDATA", string);
            }
            return string7;
        }
        return null;
    }

    public void b(String string, String string2) throws SAXException {
        if (string != null && string.length() > 0) {
            String string3;
            String string4;
            int n2 = string2.indexOf(":");
            String string5 = string4 = n2 < 0 ? "" : string2.substring(0, n2);
            if (!(null == string4 || null != (string3 = this.m_prefixMap.lookupNamespace(string4)) && string3.equals(string))) {
                this.startPrefixMapping(string4, string);
                this.addAttributeAlways("http://www.w3.org/2000/xmlns/", string4, "xmlns" + (string4.length() == 0 ? "" : ":") + string4, "CDATA", string);
            }
        }
    }

    public void flushPending() throws SAXException {
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        }
        if (this.m_elemContext.d) {
            this.closeStartTag();
            this.m_elemContext.d = false;
        }
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
            this.m_cdataTagOpen = false;
        }
    }

    public void setContentHandler(ContentHandler contentHandler) {
    }

    public void addAttributeAlways(String string, String string2, String string3, String string4, String string5) {
        int n2 = this.m_attributes.getIndex(string3);
        if (n2 >= 0) {
            String string6 = null;
            if (this.m_tracer != null && string5.equals(string6 = this.m_attributes.getValue(n2))) {
                string6 = null;
            }
            this.m_attributes.setValue(n2, string5);
            if (string6 != null) {
                this.firePseudoAttributes();
            }
        } else {
            this.m_attributes.addAttribute(string, string2, string3, string4, string5);
            if (this.m_tracer != null) {
                this.firePseudoAttributes();
            }
        }
    }

    public void firePseudoAttributes() {
        if (this.m_tracer != null) {
            try {
                Object object;
                this.m_writer.flush();
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = this.m_attributes.getLength();
                if (n2 > 0) {
                    object = new WritertoStringBuffer(this, stringBuffer);
                    this.processAttributes((Writer)object, n2);
                }
                stringBuffer.append('>');
                object = stringBuffer.toString().toCharArray();
                this.m_tracer.fireGenerateEvent(11, (char[])object, 0, ((Object)object).length);
            }
            catch (IOException iOException) {
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    public void setTransformer(Transformer transformer) {
        super.setTransformer(transformer);
        if (this.m_tracer != null && !(this.m_writer instanceof SerializerTraceWriter)) {
            this.m_writer = new SerializerTraceWriter(this.m_writer, this.m_tracer);
        }
    }

    public boolean reset() {
        boolean bl2 = false;
        if (super.reset()) {
            this.resetToStream();
            bl2 = true;
        }
        return bl2;
    }

    private void resetToStream() {
        this.e = null;
        this.m_cdataStartCalled = false;
        this.g = null;
        this.m_disableOutputEscapingStates.clear();
        this.m_escaping = true;
        this.m_inDoctype = false;
        this.m_ispreserve = false;
        this.m_ispreserve = false;
        this.m_isprevtext = false;
        this.c = false;
        this.m_maxCharacter = Encodings.getLastPrintable();
        this.m_preserves.clear();
        this.d = true;
        this.m_spaceBeforeClose = false;
        this.f = false;
        this.b = false;
        this.m_lineSepUse = true;
    }

    private class WritertoStringBuffer
    extends Writer {
        private final StringBuffer m_stringbuf;
        private final ToStream this$0;

        public WritertoStringBuffer(ToStream toStream, StringBuffer stringBuffer) {
            this.this$0 = toStream;
            this.m_stringbuf = stringBuffer;
        }

        public void write(char[] cArray, int n2, int n3) throws IOException {
            this.m_stringbuf.append(cArray, n2, n3);
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        public void write(int n2) {
            this.m_stringbuf.append((char)n2);
        }

        public void write(String string) {
            this.m_stringbuf.append(string);
        }
    }
}

