/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import org.apache.xml.dtm.ref.dom2dtm.DOM2DTM;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.serializer.AttributesImplSerializer;
import org.apache.xml.serializer.DOMSerializer;
import org.apache.xml.serializer.ElemContext;
import org.apache.xml.serializer.NamespaceMappings;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xml.serializer.SerializerConstants;
import org.apache.xml.serializer.SerializerTrace;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class SerializerBase
implements SerializationHandler,
SerializerConstants,
DOM2DTM.CharacterNodeHandler {
    public boolean m_needToCallStartDocument = true;
    public boolean m_cdataTagOpen = false;
    public AttributesImplSerializer m_attributes = new AttributesImplSerializer();
    public boolean m_inEntityRef = false;
    public boolean m_inExternalDTD = false;
    private String m_doctypeSystem;
    private String m_doctypePublic;
    public boolean a = true;
    private String m_encoding = null;
    private boolean m_shouldNotWriteXMLHeader = false;
    private String m_standalone;
    public boolean m_standaloneWasSpecified = false;
    public boolean m_doIndent = false;
    public int m_indentAmount = 0;
    private String m_version = null;
    private String m_mediatype;
    private Transformer m_transformer;
    public Vector m_cdataSectionElements = null;
    public NamespaceMappings m_prefixMap;
    public SerializerTrace m_tracer;
    public SourceLocator m_sourceLocator;
    public Writer m_writer = null;
    public ElemContext m_elemContext = new ElemContext();
    public char[] m_charsBuff = new char[60];
    public char[] m_attrBuff = new char[30];

    public void fireEndElem(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(4, string, (Attributes)null);
        }
    }

    public void fireCharEvent(char[] cArray, int n2, int n3) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(5, cArray, n2, n3);
        }
    }

    public void comment(String string) throws SAXException {
        int n2 = string.length();
        if (n2 > this.m_charsBuff.length) {
            this.m_charsBuff = new char[n2 * 2 + 1];
        }
        string.getChars(0, n2, this.m_charsBuff, 0);
        this.comment(this.m_charsBuff, 0, n2);
    }

    public String patchName(String string) {
        int n2 = string.lastIndexOf(58);
        if (n2 > 0) {
            int n3 = string.indexOf(58);
            String string2 = string.substring(0, n3);
            String string3 = string.substring(n2 + 1);
            String string4 = this.m_prefixMap.lookupNamespace(string2);
            if (string4 != null && string4.length() == 0) {
                return string3;
            }
            if (n3 != n2) {
                return string2 + ':' + string3;
            }
        }
        return string;
    }

    public static String getLocalName(String string) {
        int n2 = string.lastIndexOf(58);
        return n2 > 0 ? string.substring(n2 + 1) : string;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (this.m_elemContext.d) {
            this.addAttributeAlways(string, string2, string3, string4, string5);
        }
    }

    public void addAttributeAlways(String string, String string2, String string3, String string4, String string5) {
        int n2 = this.m_attributes.getIndex(string3);
        if (n2 >= 0) {
            this.m_attributes.setValue(n2, string5);
        } else {
            this.m_attributes.addAttribute(string, string2, string3, string4, string5);
        }
    }

    public void addAttribute(String string, String string2) {
        if (this.m_elemContext.d) {
            String string3 = this.patchName(string);
            String string4 = SerializerBase.getLocalName(string3);
            String string5 = this.getNamespaceURI(string3, false);
            this.addAttributeAlways(string5, string4, string3, "CDATA", string2);
        }
    }

    public void addAttributes(Attributes attributes) throws SAXException {
        int n2 = attributes.getLength();
        int n3 = 0;
        while (n3 < n2) {
            String string = attributes.getURI(n3);
            if (null == string) {
                string = "";
            }
            this.addAttributeAlways(string, attributes.getLocalName(n3), attributes.getQName(n3), attributes.getType(n3), attributes.getValue(n3));
            ++n3;
        }
    }

    public ContentHandler asContentHandler() throws IOException {
        return this;
    }

    public void endEntity(String string) throws SAXException {
        if (string.equals("[dtd]")) {
            this.m_inExternalDTD = false;
        }
        this.m_inEntityRef = false;
        if (this.m_tracer != null) {
            this.fireEndEntity(string);
        }
    }

    public void close() {
    }

    public void initCDATA() {
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public void setEncoding(String string) {
        this.m_encoding = string;
    }

    public void setOmitXMLDeclaration(boolean bl2) {
        this.m_shouldNotWriteXMLHeader = bl2;
    }

    public boolean getOmitXMLDeclaration() {
        return this.m_shouldNotWriteXMLHeader;
    }

    public String getDoctypePublic() {
        return this.m_doctypePublic;
    }

    public void setDoctypePublic(String string) {
        this.m_doctypePublic = string;
    }

    public String getDoctypeSystem() {
        return this.m_doctypeSystem;
    }

    public void setDoctypeSystem(String string) {
        this.m_doctypeSystem = string;
    }

    public void setDoctype(String string, String string2) {
        this.m_doctypeSystem = string;
        this.m_doctypePublic = string2;
    }

    public void setStandalone(String string) {
        if (string != null) {
            this.m_standaloneWasSpecified = true;
            this.setStandaloneInternal(string);
        }
    }

    public void setStandaloneInternal(String string) {
        this.m_standalone = "yes".equals(string) ? "yes" : "no";
    }

    public String getStandalone() {
        return this.m_standalone;
    }

    public boolean getIndent() {
        return this.m_doIndent;
    }

    public String getMediaType() {
        return this.m_mediatype;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String string) {
        this.m_version = string;
    }

    public void setMediaType(String string) {
        this.m_mediatype = string;
    }

    public int getIndentAmount() {
        return this.m_indentAmount;
    }

    public void setIndentAmount(int n2) {
        this.m_indentAmount = n2;
    }

    public void setIndent(boolean bl2) {
        this.m_doIndent = bl2;
    }

    public void namespaceAfterStartElement(String string, String string2) throws SAXException {
    }

    public DOMSerializer asDOMSerializer() throws IOException {
        return this;
    }

    public boolean isCdataSection() {
        boolean bl2 = false;
        if (null != this.m_cdataSectionElements) {
            String string;
            if (this.m_elemContext.a == null) {
                this.m_elemContext.a = SerializerBase.getLocalName(this.m_elemContext.e);
            }
            if (this.m_elemContext.c == null && (string = SerializerBase.getPrefixPart(this.m_elemContext.e)) != null) {
                this.m_elemContext.c = this.m_prefixMap.lookupNamespace(string);
            }
            if (null != this.m_elemContext.c && this.m_elemContext.c.length() == 0) {
                this.m_elemContext.c = null;
            }
            int n2 = this.m_cdataSectionElements.size();
            int n3 = 0;
            while (n3 < n2) {
                String string2 = (String)this.m_cdataSectionElements.elementAt(n3);
                String string3 = (String)this.m_cdataSectionElements.elementAt(n3 + 1);
                if (string3.equals(this.m_elemContext.a) && SerializerBase.subPartMatch(this.m_elemContext.c, string2)) {
                    bl2 = true;
                    break;
                }
                n3 += 2;
            }
        }
        return bl2;
    }

    private static final boolean subPartMatch(String string, String string2) {
        return string == string2 || null != string && string.equals(string2);
    }

    public static final String getPrefixPart(String string) {
        int n2 = string.indexOf(58);
        return n2 > 0 ? string.substring(0, n2) : null;
    }

    public NamespaceMappings getNamespaceMappings() {
        return this.m_prefixMap;
    }

    public String getPrefix(String string) {
        String string2 = this.m_prefixMap.lookupPrefix(string);
        return string2;
    }

    public String getNamespaceURI(String string, boolean bl2) {
        String string2;
        String string3 = "";
        int n2 = string.lastIndexOf(58);
        String string4 = string2 = n2 > 0 ? string.substring(0, n2) : "";
        if (!("".equals(string2) && !bl2 || this.m_prefixMap == null || (string3 = this.m_prefixMap.lookupNamespace(string2)) != null || string2.equals("xmlns"))) {
            throw new RuntimeException(XMLMessages.createXMLMessage("ER_NAMESPACE_PREFIX", new Object[]{string.substring(0, n2)}));
        }
        return string3;
    }

    public String getNamespaceURIFromPrefix(String string) {
        String string2 = null;
        if (this.m_prefixMap != null) {
            string2 = this.m_prefixMap.lookupNamespace(string);
        }
        return string2;
    }

    public void entityReference(String string) throws SAXException {
        this.flushPending();
        this.startEntity(string);
        this.endEntity(string);
        if (this.m_tracer != null) {
            this.fireEntityReference(string);
        }
    }

    public void setTransformer(Transformer transformer) {
        this.m_transformer = transformer;
        this.m_tracer = this.m_transformer instanceof SerializerTrace && ((SerializerTrace)((Object)this.m_transformer)).hasTraceListeners() ? (SerializerTrace)((Object)this.m_transformer) : null;
    }

    public Transformer getTransformer() {
        return this.m_transformer;
    }

    public void characters(Node node) throws SAXException {
        this.flushPending();
        String string = node.getNodeValue();
        if (string != null) {
            int n2 = string.length();
            if (n2 > this.m_charsBuff.length) {
                this.m_charsBuff = new char[n2 * 2 + 1];
            }
            string.getChars(0, n2, this.m_charsBuff, 0);
            this.characters(this.m_charsBuff, 0, n2);
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.m_elemContext.d = false;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    public void fireStartEntity(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(9, string);
        }
    }

    private void flushMyWriter() {
        if (this.m_writer != null) {
            try {
                this.m_writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void fireCDATAEvent(char[] cArray, int n2, int n3) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(10, cArray, n2, n3);
        }
    }

    public void fireCommentEvent(char[] cArray, int n2, int n3) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(8, new String(cArray, n2, n3));
        }
    }

    public void fireEndEntity(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
        }
    }

    public void fireStartDoc() throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(1);
        }
    }

    public void fireEndDoc() throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(2);
        }
    }

    public void fireStartElem(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(3, string, this.m_attributes);
        }
    }

    public void fireEscapingEvent(String string, String string2) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(7, string, string2);
        }
    }

    public void fireEntityReference(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(9, string, (Attributes)null);
        }
    }

    public void startDocument() throws SAXException {
        this.startDocumentInternal();
        this.m_needToCallStartDocument = false;
    }

    public void startDocumentInternal() throws SAXException {
        if (this.m_tracer != null) {
            this.fireStartDoc();
        }
    }

    public void setSourceLocator(SourceLocator sourceLocator) {
        this.m_sourceLocator = sourceLocator;
    }

    public void setNamespaceMappings(NamespaceMappings namespaceMappings) {
        this.m_prefixMap = namespaceMappings;
    }

    public boolean reset() {
        this.resetSerializerBase();
        return true;
    }

    private void resetSerializerBase() {
        this.m_attributes.clear();
        this.m_cdataSectionElements = null;
        this.m_elemContext = new ElemContext();
        this.m_doctypePublic = null;
        this.m_doctypeSystem = null;
        this.m_doIndent = false;
        this.m_encoding = null;
        this.m_indentAmount = 0;
        this.m_inEntityRef = false;
        this.m_inExternalDTD = false;
        this.m_mediatype = null;
        this.m_needToCallStartDocument = true;
        this.a = false;
        if (this.m_prefixMap != null) {
            this.m_prefixMap.reset();
        }
        this.m_shouldNotWriteXMLHeader = false;
        this.m_sourceLocator = null;
        this.m_standalone = null;
        this.m_standaloneWasSpecified = false;
        this.m_tracer = null;
        this.m_transformer = null;
        this.m_version = null;
    }

    public abstract void flushPending() throws SAXException;

    public abstract boolean setEscaping(boolean var1) throws SAXException;

    public abstract void serialize(Node var1) throws IOException;

    public abstract void setContentHandler(ContentHandler var1);

    public abstract void addUniqueAttribute(String var1, String var2, int var3) throws SAXException;

    public abstract boolean startPrefixMapping(String var1, String var2, boolean var3) throws SAXException;

    public abstract void startElement(String var1) throws SAXException;

    public abstract void startElement(String var1, String var2, String var3) throws SAXException;

    public abstract void endElement(String var1) throws SAXException;

    public abstract void characters(String var1) throws SAXException;

    public abstract void skippedEntity(String var1) throws SAXException;

    public abstract void processingInstruction(String var1, String var2) throws SAXException;

    public abstract void ignorableWhitespace(char[] var1, int var2, int var3) throws SAXException;

    public abstract void characters(char[] var1, int var2, int var3) throws SAXException;

    public abstract void endElement(String var1, String var2, String var3) throws SAXException;

    public abstract void startElement(String var1, String var2, String var3, Attributes var4) throws SAXException;

    public abstract void endPrefixMapping(String var1) throws SAXException;

    public abstract void startPrefixMapping(String var1, String var2) throws SAXException;

    public abstract void endDocument() throws SAXException;

    public abstract void comment(char[] var1, int var2, int var3) throws SAXException;

    public abstract void endCDATA() throws SAXException;

    public abstract void startCDATA() throws SAXException;

    public abstract void startEntity(String var1) throws SAXException;

    public abstract void endDTD() throws SAXException;

    public abstract void startDTD(String var1, String var2, String var3) throws SAXException;

    public abstract void setCdataSectionElements(Vector var1);

    public abstract void externalEntityDecl(String var1, String var2, String var3) throws SAXException;

    public abstract void internalEntityDecl(String var1, String var2) throws SAXException;

    public abstract void attributeDecl(String var1, String var2, String var3, String var4, String var5) throws SAXException;

    public abstract void elementDecl(String var1, String var2) throws SAXException;

    public abstract Properties getOutputFormat();

    public abstract void setOutputFormat(Properties var1);

    public abstract Writer getWriter();

    public abstract void setWriter(Writer var1);

    public abstract OutputStream getOutputStream();

    public abstract void setOutputStream(OutputStream var1);
}

