/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.extensions;

import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.extensions.ExtensionHandler;
import org.apache.xalan.extensions.ExtensionNamespaceSupport;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xpath.XPathProcessorException;
import org.apache.xpath.functions.FuncExtFunction;

public class ExtensionsTable {
    public Hashtable m_extensionFunctionNamespaces = new Hashtable();
    private StylesheetRoot m_sroot;

    public ExtensionsTable(StylesheetRoot stylesheetRoot) throws TransformerException {
        this.m_sroot = stylesheetRoot;
        Vector vector = this.m_sroot.getExtensions();
        int n2 = 0;
        while (n2 < vector.size()) {
            ExtensionNamespaceSupport extensionNamespaceSupport = (ExtensionNamespaceSupport)vector.elementAt(n2);
            ExtensionHandler extensionHandler = extensionNamespaceSupport.launch();
            if (extensionHandler != null) {
                this.addExtensionNamespace(extensionNamespaceSupport.getNamespace(), extensionHandler);
            }
            ++n2;
        }
    }

    public ExtensionHandler get(String string) {
        return (ExtensionHandler)this.m_extensionFunctionNamespaces.get(string);
    }

    public void addExtensionNamespace(String string, ExtensionHandler extensionHandler) {
        this.m_extensionFunctionNamespaces.put(string, extensionHandler);
    }

    public boolean functionAvailable(String string, String string2) throws TransformerException {
        ExtensionHandler extensionHandler;
        boolean bl2 = false;
        if (null != string && (extensionHandler = (ExtensionHandler)this.m_extensionFunctionNamespaces.get(string)) != null) {
            bl2 = extensionHandler.isFunctionAvailable(string2);
        }
        return bl2;
    }

    public boolean elementAvailable(String string, String string2) throws TransformerException {
        ExtensionHandler extensionHandler;
        boolean bl2 = false;
        if (null != string && (extensionHandler = (ExtensionHandler)this.m_extensionFunctionNamespaces.get(string)) != null) {
            bl2 = extensionHandler.isElementAvailable(string2);
        }
        return bl2;
    }

    public Object extFunction(String string, String string2, Vector vector, Object object, ExpressionContext expressionContext) throws TransformerException {
        Object object2 = null;
        if (null != string) {
            ExtensionHandler extensionHandler = (ExtensionHandler)this.m_extensionFunctionNamespaces.get(string);
            if (null != extensionHandler) {
                try {
                    object2 = extensionHandler.callFunction(string2, vector, object, expressionContext);
                }
                catch (TransformerException transformerException) {
                    throw transformerException;
                }
                catch (Exception exception) {
                    throw new TransformerException(exception);
                }
            } else {
                throw new XPathProcessorException(XSLMessages.createMessage("ER_EXTENSION_FUNC_UNKNOWN", new Object[]{string, string2}));
            }
        }
        return object2;
    }

    public Object extFunction(FuncExtFunction funcExtFunction, Vector vector, ExpressionContext expressionContext) throws TransformerException {
        Object object = null;
        String string = funcExtFunction.getNamespace();
        if (null != string) {
            ExtensionHandler extensionHandler = (ExtensionHandler)this.m_extensionFunctionNamespaces.get(string);
            if (null != extensionHandler) {
                try {
                    object = extensionHandler.callFunction(funcExtFunction, vector, expressionContext);
                }
                catch (TransformerException transformerException) {
                    throw transformerException;
                }
                catch (Exception exception) {
                    throw new TransformerException(exception);
                }
            } else {
                throw new XPathProcessorException(XSLMessages.createMessage("ER_EXTENSION_FUNC_UNKNOWN", new Object[]{string, funcExtFunction.getFunctionName()}));
            }
        }
        return object;
    }
}

