/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public final class Log4JCategoryLog
implements Log {
    private static final String FQCN = (a == null ? (a = Log4JCategoryLog.a("org.apache.commons.logging.impl.Log4JCategoryLog")) : a).getName();
    private static boolean initialized = false;
    private static String LAYOUT = "%r [%t] %p %c{2} %x - %m%n";
    private Category category = null;
    public static Class a;

    public Log4JCategoryLog() {
        if (!initialized) {
            this.initialize();
        }
    }

    public Log4JCategoryLog(String string) {
        if (!initialized) {
            this.initialize();
        }
        this.category = Category.getInstance((String)string);
    }

    public Log4JCategoryLog(Category category) {
        if (!initialized) {
            this.initialize();
        }
        this.category = category;
    }

    private void initialize() {
        Category category = Category.getRoot();
        Enumeration enumeration = category.getAllAppenders();
        if (enumeration == null || !enumeration.hasMoreElements()) {
            ConsoleAppender consoleAppender = new ConsoleAppender((Layout)new PatternLayout(LAYOUT), "System.err");
            consoleAppender.setName("commons-logging");
            category.addAppender((Appender)consoleAppender);
            category.setPriority(Priority.INFO);
        }
        initialized = true;
    }

    public void trace(Object object) {
        this.category.log(FQCN, Priority.DEBUG, object, null);
    }

    public void trace(Object object, Throwable throwable) {
        this.category.log(FQCN, Priority.DEBUG, object, throwable);
    }

    public void debug(Object object) {
        this.category.log(FQCN, Priority.DEBUG, object, null);
    }

    public void debug(Object object, Throwable throwable) {
        this.category.log(FQCN, Priority.DEBUG, object, throwable);
    }

    public void info(Object object) {
        this.category.log(FQCN, Priority.INFO, object, null);
    }

    public void info(Object object, Throwable throwable) {
        this.category.log(FQCN, Priority.INFO, object, throwable);
    }

    public void warn(Object object) {
        this.category.log(FQCN, Priority.WARN, object, null);
    }

    public void warn(Object object, Throwable throwable) {
        this.category.log(FQCN, Priority.WARN, object, throwable);
    }

    public void error(Object object) {
        this.category.log(FQCN, Priority.ERROR, object, null);
    }

    public void error(Object object, Throwable throwable) {
        this.category.log(FQCN, Priority.ERROR, object, throwable);
    }

    public void fatal(Object object) {
        this.category.log(FQCN, Priority.FATAL, object, null);
    }

    public void fatal(Object object, Throwable throwable) {
        this.category.log(FQCN, Priority.FATAL, object, throwable);
    }

    public boolean isDebugEnabled() {
        return this.category.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.category.isEnabledFor(Priority.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.category.isEnabledFor(Priority.FATAL);
    }

    public boolean isInfoEnabled() {
        return this.category.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.category.isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return this.category.isEnabledFor(Priority.WARN);
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

