/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator
implements Iterator {
    private Object array;
    private int length = 0;
    private int index = 0;

    public ArrayIterator() {
    }

    public ArrayIterator(Object object) {
        this.setArray(object);
    }

    public ArrayIterator(Object object, int n2) {
        this.setArray(object);
        this.checkBound(n2, "start");
        this.index = n2;
    }

    public ArrayIterator(Object object, int n2, int n3) {
        this.setArray(object);
        this.checkBound(n2, "start");
        this.checkBound(n3, "end");
        if (n3 <= n2) {
            throw new IllegalArgumentException("End index must be greater than start index. ");
        }
        this.index = n2;
        this.length = n3;
    }

    private void checkBound(int n2, String string) {
        if (n2 > this.length) {
            throw new ArrayIndexOutOfBoundsException("Attempt to make an ArrayIterator that " + string + "s beyond the end of the array. ");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Attempt to make an ArrayIterator that " + string + "s before the start of the array. ");
        }
    }

    public Object getArray() {
        return this.array;
    }

    public boolean hasNext() {
        return this.index < this.length;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return Array.get(this.array, this.index++);
    }

    public void remove() {
        throw new UnsupportedOperationException("remove() method is not supported");
    }

    public void setArray(Object object) {
        this.length = Array.getLength(object);
        this.array = object;
        this.index = 0;
    }
}

