/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.comparators;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ComparatorChain
implements Comparator,
Serializable {
    public List comparatorChain = null;
    public BitSet orderingBits = null;
    public boolean isLocked = false;

    public ComparatorChain() {
        this(new ArrayList(), new BitSet());
    }

    public ComparatorChain(Comparator comparator) {
        this(comparator, false);
    }

    public ComparatorChain(Comparator comparator, boolean bl2) {
        this.comparatorChain = new ArrayList();
        this.comparatorChain.add(comparator);
        this.orderingBits = new BitSet(1);
        if (bl2) {
            this.orderingBits.set(0);
        }
    }

    public ComparatorChain(List list) {
        this(list, new BitSet(list.size()));
    }

    public ComparatorChain(List list, BitSet bitSet) {
        this.comparatorChain = list;
        this.orderingBits = bitSet;
    }

    public void addComparator(Comparator comparator) {
        this.addComparator(comparator, false);
    }

    public void addComparator(Comparator comparator, boolean bl2) {
        this.checkLocked();
        this.comparatorChain.add(comparator);
        if (bl2) {
            this.orderingBits.set(this.comparatorChain.size() - 1);
        }
    }

    private void checkChainIntegrity() {
        if (this.comparatorChain.size() == 0) {
            throw new UnsupportedOperationException("ComparatorChains must contain at least one Comparator");
        }
    }

    private void checkLocked() {
        if (this.isLocked) {
            throw new UnsupportedOperationException("Comparator ordering cannot be changed after the first comparison is performed");
        }
    }

    public int compare(Object object, Object object2) throws UnsupportedOperationException {
        if (!this.isLocked) {
            this.checkChainIntegrity();
            this.isLocked = true;
        }
        Iterator iterator = this.comparatorChain.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Comparator comparator = (Comparator)iterator.next();
            int n3 = comparator.compare(object, object2);
            if (n3 != 0) {
                if (this.orderingBits.get(n2)) {
                    n3 *= -1;
                }
                return n3;
            }
            ++n2;
        }
        return 0;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setComparator(int n2, Comparator comparator) throws IndexOutOfBoundsException {
        this.setComparator(n2, comparator, false);
    }

    public void setComparator(int n2, Comparator comparator, boolean bl2) {
        this.checkLocked();
        this.comparatorChain.set(n2, comparator);
        if (bl2) {
            this.orderingBits.set(n2);
        } else {
            this.orderingBits.clear(n2);
        }
    }

    public void setForwardSort(int n2) {
        this.checkLocked();
        this.orderingBits.clear(n2);
    }

    public void setReverseSort(int n2) {
        this.checkLocked();
        this.orderingBits.set(n2);
    }

    public int size() {
        return this.comparatorChain.size();
    }
}

