/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class FastTreeMap
extends TreeMap {
    public TreeMap map = null;
    public boolean fast = false;

    public FastTreeMap() {
        this.map = new TreeMap();
    }

    public FastTreeMap(Comparator comparator) {
        this.map = new TreeMap(comparator);
    }

    public FastTreeMap(Map map) {
        this.map = new TreeMap(map);
    }

    public FastTreeMap(SortedMap sortedMap) {
        this.map = new TreeMap(sortedMap);
    }

    public void clear() {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap treeMap = (TreeMap)this.map.clone();
                treeMap.clear();
                this.map = treeMap;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            this.map.clear();
        }
    }

    public Object clone() {
        FastTreeMap fastTreeMap = null;
        if (this.fast) {
            fastTreeMap = new FastTreeMap((SortedMap)this.map);
        } else {
            TreeMap treeMap = this.map;
            synchronized (treeMap) {
                fastTreeMap = new FastTreeMap((SortedMap)this.map);
            }
        }
        fastTreeMap.setFast(this.getFast());
        return fastTreeMap;
    }

    public Comparator comparator() {
        if (this.fast) {
            return this.map.comparator();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Comparator comparator = this.map.comparator();
            Object var3_3 = null;
            return comparator;
        }
    }

    public boolean containsKey(Object object) {
        if (this.fast) {
            return this.map.containsKey(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            boolean bl2 = this.map.containsKey(object);
            Object var4_4 = null;
            return bl2;
        }
    }

    public boolean containsValue(Object object) {
        if (this.fast) {
            return this.map.containsValue(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            boolean bl2 = this.map.containsValue(object);
            Object var4_4 = null;
            return bl2;
        }
    }

    public Set entrySet() {
        return new EntrySet(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.fast) {
            if (map.size() != this.map.size()) {
                return false;
            }
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k2 = entry.getKey();
                Object v2 = entry.getValue();
                if (v2 == null) {
                    if (map.get(k2) != null) return false;
                    if (map.containsKey(k2)) continue;
                    return false;
                }
                if (v2.equals(map.get(k2))) continue;
                return false;
            }
            return true;
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            if (map.size() != this.map.size()) {
                return false;
            }
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k3 = entry.getKey();
                Object v3 = entry.getValue();
                if (v3 == null) {
                    if (map.get(k3) != null) return false;
                    if (map.containsKey(k3)) continue;
                    return false;
                }
                if (v3.equals(map.get(k3))) continue;
                return false;
            }
            return true;
        }
    }

    public Object firstKey() {
        if (this.fast) {
            return this.map.firstKey();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object k2 = this.map.firstKey();
            Object var3_3 = null;
            return k2;
        }
    }

    public Object get(Object object) {
        if (this.fast) {
            return this.map.get(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object v2 = this.map.get(object);
            Object var4_4 = null;
            return v2;
        }
    }

    public boolean getFast() {
        return this.fast;
    }

    public int hashCode() {
        if (this.fast) {
            int n2 = 0;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                n2 += ((Object)iterator.next()).hashCode();
            }
            return n2;
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            int n3 = 0;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                n3 += ((Object)iterator.next()).hashCode();
            }
            int n4 = n3;
            Object var3_7 = null;
            return n4;
        }
    }

    public SortedMap headMap(Object object) {
        if (this.fast) {
            return this.map.headMap(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            SortedMap sortedMap = this.map.headMap(object);
            Object var4_4 = null;
            return sortedMap;
        }
    }

    public boolean isEmpty() {
        if (this.fast) {
            return this.map.isEmpty();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            boolean bl2 = this.map.isEmpty();
            Object var3_3 = null;
            return bl2;
        }
    }

    public Set keySet() {
        return new KeySet(this);
    }

    public Object lastKey() {
        if (this.fast) {
            return this.map.lastKey();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object k2 = this.map.lastKey();
            Object var3_3 = null;
            return k2;
        }
    }

    public Object put(Object object, Object object2) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap treeMap = (TreeMap)this.map.clone();
                Object object3 = treeMap.put(object, object2);
                this.map = treeMap;
                Object object4 = object3;
                Object var5_9 = null;
                return object4;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object object5 = this.map.put(object, object2);
            Object var5_10 = null;
            return object5;
        }
    }

    public void putAll(Map map) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap treeMap = (TreeMap)this.map.clone();
                treeMap.putAll(map);
                this.map = treeMap;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            this.map.putAll(map);
        }
    }

    public Object remove(Object object) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap treeMap = (TreeMap)this.map.clone();
                Object v2 = treeMap.remove(object);
                this.map = treeMap;
                Object v3 = v2;
                Object var4_8 = null;
                return v3;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object v4 = this.map.remove(object);
            Object var4_9 = null;
            return v4;
        }
    }

    public void setFast(boolean bl2) {
        this.fast = bl2;
    }

    public int size() {
        if (this.fast) {
            return this.map.size();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            int n2 = this.map.size();
            Object var3_3 = null;
            return n2;
        }
    }

    public SortedMap subMap(Object object, Object object2) {
        if (this.fast) {
            return this.map.subMap(object, object2);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            SortedMap sortedMap = this.map.subMap(object, object2);
            Object var5_5 = null;
            return sortedMap;
        }
    }

    public SortedMap tailMap(Object object) {
        if (this.fast) {
            return this.map.tailMap(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            SortedMap sortedMap = this.map.tailMap(object);
            Object var4_4 = null;
            return sortedMap;
        }
    }

    public Collection values() {
        return new Values(this);
    }

    private abstract class CollectionView
    implements Collection {
        private final FastTreeMap this$0;

        public CollectionView(FastTreeMap fastTreeMap) {
            this.this$0 = fastTreeMap;
        }

        public static FastTreeMap a(CollectionView collectionView) {
            return collectionView.this$0;
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            if (this.this$0.fast) {
                FastTreeMap fastTreeMap = this.this$0;
                synchronized (fastTreeMap) {
                    TreeMap treeMap = (TreeMap)this.this$0.map.clone();
                    this.get(treeMap).clear();
                    this.this$0.map = treeMap;
                }
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                this.get(this.this$0.map).clear();
            }
        }

        public boolean contains(Object object) {
            if (this.this$0.fast) {
                return this.get(this.this$0.map).contains(object);
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                boolean bl2 = this.get(this.this$0.map).contains(object);
                Object var4_4 = null;
                return bl2;
            }
        }

        public boolean containsAll(Collection collection) {
            if (this.this$0.fast) {
                return this.get(this.this$0.map).containsAll(collection);
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                boolean bl2 = this.get(this.this$0.map).containsAll(collection);
                Object var4_4 = null;
                return bl2;
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (this.this$0.fast) {
                return this.get(this.this$0.map).equals(object);
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                boolean bl2 = this.get(this.this$0.map).equals(object);
                Object var4_4 = null;
                return bl2;
            }
        }

        public abstract Collection get(Map var1);

        public int hashCode() {
            if (this.this$0.fast) {
                return this.get(this.this$0.map).hashCode();
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                int n2 = this.get(this.this$0.map).hashCode();
                Object var3_3 = null;
                return n2;
            }
        }

        public boolean isEmpty() {
            if (this.this$0.fast) {
                return this.get(this.this$0.map).isEmpty();
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                boolean bl2 = this.get(this.this$0.map).isEmpty();
                Object var3_3 = null;
                return bl2;
            }
        }

        public Iterator iterator() {
            return new CollectionViewIterator(this);
        }

        public abstract Object iteratorNext(Map.Entry var1);

        public boolean remove(Object object) {
            if (this.this$0.fast) {
                FastTreeMap fastTreeMap = this.this$0;
                synchronized (fastTreeMap) {
                    TreeMap treeMap = (TreeMap)this.this$0.map.clone();
                    boolean bl2 = this.get(treeMap).remove(object);
                    this.this$0.map = treeMap;
                    boolean bl3 = bl2;
                    Object var4_8 = null;
                    return bl3;
                }
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                boolean bl4 = this.get(this.this$0.map).remove(object);
                Object var4_9 = null;
                return bl4;
            }
        }

        public boolean removeAll(Collection collection) {
            if (this.this$0.fast) {
                FastTreeMap fastTreeMap = this.this$0;
                synchronized (fastTreeMap) {
                    TreeMap treeMap = (TreeMap)this.this$0.map.clone();
                    boolean bl2 = this.get(treeMap).removeAll(collection);
                    this.this$0.map = treeMap;
                    boolean bl3 = bl2;
                    Object var4_8 = null;
                    return bl3;
                }
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                boolean bl4 = this.get(this.this$0.map).removeAll(collection);
                Object var4_9 = null;
                return bl4;
            }
        }

        public boolean retainAll(Collection collection) {
            if (this.this$0.fast) {
                FastTreeMap fastTreeMap = this.this$0;
                synchronized (fastTreeMap) {
                    TreeMap treeMap = (TreeMap)this.this$0.map.clone();
                    boolean bl2 = this.get(treeMap).retainAll(collection);
                    this.this$0.map = treeMap;
                    boolean bl3 = bl2;
                    Object var4_8 = null;
                    return bl3;
                }
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                boolean bl4 = this.get(this.this$0.map).retainAll(collection);
                Object var4_9 = null;
                return bl4;
            }
        }

        public int size() {
            if (this.this$0.fast) {
                return this.get(this.this$0.map).size();
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                int n2 = this.get(this.this$0.map).size();
                Object var3_3 = null;
                return n2;
            }
        }

        public Object[] toArray() {
            if (this.this$0.fast) {
                return this.get(this.this$0.map).toArray();
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                Object[] objectArray = this.get(this.this$0.map).toArray();
                Object var3_3 = null;
                return objectArray;
            }
        }

        public Object[] toArray(Object[] objectArray) {
            if (this.this$0.fast) {
                return this.get(this.this$0.map).toArray(objectArray);
            }
            TreeMap treeMap = this.this$0.map;
            synchronized (treeMap) {
                Object[] objectArray2 = this.get(this.this$0.map).toArray(objectArray);
                Object var4_4 = null;
                return objectArray2;
            }
        }

        private class CollectionViewIterator
        implements Iterator {
            private final CollectionView this$1;
            private Map expected;
            private Map.Entry lastReturned;
            private Iterator iterator;

            public CollectionViewIterator(CollectionView collectionView) {
                this.this$1 = collectionView;
                this.lastReturned = null;
                this.expected = CollectionView.a((CollectionView)collectionView).map;
                this.iterator = this.expected.entrySet().iterator();
            }

            public boolean hasNext() {
                if (this.expected != CollectionView.a((CollectionView)this.this$1).map) {
                    throw new ConcurrentModificationException();
                }
                return this.iterator.hasNext();
            }

            public Object next() {
                if (this.expected != CollectionView.a((CollectionView)this.this$1).map) {
                    throw new ConcurrentModificationException();
                }
                this.lastReturned = (Map.Entry)this.iterator.next();
                return this.this$1.iteratorNext(this.lastReturned);
            }

            public void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (CollectionView.a((CollectionView)this.this$1).fast) {
                    FastTreeMap fastTreeMap = CollectionView.a(this.this$1);
                    synchronized (fastTreeMap) {
                        if (this.expected != CollectionView.a((CollectionView)this.this$1).map) {
                            throw new ConcurrentModificationException();
                        }
                        CollectionView.a(this.this$1).remove(this.lastReturned.getKey());
                        this.lastReturned = null;
                        this.expected = CollectionView.a((CollectionView)this.this$1).map;
                    }
                } else {
                    this.iterator.remove();
                    this.lastReturned = null;
                }
            }
        }
    }

    private class KeySet
    extends CollectionView
    implements Set {
        private final FastTreeMap this$0;

        public KeySet(FastTreeMap fastTreeMap) {
            super(fastTreeMap);
            this.this$0 = fastTreeMap;
        }

        public Collection get(Map map) {
            return map.keySet();
        }

        public Object iteratorNext(Map.Entry entry) {
            return entry.getKey();
        }
    }

    private class Values
    extends CollectionView {
        private final FastTreeMap this$0;

        public Values(FastTreeMap fastTreeMap) {
            super(fastTreeMap);
            this.this$0 = fastTreeMap;
        }

        public Collection get(Map map) {
            return map.values();
        }

        public Object iteratorNext(Map.Entry entry) {
            return entry.getValue();
        }
    }

    private class EntrySet
    extends CollectionView
    implements Set {
        private final FastTreeMap this$0;

        public EntrySet(FastTreeMap fastTreeMap) {
            super(fastTreeMap);
            this.this$0 = fastTreeMap;
        }

        public Collection get(Map map) {
            return map.entrySet();
        }

        public Object iteratorNext(Map.Entry entry) {
            return entry;
        }
    }
}

