/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class DoubleOrderedMap
extends AbstractMap {
    private Node[] rootNode = new Node[]{null, null};
    private int nodeCount = 0;
    private int modifications = 0;
    private Set[] setOfKeys = new Set[]{null, null};
    private Set[] setOfEntries = new Set[]{null, null};
    private Collection[] collectionOfValues = new Collection[]{null, null};
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int SUM_OF_INDICES = 1;
    private static final int FIRST_INDEX = 0;
    private static final int NUMBER_OF_INDICES = 2;
    private static final String[] dataName = new String[]{"key", "value"};

    public DoubleOrderedMap() {
    }

    public DoubleOrderedMap(Map map) throws ClassCastException, NullPointerException, IllegalArgumentException {
        this.putAll(map);
    }

    public static Node a(DoubleOrderedMap doubleOrderedMap, Comparable comparable, int n2) {
        return doubleOrderedMap.lookup(comparable, n2);
    }

    public static void a(DoubleOrderedMap doubleOrderedMap, Node node) {
        doubleOrderedMap.doRedBlackDelete(node);
    }

    public static int a(DoubleOrderedMap doubleOrderedMap) {
        return doubleOrderedMap.nodeCount;
    }

    public static int c(DoubleOrderedMap doubleOrderedMap) {
        return doubleOrderedMap.modifications;
    }

    public static Node[] b(DoubleOrderedMap doubleOrderedMap) {
        return doubleOrderedMap.rootNode;
    }

    public static Node a(Node node, int n2) {
        return DoubleOrderedMap.leastNode(node, n2);
    }

    public static Node a(DoubleOrderedMap doubleOrderedMap, Node node, int n2) {
        return doubleOrderedMap.nextGreater(node, n2);
    }

    private static void checkKey(Object object) {
        DoubleOrderedMap.checkNonNullComparable(object, 0);
    }

    private static void checkKeyAndValue(Object object, Object object2) {
        DoubleOrderedMap.checkKey(object);
        DoubleOrderedMap.checkValue(object2);
    }

    private static void checkNonNullComparable(Object object, int n2) {
        if (object == null) {
            throw new NullPointerException(String.valueOf(dataName[n2]) + " cannot be null");
        }
        if (!(object instanceof Comparable)) {
            throw new ClassCastException(String.valueOf(dataName[n2]) + " must be Comparable");
        }
    }

    private static void checkValue(Object object) {
        DoubleOrderedMap.checkNonNullComparable(object, 1);
    }

    public void clear() {
        this.modify();
        this.nodeCount = 0;
        this.rootNode[0] = null;
        this.rootNode[1] = null;
    }

    private static int compare(Comparable comparable, Comparable comparable2) {
        return comparable.compareTo(comparable2);
    }

    public boolean containsKey(Object object) throws ClassCastException, NullPointerException {
        DoubleOrderedMap.checkKey(object);
        return this.lookup((Comparable)object, 0) != null;
    }

    public boolean containsValue(Object object) {
        DoubleOrderedMap.checkValue(object);
        return this.lookup((Comparable)object, 1) != null;
    }

    private static void copyColor(Node node, Node node2, int n2) {
        if (node2 != null) {
            if (node == null) {
                Node.b(node2, n2);
            } else {
                Node.d(node2, node, n2);
            }
        }
    }

    private Object doGet(Comparable comparable, int n2) {
        DoubleOrderedMap.checkNonNullComparable(comparable, n2);
        Node node = this.lookup(comparable, n2);
        return node == null ? null : Node.g(node, this.oppositeIndex(n2));
    }

    private void doRedBlackDelete(Node node) {
        int n2 = 0;
        while (n2 < 2) {
            Node node2;
            if (Node.c(node, n2) != null && Node.e(node, n2) != null) {
                this.swapPosition(this.nextGreater(node, n2), node, n2);
            }
            Node node3 = node2 = Node.c(node, n2) != null ? Node.c(node, n2) : Node.e(node, n2);
            if (node2 != null) {
                Node.e(node2, Node.h(node, n2), n2);
                if (Node.h(node, n2) == null) {
                    this.rootNode[n2] = node2;
                } else if (node == Node.c(Node.h(node, n2), n2)) {
                    Node.b(Node.h(node, n2), node2, n2);
                } else {
                    Node.c(Node.h(node, n2), node2, n2);
                }
                Node.b(node, null, n2);
                Node.c(node, null, n2);
                Node.e(node, null, n2);
                if (DoubleOrderedMap.isBlack(node, n2)) {
                    this.doRedBlackDeleteFixup(node2, n2);
                }
            } else if (Node.h(node, n2) == null) {
                this.rootNode[n2] = null;
            } else {
                if (DoubleOrderedMap.isBlack(node, n2)) {
                    this.doRedBlackDeleteFixup(node, n2);
                }
                if (Node.h(node, n2) != null) {
                    if (node == Node.c(Node.h(node, n2), n2)) {
                        Node.b(Node.h(node, n2), null, n2);
                    } else {
                        Node.c(Node.h(node, n2), null, n2);
                    }
                    Node.e(node, null, n2);
                }
            }
            ++n2;
        }
        this.shrink();
    }

    private void doRedBlackDeleteFixup(Node node, int n2) {
        Node node2 = node;
        while (node2 != this.rootNode[n2] && DoubleOrderedMap.isBlack(node2, n2)) {
            Node node3;
            if (DoubleOrderedMap.isLeftChild(node2, n2)) {
                node3 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getParent(node2, n2), n2);
                if (DoubleOrderedMap.isRed(node3, n2)) {
                    DoubleOrderedMap.makeBlack(node3, n2);
                    DoubleOrderedMap.makeRed(DoubleOrderedMap.getParent(node2, n2), n2);
                    this.rotateLeft(DoubleOrderedMap.getParent(node2, n2), n2);
                    node3 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getParent(node2, n2), n2);
                }
                if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getLeftChild(node3, n2), n2) && DoubleOrderedMap.isBlack(DoubleOrderedMap.getRightChild(node3, n2), n2)) {
                    DoubleOrderedMap.makeRed(node3, n2);
                    node2 = DoubleOrderedMap.getParent(node2, n2);
                    continue;
                }
                if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getRightChild(node3, n2), n2)) {
                    DoubleOrderedMap.makeBlack(DoubleOrderedMap.getLeftChild(node3, n2), n2);
                    DoubleOrderedMap.makeRed(node3, n2);
                    this.rotateRight(node3, n2);
                    node3 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getParent(node2, n2), n2);
                }
                DoubleOrderedMap.copyColor(DoubleOrderedMap.getParent(node2, n2), node3, n2);
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n2), n2);
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getRightChild(node3, n2), n2);
                this.rotateLeft(DoubleOrderedMap.getParent(node2, n2), n2);
                node2 = this.rootNode[n2];
                continue;
            }
            node3 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getParent(node2, n2), n2);
            if (DoubleOrderedMap.isRed(node3, n2)) {
                DoubleOrderedMap.makeBlack(node3, n2);
                DoubleOrderedMap.makeRed(DoubleOrderedMap.getParent(node2, n2), n2);
                this.rotateRight(DoubleOrderedMap.getParent(node2, n2), n2);
                node3 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getParent(node2, n2), n2);
            }
            if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getRightChild(node3, n2), n2) && DoubleOrderedMap.isBlack(DoubleOrderedMap.getLeftChild(node3, n2), n2)) {
                DoubleOrderedMap.makeRed(node3, n2);
                node2 = DoubleOrderedMap.getParent(node2, n2);
                continue;
            }
            if (DoubleOrderedMap.isBlack(DoubleOrderedMap.getLeftChild(node3, n2), n2)) {
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getRightChild(node3, n2), n2);
                DoubleOrderedMap.makeRed(node3, n2);
                this.rotateLeft(node3, n2);
                node3 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getParent(node2, n2), n2);
            }
            DoubleOrderedMap.copyColor(DoubleOrderedMap.getParent(node2, n2), node3, n2);
            DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n2), n2);
            DoubleOrderedMap.makeBlack(DoubleOrderedMap.getLeftChild(node3, n2), n2);
            this.rotateRight(DoubleOrderedMap.getParent(node2, n2), n2);
            node2 = this.rootNode[n2];
        }
        DoubleOrderedMap.makeBlack(node2, n2);
    }

    private void doRedBlackInsert(Node node, int n2) {
        Node node2 = node;
        DoubleOrderedMap.makeRed(node2, n2);
        while (node2 != null && node2 != this.rootNode[n2] && DoubleOrderedMap.isRed(Node.h(node2, n2), n2)) {
            Node node3;
            if (DoubleOrderedMap.isLeftChild(DoubleOrderedMap.getParent(node2, n2), n2)) {
                node3 = DoubleOrderedMap.getRightChild(DoubleOrderedMap.getGrandParent(node2, n2), n2);
                if (DoubleOrderedMap.isRed(node3, n2)) {
                    DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n2), n2);
                    DoubleOrderedMap.makeBlack(node3, n2);
                    DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node2, n2), n2);
                    node2 = DoubleOrderedMap.getGrandParent(node2, n2);
                    continue;
                }
                if (DoubleOrderedMap.isRightChild(node2, n2)) {
                    node2 = DoubleOrderedMap.getParent(node2, n2);
                    this.rotateLeft(node2, n2);
                }
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n2), n2);
                DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node2, n2), n2);
                if (DoubleOrderedMap.getGrandParent(node2, n2) == null) continue;
                this.rotateRight(DoubleOrderedMap.getGrandParent(node2, n2), n2);
                continue;
            }
            node3 = DoubleOrderedMap.getLeftChild(DoubleOrderedMap.getGrandParent(node2, n2), n2);
            if (DoubleOrderedMap.isRed(node3, n2)) {
                DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n2), n2);
                DoubleOrderedMap.makeBlack(node3, n2);
                DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node2, n2), n2);
                node2 = DoubleOrderedMap.getGrandParent(node2, n2);
                continue;
            }
            if (DoubleOrderedMap.isLeftChild(node2, n2)) {
                node2 = DoubleOrderedMap.getParent(node2, n2);
                this.rotateRight(node2, n2);
            }
            DoubleOrderedMap.makeBlack(DoubleOrderedMap.getParent(node2, n2), n2);
            DoubleOrderedMap.makeRed(DoubleOrderedMap.getGrandParent(node2, n2), n2);
            if (DoubleOrderedMap.getGrandParent(node2, n2) == null) continue;
            this.rotateLeft(DoubleOrderedMap.getGrandParent(node2, n2), n2);
        }
        DoubleOrderedMap.makeBlack(this.rootNode[n2], n2);
    }

    private Object doRemove(Comparable comparable, int n2) {
        Node node = this.lookup(comparable, n2);
        Comparable comparable2 = null;
        if (node != null) {
            comparable2 = Node.g(node, this.oppositeIndex(n2));
            this.doRedBlackDelete(node);
        }
        return comparable2;
    }

    public Set entrySet() {
        if (this.setOfEntries[0] == null) {
            this.setOfEntries[0] = new AbstractSet(this){
                private final DoubleOrderedMap this$0;
                {
                    this.this$0 = doubleOrderedMap;
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object v2 = entry.getValue();
                    Node node = DoubleOrderedMap.a(this.this$0, (Comparable)entry.getKey(), 0);
                    return node != null && Node.g(node, 1).equals(v2);
                }

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this.this$0, 0){

                        public Object doGetNext() {
                            return this.lastReturnedNode;
                        }
                    };
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object v2 = entry.getValue();
                    Node node = DoubleOrderedMap.a(this.this$0, (Comparable)entry.getKey(), 0);
                    if (node != null && Node.g(node, 1).equals(v2)) {
                        DoubleOrderedMap.a(this.this$0, node);
                        return true;
                    }
                    return false;
                }

                public int size() {
                    return this.this$0.size();
                }
            };
        }
        return this.setOfEntries[0];
    }

    public Set entrySetByValue() {
        if (this.setOfEntries[1] == null) {
            this.setOfEntries[1] = new AbstractSet(this){
                private final DoubleOrderedMap this$0;
                {
                    this.this$0 = doubleOrderedMap;
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k2 = entry.getKey();
                    Node node = DoubleOrderedMap.a(this.this$0, (Comparable)entry.getValue(), 1);
                    return node != null && Node.g(node, 0).equals(k2);
                }

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this.this$0, 1){

                        public Object doGetNext() {
                            return this.lastReturnedNode;
                        }
                    };
                }

                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k2 = entry.getKey();
                    Node node = DoubleOrderedMap.a(this.this$0, (Comparable)entry.getValue(), 1);
                    if (node != null && Node.g(node, 0).equals(k2)) {
                        DoubleOrderedMap.a(this.this$0, node);
                        return true;
                    }
                    return false;
                }

                public int size() {
                    return this.this$0.size();
                }
            };
        }
        return this.setOfEntries[1];
    }

    public Object get(Object object) throws ClassCastException, NullPointerException {
        return this.doGet((Comparable)object, 0);
    }

    private static Node getGrandParent(Node node, int n2) {
        return DoubleOrderedMap.getParent(DoubleOrderedMap.getParent(node, n2), n2);
    }

    public Object getKeyForValue(Object object) throws ClassCastException, NullPointerException {
        return this.doGet((Comparable)object, 1);
    }

    private static Node getLeftChild(Node node, int n2) {
        return node == null ? null : Node.c(node, n2);
    }

    private static Node getParent(Node node, int n2) {
        return node == null ? null : Node.h(node, n2);
    }

    private static Node getRightChild(Node node, int n2) {
        return node == null ? null : Node.e(node, n2);
    }

    private void grow() {
        this.modify();
        ++this.nodeCount;
    }

    private void insertValue(Node node) throws IllegalArgumentException {
        block4: {
            Node node2 = this.rootNode[1];
            while (true) {
                int n2;
                if ((n2 = DoubleOrderedMap.compare(Node.g(node, 1), Node.g(node2, 1))) == 0) {
                    throw new IllegalArgumentException("Cannot store a duplicate value (\"" + Node.g(node, 1) + "\") in this Map");
                }
                if (n2 < 0) {
                    if (Node.c(node2, 1) != null) {
                        node2 = Node.c(node2, 1);
                        continue;
                    }
                    Node.b(node2, node, 1);
                    Node.e(node, node2, 1);
                    this.doRedBlackInsert(node, 1);
                    break block4;
                }
                if (Node.e(node2, 1) == null) break;
                node2 = Node.e(node2, 1);
            }
            Node.c(node2, node, 1);
            Node.e(node, node2, 1);
            this.doRedBlackInsert(node, 1);
        }
    }

    private static boolean isBlack(Node node, int n2) {
        return node == null ? true : Node.f(node, n2);
    }

    private static boolean isLeftChild(Node node, int n2) {
        return node == null ? true : (Node.h(node, n2) == null ? false : node == Node.c(Node.h(node, n2), n2));
    }

    private static boolean isRed(Node node, int n2) {
        return node == null ? false : Node.d(node, n2);
    }

    private static boolean isRightChild(Node node, int n2) {
        return node == null ? true : (Node.h(node, n2) == null ? false : node == Node.e(Node.h(node, n2), n2));
    }

    public Set keySet() {
        if (this.setOfKeys[0] == null) {
            this.setOfKeys[0] = new AbstractSet(this){
                private final DoubleOrderedMap this$0;
                {
                    this.this$0 = doubleOrderedMap;
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object object) {
                    return this.this$0.containsKey(object);
                }

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this.this$0, 0){

                        public Object doGetNext() {
                            return Node.g(this.lastReturnedNode, 0);
                        }
                    };
                }

                public boolean remove(Object object) {
                    int n2 = DoubleOrderedMap.a(this.this$0);
                    this.this$0.remove(object);
                    return DoubleOrderedMap.a(this.this$0) != n2;
                }

                public int size() {
                    return this.this$0.size();
                }
            };
        }
        return this.setOfKeys[0];
    }

    public Set keySetByValue() {
        if (this.setOfKeys[1] == null) {
            this.setOfKeys[1] = new AbstractSet(this){
                private final DoubleOrderedMap this$0;
                {
                    this.this$0 = doubleOrderedMap;
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object object) {
                    return this.this$0.containsKey(object);
                }

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this.this$0, 1){

                        public Object doGetNext() {
                            return Node.g(this.lastReturnedNode, 0);
                        }
                    };
                }

                public boolean remove(Object object) {
                    int n2 = DoubleOrderedMap.a(this.this$0);
                    this.this$0.remove(object);
                    return DoubleOrderedMap.a(this.this$0) != n2;
                }

                public int size() {
                    return this.this$0.size();
                }
            };
        }
        return this.setOfKeys[1];
    }

    private static Node leastNode(Node node, int n2) {
        Node node2 = node;
        if (node2 != null) {
            while (Node.c(node2, n2) != null) {
                node2 = Node.c(node2, n2);
            }
        }
        return node2;
    }

    private Node lookup(Comparable comparable, int n2) {
        Node node = null;
        Node node2 = this.rootNode[n2];
        while (node2 != null) {
            int n3 = DoubleOrderedMap.compare(comparable, Node.g(node2, n2));
            if (n3 == 0) {
                node = node2;
                break;
            }
            Node node3 = node2 = n3 < 0 ? Node.c(node2, n2) : Node.e(node2, n2);
        }
        return node;
    }

    private static void makeBlack(Node node, int n2) {
        if (node != null) {
            Node.b(node, n2);
        }
    }

    private static void makeRed(Node node, int n2) {
        if (node != null) {
            Node.a(node, n2);
        }
    }

    private void modify() {
        ++this.modifications;
    }

    private Node nextGreater(Node node, int n2) {
        Node node2 = null;
        if (node == null) {
            node2 = null;
        } else if (Node.e(node, n2) != null) {
            node2 = DoubleOrderedMap.leastNode(Node.e(node, n2), n2);
        } else {
            Node node3 = Node.h(node, n2);
            Node node4 = node;
            while (node3 != null && node4 == Node.e(node3, n2)) {
                node4 = node3;
                node3 = Node.h(node3, n2);
            }
            node2 = node3;
        }
        return node2;
    }

    private int oppositeIndex(int n2) {
        return 1 - n2;
    }

    public Object put(Object object, Object object2) throws ClassCastException, NullPointerException, IllegalArgumentException {
        block6: {
            DoubleOrderedMap.checkKeyAndValue(object, object2);
            Node node = this.rootNode[0];
            if (node == null) {
                Node node2;
                this.rootNode[0] = node2 = new Node((Comparable)object, (Comparable)object2);
                this.rootNode[1] = node2;
                this.grow();
            } else {
                while (true) {
                    int n2;
                    if ((n2 = DoubleOrderedMap.compare((Comparable)object, Node.g(node, 0))) == 0) {
                        throw new IllegalArgumentException("Cannot store a duplicate key (\"" + object + "\") in this Map");
                    }
                    if (n2 < 0) {
                        if (Node.c(node, 0) != null) {
                            node = Node.c(node, 0);
                            continue;
                        }
                        Node node3 = new Node((Comparable)object, (Comparable)object2);
                        this.insertValue(node3);
                        Node.b(node, node3, 0);
                        Node.e(node3, node, 0);
                        this.doRedBlackInsert(node3, 0);
                        this.grow();
                        break block6;
                    }
                    if (Node.e(node, 0) == null) break;
                    node = Node.e(node, 0);
                }
                Node node4 = new Node((Comparable)object, (Comparable)object2);
                this.insertValue(node4);
                Node.c(node, node4, 0);
                Node.e(node4, node, 0);
                this.doRedBlackInsert(node4, 0);
                this.grow();
            }
        }
        return null;
    }

    public Object remove(Object object) {
        return this.doRemove((Comparable)object, 0);
    }

    public Object removeValue(Object object) {
        return this.doRemove((Comparable)object, 1);
    }

    private void rotateLeft(Node node, int n2) {
        Node node2 = Node.e(node, n2);
        Node.c(node, Node.c(node2, n2), n2);
        if (Node.c(node2, n2) != null) {
            Node.e(Node.c(node2, n2), node, n2);
        }
        Node.e(node2, Node.h(node, n2), n2);
        if (Node.h(node, n2) == null) {
            this.rootNode[n2] = node2;
        } else if (Node.c(Node.h(node, n2), n2) == node) {
            Node.b(Node.h(node, n2), node2, n2);
        } else {
            Node.c(Node.h(node, n2), node2, n2);
        }
        Node.b(node2, node, n2);
        Node.e(node, node2, n2);
    }

    private void rotateRight(Node node, int n2) {
        Node node2 = Node.c(node, n2);
        Node.b(node, Node.e(node2, n2), n2);
        if (Node.e(node2, n2) != null) {
            Node.e(Node.e(node2, n2), node, n2);
        }
        Node.e(node2, Node.h(node, n2), n2);
        if (Node.h(node, n2) == null) {
            this.rootNode[n2] = node2;
        } else if (Node.e(Node.h(node, n2), n2) == node) {
            Node.c(Node.h(node, n2), node2, n2);
        } else {
            Node.b(Node.h(node, n2), node2, n2);
        }
        Node.c(node2, node, n2);
        Node.e(node, node2, n2);
    }

    private void shrink() {
        this.modify();
        --this.nodeCount;
    }

    public int size() {
        return this.nodeCount;
    }

    private void swapPosition(Node node, Node node2, int n2) {
        boolean bl2;
        Node node3 = Node.h(node, n2);
        Node node4 = Node.c(node, n2);
        Node node5 = Node.e(node, n2);
        Node node6 = Node.h(node2, n2);
        Node node7 = Node.c(node2, n2);
        Node node8 = Node.e(node2, n2);
        boolean bl3 = Node.h(node, n2) != null && node == Node.c(Node.h(node, n2), n2);
        boolean bl4 = bl2 = Node.h(node2, n2) != null && node2 == Node.c(Node.h(node2, n2), n2);
        if (node == node6) {
            Node.e(node, node2, n2);
            if (bl2) {
                Node.b(node2, node, n2);
                Node.c(node2, node5, n2);
            } else {
                Node.c(node2, node, n2);
                Node.b(node2, node4, n2);
            }
        } else {
            Node.e(node, node6, n2);
            if (node6 != null) {
                if (bl2) {
                    Node.b(node6, node, n2);
                } else {
                    Node.c(node6, node, n2);
                }
            }
            Node.b(node2, node4, n2);
            Node.c(node2, node5, n2);
        }
        if (node2 == node3) {
            Node.e(node2, node, n2);
            if (bl3) {
                Node.b(node, node2, n2);
                Node.c(node, node8, n2);
            } else {
                Node.c(node, node2, n2);
                Node.b(node, node7, n2);
            }
        } else {
            Node.e(node2, node3, n2);
            if (node3 != null) {
                if (bl3) {
                    Node.b(node3, node2, n2);
                } else {
                    Node.c(node3, node2, n2);
                }
            }
            Node.b(node, node7, n2);
            Node.c(node, node8, n2);
        }
        if (Node.c(node, n2) != null) {
            Node.e(Node.c(node, n2), node, n2);
        }
        if (Node.e(node, n2) != null) {
            Node.e(Node.e(node, n2), node, n2);
        }
        if (Node.c(node2, n2) != null) {
            Node.e(Node.c(node2, n2), node2, n2);
        }
        if (Node.e(node2, n2) != null) {
            Node.e(Node.e(node2, n2), node2, n2);
        }
        Node.a(node, node2, n2);
        if (this.rootNode[n2] == node) {
            this.rootNode[n2] = node2;
        } else if (this.rootNode[n2] == node2) {
            this.rootNode[n2] = node;
        }
    }

    public Collection values() {
        if (this.collectionOfValues[0] == null) {
            this.collectionOfValues[0] = new AbstractCollection(this){
                private final DoubleOrderedMap this$0;
                {
                    this.this$0 = doubleOrderedMap;
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object object) {
                    return this.this$0.containsValue(object);
                }

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this.this$0, 0){

                        public Object doGetNext() {
                            return Node.g(this.lastReturnedNode, 1);
                        }
                    };
                }

                public boolean remove(Object object) {
                    int n2 = DoubleOrderedMap.a(this.this$0);
                    this.this$0.removeValue(object);
                    return DoubleOrderedMap.a(this.this$0) != n2;
                }

                public boolean removeAll(Collection collection) {
                    boolean bl2 = false;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        if (this.this$0.removeValue(iterator.next()) == null) continue;
                        bl2 = true;
                    }
                    return bl2;
                }

                public int size() {
                    return this.this$0.size();
                }
            };
        }
        return this.collectionOfValues[0];
    }

    public Collection valuesByValue() {
        if (this.collectionOfValues[1] == null) {
            this.collectionOfValues[1] = new AbstractCollection(this){
                private final DoubleOrderedMap this$0;
                {
                    this.this$0 = doubleOrderedMap;
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object object) {
                    return this.this$0.containsValue(object);
                }

                public Iterator iterator() {
                    return new DoubleOrderedMapIterator(this.this$0, 1){

                        public Object doGetNext() {
                            return Node.g(this.lastReturnedNode, 1);
                        }
                    };
                }

                public boolean remove(Object object) {
                    int n2 = DoubleOrderedMap.a(this.this$0);
                    this.this$0.removeValue(object);
                    return DoubleOrderedMap.a(this.this$0) != n2;
                }

                public boolean removeAll(Collection collection) {
                    boolean bl2 = false;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        if (this.this$0.removeValue(iterator.next()) == null) continue;
                        bl2 = true;
                    }
                    return bl2;
                }

                public int size() {
                    return this.this$0.size();
                }
            };
        }
        return this.collectionOfValues[1];
    }

    private abstract class DoubleOrderedMapIterator
    implements Iterator {
        private final DoubleOrderedMap this$0;
        private int expectedModifications;
        public Node lastReturnedNode;
        private Node nextNode;
        private int iteratorType;

        public DoubleOrderedMapIterator(DoubleOrderedMap doubleOrderedMap, int n2) {
            this.this$0 = doubleOrderedMap;
            this.iteratorType = n2;
            this.expectedModifications = DoubleOrderedMap.c(doubleOrderedMap);
            this.lastReturnedNode = null;
            this.nextNode = DoubleOrderedMap.a(DoubleOrderedMap.b(doubleOrderedMap)[this.iteratorType], this.iteratorType);
        }

        public abstract Object doGetNext();

        public final boolean hasNext() {
            return this.nextNode != null;
        }

        public final Object next() throws NoSuchElementException, ConcurrentModificationException {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            if (DoubleOrderedMap.c(this.this$0) != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            this.lastReturnedNode = this.nextNode;
            this.nextNode = DoubleOrderedMap.a(this.this$0, this.nextNode, this.iteratorType);
            return this.doGetNext();
        }

        public final void remove() throws IllegalStateException, ConcurrentModificationException {
            if (this.lastReturnedNode == null) {
                throw new IllegalStateException();
            }
            if (DoubleOrderedMap.c(this.this$0) != this.expectedModifications) {
                throw new ConcurrentModificationException();
            }
            DoubleOrderedMap.a(this.this$0, this.lastReturnedNode);
            ++this.expectedModifications;
            this.lastReturnedNode = null;
        }
    }

    private static final class Node
    implements Map.Entry {
        private Comparable[] data;
        private Node[] leftNode;
        private Node[] rightNode;
        private Node[] parentNode;
        private boolean[] blackColor;
        private int hashcodeValue;
        private boolean calculatedHashCode;

        public Node(Comparable comparable, Comparable comparable2) {
            this.data = new Comparable[]{comparable, comparable2};
            this.leftNode = new Node[]{null, null};
            this.rightNode = new Node[]{null, null};
            this.parentNode = new Node[]{null, null};
            this.blackColor = new boolean[]{true, true};
            this.calculatedHashCode = false;
        }

        public static Comparable g(Node node, int n2) {
            return node.getData(n2);
        }

        public static Node c(Node node, int n2) {
            return node.getLeft(n2);
        }

        public static void e(Node node, Node node2, int n2) {
            node.setParent(node2, n2);
        }

        public static void b(Node node, Node node2, int n2) {
            node.setLeft(node2, n2);
        }

        public static void a(Node node, Node node2, int n2) {
            node.swapColors(node2, n2);
        }

        public static Node e(Node node, int n2) {
            return node.getRight(n2);
        }

        public static Node h(Node node, int n2) {
            return node.getParent(n2);
        }

        public static void b(Node node, int n2) {
            node.setBlack(n2);
        }

        public static void d(Node node, Node node2, int n2) {
            node.copyColor(node2, n2);
        }

        public static boolean d(Node node, int n2) {
            return node.isRed(n2);
        }

        public static boolean f(Node node, int n2) {
            return node.isBlack(n2);
        }

        public static void a(Node node, int n2) {
            node.setRed(n2);
        }

        public static void c(Node node, Node node2, int n2) {
            node.setRight(node2, n2);
        }

        private void copyColor(Node node, int n2) {
            this.blackColor[n2] = node.blackColor[n2];
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.data[0].equals(entry.getKey()) && this.data[1].equals(entry.getValue());
        }

        private Comparable getData(int n2) {
            return this.data[n2];
        }

        public Object getKey() {
            return this.data[0];
        }

        private Node getLeft(int n2) {
            return this.leftNode[n2];
        }

        private Node getParent(int n2) {
            return this.parentNode[n2];
        }

        private Node getRight(int n2) {
            return this.rightNode[n2];
        }

        public Object getValue() {
            return this.data[1];
        }

        public int hashCode() {
            if (!this.calculatedHashCode) {
                this.hashcodeValue = this.data[0].hashCode() ^ this.data[1].hashCode();
                this.calculatedHashCode = true;
            }
            return this.hashcodeValue;
        }

        private boolean isBlack(int n2) {
            return this.blackColor[n2];
        }

        private boolean isRed(int n2) {
            return this.blackColor[n2] ^ true;
        }

        private void setBlack(int n2) {
            this.blackColor[n2] = true;
        }

        private void setLeft(Node node, int n2) {
            this.leftNode[n2] = node;
        }

        private void setParent(Node node, int n2) {
            this.parentNode[n2] = node;
        }

        private void setRed(int n2) {
            this.blackColor[n2] = false;
        }

        private void setRight(Node node, int n2) {
            this.rightNode[n2] = node;
        }

        public Object setValue(Object object) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Map.Entry.setValue is not supported");
        }

        private void swapColors(Node node, int n2) {
            int n3 = n2;
            this.blackColor[n3] = this.blackColor[n3] ^ node.blackColor[n2];
            int n4 = n2;
            node.blackColor[n4] = node.blackColor[n4] ^ this.blackColor[n2];
            int n5 = n2;
            this.blackColor[n5] = this.blackColor[n5] ^ node.blackColor[n2];
        }
    }
}

