/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.HashBag;
import org.apache.commons.collections.MapUtils;

public abstract class DefaultMapBag
implements Bag {
    private Map _map = null;
    private int _total = 0;
    private int _mods = 0;

    public static int a(DefaultMapBag defaultMapBag) {
        return defaultMapBag.modCount();
    }

    public boolean add(Object object) {
        return this.add(object, 1);
    }

    public boolean add(Object object, int n2) {
        ++this._mods;
        if (n2 > 0) {
            int n3 = n2 + this.getCount(object);
            this._map.put(object, new Integer(n3));
            this._total += n2;
            return n3 == n2;
        }
        return false;
    }

    public boolean addAll(Collection collection) {
        boolean bl2 = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            boolean bl3 = this.add(iterator.next());
            boolean bl4 = bl2 = bl2 || bl3;
        }
        return bl2;
    }

    public int calcTotalSize() {
        this._total = this.extractList().size();
        return this._total;
    }

    public void clear() {
        ++this._mods;
        this._map.clear();
        this._total = 0;
    }

    public boolean contains(Object object) {
        return this._map.containsKey(object);
    }

    public boolean containsAll(Collection collection) {
        return this.containsAll(new HashBag(collection));
    }

    public boolean containsAll(Bag bag) {
        boolean bl2 = true;
        Iterator iterator = bag.uniqueSet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            boolean bl3 = this.getCount(e2) >= bag.getCount(e2);
            boolean bl4 = bl2 = bl2 && bl3;
        }
        return bl2;
    }

    public boolean equals(Object object) {
        return object == this || object != null && object.getClass().equals(this.getClass()) && ((DefaultMapBag)object)._map.equals(this._map);
    }

    private List extractList() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.uniqueSet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            int n2 = this.getCount(e2);
            while (n2 > 0) {
                arrayList.add(e2);
                --n2;
            }
        }
        return arrayList;
    }

    public int getCount(Object object) {
        int n2 = 0;
        Integer n3 = MapUtils.getInteger(this._map, object);
        if (n3 != null) {
            n2 = n3;
        }
        return n2;
    }

    public Map getMap() {
        return this._map;
    }

    public int hashCode() {
        return this._map.hashCode();
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public Iterator iterator() {
        return new BagIterator(this, this, this.extractList().iterator());
    }

    private int modCount() {
        return this._mods;
    }

    public boolean remove(Object object) {
        return this.remove(object, this.getCount(object));
    }

    public boolean remove(Object object, int n2) {
        ++this._mods;
        boolean bl2 = false;
        int n3 = this.getCount(object);
        if (n2 <= 0) {
            bl2 = false;
        } else if (n3 > n2) {
            this._map.put(object, new Integer(n3 - n2));
            bl2 = true;
            this._total -= n2;
        } else {
            bl2 = this._map.remove(object) != null;
            this._total -= n3;
        }
        return bl2;
    }

    public boolean removeAll(Collection collection) {
        boolean bl2 = false;
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                boolean bl3 = this.remove(iterator.next(), 1);
                boolean bl4 = bl2 = bl2 || bl3;
            }
        }
        return bl2;
    }

    public boolean retainAll(Collection collection) {
        return this.retainAll(new HashBag(collection));
    }

    public boolean retainAll(Bag bag) {
        boolean bl2 = false;
        HashBag hashBag = new HashBag();
        Iterator iterator = this.uniqueSet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            int n2 = this.getCount(e2);
            int n3 = bag.getCount(e2);
            if (n3 >= 1 && n3 <= n2) {
                hashBag.add(e2, n2 - n3);
                continue;
            }
            hashBag.add(e2, n2);
        }
        if (!hashBag.isEmpty()) {
            bl2 = this.removeAll((Collection)hashBag);
        }
        return bl2;
    }

    public void setMap(Map map) {
        this._map = map;
    }

    public int size() {
        return this._total;
    }

    public Object[] toArray() {
        return this.extractList().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.extractList().toArray(objectArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator iterator = this.uniqueSet().iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            int n2 = this.getCount(e2);
            stringBuffer.append(n2);
            stringBuffer.append(":");
            stringBuffer.append(e2);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Set uniqueSet() {
        return Collections.unmodifiableSet(this._map.keySet());
    }

    private class BagIterator
    implements Iterator {
        private final DefaultMapBag this$0;
        private DefaultMapBag _parent;
        private Iterator _support;
        private Object _current;
        private int _mods;

        public BagIterator(DefaultMapBag defaultMapBag, DefaultMapBag defaultMapBag2, Iterator iterator) {
            this.this$0 = defaultMapBag;
            this._parent = null;
            this._support = null;
            this._current = null;
            this._mods = 0;
            this._parent = defaultMapBag2;
            this._support = iterator;
            this._current = null;
            this._mods = DefaultMapBag.a(defaultMapBag2);
        }

        public boolean hasNext() {
            return this._support.hasNext();
        }

        public Object next() {
            if (DefaultMapBag.a(this._parent) != this._mods) {
                throw new ConcurrentModificationException();
            }
            this._current = this._support.next();
            return this._current;
        }

        public void remove() {
            if (DefaultMapBag.a(this._parent) != this._mods) {
                throw new ConcurrentModificationException();
            }
            this._support.remove();
            this._parent.remove(this._current, 1);
            ++this._mods;
        }
    }
}

