/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.CursorableSubList;

public class CursorableLinkedList
implements List,
Serializable {
    public transient int _size = 0;
    public transient Listable _head = new Listable(this, null, null, null);
    public int _modCount = 0;
    public List _cursors = new ArrayList();

    public void add(int n2, Object object) {
        if (n2 == this._size) {
            this.add(object);
        } else {
            if (n2 < 0 || n2 > this._size) {
                throw new IndexOutOfBoundsException(String.valueOf(String.valueOf(n2)) + " < 0 or " + String.valueOf(n2) + " > " + this._size);
            }
            Listable listable = this.isEmpty() ? null : this.getListableAt(n2);
            Listable listable2 = listable == null ? null : listable.b();
            this.insertListable(listable2, listable, object);
        }
    }

    public boolean add(Object object) {
        this.insertListable(this._head.b(), null, object);
        return true;
    }

    public boolean addAll(int n2, Collection collection) {
        if (collection.isEmpty()) {
            return false;
        }
        if (this._size == n2 || this._size == 0) {
            return this.addAll(collection);
        }
        Listable listable = this.getListableAt(n2);
        Listable listable2 = listable == null ? null : listable.b();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            listable2 = this.insertListable(listable2, listable, iterator.next());
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        if (collection.isEmpty()) {
            return false;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.insertListable(this._head.b(), null, iterator.next());
        }
        return true;
    }

    public boolean addFirst(Object object) {
        this.insertListable(null, this._head.c(), object);
        return true;
    }

    public boolean addLast(Object object) {
        this.insertListable(this._head.b(), null, object);
        return true;
    }

    public void broadcastListableChanged(Listable listable) {
        Iterator iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            ((Cursor)iterator.next()).listableChanged(listable);
        }
    }

    public void broadcastListableInserted(Listable listable) {
        Iterator iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            ((Cursor)iterator.next()).listableInserted(listable);
        }
    }

    public void broadcastListableRemoved(Listable listable) {
        Iterator iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            ((Cursor)iterator.next()).listableRemoved(listable);
        }
    }

    public void clear() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public boolean contains(Object object) {
        Listable listable = this._head.c();
        Listable listable2 = null;
        while (listable != null && listable2 != this._head.b()) {
            if (object == null && listable.a() == null || object != null && object.equals(listable.a())) {
                return true;
            }
            listable2 = listable;
            listable = listable2.c();
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public Cursor cursor() {
        return new Cursor(this, 0);
    }

    public Cursor cursor(int n2) {
        return new Cursor(this, n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        ListIterator listIterator = ((List)object).listIterator();
        Listable listable = this._head.c();
        Listable listable2 = null;
        while (listable != null && listable2 != this._head.b()) {
            block9: {
                block6: {
                    boolean bl2;
                    block8: {
                        block7: {
                            if (!listIterator.hasNext()) break block6;
                            if (listable.a() != null) break block7;
                            if (listIterator.next() != null) break block6;
                            bl2 = false;
                            break block8;
                        }
                        bl2 = listable.a().equals(listIterator.next()) ^ true;
                    }
                    if (!bl2) break block9;
                }
                return false;
            }
            listable2 = listable;
            listable = listable2.c();
        }
        return listIterator.hasNext() ^ true;
    }

    public Object get(int n2) {
        return this.getListableAt(n2).a();
    }

    public Object getFirst() {
        try {
            return this._head.c().a();
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchElementException();
        }
    }

    public Object getLast() {
        try {
            return this._head.b().a();
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchElementException();
        }
    }

    public Listable getListableAt(int n2) {
        if (n2 < 0 || n2 >= this._size) {
            throw new IndexOutOfBoundsException(String.valueOf(String.valueOf(n2)) + " < 0 or " + String.valueOf(n2) + " >= " + this._size);
        }
        if (n2 <= this._size / 2) {
            Listable listable = this._head.c();
            int n3 = 0;
            while (n3 < n2) {
                listable = listable.c();
                ++n3;
            }
            return listable;
        }
        Listable listable = this._head.b();
        int n4 = this._size - 1;
        while (n4 > n2) {
            listable = listable.b();
            --n4;
        }
        return listable;
    }

    public int hashCode() {
        int n2 = 1;
        Listable listable = this._head.c();
        Listable listable2 = null;
        while (listable != null && listable2 != this._head.b()) {
            n2 = 31 * n2 + (listable.a() == null ? 0 : listable.a().hashCode());
            listable2 = listable;
            listable = listable2.c();
        }
        return n2;
    }

    public int indexOf(Object object) {
        int n2 = 0;
        if (object == null) {
            Listable listable = this._head.c();
            Listable listable2 = null;
            while (listable != null && listable2 != this._head.b()) {
                if (listable.a() == null) {
                    return n2;
                }
                ++n2;
                listable2 = listable;
                listable = listable2.c();
            }
        } else {
            Listable listable = this._head.c();
            Listable listable3 = null;
            while (listable != null && listable3 != this._head.b()) {
                if (object.equals(listable.a())) {
                    return n2;
                }
                ++n2;
                listable3 = listable;
                listable = listable3.c();
            }
        }
        return -1;
    }

    public Listable insertListable(Listable listable, Listable listable2, Object object) {
        ++this._modCount;
        ++this._size;
        Listable listable3 = new Listable(this, listable, listable2, object);
        if (listable != null) {
            listable.b(listable3);
        } else {
            this._head.b(listable3);
        }
        if (listable2 != null) {
            listable2.a(listable3);
        } else {
            this._head.a(listable3);
        }
        this.broadcastListableInserted(listable3);
        return listable3;
    }

    public void invalidateCursors() {
        Iterator iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            ((Cursor)iterator.next()).invalidate();
            iterator.remove();
        }
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public Iterator iterator() {
        return this.listIterator(0);
    }

    public int lastIndexOf(Object object) {
        int n2 = this._size - 1;
        if (object == null) {
            Listable listable = this._head.b();
            Listable listable2 = null;
            while (listable != null && listable2 != this._head.c()) {
                if (listable.a() == null) {
                    return n2;
                }
                --n2;
                listable2 = listable;
                listable = listable2.b();
            }
        } else {
            Listable listable = this._head.b();
            Listable listable3 = null;
            while (listable != null && listable3 != this._head.c()) {
                if (object.equals(listable.a())) {
                    return n2;
                }
                --n2;
                listable3 = listable;
                listable = listable3.b();
            }
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int n2) {
        if (n2 < 0 || n2 > this._size) {
            throw new IndexOutOfBoundsException(String.valueOf(n2) + " < 0 or > " + this._size);
        }
        return new ListIter(this, n2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._size = 0;
        this._head = new Listable(this, null, null, null);
        int n2 = objectInputStream.readInt();
        int n3 = 0;
        while (n3 < n2) {
            this.add(objectInputStream.readObject());
            ++n3;
        }
    }

    public void registerCursor(Cursor cursor) {
        this._cursors.add(cursor);
    }

    public Object remove(int n2) {
        Listable listable = this.getListableAt(n2);
        Object object = listable.a();
        this.removeListable(listable);
        return object;
    }

    public boolean remove(Object object) {
        Listable listable = this._head.c();
        Listable listable2 = null;
        while (listable != null && listable2 != this._head.b()) {
            if (object == null && listable.a() == null) {
                this.removeListable(listable);
                return true;
            }
            if (object != null && object.equals(listable.a())) {
                this.removeListable(listable);
                return true;
            }
            listable2 = listable;
            listable = listable2.c();
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        if (collection.size() == 0 || this._size == 0) {
            return false;
        }
        boolean bl2 = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    public Object removeFirst() {
        if (this._head.c() != null) {
            Object object = this._head.c().a();
            this.removeListable(this._head.c());
            return object;
        }
        throw new NoSuchElementException();
    }

    public Object removeLast() {
        if (this._head.b() != null) {
            Object object = this._head.b().a();
            this.removeListable(this._head.b());
            return object;
        }
        throw new NoSuchElementException();
    }

    public void removeListable(Listable listable) {
        ++this._modCount;
        --this._size;
        if (this._head.c() == listable) {
            this._head.b(listable.c());
        }
        if (listable.c() != null) {
            listable.c().a(listable.b());
        }
        if (this._head.b() == listable) {
            this._head.a(listable.b());
        }
        if (listable.b() != null) {
            listable.b().b(listable.c());
        }
        this.broadcastListableRemoved(listable);
    }

    public boolean retainAll(Collection collection) {
        boolean bl2 = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    public Object set(int n2, Object object) {
        Listable listable = this.getListableAt(n2);
        Object object2 = listable.a(object);
        this.broadcastListableChanged(listable);
        return object2;
    }

    public int size() {
        return this._size;
    }

    public List subList(int n2, int n3) {
        if (n2 < 0 || n3 > this._size || n2 > n3) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0 && n3 == this._size) {
            return this;
        }
        return new CursorableSubList(this, n2, n3);
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this._size];
        int n2 = 0;
        Listable listable = this._head.c();
        Listable listable2 = null;
        while (listable != null && listable2 != this._head.b()) {
            objectArray[n2++] = listable.a();
            listable2 = listable;
            listable = listable2.c();
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this._size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this._size);
        }
        int n2 = 0;
        Listable listable = this._head.c();
        Listable listable2 = null;
        while (listable != null && listable2 != this._head.b()) {
            objectArray[n2++] = listable.a();
            listable2 = listable;
            listable = listable2.c();
        }
        if (objectArray.length > this._size) {
            objectArray[this._size] = null;
        }
        return objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Listable listable = this._head.c();
        Listable listable2 = null;
        while (listable != null && listable2 != this._head.b()) {
            if (this._head.c() != listable) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(listable.a());
            listable2 = listable;
            listable = listable2.c();
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void unregisterCursor(Cursor cursor) {
        this._cursors.remove(cursor);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        Listable listable = this._head.c();
        while (listable != null) {
            objectOutputStream.writeObject(listable.a());
            listable = listable.c();
        }
    }

    public class Listable
    implements Serializable {
        private final CursorableLinkedList this$0;
        private Listable _prev;
        private Listable _next;
        private Object _val;

        public Listable(CursorableLinkedList cursorableLinkedList, Listable listable, Listable listable2, Object object) {
            this.this$0 = cursorableLinkedList;
            this._prev = null;
            this._next = null;
            this._val = null;
            this._prev = listable;
            this._next = listable2;
            this._val = object;
        }

        public Listable c() {
            return this._next;
        }

        public Listable b() {
            return this._prev;
        }

        public void b(Listable listable) {
            this._next = listable;
        }

        public void a(Listable listable) {
            this._prev = listable;
        }

        public Object a(Object object) {
            Object object2 = this._val;
            this._val = object;
            return object2;
        }

        public Object a() {
            return this._val;
        }
    }

    public class ListIter
    implements ListIterator {
        private final CursorableLinkedList this$0;
        public Listable b;
        public Listable e;
        public int a;
        public int c;

        public ListIter(CursorableLinkedList cursorableLinkedList, int n2) {
            this.this$0 = cursorableLinkedList;
            this.b = null;
            this.e = null;
            this.a = this.this$0._modCount;
            this.c = 0;
            if (n2 == 0) {
                CursorableLinkedList cursorableLinkedList2 = cursorableLinkedList;
                cursorableLinkedList2.getClass();
                this.b = new Listable(cursorableLinkedList2, null, cursorableLinkedList._head.c(), null);
                this.c = 0;
            } else if (n2 == cursorableLinkedList._size) {
                CursorableLinkedList cursorableLinkedList3 = cursorableLinkedList;
                cursorableLinkedList3.getClass();
                this.b = new Listable(cursorableLinkedList3, cursorableLinkedList._head.b(), null, null);
                this.c = cursorableLinkedList._size;
            } else {
                Listable listable = cursorableLinkedList.getListableAt(n2);
                CursorableLinkedList cursorableLinkedList4 = cursorableLinkedList;
                cursorableLinkedList4.getClass();
                this.b = new Listable(cursorableLinkedList4, listable.b(), listable, null);
                this.c = n2;
            }
        }

        public void add(Object object) {
            this.checkForComod();
            this.b.a(this.this$0.insertListable(this.b.b(), this.b.c(), object));
            this.e = null;
            ++this.c;
            ++this.a;
        }

        public void checkForComod() {
            if (this.a != this.this$0._modCount) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean hasNext() {
            this.checkForComod();
            return this.b.c() != null && this.b.b() != this.this$0._head.b();
        }

        public boolean hasPrevious() {
            this.checkForComod();
            return this.b.b() != null && this.b.c() != this.this$0._head.c();
        }

        public Object next() {
            this.checkForComod();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this.b.c().a();
            this.e = this.b.c();
            this.b.a(this.b.c());
            this.b.b(this.b.c().c());
            ++this.c;
            return object;
        }

        public int nextIndex() {
            this.checkForComod();
            if (!this.hasNext()) {
                return this.this$0.size();
            }
            return this.c;
        }

        public Object previous() {
            this.checkForComod();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            Object object = this.b.b().a();
            this.e = this.b.b();
            this.b.b(this.b.b());
            this.b.a(this.b.b().b());
            --this.c;
            return object;
        }

        public int previousIndex() {
            this.checkForComod();
            if (!this.hasPrevious()) {
                return -1;
            }
            return this.c - 1;
        }

        public void remove() {
            this.checkForComod();
            if (this.e == null) {
                throw new IllegalStateException();
            }
            this.b.b(this.e == this.this$0._head.b() ? null : this.e.c());
            this.b.a(this.e == this.this$0._head.c() ? null : this.e.b());
            this.this$0.removeListable(this.e);
            this.e = null;
            --this.c;
            ++this.a;
        }

        public void set(Object object) {
            this.checkForComod();
            try {
                this.e.a(object);
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalStateException();
            }
        }
    }

    public class Cursor
    extends ListIter
    implements ListIterator {
        private final CursorableLinkedList this$0;
        public boolean d;

        public Cursor(CursorableLinkedList cursorableLinkedList, int n2) {
            super(cursorableLinkedList, n2);
            this.this$0 = cursorableLinkedList;
            this.d = false;
            this.d = true;
            cursorableLinkedList.registerCursor(this);
        }

        public void add(Object object) {
            this.checkForComod();
            Listable listable = this.this$0.insertListable(this.b.b(), this.b.c(), object);
            this.b.a(listable);
            this.b.b(listable.c());
            this.e = null;
            ++this.c;
            ++this.a;
        }

        public void checkForComod() {
            if (!this.d) {
                throw new ConcurrentModificationException();
            }
        }

        public void close() {
            if (this.d) {
                this.d = false;
                this.this$0.unregisterCursor(this);
            }
        }

        public void invalidate() {
            this.d = false;
        }

        public void listableChanged(Listable listable) {
            if (this.e == listable) {
                this.e = null;
            }
        }

        public void listableInserted(Listable listable) {
            if (this.b.c() == null && this.b.b() == null) {
                this.b.b(listable);
            } else if (this.b.b() == listable.b()) {
                this.b.b(listable);
            }
            if (this.b.c() == listable.c()) {
                this.b.a(listable);
            }
            if (this.e == listable) {
                this.e = null;
            }
        }

        public void listableRemoved(Listable listable) {
            if (this.this$0._head.b() == null) {
                this.b.b(null);
            } else if (this.b.c() == listable) {
                this.b.b(listable.c());
            }
            if (this.this$0._head.c() == null) {
                this.b.a(null);
            } else if (this.b.b() == listable) {
                this.b.a(listable.b());
            }
            if (this.e == listable) {
                this.e = null;
            }
        }

        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        public int previousIndex() {
            throw new UnsupportedOperationException();
        }
    }
}

