/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferOverflowException;
import org.apache.commons.collections.BufferUnderflowException;

public class BoundedFifoBuffer
extends AbstractCollection
implements Buffer {
    private final Object[] m_elements;
    private int m_start = 0;
    private int m_end = 0;
    private boolean m_full = false;

    public BoundedFifoBuffer() {
        this(32);
    }

    public BoundedFifoBuffer(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.m_elements = new Object[n2];
    }

    public BoundedFifoBuffer(Collection collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public static int d(BoundedFifoBuffer boundedFifoBuffer) {
        return boundedFifoBuffer.m_start;
    }

    public static boolean c(BoundedFifoBuffer boundedFifoBuffer) {
        return boundedFifoBuffer.m_full;
    }

    public static int a(BoundedFifoBuffer boundedFifoBuffer) {
        return boundedFifoBuffer.m_end;
    }

    public static int c(BoundedFifoBuffer boundedFifoBuffer, int n2) {
        return boundedFifoBuffer.increment(n2);
    }

    public static Object[] b(BoundedFifoBuffer boundedFifoBuffer) {
        return boundedFifoBuffer.m_elements;
    }

    public static int b(BoundedFifoBuffer boundedFifoBuffer, int n2) {
        return boundedFifoBuffer.decrement(n2);
    }

    public static void a(BoundedFifoBuffer boundedFifoBuffer, int n2) {
        boundedFifoBuffer.m_end = n2;
    }

    public static void a(BoundedFifoBuffer boundedFifoBuffer, boolean bl2) {
        boundedFifoBuffer.m_full = bl2;
    }

    public boolean add(Object object) {
        if (object == null) {
            throw new NullPointerException("Attempted to add null object to buffer");
        }
        if (this.m_full) {
            throw new BufferOverflowException("The buffer cannot hold more than " + this.m_elements.length + " objects.");
        }
        this.m_elements[this.m_end++] = object;
        if (this.m_end >= this.m_elements.length) {
            this.m_end = 0;
        }
        if (this.m_end == this.m_start) {
            this.m_full = true;
        }
        return true;
    }

    public void clear() {
        this.m_full = false;
        this.m_start = 0;
        this.m_end = 0;
        Arrays.fill(this.m_elements, null);
    }

    private int decrement(int n2) {
        if (--n2 < 0) {
            n2 = this.m_elements.length - 1;
        }
        return n2;
    }

    public Object get() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        return this.m_elements[this.m_start];
    }

    private int increment(int n2) {
        if (++n2 >= this.m_elements.length) {
            n2 = 0;
        }
        return n2;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new Iterator(this){
            private final BoundedFifoBuffer this$0;
            private int index;
            private int lastReturnedIndex;
            private boolean isFirst;
            {
                this.this$0 = boundedFifoBuffer;
                this.index = BoundedFifoBuffer.d(boundedFifoBuffer);
                this.lastReturnedIndex = -1;
                this.isFirst = BoundedFifoBuffer.c(boundedFifoBuffer);
            }

            public boolean hasNext() {
                return this.isFirst || this.index != BoundedFifoBuffer.a(this.this$0);
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.isFirst = false;
                this.lastReturnedIndex = this.index;
                this.index = BoundedFifoBuffer.c(this.this$0, this.index);
                return BoundedFifoBuffer.b(this.this$0)[this.lastReturnedIndex];
            }

            public void remove() {
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                if (this.lastReturnedIndex == BoundedFifoBuffer.d(this.this$0)) {
                    this.this$0.remove();
                    this.lastReturnedIndex = -1;
                    return;
                }
                int n2 = this.lastReturnedIndex + 1;
                while (n2 != BoundedFifoBuffer.a(this.this$0)) {
                    if (n2 >= BoundedFifoBuffer.b(this.this$0).length) {
                        BoundedFifoBuffer.b((BoundedFifoBuffer)this.this$0)[n2 - 1] = BoundedFifoBuffer.b(this.this$0)[0];
                        n2 = 0;
                        continue;
                    }
                    BoundedFifoBuffer.b((BoundedFifoBuffer)this.this$0)[n2 - 1] = BoundedFifoBuffer.b(this.this$0)[n2];
                    ++n2;
                }
                this.lastReturnedIndex = -1;
                BoundedFifoBuffer.a(this.this$0, BoundedFifoBuffer.b(this.this$0, BoundedFifoBuffer.a(this.this$0)));
                BoundedFifoBuffer.b((BoundedFifoBuffer)this.this$0)[BoundedFifoBuffer.a((BoundedFifoBuffer)this.this$0)] = null;
                BoundedFifoBuffer.a(this.this$0, false);
                this.index = BoundedFifoBuffer.b(this.this$0, this.index);
            }
        };
    }

    public Object remove() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        Object object = this.m_elements[this.m_start];
        if (object != null) {
            this.m_elements[this.m_start++] = null;
            if (this.m_start >= this.m_elements.length) {
                this.m_start = 0;
            }
            this.m_full = false;
        }
        return object;
    }

    public int size() {
        int n2 = 0;
        n2 = this.m_end < this.m_start ? this.m_elements.length - this.m_start + this.m_end : (this.m_end == this.m_start ? (this.m_full ? this.m_elements.length : 0) : this.m_end - this.m_start);
        return n2;
    }
}

