/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodUtils {
    private static Log log = LogFactory.getLog(c == null ? (c = MethodUtils.a("org.apache.commons.beanutils.MethodUtils")) : c);
    private static boolean loggedAccessibleWarning = false;
    private static final Class[] emptyClassArray = new Class[0];
    private static final Object[] emptyObjectArray = new Object[0];
    private static WeakHashMap cache = new WeakHashMap();
    public static Class c;
    public static Class h;
    public static Class d;
    public static Class a;
    public static Class g;
    public static Class e;
    public static Class i;
    public static Class b;
    public static Class f;

    public static Object invokeMethod(Object object, String string, Object object2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{object2};
        return MethodUtils.invokeMethod(object, string, objectArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        int n2 = objectArray.length;
        Class[] classArray = new Class[n2];
        int n3 = 0;
        while (n3 < n2) {
            classArray[n3] = objectArray[n3].getClass();
            ++n3;
        }
        return MethodUtils.invokeMethod(object, string, objectArray, classArray);
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (classArray == null) {
            classArray = emptyClassArray;
        }
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, objectArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object object2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{object2};
        return MethodUtils.invokeExactMethod(object, string, objectArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        int n2 = objectArray.length;
        Class[] classArray = new Class[n2];
        int n3 = 0;
        while (n3 < n2) {
            classArray[n3] = objectArray[n3].getClass();
            ++n3;
        }
        return MethodUtils.invokeExactMethod(object, string, objectArray, classArray);
    }

    public static Object invokeExactMethod(Object object, String string, Object[] objectArray, Class[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (objectArray == null) {
            objectArray = emptyObjectArray;
        }
        if (classArray == null) {
            classArray = emptyClassArray;
        }
        if ((method = MethodUtils.getAccessibleMethod(object.getClass(), string, classArray)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + string + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, objectArray);
    }

    public static Method getAccessibleMethod(Class clazz, String string, Class clazz2) {
        Class[] classArray = new Class[]{clazz2};
        return MethodUtils.getAccessibleMethod(clazz, string, classArray);
    }

    public static Method getAccessibleMethod(Class clazz, String string, Class[] classArray) {
        try {
            MethodDescriptor methodDescriptor = new MethodDescriptor(clazz, string, classArray, true);
            Method method = (Method)cache.get(methodDescriptor);
            if (method != null) {
                return method;
            }
            method = MethodUtils.getAccessibleMethod(clazz.getMethod(string, classArray));
            cache.put(methodDescriptor, method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, method.getName(), method.getParameterTypes());
        return method;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String string, Class[] classArray) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] classArray2 = clazz.getInterfaces();
            int n2 = 0;
            while (n2 < classArray2.length) {
                if (Modifier.isPublic(classArray2[n2].getModifiers())) {
                    try {
                        method = classArray2[n2].getDeclaredMethod(string, classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (method != null || (method = MethodUtils.getAccessibleMethodFromInterfaceNest(classArray2[n2], string, classArray)) != null) break;
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        if (method != null) {
            return method;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Method getMatchingAccessibleMethod(Class var0, String var1_1, Class[] var2_2) {
        if (MethodUtils.log.isTraceEnabled()) {
            MethodUtils.log.trace("Matching name=" + var1_1 + " on " + var0);
        }
        var3_3 = new MethodDescriptor(var0, var1_1, var2_2, false);
        try {
            var4_4 = (Method)MethodUtils.cache.get(var3_3);
            if (var4_4 != null) {
                return var4_4;
            }
            var4_4 = var0.getMethod(var1_1, var2_2);
            if (MethodUtils.log.isTraceEnabled()) {
                MethodUtils.log.trace("Found straight match: " + var4_4);
                MethodUtils.log.trace("isPublic:" + Modifier.isPublic(var4_4.getModifiers()));
            }
            try {
                var4_4.setAccessible(true);
            }
            catch (SecurityException var5_7) {
                if (!MethodUtils.loggedAccessibleWarning) {
                    var6_9 = false;
                    try {
                        var7_11 = System.getProperty("java.specification.version");
                        if (var7_11.charAt(0) == '1' && (var7_11.charAt(0) == '0' || var7_11.charAt(0) == '1' || var7_11.charAt(0) == '2' || var7_11.charAt(0) == '3')) {
                            var6_9 = true;
                        }
                    }
                    catch (SecurityException var7_12) {
                        var6_9 = true;
                    }
                    if (var6_9) {
                        MethodUtils.log.warn("Current Security Manager restricts use of workarounds for reflection bugs  in pre-1.4 JVMs.");
                    }
                    MethodUtils.loggedAccessibleWarning = true;
                }
                MethodUtils.log.debug("Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", var5_7);
            }
            MethodUtils.cache.put(var3_3, var4_4);
            return var4_4;
        }
        catch (NoSuchMethodException var4_5) {
            var4_6 = var2_2.length;
            var5_8 = var0.getMethods();
            var6_10 = 0;
            var7_13 = var5_8.length;
            ** while (var6_10 < var7_13)
        }
lbl-1000:
        // 1 sources

        {
            if (var5_8[var6_10].getName().equals(var1_1)) {
                if (MethodUtils.log.isTraceEnabled()) {
                    MethodUtils.log.trace("Found matching name:");
                    MethodUtils.log.trace(var5_8[var6_10]);
                }
                if ((var9_15 = (var8_14 = var5_8[var6_10].getParameterTypes()).length) == var4_6) {
                    var10_16 = true;
                    var11_17 = 0;
                    while (var11_17 < var9_15) {
                        if (MethodUtils.log.isTraceEnabled()) {
                            MethodUtils.log.trace("Param=" + var2_2[var11_17].getName());
                            MethodUtils.log.trace("Method=" + var8_14[var11_17].getName());
                        }
                        if (!MethodUtils.isAssignmentCompatible(var8_14[var11_17], var2_2[var11_17])) {
                            if (MethodUtils.log.isTraceEnabled()) {
                                MethodUtils.log.trace(var8_14[var11_17] + " is not assignable from " + var2_2[var11_17]);
                            }
                            var10_16 = false;
                            break;
                        }
                        ++var11_17;
                    }
                    if (var10_16) {
                        var12_18 = MethodUtils.getAccessibleMethod(var5_8[var6_10]);
                        if (var12_18 != null) {
                            if (MethodUtils.log.isTraceEnabled()) {
                                MethodUtils.log.trace(var12_18 + " accessible version of " + var5_8[var6_10]);
                            }
                            try {
                                var12_18.setAccessible(true);
                            }
                            catch (SecurityException var13_19) {
                                if (!MethodUtils.loggedAccessibleWarning) {
                                    MethodUtils.log.warn("Cannot use JVM pre-1.4 access bug workaround due to restrictive security manager.");
                                    MethodUtils.loggedAccessibleWarning = true;
                                }
                                MethodUtils.log.debug("Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", var13_19);
                            }
                            MethodUtils.cache.put(var3_3, var12_18);
                            return var12_18;
                        }
                        MethodUtils.log.trace("Couldn't find accessible method.");
                    }
                }
            }
            ++var6_10;
            continue;
        }
lbl75:
        // 1 sources

        MethodUtils.log.trace("No match found.");
        return null;
    }

    public static final boolean isAssignmentCompatible(Class clazz, Class clazz2) {
        Class clazz3;
        if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        if (clazz.isPrimitive() && (clazz3 = MethodUtils.getPrimitiveWrapper(clazz)) != null) {
            return clazz3.equals(clazz2);
        }
        return false;
    }

    public static Class getPrimitiveWrapper(Class clazz) {
        if (Boolean.TYPE.equals(clazz)) {
            return h == null ? (h = MethodUtils.a("java.lang.Boolean")) : h;
        }
        if (Float.TYPE.equals(clazz)) {
            return d == null ? (d = MethodUtils.a("java.lang.Float")) : d;
        }
        if (Long.TYPE.equals(clazz)) {
            return a == null ? (a = MethodUtils.a("java.lang.Long")) : a;
        }
        if (Integer.TYPE.equals(clazz)) {
            return g == null ? (g = MethodUtils.a("java.lang.Integer")) : g;
        }
        if (Short.TYPE.equals(clazz)) {
            return e == null ? (e = MethodUtils.a("java.lang.Short")) : e;
        }
        if (Byte.TYPE.equals(clazz)) {
            return i == null ? (i = MethodUtils.a("java.lang.Byte")) : i;
        }
        if (Double.TYPE.equals(clazz)) {
            return b == null ? (b = MethodUtils.a("java.lang.Double")) : b;
        }
        if (Character.TYPE.equals(clazz)) {
            return f == null ? (f = MethodUtils.a("java.lang.Character")) : f;
        }
        return null;
    }

    public static Class getPrimitiveType(Class clazz) {
        if ((h == null ? (h = MethodUtils.a("java.lang.Boolean")) : h).equals(clazz)) {
            return Boolean.TYPE;
        }
        if ((d == null ? (d = MethodUtils.a("java.lang.Float")) : d).equals(clazz)) {
            return Float.TYPE;
        }
        if ((a == null ? (a = MethodUtils.a("java.lang.Long")) : a).equals(clazz)) {
            return Long.TYPE;
        }
        if ((g == null ? (g = MethodUtils.a("java.lang.Integer")) : g).equals(clazz)) {
            return Integer.TYPE;
        }
        if ((e == null ? (e = MethodUtils.a("java.lang.Short")) : e).equals(clazz)) {
            return Short.TYPE;
        }
        if ((i == null ? (i = MethodUtils.a("java.lang.Byte")) : i).equals(clazz)) {
            return Byte.TYPE;
        }
        if ((b == null ? (b = MethodUtils.a("java.lang.Double")) : b).equals(clazz)) {
            return Double.TYPE;
        }
        if ((f == null ? (f = MethodUtils.a("java.lang.Character")) : f).equals(clazz)) {
            return Character.TYPE;
        }
        if (log.isDebugEnabled()) {
            log.debug("Not a known primitive wrapper class: " + clazz);
        }
        return null;
    }

    public static Class toNonPrimitiveClass(Class clazz) {
        if (clazz.isPrimitive()) {
            Class clazz2 = MethodUtils.getPrimitiveWrapper(clazz);
            if (clazz2 != null) {
                return clazz2;
            }
            return clazz;
        }
        return clazz;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Class[] a() {
        return emptyClassArray;
    }

    private static class MethodDescriptor {
        private Class cls;
        private String methodName;
        private Class[] paramTypes;
        private boolean exact;
        private int hashCode;

        public MethodDescriptor(Class clazz, String string, Class[] classArray, boolean bl2) {
            if (clazz == null) {
                throw new IllegalArgumentException("Class cannot be null");
            }
            if (string == null) {
                throw new IllegalArgumentException("Method Name cannot be null");
            }
            if (classArray == null) {
                classArray = MethodUtils.a();
            }
            this.cls = clazz;
            this.methodName = string;
            this.paramTypes = classArray;
            this.exact = bl2;
            this.hashCode = string.length();
        }

        public boolean equals(Object object) {
            if (!(object instanceof MethodDescriptor)) {
                return false;
            }
            MethodDescriptor methodDescriptor = (MethodDescriptor)object;
            return this.exact == methodDescriptor.exact && this.methodName.equals(methodDescriptor.methodName) && this.cls.equals(methodDescriptor.cls) && Arrays.equals(this.paramTypes, methodDescriptor.paramTypes);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

