/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public class MappedPropertyDescriptor
extends PropertyDescriptor {
    private Class mappedPropertyType;
    private Method mappedReadMethod;
    private Method mappedWriteMethod;
    private static final Class[] stringClassArray = new Class[]{a == null ? (a = MappedPropertyDescriptor.a("java.lang.String")) : a};
    private static Hashtable declaredMethodCache = new Hashtable();
    public static Class a;

    public MappedPropertyDescriptor(String string, Class clazz) throws IntrospectionException {
        super(string, null, null);
        if (string == null || string.length() == 0) {
            throw new IntrospectionException("bad property name: " + string + " on class: " + clazz.getClass().getName());
        }
        this.setName(string);
        String string2 = MappedPropertyDescriptor.capitalizePropertyName(string);
        try {
            this.mappedReadMethod = MappedPropertyDescriptor.a(clazz, "get" + string2, 1, stringClassArray);
            Class[] classArray = new Class[]{a == null ? (a = MappedPropertyDescriptor.a("java.lang.String")) : a, this.mappedReadMethod.getReturnType()};
            this.mappedWriteMethod = MappedPropertyDescriptor.a(clazz, "set" + string2, 2, classArray);
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (this.mappedReadMethod == null) {
            this.mappedWriteMethod = MappedPropertyDescriptor.a(clazz, "set" + string2, 2);
        }
        if (this.mappedReadMethod == null && this.mappedWriteMethod == null) {
            throw new IntrospectionException("Property '" + string + "' not found on " + clazz.getName());
        }
        this.findMappedPropertyType();
    }

    public MappedPropertyDescriptor(String string, Class clazz, String string2, String string3) throws IntrospectionException {
        super(string, null, null);
        if (string == null || string.length() == 0) {
            throw new IntrospectionException("bad property name: " + string);
        }
        this.setName(string);
        this.mappedReadMethod = MappedPropertyDescriptor.a(clazz, string2, 1, stringClassArray);
        if (this.mappedReadMethod != null) {
            Class[] classArray = new Class[]{a == null ? (a = MappedPropertyDescriptor.a("java.lang.String")) : a, this.mappedReadMethod.getReturnType()};
            this.mappedWriteMethod = MappedPropertyDescriptor.a(clazz, string3, 2, classArray);
        } else {
            this.mappedWriteMethod = MappedPropertyDescriptor.a(clazz, string3, 2);
        }
        this.findMappedPropertyType();
    }

    public MappedPropertyDescriptor(String string, Method method, Method method2) throws IntrospectionException {
        super(string, method, method2);
        if (string == null || string.length() == 0) {
            throw new IntrospectionException("bad property name: " + string);
        }
        this.setName(string);
        this.mappedReadMethod = method;
        this.mappedWriteMethod = method2;
        this.findMappedPropertyType();
    }

    public Class getMappedPropertyType() {
        return this.mappedPropertyType;
    }

    public Method getMappedReadMethod() {
        return this.mappedReadMethod;
    }

    public void setMappedReadMethod(Method method) throws IntrospectionException {
        this.mappedReadMethod = method;
        this.findMappedPropertyType();
    }

    public Method getMappedWriteMethod() {
        return this.mappedWriteMethod;
    }

    public void setMappedWriteMethod(Method method) throws IntrospectionException {
        this.mappedWriteMethod = method;
        this.findMappedPropertyType();
    }

    private void findMappedPropertyType() throws IntrospectionException {
        this.mappedPropertyType = null;
        if (this.mappedReadMethod != null) {
            if (this.mappedReadMethod.getParameterTypes().length != 1) {
                throw new IntrospectionException("bad mapped read method arg count");
            }
            this.mappedPropertyType = this.mappedReadMethod.getReturnType();
            if (this.mappedPropertyType == Void.TYPE) {
                throw new IntrospectionException("mapped read method " + this.mappedReadMethod.getName() + " returns void");
            }
        }
        if (this.mappedWriteMethod != null) {
            Class<?>[] classArray = this.mappedWriteMethod.getParameterTypes();
            if (classArray.length != 2) {
                throw new IntrospectionException("bad mapped write method arg count");
            }
            if (this.mappedPropertyType != null && this.mappedPropertyType != classArray[1]) {
                throw new IntrospectionException("type mismatch between mapped read and write methods");
            }
            this.mappedPropertyType = classArray[1];
        }
    }

    private static String capitalizePropertyName(String string) {
        if (string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return new String(cArray);
    }

    private static synchronized Method[] getPublicDeclaredMethods(Class clazz) {
        Class clazz2 = clazz;
        Method[] methodArray = (Method[])declaredMethodCache.get(clazz2);
        if (methodArray != null) {
            return methodArray;
        }
        methodArray = (Method[])AccessController.doPrivileged(new PrivilegedAction(clazz2){
            private final Class val$fclz;
            {
                this.val$fclz = clazz;
            }

            /*
             * Unable to fully structure code
             */
            public Object run() {
                try {
                    return this.val$fclz.getDeclaredMethods();
                }
                catch (SecurityException var1_1) {
                    var2_2 = this.val$fclz.getMethods();
                    var3_3 = 0;
                    var4_4 = var2_2.length;
                    ** while (var3_3 < var4_4)
                }
lbl-1000:
                // 1 sources

                {
                    var5_5 = var2_2[var3_3];
                    if (!this.val$fclz.equals(var5_5.getDeclaringClass())) {
                        var2_2[var3_3] = null;
                    }
                    ++var3_3;
                    continue;
                }
lbl13:
                // 1 sources

                return var2_2;
            }
        });
        int n2 = 0;
        while (n2 < methodArray.length) {
            int n3;
            Method method = methodArray[n2];
            if (method != null && !Modifier.isPublic(n3 = method.getModifiers())) {
                methodArray[n2] = null;
            }
            ++n2;
        }
        declaredMethodCache.put(clazz, methodArray);
        return methodArray;
    }

    private static Method internalFindMethod(Class clazz, String string, int n2) {
        GenericDeclaration genericDeclaration;
        int n3;
        GenericDeclaration[] genericDeclarationArray;
        Class clazz2 = clazz;
        while (clazz2 != null) {
            genericDeclarationArray = MappedPropertyDescriptor.getPublicDeclaredMethods(clazz2);
            n3 = 0;
            while (n3 < genericDeclarationArray.length) {
                int n4;
                genericDeclaration = genericDeclarationArray[n3];
                if (genericDeclaration != null && !Modifier.isStatic(n4 = ((Method)genericDeclaration).getModifiers()) && ((Method)genericDeclaration).getName().equals(string) && ((Method)genericDeclaration).getParameterTypes().length == n2) {
                    return genericDeclaration;
                }
                ++n3;
            }
            clazz2 = clazz2.getSuperclass();
        }
        genericDeclarationArray = clazz.getInterfaces();
        n3 = 0;
        while (n3 < genericDeclarationArray.length) {
            genericDeclaration = MappedPropertyDescriptor.internalFindMethod((Class)genericDeclarationArray[n3], string, n2);
            if (genericDeclaration != null) {
                return genericDeclaration;
            }
            ++n3;
        }
        return null;
    }

    private static Method internalFindMethod(Class clazz, String string, int n2, Class[] classArray) {
        GenericDeclaration genericDeclaration;
        int n3;
        GenericDeclaration[] genericDeclarationArray;
        Class clazz2 = clazz;
        while (clazz2 != null) {
            genericDeclarationArray = MappedPropertyDescriptor.getPublicDeclaredMethods(clazz2);
            n3 = 0;
            while (n3 < genericDeclarationArray.length) {
                block9: {
                    block10: {
                        int n4;
                        genericDeclaration = genericDeclarationArray[n3];
                        if (genericDeclaration == null || Modifier.isStatic(n4 = ((Method)genericDeclaration).getModifiers())) break block9;
                        Class<?>[] classArray2 = ((Method)genericDeclaration).getParameterTypes();
                        if (!((Method)genericDeclaration).getName().equals(string) || classArray2.length != n2) break block9;
                        boolean bl2 = false;
                        if (n2 <= 0) break block10;
                        int n5 = 0;
                        while (n5 < n2) {
                            if (classArray2[n5] != classArray[n5]) {
                                bl2 = true;
                            }
                            ++n5;
                        }
                        if (bl2) break block9;
                    }
                    return genericDeclaration;
                }
                ++n3;
            }
            clazz2 = clazz2.getSuperclass();
        }
        genericDeclarationArray = clazz.getInterfaces();
        n3 = 0;
        while (n3 < genericDeclarationArray.length) {
            genericDeclaration = MappedPropertyDescriptor.internalFindMethod((Class)genericDeclarationArray[n3], string, n2);
            if (genericDeclaration != null) {
                return genericDeclaration;
            }
            ++n3;
        }
        return null;
    }

    public static Method a(Class clazz, String string, int n2) throws IntrospectionException {
        if (string == null) {
            return null;
        }
        Method method = MappedPropertyDescriptor.internalFindMethod(clazz, string, n2);
        if (method != null) {
            return method;
        }
        throw new IntrospectionException("No method \"" + string + "\" with " + n2 + " arg(s)");
    }

    public static Method a(Class clazz, String string, int n2, Class[] classArray) throws IntrospectionException {
        if (string == null) {
            return null;
        }
        Method method = MappedPropertyDescriptor.internalFindMethod(clazz, string, n2, classArray);
        if (method != null) {
            return method;
        }
        throw new IntrospectionException("No method \"" + string + "\" with " + n2 + " arg(s) of matching types.");
    }

    private boolean throwsException(Method method, Class clazz) {
        Class<?>[] classArray = method.getExceptionTypes();
        int n2 = 0;
        while (n2 < classArray.length) {
            if (classArray[n2] == clazz) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

