/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanToPropertyValueTransformer
implements Transformer {
    private final Log log = LogFactory.getLog(this.getClass());
    private String propertyName;
    private boolean ignoreNull;

    public BeanToPropertyValueTransformer(String string) {
        this(string, false);
    }

    public BeanToPropertyValueTransformer(String string, boolean bl2) {
        if (string == null || string.length() <= 0) {
            throw new IllegalArgumentException("propertyName cannot be null or empty");
        }
        this.propertyName = string;
        this.ignoreNull = bl2;
    }

    public Object transform(Object object) {
        Object object2 = null;
        try {
            object2 = PropertyUtils.getProperty(object, this.propertyName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = "Problem during transformation. Null value encountered in property path...";
            if (this.ignoreNull) {
                this.log.warn("WARNING: Problem during transformation. Null value encountered in property path...", illegalArgumentException);
            }
            this.log.error("ERROR: Problem during transformation. Null value encountered in property path...", illegalArgumentException);
            throw illegalArgumentException;
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = "Unable to access the property provided.";
            this.log.error("Unable to access the property provided.", illegalAccessException);
            throw new IllegalArgumentException("Unable to access the property provided.");
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = "Exception occurred in property's getter";
            this.log.error("Exception occurred in property's getter", invocationTargetException);
            throw new IllegalArgumentException("Exception occurred in property's getter");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = "No property found for name [" + this.propertyName + "]";
            this.log.error(string, noSuchMethodException);
            throw new IllegalArgumentException(string);
        }
        return object2;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }
}

