/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRImageMapRenderer;
import net.sf.jasperreports.engine.JRPrintAnchorIndex;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.print.JRPrinterAWT;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.xml.JRPrintXmlLoader;
import net.sf.jasperreports.view.JRHyperlinkListener;
import net.sf.jasperreports.view.JRSaveContributor;
import net.sf.jasperreports.view.save.JRPrintSaveContributor;

public class JRViewer
extends JPanel
implements JRHyperlinkListener {
    private static final long serialVersionUID = 10200L;
    public static final String VIEWER_RENDER_BUFFER_MAX_SIZE = "net.sf.jasperreports.viewer.render.buffer.max.size";
    public static final int TYPE_FILE_NAME = 1;
    public static final int TYPE_INPUT_STREAM = 2;
    public static final int TYPE_OBJECT = 3;
    public static final int REPORT_RESOLUTION = 72;
    public float MIN_ZOOM = 0.5f;
    public float MAX_ZOOM = 10.0f;
    public int[] zooms = new int[]{50, 75, 100, 125, 150, 175, 200, 250, 400, 800};
    public int defaultZoomIndex = 2;
    public int type = 1;
    public boolean isXML = false;
    public String reportFileName = null;
    public JasperPrint a = null;
    private int pageIndex = 0;
    private boolean pageError;
    public float zoom = 0.0f;
    private JRGraphics2DExporter exporter = null;
    private int screenResolution = 72;
    public float realZoom = 0.0f;
    private DecimalFormat zoomDecimalFormat = new DecimalFormat("#.##");
    private ResourceBundle resourceBundle = null;
    private int downX = 0;
    private int downY = 0;
    private List hyperlinkListeners = new ArrayList();
    private Map linksMap = new HashMap();
    private MouseListener mouseListener = new MouseAdapter(this){
        private final JRViewer this$0;
        {
            this.this$0 = jRViewer;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.this$0.c(mouseEvent);
        }
    };
    public KeyListener keyNavigationListener = new KeyListener(this){
        private final JRViewer this$0;
        {
            this.this$0 = jRViewer;
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.this$0.keyNavigate(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    };
    public List saveContributors = new ArrayList();
    public JToggleButton btnActualSize;
    public JButton btnFirst;
    public JToggleButton btnFitPage;
    public JToggleButton btnFitWidth;
    public JButton btnLast;
    public JButton btnNext;
    public JButton btnPrevious;
    public JButton btnPrint;
    public JButton btnReload;
    public JButton btnSave;
    public JButton btnZoomIn;
    public JButton btnZoomOut;
    public JComboBox cmbZoom;
    private JLabel jLabel1;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private PageRenderer lblPage;
    public JLabel lblStatus;
    private JPanel pnlInScroll;
    private JPanel pnlLinks;
    private JPanel pnlMain;
    private JPanel pnlPage;
    public JPanel pnlSep01;
    public JPanel pnlSep02;
    public JPanel pnlSep03;
    public JPanel pnlStatus;
    private JScrollPane scrollPane;
    public JPanel tlbToolBar;
    public JTextField txtGoTo;

    public JRViewer(String string, boolean bl2) throws JRException {
        this(string, bl2, null);
    }

    public JRViewer(InputStream inputStream, boolean bl2) throws JRException {
        this(inputStream, bl2, null);
    }

    public JRViewer(JasperPrint jasperPrint) {
        this(jasperPrint, null);
    }

    public JRViewer(String string, boolean bl2, Locale locale) throws JRException {
        this(string, bl2, locale, null);
    }

    public JRViewer(InputStream inputStream, boolean bl2, Locale locale) throws JRException {
        this(inputStream, bl2, locale, null);
    }

    public JRViewer(JasperPrint jasperPrint, Locale locale) {
        this(jasperPrint, locale, null);
    }

    public JRViewer(String string, boolean bl2, Locale locale, ResourceBundle resourceBundle) throws JRException {
        this.initResources(locale, resourceBundle);
        this.setScreenDetails();
        this.setZooms();
        this.initComponents();
        this.loadReport(string, bl2);
        this.cmbZoom.setSelectedIndex(this.defaultZoomIndex);
        this.initSaveContributors();
        this.addHyperlinkListener(this);
    }

    public JRViewer(InputStream inputStream, boolean bl2, Locale locale, ResourceBundle resourceBundle) throws JRException {
        this.initResources(locale, resourceBundle);
        this.setScreenDetails();
        this.setZooms();
        this.initComponents();
        this.loadReport(inputStream, bl2);
        this.cmbZoom.setSelectedIndex(this.defaultZoomIndex);
        this.initSaveContributors();
        this.addHyperlinkListener(this);
    }

    public JRViewer(JasperPrint jasperPrint, Locale locale, ResourceBundle resourceBundle) {
        this.initResources(locale, resourceBundle);
        this.setScreenDetails();
        this.setZooms();
        this.initComponents();
        this.loadReport(jasperPrint);
        this.cmbZoom.setSelectedIndex(this.defaultZoomIndex);
        this.initSaveContributors();
        this.addHyperlinkListener(this);
    }

    private void setScreenDetails() {
        this.screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public void clear() {
        this.emptyContainer(this);
        this.a = null;
    }

    public void setZooms() {
    }

    public void addSaveContributor(JRSaveContributor jRSaveContributor) {
        this.saveContributors.add(jRSaveContributor);
    }

    public void removeSaveContributor(JRSaveContributor jRSaveContributor) {
        this.saveContributors.remove(jRSaveContributor);
    }

    public JRSaveContributor[] getSaveContributors() {
        return this.saveContributors.toArray(new JRSaveContributor[this.saveContributors.size()]);
    }

    public void addHyperlinkListener(JRHyperlinkListener jRHyperlinkListener) {
        this.hyperlinkListeners.add(jRHyperlinkListener);
    }

    public void removeHyperlinkListener(JRHyperlinkListener jRHyperlinkListener) {
        this.hyperlinkListeners.remove(jRHyperlinkListener);
    }

    public JRHyperlinkListener[] getHyperlinkListeners() {
        return this.hyperlinkListeners.toArray(new JRHyperlinkListener[this.hyperlinkListeners.size()]);
    }

    public void initResources(Locale locale, ResourceBundle resourceBundle) {
        if (locale != null) {
            this.setLocale(locale);
        } else {
            this.setLocale(Locale.getDefault());
        }
        this.resourceBundle = resourceBundle == null ? ResourceBundle.getBundle("net/sf/jasperreports/view/viewer", this.getLocale()) : resourceBundle;
    }

    public String getBundleString(String string) {
        return this.resourceBundle.getString(string);
    }

    public void initSaveContributors() {
        String[] stringArray = new String[]{"net.sf.jasperreports.view.save.JRPrintSaveContributor", "net.sf.jasperreports.view.save.JRPdfSaveContributor", "net.sf.jasperreports.view.save.JRRtfSaveContributor", "net.sf.jasperreports.view.save.JROdtSaveContributor", "net.sf.jasperreports.view.save.JRHtmlSaveContributor", "net.sf.jasperreports.view.save.JRSingleSheetXlsSaveContributor", "net.sf.jasperreports.view.save.JRMultipleSheetsXlsSaveContributor", "net.sf.jasperreports.view.save.JRCsvSaveContributor", "net.sf.jasperreports.view.save.JRXmlSaveContributor", "net.sf.jasperreports.view.save.JREmbeddedImagesXmlSaveContributor"};
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                Class clazz = JRClassLoader.loadClassForName(stringArray[i2]);
                Method method = clazz.getMethod("getInstance", null);
                JRSaveContributor jRSaveContributor = (JRSaveContributor)method.invoke(null, (Object[])null);
                this.saveContributors.add(jRSaveContributor);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void gotoHyperlink(JRPrintHyperlink jRPrintHyperlink) {
        switch (jRPrintHyperlink.getHyperlinkType()) {
            case 2: {
                if (!this.isOnlyHyperlinkListener()) break;
                System.out.println("Hyperlink reference : " + jRPrintHyperlink.getHyperlinkReference());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
            case 3: {
                Container container;
                if (jRPrintHyperlink.getHyperlinkAnchor() == null) break;
                Map map = this.a.getAnchorIndexes();
                JRPrintAnchorIndex jRPrintAnchorIndex = (JRPrintAnchorIndex)map.get(jRPrintHyperlink.getHyperlinkAnchor());
                if (jRPrintAnchorIndex.getPageIndex() != this.pageIndex) {
                    this.setPageIndex(jRPrintAnchorIndex.getPageIndex());
                    this.refreshPage();
                }
                if (!((container = this.pnlInScroll.getParent()) instanceof JViewport)) break;
                JViewport jViewport = (JViewport)container;
                int n2 = (int)((float)jRPrintAnchorIndex.getElementAbsoluteX() * this.realZoom);
                int n3 = (int)((float)jRPrintAnchorIndex.getElementAbsoluteY() * this.realZoom);
                int n4 = this.pnlInScroll.getWidth() - jViewport.getWidth();
                int n5 = this.pnlInScroll.getHeight() - jViewport.getHeight();
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n2 > n4) {
                    n2 = n4;
                }
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n3 > n5) {
                    n3 = n5;
                }
                jViewport.setViewPosition(new Point(n2, n3));
                break;
            }
            case 4: {
                int n6 = this.pageIndex + 1;
                if (jRPrintHyperlink.getHyperlinkPage() != null) {
                    n6 = jRPrintHyperlink.getHyperlinkPage();
                }
                if (n6 < 1 || n6 > this.a.getPages().size() || n6 == this.pageIndex + 1) break;
                this.setPageIndex(n6 - 1);
                this.refreshPage();
                Container container = this.pnlInScroll.getParent();
                if (!(container instanceof JViewport)) break;
                JViewport jViewport = (JViewport)container;
                jViewport.setViewPosition(new Point(0, 0));
                break;
            }
            case 5: {
                if (!this.isOnlyHyperlinkListener()) break;
                System.out.println("Hyperlink reference : " + jRPrintHyperlink.getHyperlinkReference());
                System.out.println("Hyperlink anchor    : " + jRPrintHyperlink.getHyperlinkAnchor());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
            case 6: {
                if (!this.isOnlyHyperlinkListener()) break;
                System.out.println("Hyperlink reference : " + jRPrintHyperlink.getHyperlinkReference());
                System.out.println("Hyperlink page      : " + jRPrintHyperlink.getHyperlinkPage());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
            case 7: {
                if (!this.isOnlyHyperlinkListener()) break;
                System.out.println("Hyperlink of type " + jRPrintHyperlink.getLinkType());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
        }
    }

    public boolean isOnlyHyperlinkListener() {
        int n2;
        if (this.hyperlinkListeners == null) {
            n2 = 0;
        } else {
            n2 = this.hyperlinkListeners.size();
            if (this.hyperlinkListeners.contains(this)) {
                --n2;
            }
        }
        return n2 == 0;
    }

    private void initComponents() {
        this.tlbToolBar = new JPanel();
        this.btnSave = new JButton();
        this.btnPrint = new JButton();
        this.btnReload = new JButton();
        this.pnlSep01 = new JPanel();
        this.btnFirst = new JButton();
        this.btnPrevious = new JButton();
        this.btnNext = new JButton();
        this.btnLast = new JButton();
        this.txtGoTo = new JTextField();
        this.pnlSep02 = new JPanel();
        this.btnActualSize = new JToggleButton();
        this.btnFitPage = new JToggleButton();
        this.btnFitWidth = new JToggleButton();
        this.pnlSep03 = new JPanel();
        this.btnZoomIn = new JButton();
        this.btnZoomOut = new JButton();
        this.cmbZoom = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (int i2 = 0; i2 < this.zooms.length; ++i2) {
            defaultComboBoxModel.addElement("" + this.zooms[i2] + "%");
        }
        this.cmbZoom.setModel(defaultComboBoxModel);
        this.pnlMain = new JPanel();
        this.scrollPane = new JScrollPane();
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(5);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.pnlInScroll = new JPanel();
        this.pnlPage = new JPanel();
        this.jPanel4 = new JPanel();
        this.pnlLinks = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel9 = new JPanel();
        this.lblPage = new PageRenderer(this, this);
        this.pnlStatus = new JPanel();
        this.lblStatus = new JLabel();
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(450, 150));
        this.setPreferredSize(new Dimension(450, 150));
        this.tlbToolBar.setLayout(new FlowLayout(0, 0, 2));
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/save.GIF")));
        this.btnSave.setToolTipText(this.getBundleString("save"));
        this.btnSave.setMargin(new Insets(2, 2, 2, 2));
        this.btnSave.setMaximumSize(new Dimension(23, 23));
        this.btnSave.setMinimumSize(new Dimension(23, 23));
        this.btnSave.setPreferredSize(new Dimension(23, 23));
        this.btnSave.addActionListener(new ActionListener(this){
            private final JRViewer this$0;
            {
                this.this$0 = jRViewer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.h(actionEvent);
            }
        });
        this.btnSave.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnSave);
        this.btnPrint.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/print.GIF")));
        this.btnPrint.setToolTipText(this.getBundleString("print"));
        this.btnPrint.setMargin(new Insets(2, 2, 2, 2));
        this.btnPrint.setMaximumSize(new Dimension(23, 23));
        this.btnPrint.setMinimumSize(new Dimension(23, 23));
        this.btnPrint.setPreferredSize(new Dimension(23, 23));
        this.btnPrint.addActionListener(new ActionListener(this){
            private final JRViewer this$0;
            {
                this.this$0 = jRViewer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.n(actionEvent);
            }
        });
        this.btnPrint.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnPrint);
        this.btnReload.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/reload.GIF")));
        this.btnReload.setToolTipText(this.getBundleString("reload"));
        this.btnReload.setMargin(new Insets(2, 2, 2, 2));
        this.btnReload.setMaximumSize(new Dimension(23, 23));
        this.btnReload.setMinimumSize(new Dimension(23, 23));
        this.btnReload.setPreferredSize(new Dimension(23, 23));
        this.btnReload.addActionListener(new ActionListener(this){
            private final JRViewer this$0;
            {
                this.this$0 = jRViewer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.i(actionEvent);
            }
        });
        this.btnReload.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnReload);
        this.pnlSep01.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep01);
        this.btnFirst.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/first.GIF")));
        this.btnFirst.setToolTipText(this.getBundleString("first.page"));
        this.btnFirst.setMargin(new Insets(2, 2, 2, 2));
        this.btnFirst.setMaximumSize(new Dimension(23, 23));
        this.btnFirst.setMinimumSize(new Dimension(23, 23));
        this.btnFirst.setPreferredSize(new Dimension(23, 23));
        this.btnFirst.addActionListener(new ActionListener(this){
            private final JRViewer this$0;
            {
                this.this$0 = jRViewer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.f(actionEvent);
            }
        });
        this.btnFirst.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnFirst);
        this.btnPrevious.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/previous.GIF")));
        this.btnPrevious.setToolTipText(this.getBundleString("previous.page"));
        this.btnPrevious.setMargin(new Insets(2, 2, 2, 2));
        this.btnPrevious.setMaximumSize(new Dimension(23, 23));
        this.btnPrevious.setMinimumSize(new Dimension(23, 23));
        this.btnPrevious.setPreferredSize(new Dimension(23, 23));
        this.btnPrevious.addActionListener(new ActionListener(this){
            private final JRViewer this$0;
            {
                this.this$0 = jRViewer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.d(actionEvent);
            }
        });
        this.btnPrevious.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnPrevious);
        this.btnNext.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/next.GIF")));
        this.btnNext.setToolTipText(this.getBundleString("next.page"));
        this.btnNext.setMargin(new Insets(2, 2, 2, 2));
        this.btnNext.setMaximumSize(new Dimension(23, 23));
        this.btnNext.setMinimumSize(new Dimension(23, 23));
        this.btnNext.setPreferredSize(new Dimension(23, 23));
        this.btnNext.addActionListener(new ActionListener(this){
            private final JRViewer this$0;
            {
                this.this$0 = jRViewer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.j(actionEvent);
            }
        });
        this.btnNext.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnNext);
        this.btnLast.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/last.GIF")));
        this.btnLast.setToolTipText(this.getBundleString("last.page"));
        this.btnLast.setMargin(new Insets(2, 2, 2, 2));
        this.btnLast.setMaximumSize(new Dimension(23, 23));
        this.btnLast.setMinimumSize(new Dimension(23, 23));
        this.btnLast.setPreferredSize(new Dimension(23, 23));
        this.btnLast.addActionListener(new ActionListener(this){
            private final JRViewer this$0;
            {
                this.this$0 = jRViewer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.l(actionEvent);
            }
        });
        this.btnLast.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnLast);
        this.txtGoTo.setToolTipText(this.getBundleString("go.to.page"));
        this.txtGoTo.setMaximumSize(new Dimension(40, 23));
        this.txtGoTo.setMinimumSize(new Dimension(40, 23));
        this.txtGoTo.setPreferredSize(new Dimension(40, 23));
        this.txtGoTo.addActionListener(new ActionListener(this){
            private final JRViewer this$0;
            {
                this.this$0 = jRViewer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.a(actionEvent);
            }
        });
        this.txtGoTo.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.txtGoTo);
        this.pnlSep02.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep02);
        this.btnActualSize.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/actualsize.GIF")));
        this.btnActualSize.setToolTipText(this.getBundleString("actual.size"));
        this.btnActualSize.setMargin(new Insets(2, 2, 2, 2));
        this.btnActualSize.setMaximumSize(new Dimension(23, 23));
        this.btnActualSize.setMinimumSize(new Dimension(23, 23));
        this.btnActualSize.setPreferredSize(new Dimension(23, 23));
        this.btnActualSize.addActionListener(new ActionListener(this){
            private final JRViewer this$0;
            {
                this.this$0 = jRViewer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.k(actionEvent);
            }
        });
        this.btnActualSize.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnActualSize);
        this.btnFitPage.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/fitpage.GIF")));
        this.btnFitPage.setToolTipText(this.getBundleString("fit.page"));
        this.btnFitPage.setMargin(new Insets(2, 2, 2, 2));
        this.btnFitPage.setMaximumSize(new Dimension(23, 23));
        this.btnFitPage.setMinimumSize(new Dimension(23, 23));
        this.btnFitPage.setPreferredSize(new Dimension(23, 23));
        this.btnFitPage.addActionListener(new ActionListener(this){
            private final JRViewer this$0;
            {
                this.this$0 = jRViewer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.g(actionEvent);
            }
        });
        this.btnFitPage.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnFitPage);
        this.btnFitWidth.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/fitwidth.GIF")));
        this.btnFitWidth.setToolTipText(this.getBundleString("fit.width"));
        this.btnFitWidth.setMargin(new Insets(2, 2, 2, 2));
        this.btnFitWidth.setMaximumSize(new Dimension(23, 23));
        this.btnFitWidth.setMinimumSize(new Dimension(23, 23));
        this.btnFitWidth.setPreferredSize(new Dimension(23, 23));
        this.btnFitWidth.addActionListener(new ActionListener(this){
            private final JRViewer this$0;
            {
                this.this$0 = jRViewer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.m(actionEvent);
            }
        });
        this.btnFitWidth.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnFitWidth);
        this.pnlSep03.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep03);
        this.btnZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/zoomin.GIF")));
        this.btnZoomIn.setToolTipText(this.getBundleString("zoom.in"));
        this.btnZoomIn.setMargin(new Insets(2, 2, 2, 2));
        this.btnZoomIn.setMaximumSize(new Dimension(23, 23));
        this.btnZoomIn.setMinimumSize(new Dimension(23, 23));
        this.btnZoomIn.setPreferredSize(new Dimension(23, 23));
        this.btnZoomIn.addActionListener(new ActionListener(this){
            private final JRViewer this$0;
            {
                this.this$0 = jRViewer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.e(actionEvent);
            }
        });
        this.btnZoomIn.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnZoomIn);
        this.btnZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/zoomout.GIF")));
        this.btnZoomOut.setToolTipText(this.getBundleString("zoom.out"));
        this.btnZoomOut.setMargin(new Insets(2, 2, 2, 2));
        this.btnZoomOut.setMaximumSize(new Dimension(23, 23));
        this.btnZoomOut.setMinimumSize(new Dimension(23, 23));
        this.btnZoomOut.setPreferredSize(new Dimension(23, 23));
        this.btnZoomOut.addActionListener(new ActionListener(this){
            private final JRViewer this$0;
            {
                this.this$0 = jRViewer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.b(actionEvent);
            }
        });
        this.btnZoomOut.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.btnZoomOut);
        this.cmbZoom.setEditable(true);
        this.cmbZoom.setToolTipText(this.getBundleString("zoom.ratio"));
        this.cmbZoom.setMaximumSize(new Dimension(80, 23));
        this.cmbZoom.setMinimumSize(new Dimension(80, 23));
        this.cmbZoom.setPreferredSize(new Dimension(80, 23));
        this.cmbZoom.addActionListener(new ActionListener(this){
            private final JRViewer this$0;
            {
                this.this$0 = jRViewer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.c(actionEvent);
            }
        });
        this.cmbZoom.addItemListener(new ItemListener(this){
            private final JRViewer this$0;
            {
                this.this$0 = jRViewer;
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                this.this$0.a(itemEvent);
            }
        });
        this.cmbZoom.addKeyListener(this.keyNavigationListener);
        this.tlbToolBar.add(this.cmbZoom);
        this.add((Component)this.tlbToolBar, "North");
        this.pnlMain.setLayout(new BorderLayout());
        this.pnlMain.addComponentListener(new ComponentAdapter(this){
            private final JRViewer this$0;
            {
                this.this$0 = jRViewer;
            }

            public void componentResized(ComponentEvent componentEvent) {
                this.this$0.a(componentEvent);
            }
        });
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.pnlInScroll.setLayout(new GridBagLayout());
        this.pnlPage.setLayout(new BorderLayout());
        this.pnlPage.setMinimumSize(new Dimension(100, 100));
        this.pnlPage.setPreferredSize(new Dimension(100, 100));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setMinimumSize(new Dimension(100, 120));
        this.jPanel4.setPreferredSize(new Dimension(100, 120));
        this.pnlLinks.setLayout(null);
        this.pnlLinks.setMinimumSize(new Dimension(5, 5));
        this.pnlLinks.setPreferredSize(new Dimension(5, 5));
        this.pnlLinks.setOpaque(false);
        this.pnlLinks.addMouseListener(new MouseAdapter(this){
            private final JRViewer this$0;
            {
                this.this$0 = jRViewer;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.this$0.a(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.this$0.b(mouseEvent);
            }
        });
        this.pnlLinks.addMouseMotionListener(new MouseMotionAdapter(this){
            private final JRViewer this$0;
            {
                this.this$0 = jRViewer;
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                this.this$0.d(mouseEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.pnlLinks, gridBagConstraints);
        this.jPanel5.setBackground(Color.gray);
        this.jPanel5.setMinimumSize(new Dimension(5, 5));
        this.jPanel5.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setMinimumSize(new Dimension(5, 5));
        this.jPanel6.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel7.setBackground(Color.gray);
        this.jPanel7.setMinimumSize(new Dimension(5, 5));
        this.jPanel7.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setBackground(Color.gray);
        this.jPanel8.setMinimumSize(new Dimension(5, 5));
        this.jPanel8.setPreferredSize(new Dimension(5, 5));
        this.jLabel1.setText("jLabel1");
        this.jPanel8.add(this.jLabel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel9.setMinimumSize(new Dimension(5, 5));
        this.jPanel9.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.jPanel9, gridBagConstraints);
        this.lblPage.setBackground(Color.white);
        this.lblPage.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.lblPage.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.lblPage, gridBagConstraints);
        this.pnlPage.add((Component)this.jPanel4, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlInScroll.add((Component)this.pnlPage, gridBagConstraints);
        this.scrollPane.setViewportView(this.pnlInScroll);
        this.pnlMain.add((Component)this.scrollPane, "Center");
        this.add((Component)this.pnlMain, "Center");
        this.pnlStatus.setLayout(new FlowLayout(1, 0, 0));
        this.lblStatus.setFont(new Font("Dialog", 1, 10));
        this.lblStatus.setText("Page i of n");
        this.pnlStatus.add(this.lblStatus);
        this.add((Component)this.pnlStatus, "South");
        this.addKeyListener(this.keyNavigationListener);
    }

    public void a(ActionEvent actionEvent) {
        try {
            int n2 = Integer.parseInt(this.txtGoTo.getText());
            if (n2 != this.pageIndex + 1 && n2 > 0 && n2 <= this.a.getPages().size()) {
                this.setPageIndex(n2 - 1);
                this.refreshPage();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void a(ItemEvent itemEvent) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
    }

    public void a(ComponentEvent componentEvent) {
        if (this.btnFitPage.isSelected()) {
            this.fitPage();
            this.btnFitPage.setSelected(true);
        } else if (this.btnFitWidth.isSelected()) {
            this.setRealZoomRatio(((float)this.pnlInScroll.getVisibleRect().getWidth() - 20.0f) / (float)this.a.getPageWidth());
            this.btnFitWidth.setSelected(true);
        }
    }

    public void k(ActionEvent actionEvent) {
        if (this.btnActualSize.isSelected()) {
            this.btnFitPage.setSelected(false);
            this.btnFitWidth.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.setZoomRatio(1.0f);
            this.btnActualSize.setSelected(true);
        }
    }

    public void m(ActionEvent actionEvent) {
        if (this.btnFitWidth.isSelected()) {
            this.btnActualSize.setSelected(false);
            this.btnFitPage.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.setRealZoomRatio(((float)this.pnlInScroll.getVisibleRect().getWidth() - 20.0f) / (float)this.a.getPageWidth());
            this.btnFitWidth.setSelected(true);
        }
    }

    public void g(ActionEvent actionEvent) {
        if (this.btnFitPage.isSelected()) {
            this.btnActualSize.setSelected(false);
            this.btnFitWidth.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.fitPage();
            this.btnFitPage.setSelected(true);
        }
    }

    public void h(ActionEvent actionEvent) {
        int n2;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setLocale(this.getLocale());
        jFileChooser.updateUI();
        for (n2 = 0; n2 < this.saveContributors.size(); ++n2) {
            jFileChooser.addChoosableFileFilter((JRSaveContributor)this.saveContributors.get(n2));
        }
        if (this.saveContributors.size() > 0) {
            jFileChooser.setFileFilter((JRSaveContributor)this.saveContributors.get(0));
        }
        if ((n2 = jFileChooser.showSaveDialog(this)) == 0) {
            FileFilter fileFilter = jFileChooser.getFileFilter();
            File file = jFileChooser.getSelectedFile();
            JRSaveContributor jRSaveContributor = null;
            if (fileFilter instanceof JRSaveContributor) {
                jRSaveContributor = (JRSaveContributor)fileFilter;
            } else {
                int n3 = 0;
                while (jRSaveContributor == null && n3 < this.saveContributors.size()) {
                    if ((jRSaveContributor = (JRSaveContributor)this.saveContributors.get(n3++)).accept(file)) continue;
                    jRSaveContributor = null;
                }
                if (jRSaveContributor == null) {
                    jRSaveContributor = new JRPrintSaveContributor();
                }
            }
            try {
                jRSaveContributor.save(this.a, file);
            }
            catch (JRException jRException) {
                jRException.printStackTrace();
                JOptionPane.showMessageDialog(this, this.getBundleString("error.saving"));
            }
        }
    }

    public void d(MouseEvent mouseEvent) {
        Container container = this.pnlInScroll.getParent();
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            Point point = jViewport.getViewPosition();
            int n2 = point.x - (mouseEvent.getX() - this.downX);
            int n3 = point.y - (mouseEvent.getY() - this.downY);
            int n4 = this.pnlInScroll.getWidth() - jViewport.getWidth();
            int n5 = this.pnlInScroll.getHeight() - jViewport.getHeight();
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > n4) {
                n2 = n4;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 > n5) {
                n3 = n5;
            }
            jViewport.setViewPosition(new Point(n2, n3));
        }
    }

    public void b(MouseEvent mouseEvent) {
        this.pnlLinks.setCursor(new Cursor(0));
    }

    public void a(MouseEvent mouseEvent) {
        this.pnlLinks.setCursor(new Cursor(13));
        this.downX = mouseEvent.getX();
        this.downY = mouseEvent.getY();
    }

    public void n(ActionEvent actionEvent) {
        Thread thread = new Thread(new Runnable(this){
            private final JRViewer this$0;
            {
                this.this$0 = jRViewer;
            }

            public void run() {
                try {
                    JasperPrintManager.printReport(this.this$0.a, true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(this.this$0, this.this$0.getBundleString("error.printing"));
                }
            }
        });
        thread.start();
    }

    public void l(ActionEvent actionEvent) {
        this.setPageIndex(this.a.getPages().size() - 1);
        this.refreshPage();
    }

    public void j(ActionEvent actionEvent) {
        this.setPageIndex(this.pageIndex + 1);
        this.refreshPage();
    }

    public void d(ActionEvent actionEvent) {
        this.setPageIndex(this.pageIndex - 1);
        this.refreshPage();
    }

    public void f(ActionEvent actionEvent) {
        this.setPageIndex(0);
        this.refreshPage();
    }

    public void i(ActionEvent actionEvent) {
        if (this.type == 1) {
            try {
                this.loadReport(this.reportFileName, this.isXML);
            }
            catch (JRException jRException) {
                jRException.printStackTrace();
                this.a = null;
                this.setPageIndex(0);
                this.refreshPage();
                JOptionPane.showMessageDialog(this, this.getBundleString("error.loading"));
            }
            this.forceRefresh();
        }
    }

    public void forceRefresh() {
        this.zoom = 0.0f;
        this.realZoom = 0.0f;
        this.setZoomRatio(1.0f);
    }

    public void e(ActionEvent actionEvent) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int n2 = (int)(100.0f * this.getZoomRatio());
        int n3 = Arrays.binarySearch(this.zooms, n2);
        if (n3 < 0) {
            this.setZoomRatio((float)this.zooms[-n3 - 1] / 100.0f);
        } else if (n3 < this.cmbZoom.getModel().getSize() - 1) {
            this.setZoomRatio((float)this.zooms[n3 + 1] / 100.0f);
        }
    }

    public void b(ActionEvent actionEvent) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int n2 = (int)(100.0f * this.getZoomRatio());
        int n3 = Arrays.binarySearch(this.zooms, n2);
        if (n3 > 0) {
            this.setZoomRatio((float)this.zooms[n3 - 1] / 100.0f);
        } else if (n3 < -1) {
            this.setZoomRatio((float)this.zooms[-n3 - 2] / 100.0f);
        }
    }

    public void c(ActionEvent actionEvent) {
        float f2 = this.getZoomRatio();
        if (f2 < this.MIN_ZOOM) {
            f2 = this.MIN_ZOOM;
        }
        if (f2 > this.MAX_ZOOM) {
            f2 = this.MAX_ZOOM;
        }
        this.setZoomRatio(f2);
    }

    public void c(MouseEvent mouseEvent) {
        JPanel jPanel = (JPanel)mouseEvent.getSource();
        JRPrintHyperlink jRPrintHyperlink = (JRPrintHyperlink)this.linksMap.get(jPanel);
        this.hyperlinkClicked(jRPrintHyperlink);
    }

    public void hyperlinkClicked(JRPrintHyperlink jRPrintHyperlink) {
        try {
            JRHyperlinkListener jRHyperlinkListener = null;
            for (int i2 = 0; i2 < this.hyperlinkListeners.size(); ++i2) {
                jRHyperlinkListener = (JRHyperlinkListener)this.hyperlinkListeners.get(i2);
                jRHyperlinkListener.gotoHyperlink(jRPrintHyperlink);
            }
        }
        catch (JRException jRException) {
            jRException.printStackTrace();
            JOptionPane.showMessageDialog(this, this.getBundleString("error.hyperlink"));
        }
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    private void setPageIndex(int n2) {
        if (this.a != null && this.a.getPages() != null && this.a.getPages().size() > 0) {
            if (n2 >= 0 && n2 < this.a.getPages().size()) {
                this.pageIndex = n2;
                this.pageError = false;
                this.btnFirst.setEnabled(this.pageIndex > 0);
                this.btnPrevious.setEnabled(this.pageIndex > 0);
                this.btnNext.setEnabled(this.pageIndex < this.a.getPages().size() - 1);
                this.btnLast.setEnabled(this.pageIndex < this.a.getPages().size() - 1);
                this.txtGoTo.setEnabled(this.btnFirst.isEnabled() || this.btnLast.isEnabled());
                this.txtGoTo.setText("" + (this.pageIndex + 1));
                this.lblStatus.setText(MessageFormat.format(this.getBundleString("page"), new Integer(this.pageIndex + 1), new Integer(this.a.getPages().size())));
            }
        } else {
            this.btnFirst.setEnabled(false);
            this.btnPrevious.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.txtGoTo.setEnabled(false);
            this.txtGoTo.setText("");
            this.lblStatus.setText("");
        }
    }

    public void loadReport(String string, boolean bl2) throws JRException {
        this.a = bl2 ? JRPrintXmlLoader.load(string) : (JasperPrint)JRLoader.loadObject(string);
        this.type = 1;
        this.isXML = bl2;
        this.reportFileName = string;
        this.btnReload.setEnabled(true);
        this.setPageIndex(0);
    }

    public void loadReport(InputStream inputStream, boolean bl2) throws JRException {
        this.a = bl2 ? JRPrintXmlLoader.load(inputStream) : (JasperPrint)JRLoader.loadObject(inputStream);
        this.type = 2;
        this.isXML = bl2;
        this.btnReload.setEnabled(false);
        this.setPageIndex(0);
    }

    public void loadReport(JasperPrint jasperPrint) {
        this.a = jasperPrint;
        this.type = 3;
        this.isXML = false;
        this.btnReload.setEnabled(false);
        this.setPageIndex(0);
    }

    public void refreshPage() {
        long l2;
        if (this.a == null || this.a.getPages() == null || this.a.getPages().size() == 0) {
            this.pnlPage.setVisible(false);
            this.btnSave.setEnabled(false);
            this.btnPrint.setEnabled(false);
            this.btnActualSize.setEnabled(false);
            this.btnFitPage.setEnabled(false);
            this.btnFitWidth.setEnabled(false);
            this.btnZoomIn.setEnabled(false);
            this.btnZoomOut.setEnabled(false);
            this.cmbZoom.setEnabled(false);
            if (this.a != null) {
                JOptionPane.showMessageDialog(this, this.getBundleString("no.pages"));
            }
            return;
        }
        this.pnlPage.setVisible(true);
        this.btnSave.setEnabled(true);
        this.btnPrint.setEnabled(true);
        this.btnActualSize.setEnabled(true);
        this.btnFitPage.setEnabled(true);
        this.btnFitWidth.setEnabled(true);
        this.btnZoomIn.setEnabled(this.zoom < this.MAX_ZOOM);
        this.btnZoomOut.setEnabled(this.zoom > this.MIN_ZOOM);
        this.cmbZoom.setEnabled(true);
        Dimension dimension = new Dimension((int)((float)this.a.getPageWidth() * this.realZoom) + 8, (int)((float)this.a.getPageHeight() * this.realZoom) + 8);
        this.pnlPage.setMaximumSize(dimension);
        this.pnlPage.setMinimumSize(dimension);
        this.pnlPage.setPreferredSize(dimension);
        long l3 = JRProperties.getLongProperty(VIEWER_RENDER_BUFFER_MAX_SIZE);
        boolean bl2 = l3 <= 0L ? false : (l2 = JRPrinterAWT.getImageSize(this.a, this.realZoom)) <= l3;
        this.lblPage.setRenderImage(bl2);
        if (bl2) {
            this.setPageImage();
        }
        this.pnlLinks.removeAll();
        this.linksMap = new HashMap();
        this.createHyperlinks();
        if (!bl2) {
            this.lblPage.setIcon(null);
            this.pnlMain.validate();
            this.pnlMain.repaint();
        }
    }

    public void setPageImage() {
        Image image;
        if (this.pageError) {
            image = this.getPageErrorImage();
        } else {
            try {
                image = JasperPrintManager.printPageToImage(this.a, this.pageIndex, this.realZoom);
            }
            catch (Exception exception) {
                this.pageError = true;
                exception.printStackTrace();
                image = this.getPageErrorImage();
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("error.displaying"));
            }
        }
        ImageIcon imageIcon = new ImageIcon(image);
        this.lblPage.setIcon(imageIcon);
    }

    public Image getPageErrorImage() {
        BufferedImage bufferedImage = new BufferedImage((int)((float)this.a.getPageWidth() * this.realZoom) + 1, (int)((float)this.a.getPageHeight() * this.realZoom) + 1, 1);
        Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(this.realZoom, this.realZoom);
        graphics2D.transform(affineTransform);
        this.drawPageError(graphics2D);
        return bufferedImage;
    }

    public void createHyperlinks() {
        List list = this.a.getPages();
        JRPrintPage jRPrintPage = (JRPrintPage)list.get(this.pageIndex);
        this.createHyperlinks(jRPrintPage.getElements(), 0, 0);
    }

    public void createHyperlinks(List list, int n2, int n3) {
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object;
                boolean bl2;
                JRRenderable jRRenderable;
                JRPrintElement jRPrintElement = (JRPrintElement)iterator.next();
                JRImageMapRenderer jRImageMapRenderer = null;
                if (jRPrintElement instanceof JRPrintImage && (jRRenderable = ((JRPrintImage)jRPrintElement).getRenderer()) instanceof JRImageMapRenderer) {
                    jRImageMapRenderer = (JRImageMapRenderer)jRRenderable;
                }
                boolean bl3 = jRImageMapRenderer != null;
                JRPrintHyperlink jRPrintHyperlink = null;
                if (!bl3 && jRPrintElement instanceof JRPrintHyperlink) {
                    jRPrintHyperlink = (JRPrintHyperlink)((Object)jRPrintElement);
                }
                boolean bl4 = bl2 = jRPrintHyperlink != null && jRPrintHyperlink.getHyperlinkType() != 1;
                if (bl2 || bl3) {
                    Object object2;
                    if (bl2) {
                        object = new JPanel();
                        ((Component)object).addMouseListener(this.mouseListener);
                    } else {
                        object2 = new Rectangle(0, 0, jRPrintElement.getWidth(), jRPrintElement.getHeight());
                        object = new ImageMapPanel(this, (Rectangle)object2, jRImageMapRenderer);
                    }
                    if (bl2) {
                        ((Component)object).setCursor(new Cursor(12));
                    }
                    ((Component)object).setLocation((int)((float)(jRPrintElement.getX() + n2) * this.realZoom), (int)((float)(jRPrintElement.getY() + n3) * this.realZoom));
                    ((Component)object).setSize((int)((float)jRPrintElement.getWidth() * this.realZoom), (int)((float)jRPrintElement.getHeight() * this.realZoom));
                    ((JComponent)object).setOpaque(false);
                    object2 = bl2 ? this.getHyperlinkTooltip(jRPrintHyperlink) : "";
                    ((JComponent)object).setToolTipText((String)object2);
                    this.pnlLinks.add((Component)object);
                    this.linksMap.put(object, jRPrintElement);
                }
                if (!(jRPrintElement instanceof JRPrintFrame)) continue;
                object = (JRPrintFrame)jRPrintElement;
                int n4 = n2 + object.getX() + object.getLineBox().getLeftPadding();
                int n5 = n3 + object.getY() + object.getLineBox().getTopPadding();
                this.createHyperlinks(object.getElements(), n4, n5);
            }
        }
    }

    public String getHyperlinkTooltip(JRPrintHyperlink jRPrintHyperlink) {
        String string = jRPrintHyperlink.getHyperlinkTooltip();
        if (string == null) {
            string = this.getFallbackTooltip(jRPrintHyperlink);
        }
        return string;
    }

    public String getFallbackTooltip(JRPrintHyperlink jRPrintHyperlink) {
        String string = null;
        switch (jRPrintHyperlink.getHyperlinkType()) {
            case 2: {
                string = jRPrintHyperlink.getHyperlinkReference();
                break;
            }
            case 3: {
                if (jRPrintHyperlink.getHyperlinkAnchor() == null) break;
                string = "#" + jRPrintHyperlink.getHyperlinkAnchor();
                break;
            }
            case 4: {
                if (jRPrintHyperlink.getHyperlinkPage() == null) break;
                string = "#page " + jRPrintHyperlink.getHyperlinkPage();
                break;
            }
            case 5: {
                string = "";
                if (jRPrintHyperlink.getHyperlinkReference() != null) {
                    string = string + jRPrintHyperlink.getHyperlinkReference();
                }
                if (jRPrintHyperlink.getHyperlinkAnchor() == null) break;
                string = string + "#" + jRPrintHyperlink.getHyperlinkAnchor();
                break;
            }
            case 6: {
                string = "";
                if (jRPrintHyperlink.getHyperlinkReference() != null) {
                    string = string + jRPrintHyperlink.getHyperlinkReference();
                }
                if (jRPrintHyperlink.getHyperlinkPage() == null) break;
                string = string + "#page " + jRPrintHyperlink.getHyperlinkPage();
                break;
            }
        }
        return string;
    }

    private void emptyContainer(Container container) {
        Component[] componentArray = container.getComponents();
        if (componentArray != null) {
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                if (!(componentArray[i2] instanceof Container)) continue;
                this.emptyContainer((Container)componentArray[i2]);
            }
        }
        componentArray = null;
        container.removeAll();
        container = null;
    }

    private float getZoomRatio() {
        float f2 = this.zoom;
        try {
            f2 = this.zoomDecimalFormat.parse(String.valueOf(this.cmbZoom.getEditor().getItem())).floatValue() / 100.0f;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return f2;
    }

    public void setZoomRatio(float f2) {
        if (f2 > 0.0f) {
            this.cmbZoom.getEditor().setItem(this.zoomDecimalFormat.format(f2 * 100.0f) + "%");
            if (this.zoom != f2) {
                this.zoom = f2;
                this.realZoom = this.zoom * (float)this.screenResolution / 72.0f;
                this.refreshPage();
            }
        }
    }

    private void setRealZoomRatio(float f2) {
        if (f2 > 0.0f && this.realZoom != f2) {
            this.zoom = f2 * 72.0f / (float)this.screenResolution;
            this.realZoom = f2;
            this.cmbZoom.getEditor().setItem(this.zoomDecimalFormat.format(this.zoom * 100.0f) + "%");
            this.refreshPage();
        }
    }

    public void setFitWidthZoomRatio() {
        this.setRealZoomRatio(((float)this.pnlInScroll.getVisibleRect().getWidth() - 20.0f) / (float)this.a.getPageWidth());
    }

    public void setFitPageZoomRatio() {
        this.setRealZoomRatio(((float)this.pnlInScroll.getVisibleRect().getHeight() - 20.0f) / (float)this.a.getPageHeight());
    }

    public JRGraphics2DExporter getGraphics2DExporter() throws JRException {
        return new JRGraphics2DExporter();
    }

    public void paintPage(Graphics2D graphics2D) {
        if (this.pageError) {
            this.paintPageError(graphics2D);
            return;
        }
        try {
            if (this.exporter == null) {
                this.exporter = this.getGraphics2DExporter();
            } else {
                this.exporter.reset();
            }
            this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, this.a);
            this.exporter.setParameter(JRGraphics2DExporterParameter.GRAPHICS_2D, graphics2D.create());
            this.exporter.setParameter(JRExporterParameter.PAGE_INDEX, new Integer(this.pageIndex));
            this.exporter.setParameter(JRGraphics2DExporterParameter.ZOOM_RATIO, new Float(this.realZoom));
            this.exporter.setParameter(JRExporterParameter.OFFSET_X, new Integer(1));
            this.exporter.setParameter(JRExporterParameter.OFFSET_Y, new Integer(1));
            this.exporter.exportReport();
        }
        catch (Exception exception) {
            this.pageError = true;
            exception.printStackTrace();
            this.paintPageError(graphics2D);
            SwingUtilities.invokeLater(new Runnable(this){
                private final JRViewer this$0;
                {
                    this.this$0 = jRViewer;
                }

                public void run() {
                    JOptionPane.showMessageDialog(this.this$0, this.this$0.getBundleString("error.displaying"));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintPageError(Graphics2D graphics2D) {
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate(1.0, 1.0);
        affineTransform2.scale(this.realZoom, this.realZoom);
        graphics2D.transform(affineTransform2);
        try {
            this.drawPageError(graphics2D);
        }
        finally {
            graphics2D.setTransform(affineTransform);
        }
    }

    public void drawPageError(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.a.getPageWidth() + 1, this.a.getPageHeight() + 1);
    }

    public void keyNavigate(KeyEvent keyEvent) {
        boolean bl2 = true;
        switch (keyEvent.getKeyCode()) {
            case 34: 
            case 40: {
                this.dnNavigate(keyEvent);
                break;
            }
            case 33: 
            case 38: {
                this.upNavigate(keyEvent);
                break;
            }
            case 36: {
                this.homeEndNavigate(0);
                break;
            }
            case 35: {
                this.homeEndNavigate(this.a.getPages().size() - 1);
                break;
            }
            default: {
                bl2 = false;
            }
        }
        if (bl2) {
            this.refreshPage();
        }
    }

    private void dnNavigate(KeyEvent keyEvent) {
        int n2 = this.scrollPane.getVerticalScrollBar().getValue();
        this.scrollPane.dispatchEvent(keyEvent);
        if ((this.scrollPane.getViewport().getHeight() > this.pnlPage.getHeight() || this.scrollPane.getVerticalScrollBar().getValue() == n2) && this.pageIndex < this.a.getPages().size() - 1) {
            this.setPageIndex(this.pageIndex + 1);
            if (this.scrollPane.isEnabled()) {
                this.scrollPane.getVerticalScrollBar().setValue(0);
            }
        }
    }

    private void upNavigate(KeyEvent keyEvent) {
        if ((this.scrollPane.getViewport().getHeight() > this.pnlPage.getHeight() || this.scrollPane.getVerticalScrollBar().getValue() == 0) && this.pageIndex > 0) {
            this.setPageIndex(this.pageIndex - 1);
            if (this.scrollPane.isEnabled()) {
                this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum());
            }
        } else {
            this.scrollPane.dispatchEvent(keyEvent);
        }
    }

    private void homeEndNavigate(int n2) {
        this.setPageIndex(n2);
        if (this.scrollPane.isEnabled()) {
            this.scrollPane.getVerticalScrollBar().setValue(0);
        }
    }

    private void fitPage() {
        float f2;
        float f3 = ((float)this.pnlInScroll.getVisibleRect().getHeight() - 20.0f) / (float)this.a.getPageHeight();
        this.setRealZoomRatio(f3 < (f2 = ((float)this.pnlInScroll.getVisibleRect().getWidth() - 20.0f) / (float)this.a.getPageWidth()) ? f3 : f2);
    }

    public class PageRenderer
    extends JLabel {
        private static final long serialVersionUID = 10200L;
        private boolean renderImage;
        public JRViewer a;
        private final JRViewer this$0;

        public PageRenderer(JRViewer jRViewer, JRViewer jRViewer2) {
            this.this$0 = jRViewer;
            this.a = null;
            this.a = jRViewer2;
        }

        public void paintComponent(Graphics graphics) {
            if (this.isRenderImage()) {
                super.paintComponent(graphics);
            } else {
                this.a.paintPage((Graphics2D)graphics.create());
            }
        }

        public boolean isRenderImage() {
            return this.renderImage;
        }

        public void setRenderImage(boolean bl2) {
            this.renderImage = bl2;
        }
    }

    protected class ImageMapPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = 10200L;
        public final List imageAreaHyperlinks;
        private final JRViewer this$0;

        public ImageMapPanel(JRViewer jRViewer, Rectangle rectangle, JRImageMapRenderer jRImageMapRenderer) {
            this.this$0 = jRViewer;
            try {
                this.imageAreaHyperlinks = jRImageMapRenderer.getImageAreaHyperlinks(rectangle);
            }
            catch (JRException jRException) {
                throw new JRRuntimeException(jRException);
            }
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            String string = null;
            JRPrintImageAreaHyperlink jRPrintImageAreaHyperlink = this.getImageMapArea(mouseEvent);
            if (jRPrintImageAreaHyperlink != null) {
                string = this.this$0.getHyperlinkTooltip(jRPrintImageAreaHyperlink.getHyperlink());
            }
            if (string == null) {
                string = super.getToolTipText(mouseEvent);
            }
            return string;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            JRPrintImageAreaHyperlink jRPrintImageAreaHyperlink = this.getImageMapArea(mouseEvent);
            if (jRPrintImageAreaHyperlink != null && jRPrintImageAreaHyperlink.getHyperlink().getHyperlinkType() != 1) {
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            } else {
                mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
            }
        }

        public JRPrintImageAreaHyperlink getImageMapArea(MouseEvent mouseEvent) {
            return this.getImageMapArea((int)((float)mouseEvent.getX() / this.this$0.realZoom), (int)((float)mouseEvent.getY() / this.this$0.realZoom));
        }

        public JRPrintImageAreaHyperlink getImageMapArea(int n2, int n3) {
            JRPrintImageAreaHyperlink jRPrintImageAreaHyperlink = null;
            Iterator iterator = this.imageAreaHyperlinks.iterator();
            while (jRPrintImageAreaHyperlink == null && iterator.hasNext()) {
                JRPrintImageAreaHyperlink jRPrintImageAreaHyperlink2 = (JRPrintImageAreaHyperlink)iterator.next();
                if (!jRPrintImageAreaHyperlink2.getArea().containsPoint(n2, n3)) continue;
                jRPrintImageAreaHyperlink = jRPrintImageAreaHyperlink2;
            }
            return jRPrintImageAreaHyperlink;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            JRPrintImageAreaHyperlink jRPrintImageAreaHyperlink = this.getImageMapArea(mouseEvent);
            if (jRPrintImageAreaHyperlink != null) {
                this.this$0.hyperlinkClicked(jRPrintImageAreaHyperlink.getHyperlink());
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

