/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.event.ActionEvent;
import java.io.InputStream;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.view.JRViewer;

public class JRDesignViewer
extends JRViewer {
    private static final long serialVersionUID = 10200L;

    public JRDesignViewer(String string, boolean bl2) throws JRException {
        super(string, bl2);
        this.hideUnusedComponents();
    }

    public JRDesignViewer(InputStream inputStream, boolean bl2) throws JRException {
        super(inputStream, bl2);
        this.hideUnusedComponents();
    }

    public JRDesignViewer(JRReport jRReport) throws JRException {
        super(new ReportConverter(jRReport, false).getJasperPrint());
        this.hideUnusedComponents();
    }

    private void hideUnusedComponents() {
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPrevious.setVisible(false);
        this.btnNext.setVisible(false);
        this.txtGoTo.setVisible(false);
        this.pnlStatus.setVisible(false);
    }

    public void i(ActionEvent actionEvent) {
        if (this.type == 1) {
            try {
                this.loadReport(this.reportFileName, this.isXML);
                this.forceRefresh();
            }
            catch (JRException jRException) {
                jRException.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error loading report design. See console for details.");
            }
        }
    }

    public void loadReport(String string, boolean bl2) throws JRException {
        if (bl2) {
            JasperDesign jasperDesign = JRXmlLoader.load(string);
            this.setReport(jasperDesign);
        } else {
            this.setReport((JRReport)JRLoader.loadObject(string));
        }
        this.type = 1;
        this.isXML = bl2;
        this.reportFileName = string;
    }

    public void loadReport(InputStream inputStream, boolean bl2) throws JRException {
        if (bl2) {
            JasperDesign jasperDesign = JRXmlLoader.load(inputStream);
            this.setReport(jasperDesign);
        } else {
            this.setReport((JRReport)JRLoader.loadObject(inputStream));
        }
        this.type = 2;
        this.isXML = bl2;
    }

    public void loadReport(JRReport jRReport) throws JRException {
        this.setReport(jRReport);
        this.type = 3;
        this.isXML = false;
    }

    private void setReport(JRReport jRReport) throws JRException {
        this.a = new ReportConverter(jRReport, false).getJasperPrint();
    }

    public JRGraphics2DExporter getGraphics2DExporter() throws JRException {
        return new JRGraphics2DExporter(this){
            private final JRDesignViewer this$0;
            {
                this.this$0 = jRDesignViewer;
            }

            public void setDrawers() {
                super.setDrawers();
                this.frameDrawer.setClip(true);
            }
        };
    }
}

