/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap.xmla;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.olap.result.JROlapCell;
import net.sf.jasperreports.olap.result.JROlapResult;
import net.sf.jasperreports.olap.result.JROlapResultAxis;
import net.sf.jasperreports.olap.xmla.JRXmlaCell;
import net.sf.jasperreports.olap.xmla.JRXmlaResultAxis;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRXmlaResult
implements JROlapResult {
    private static final Log log = LogFactory.getLog(a == null ? (a = JRXmlaResult.a("net.sf.jasperreports.olap.xmla.JRXmlaResult")) : a);
    private List axesList = new ArrayList();
    private JRXmlaResultAxis[] axes;
    private int[] cellOrdinalFactors;
    private final List cells = new ArrayList();
    public static Class a;

    public JROlapResultAxis[] getAxes() {
        return this.ensureAxisArray();
    }

    public JROlapCell getCell(int[] nArray) {
        int n2 = this.getCellOrdinal(nArray);
        return (JROlapCell)this.cells.get(n2);
    }

    public int getCellOrdinal(int[] nArray) {
        this.ensureCellOrdinalFactors();
        if (nArray.length != this.axes.length) {
            throw new JRRuntimeException("Number of axis positions (" + nArray.length + ") doesn't match the number of axes (" + this.axes.length + ")");
        }
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n2 += this.cellOrdinalFactors[i2] * nArray[i2];
        }
        return n2;
    }

    public void addAxis(JRXmlaResultAxis jRXmlaResultAxis) {
        this.axesList.add(jRXmlaResultAxis);
        this.resetAxisArray();
    }

    public JRXmlaResultAxis getAxisByName(String string) {
        JRXmlaResultAxis jRXmlaResultAxis = null;
        Iterator iterator = this.axesList.iterator();
        while (jRXmlaResultAxis == null && iterator.hasNext()) {
            JRXmlaResultAxis jRXmlaResultAxis2 = (JRXmlaResultAxis)iterator.next();
            if (!jRXmlaResultAxis2.getAxisName().equals(string)) continue;
            jRXmlaResultAxis = jRXmlaResultAxis2;
        }
        return jRXmlaResultAxis;
    }

    public JRXmlaResultAxis[] ensureAxisArray() {
        if (this.axes == null) {
            this.axes = new JRXmlaResultAxis[this.axesList.size()];
            this.axes = this.axesList.toArray(this.axes);
        }
        return this.axes;
    }

    public void ensureCellOrdinalFactors() {
        this.ensureAxisArray();
        if (this.cellOrdinalFactors == null) {
            int n2 = this.axes.length;
            this.cellOrdinalFactors = new int[n2];
            this.cellOrdinalFactors[0] = 1;
            for (int i2 = 1; i2 < n2; ++i2) {
                this.cellOrdinalFactors[i2] = this.cellOrdinalFactors[i2 - 1] * this.axes[i2 - 1].getTupleCount();
            }
        }
    }

    public void resetAxisArray() {
        this.axes = null;
        this.cellOrdinalFactors = null;
    }

    public void setCell(JRXmlaCell jRXmlaCell, int n2) {
        int n3 = this.cells.size();
        if (n2 == -1 || n2 == n3) {
            this.cells.add(jRXmlaCell);
        } else if (n2 > n3) {
            for (int i2 = n3; i2 < n2; ++i2) {
                this.cells.add(null);
            }
            this.cells.add(jRXmlaCell);
        } else {
            if (log.isWarnEnabled()) {
                log.warn("Overwriting cell at ordinal " + n2);
            }
            this.cells.set(n2, jRXmlaCell);
        }
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

