/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.util.Map;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.design.JRDesignFont;
import net.sf.jasperreports.engine.design.JRValidationException;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.xml.sax.Attributes;

public abstract class JRFontFactory
extends JRBaseFactory {
    public abstract JRFont getFont();

    public Object createObject(Attributes attributes) {
        JRFont jRFont = this.getFont();
        JRXmlLoader jRXmlLoader = (JRXmlLoader)this.digester.peek(this.digester.getCount() - 1);
        JasperDesign jasperDesign = (JasperDesign)this.digester.peek(this.digester.getCount() - 2);
        if (attributes.getValue("reportFont") != null) {
            Map map = jasperDesign.getFontsMap();
            if (!map.containsKey(attributes.getValue("reportFont"))) {
                jRXmlLoader.addError(new JRValidationException("Unknown report font : " + attributes.getValue("reportFont"), jRFont));
            }
            jRFont.setReportFont((JRReportFont)map.get(attributes.getValue("reportFont")));
        }
        if (attributes.getValue("fontName") != null) {
            jRFont.setFontName(attributes.getValue("fontName"));
        }
        if (attributes.getValue("isBold") != null) {
            jRFont.setBold(Boolean.valueOf(attributes.getValue("isBold")));
        }
        if (attributes.getValue("isItalic") != null) {
            jRFont.setItalic(Boolean.valueOf(attributes.getValue("isItalic")));
        }
        if (attributes.getValue("isUnderline") != null) {
            jRFont.setUnderline(Boolean.valueOf(attributes.getValue("isUnderline")));
        }
        if (attributes.getValue("isStrikeThrough") != null) {
            jRFont.setStrikeThrough(Boolean.valueOf(attributes.getValue("isStrikeThrough")));
        }
        if (attributes.getValue("size") != null) {
            jRFont.setFontSize(Integer.parseInt(attributes.getValue("size")));
        }
        if (attributes.getValue("pdfFontName") != null) {
            jRFont.setPdfFontName(attributes.getValue("pdfFontName"));
        }
        if (attributes.getValue("pdfEncoding") != null) {
            jRFont.setPdfEncoding(attributes.getValue("pdfEncoding"));
        }
        if (attributes.getValue("isPdfEmbedded") != null) {
            jRFont.setPdfEmbedded(Boolean.valueOf(attributes.getValue("isPdfEmbedded")));
        }
        return jRFont;
    }

    public static class ChartFontFactory
    extends JRFontFactory {
        public JRFont getFont() {
            return new JRDesignFont();
        }
    }

    public static class TextElementFontFactory
    extends JRFontFactory {
        public JRFont getFont() {
            return (JRFont)this.digester.peek();
        }
    }
}

