/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class JRXmlWriteHelper {
    private final Writer writer;
    private final List indents;
    private int indent;
    private final List elementStack;
    private StringBuffer buffer;
    private StackElement lastElement;

    public JRXmlWriteHelper(Writer writer) {
        this.writer = writer;
        this.indents = new ArrayList();
        this.indent = 0;
        this.elementStack = new ArrayList();
        this.lastElement = null;
        this.clearBuffer();
    }

    public void writeProlog(String string) throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"" + string + "\"?>\n");
    }

    public void writePublicDoctype(String string, String string2, String string3) throws IOException {
        this.writer.write("<!DOCTYPE " + string + " PUBLIC \"" + string2 + "\" \"" + string3 + "\">\n\n");
    }

    public void startElement(String string) {
        ++this.indent;
        this.lastElement = new StackElement(string);
        this.elementStack.add(this.lastElement);
    }

    public void writeParents(boolean bl2) throws IOException {
        int n2 = this.elementStack.size();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            StackElement stackElement = (StackElement)this.elementStack.get(i2);
            if (stackElement.b) break;
            if (i2 < n2 - 1) {
                stackElement.b = true;
                continue;
            }
            stackElement.b |= bl2;
        }
        for (int i3 = i2 + 1; i3 < n2; ++i3) {
            StackElement stackElement = (StackElement)this.elementStack.get(i3);
            this.writeElementAttributes(stackElement, i3);
        }
    }

    public void writeCDATA(String string) throws IOException {
        if (string != null) {
            this.writeParents(true);
            this.buffer.append(this.getIndent(this.indent));
            this.buffer.append("<![CDATA[");
            this.buffer.append(string);
            this.buffer.append("]]>\n");
            this.flushBuffer();
        }
    }

    public void writeCDATAElement(String string, String string2) throws IOException {
        if (string2 != null) {
            this.writeParents(true);
            this.buffer.append(this.getIndent(this.indent));
            this.buffer.append('<');
            this.buffer.append(string);
            this.buffer.append("><![CDATA[");
            this.buffer.append(string2);
            this.buffer.append("]]></");
            this.buffer.append(string);
            this.buffer.append(">\n");
            this.flushBuffer();
        }
    }

    public void writeCDATAElement(String string, String string2, String string3, String string4) throws IOException {
        this.writeCDATAElement(string, string2, string3, (Object)string4);
    }

    public void writeCDATAElement(String string, String string2, String string3, Object object) throws IOException {
        if (string2 != null) {
            this.writeParents(true);
            this.buffer.append(this.getIndent(this.indent));
            this.buffer.append('<');
            this.buffer.append(string);
            if (object != null) {
                this.buffer.append(' ');
                this.buffer.append(string3);
                this.buffer.append("=\"");
                this.buffer.append(object);
                this.buffer.append("\"");
            }
            this.buffer.append("><![CDATA[");
            this.buffer.append(string2);
            this.buffer.append("]]></");
            this.buffer.append(string);
            this.buffer.append(">\n");
            this.flushBuffer();
        }
    }

    public void writeElementAttributes(StackElement stackElement, int n2) throws IOException {
        this.buffer.append(this.getIndent(n2));
        this.buffer.append('<');
        this.buffer.append(stackElement.c);
        Iterator iterator = stackElement.a.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            this.buffer.append(' ');
            this.buffer.append(attribute.b);
            this.buffer.append("=\"");
            this.buffer.append(attribute.a);
            this.buffer.append('\"');
        }
        if (stackElement.b) {
            this.buffer.append(">\n");
        } else {
            this.buffer.append("/>\n");
        }
        this.flushBuffer();
    }

    public void closeElement() throws IOException {
        this.closeElement(false);
    }

    public void closeElement(boolean bl2) throws IOException {
        --this.indent;
        if (bl2 && this.lastElement.a.size() == 0 && !this.lastElement.b) {
            this.clearBuffer();
        } else {
            this.writeParents(false);
            if (this.lastElement.b) {
                this.buffer.append(this.getIndent(this.indent));
                this.buffer.append("</");
                this.buffer.append(this.lastElement.c);
                this.buffer.append(">\n");
                this.flushBuffer();
            }
        }
        this.elementStack.remove(this.indent);
        this.lastElement = this.indent > 0 ? (StackElement)this.elementStack.get(this.indent - 1) : null;
    }

    public char[] getIndent(int n2) {
        if (n2 >= this.indents.size()) {
            for (int i2 = this.indents.size(); i2 <= n2; ++i2) {
                char[] cArray = new char[i2];
                Arrays.fill(cArray, '\t');
                this.indents.add(cArray);
            }
        }
        return (char[])this.indents.get(n2);
    }

    public void flushBuffer() throws IOException {
        this.writer.write(this.buffer.toString());
        this.clearBuffer();
    }

    public void clearBuffer() {
        this.buffer = new StringBuffer();
    }

    public void writeExpression(String string, JRExpression jRExpression, boolean bl2) throws IOException {
        this.writeExpression(string, jRExpression, bl2, null);
    }

    public void writeExpression(String string, JRExpression jRExpression, boolean bl2, String string2) throws IOException {
        if (jRExpression != null) {
            if (bl2 && (string2 == null || !string2.equals(jRExpression.getValueClassName()))) {
                this.writeCDATAElement(string, jRExpression.getText(), "class", jRExpression.getValueClassName());
            } else {
                this.writeCDATAElement(string, jRExpression.getText());
            }
        }
    }

    public void writeAttribute(String string, String string2) {
        this.lastElement.a(string, string2);
    }

    public void addAttribute(String string, String string2) {
        if (string2 != null) {
            this.writeAttribute(string, string2);
        }
    }

    public void addEncodedAttribute(String string, String string2) {
        if (string2 != null) {
            this.writeAttribute(string, JRStringUtil.xmlEncode(string2));
        }
    }

    public void addAttribute(String string, String string2, String string3) {
        if (string2 != null && !string2.equals(string3)) {
            this.writeAttribute(string, string2);
        }
    }

    public void addEncodedAttribute(String string, String string2, String string3) {
        if (string2 != null && !string2.equals(string3)) {
            this.writeAttribute(string, JRStringUtil.xmlEncode(string2));
        }
    }

    public void addAttribute(String string, Object object) {
        if (object != null) {
            this.writeAttribute(string, String.valueOf(object));
        }
    }

    public void addAttribute(String string, int n2) {
        this.writeAttribute(string, String.valueOf(n2));
    }

    public void addAttributePositive(String string, int n2) {
        if (n2 > 0) {
            this.writeAttribute(string, String.valueOf(n2));
        }
    }

    public void addAttribute(String string, float f2) {
        this.writeAttribute(string, String.valueOf(f2));
    }

    public void addAttribute(String string, float f2, float f3) {
        if (f2 != f3) {
            this.writeAttribute(string, String.valueOf(f2));
        }
    }

    public void addAttribute(String string, double d2) {
        this.writeAttribute(string, String.valueOf(d2));
    }

    public void addAttribute(String string, double d2, double d3) {
        if (d2 != d3) {
            this.writeAttribute(string, String.valueOf(d2));
        }
    }

    public void addAttribute(String string, int n2, int n3) {
        if (n2 != n3) {
            this.addAttribute(string, n2);
        }
    }

    public void addAttribute(String string, boolean bl2) {
        this.writeAttribute(string, String.valueOf(bl2));
    }

    public void addAttribute(String string, boolean bl2, boolean bl3) {
        if (bl2 != bl3) {
            this.addAttribute(string, bl2);
        }
    }

    public void addAttribute(String string, Color color) {
        if (color != null) {
            this.writeAttribute(string, "#" + JRColorUtil.getColorHexa(color));
        }
    }

    public void addAttribute(String string, Color color, Color color2) {
        if (color != null && color.getRGB() != color2.getRGB()) {
            this.addAttribute(string, color);
        }
    }

    public void addAttribute(String string, byte by2, Map map) {
        String string2 = (String)map.get(new Byte(by2));
        this.writeAttribute(string, string2);
    }

    public void addAttribute(String string, int n2, Map map) {
        String string2 = (String)map.get(new Integer(n2));
        this.writeAttribute(string, string2);
    }

    public void addAttribute(String string, byte by2, Map map, byte by3) {
        if (by2 != by3) {
            this.addAttribute(string, by2, map);
        }
    }

    public void addAttribute(String string, Object object, Map map) {
        if (object != null) {
            String string2 = (String)map.get(object);
            this.writeAttribute(string, string2);
        }
    }

    public void addAttribute(String string, Object object, Map map, Object object2) {
        if (!object.equals(object2)) {
            this.addAttribute(string, object, map);
        }
    }

    protected static class StackElement {
        public String c;
        public List a;
        public boolean b;

        public StackElement(String string) {
            this.c = string;
            this.a = new ArrayList();
            this.b = false;
        }

        public void a(String string, String string2) {
            this.a.add(new Attribute(string, string2));
        }
    }

    protected static class Attribute {
        public String b;
        public String a;

        public Attribute(String string, String string2) {
            this.b = string;
            this.a = string2;
        }
    }
}

