/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.w3c.tools.codec.Base64Decoder;
import org.w3c.tools.codec.Base64Encoder;
import org.w3c.tools.codec.Base64FormatException;

public class JRValueStringUtils {
    private static final Map serializers = JRValueStringUtils.getSerializers();
    private static final ValueSerializer defaultSerializer = new DefaultSerializer();
    public static Class j;
    public static Class f;
    public static Class k;
    public static Class l;
    public static Class e;
    public static Class i;
    public static Class a;
    public static Class d;
    public static Class b;
    public static Class g;
    public static Class h;
    public static Class n;
    public static Class m;
    public static Class c;

    public static String serialize(String string, Object object) {
        String string2;
        if (object == null) {
            string2 = null;
        } else {
            ValueSerializer valueSerializer = JRValueStringUtils.getSerializer(string);
            string2 = valueSerializer.serialize(object);
        }
        return string2;
    }

    public static Object deserialize(String string, String string2) {
        Object object;
        if (string2 == null) {
            object = null;
        } else {
            ValueSerializer valueSerializer = JRValueStringUtils.getSerializer(string);
            object = valueSerializer.deserialize(string2);
        }
        return object;
    }

    public static ValueSerializer getSerializer(String string) {
        ValueSerializer valueSerializer = (ValueSerializer)serializers.get(string);
        if (valueSerializer == null) {
            valueSerializer = defaultSerializer;
        }
        return valueSerializer;
    }

    private static Map getSerializers() {
        HashMap<String, ValueSerializer> hashMap = new HashMap<String, ValueSerializer>();
        hashMap.put((j == null ? (j = JRValueStringUtils.a("java.lang.String")) : j).getName(), new StringSerializer());
        hashMap.put((f == null ? (f = JRValueStringUtils.a("java.lang.Character")) : f).getName(), new CharacterSerializer());
        hashMap.put((k == null ? (k = JRValueStringUtils.a("java.lang.Boolean")) : k).getName(), new BooleanSerializer());
        hashMap.put((l == null ? (l = JRValueStringUtils.a("java.lang.Byte")) : l).getName(), new ByteSerializer());
        hashMap.put((e == null ? (e = JRValueStringUtils.a("java.lang.Short")) : e).getName(), new ShortSerializer());
        hashMap.put((i == null ? (i = JRValueStringUtils.a("java.lang.Integer")) : i).getName(), new IntegerSerializer());
        hashMap.put((a == null ? (a = JRValueStringUtils.a("java.lang.Long")) : a).getName(), new LongSerializer());
        hashMap.put((d == null ? (d = JRValueStringUtils.a("java.lang.Float")) : d).getName(), new FloatSerializer());
        hashMap.put((b == null ? (b = JRValueStringUtils.a("java.lang.Double")) : b).getName(), new DoubleSerializer());
        hashMap.put((g == null ? (g = JRValueStringUtils.a("java.math.BigInteger")) : g).getName(), new BigIntegerSerializer());
        hashMap.put((h == null ? (h = JRValueStringUtils.a("java.math.BigDecimal")) : h).getName(), new BigDecimalSerializer());
        hashMap.put((n == null ? (n = JRValueStringUtils.a("java.util.Date")) : n).getName(), new DateSerializer());
        hashMap.put((m == null ? (m = JRValueStringUtils.a("java.sql.Timestamp")) : m).getName(), new TimestampSerializer());
        hashMap.put((c == null ? (c = JRValueStringUtils.a("java.sql.Time")) : c).getName(), new TimeSerializer());
        return hashMap;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class DefaultSerializer
    implements ValueSerializer {
        public Object deserialize(String string) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Base64Decoder base64Decoder = new Base64Decoder(byteArrayInputStream, byteArrayOutputStream);
                base64Decoder.process();
                ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream2);
                return objectInputStream.readObject();
            }
            catch (IOException iOException) {
                throw new JRRuntimeException(iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JRRuntimeException(classNotFoundException);
            }
            catch (Base64FormatException base64FormatException) {
                throw new JRRuntimeException(base64FormatException);
            }
        }

        public String serialize(Object object) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                Base64Encoder base64Encoder = new Base64Encoder(byteArrayInputStream, byteArrayOutputStream2);
                base64Encoder.process();
                return new String(byteArrayOutputStream2.toByteArray(), "UTF-8");
            }
            catch (NotSerializableException notSerializableException) {
                throw new JRRuntimeException("Value is not serializable", notSerializableException);
            }
            catch (IOException iOException) {
                throw new JRRuntimeException(iOException);
            }
        }
    }

    protected static class TimeSerializer
    implements ValueSerializer {
        public Object deserialize(String string) {
            try {
                return Time.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JRRuntimeException("Error parsing Time data \"" + string + "\"", illegalArgumentException);
            }
        }

        public String serialize(Object object) {
            Time time = (Time)object;
            return time.toString();
        }
    }

    protected static class TimestampSerializer
    implements ValueSerializer {
        public Object deserialize(String string) {
            try {
                return Timestamp.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JRRuntimeException("Error parsing Timestamp data \"" + string + "\"", illegalArgumentException);
            }
        }

        public String serialize(Object object) {
            Timestamp timestamp = (Timestamp)object;
            return timestamp.toString();
        }
    }

    protected static class DateSerializer
    implements ValueSerializer {
        public Object deserialize(String string) {
            try {
                long l2 = Long.parseLong(string);
                return new Date(l2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("Error parsing Date data \"" + string + "\"", numberFormatException);
            }
        }

        public String serialize(Object object) {
            return Long.toString(((Date)object).getTime());
        }
    }

    protected static class BigDecimalSerializer
    implements ValueSerializer {
        public Object deserialize(String string) {
            try {
                return new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("Error parsing BigDecimal data \"" + string + "\"", numberFormatException);
            }
        }

        public String serialize(Object object) {
            return ((BigDecimal)object).toString();
        }
    }

    protected static class BigIntegerSerializer
    implements ValueSerializer {
        public Object deserialize(String string) {
            try {
                return new BigInteger(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("Error parsing BigInteger data \"" + string + "\"", numberFormatException);
            }
        }

        public String serialize(Object object) {
            return ((BigInteger)object).toString();
        }
    }

    protected static class DoubleSerializer
    implements ValueSerializer {
        public Object deserialize(String string) {
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("Error parsing Double data \"" + string + "\"", numberFormatException);
            }
        }

        public String serialize(Object object) {
            return ((Double)object).toString();
        }
    }

    protected static class FloatSerializer
    implements ValueSerializer {
        public Object deserialize(String string) {
            try {
                return Float.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("Error parsing Float data \"" + string + "\"", numberFormatException);
            }
        }

        public String serialize(Object object) {
            return ((Float)object).toString();
        }
    }

    protected static class LongSerializer
    implements ValueSerializer {
        public Object deserialize(String string) {
            try {
                return Long.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("Error parsing Long data \"" + string + "\"", numberFormatException);
            }
        }

        public String serialize(Object object) {
            return ((Long)object).toString();
        }
    }

    protected static class IntegerSerializer
    implements ValueSerializer {
        public Object deserialize(String string) {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("Error parsing Integer data \"" + string + "\"", numberFormatException);
            }
        }

        public String serialize(Object object) {
            return ((Integer)object).toString();
        }
    }

    protected static class ShortSerializer
    implements ValueSerializer {
        public Object deserialize(String string) {
            try {
                return Short.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("Error parsing Short data \"" + string + "\"", numberFormatException);
            }
        }

        public String serialize(Object object) {
            return ((Short)object).toString();
        }
    }

    protected static class ByteSerializer
    implements ValueSerializer {
        public Object deserialize(String string) {
            try {
                return Byte.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JRRuntimeException("Error parsing Byte data \"" + string + "\"", numberFormatException);
            }
        }

        public String serialize(Object object) {
            return ((Byte)object).toString();
        }
    }

    protected static class BooleanSerializer
    implements ValueSerializer {
        public Object deserialize(String string) {
            if (string.equals("true")) {
                return Boolean.TRUE;
            }
            if (string.equals("false")) {
                return Boolean.FALSE;
            }
            throw new JRRuntimeException("Unkown boolean data \"" + string + "\"");
        }

        public String serialize(Object object) {
            return (Boolean)object != false ? "true" : "false";
        }
    }

    protected static class CharacterSerializer
    implements ValueSerializer {
        public Object deserialize(String string) {
            if (string.length() != 1) {
                throw new JRRuntimeException("Character data \"" + string + "\" should be exactly one character long");
            }
            return new Character(string.charAt(0));
        }

        public String serialize(Object object) {
            return String.valueOf(new char[]{((Character)object).charValue()});
        }
    }

    protected static class StringSerializer
    implements ValueSerializer {
        public Object deserialize(String string) {
            return string;
        }

        public String serialize(Object object) {
            return (String)object;
        }
    }

    protected static interface ValueSerializer {
        public String serialize(Object var1);

        public Object deserialize(String var1);
    }
}

