/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.apache.commons.collections.ReferenceMap;

public class JRSingletonCache {
    private static final Object CONTEXT_KEY_NULL = new Object();
    private final ReferenceMap cache = new ReferenceMap(2, 1);
    private final Class itf;

    public JRSingletonCache(Class clazz) {
        this.itf = clazz;
    }

    public synchronized Object getCachedInstance(String string) throws JRException {
        Map map = this.getContextInstanceCache();
        Object object = map.get(string);
        if (object == null) {
            object = this.createInstance(string);
            map.put(string, object);
        }
        return object;
    }

    public Object createInstance(String string) throws JRException {
        try {
            Class clazz = JRClassLoader.loadClassForName(string);
            if (this.itf != null && !this.itf.isAssignableFrom(clazz)) {
                throw new JRException("Class \"" + string + "\" should be compatible with \"" + this.itf.getName() + "\"");
            }
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JRException("Class " + string + " not found.", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new JRException("Error instantiating class " + string + ".", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JRException("Error instantiating class " + string + ".", illegalAccessException);
        }
    }

    public Map getContextInstanceCache() {
        Object object = this.getContextKey();
        Map map = (Map)this.cache.get(object);
        if (map == null) {
            map = new ReferenceMap();
            this.cache.put(object, map);
        }
        return map;
    }

    public Object getContextKey() {
        Object object = Thread.currentThread().getContextClassLoader();
        if (object == null) {
            object = CONTEXT_KEY_NULL;
        }
        return object;
    }
}

