/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRResourcesUtil;

public class JRLoader {
    public static Class b;
    public static Class a;

    public static Object loadObject(String string) throws JRException {
        return JRLoader.loadObject(new File(string));
    }

    public static Object loadObject(File file) throws JRException {
        if (!file.exists() || !file.isFile()) {
            throw new JRException(new FileNotFoundException(String.valueOf(file)));
        }
        Object object = null;
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            objectInputStream = new ObjectInputStream(bufferedInputStream);
            object = objectInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new JRException("Error loading object from file : " + file, iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JRException("Class not found when loading object from file : " + file, classNotFoundException);
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return object;
    }

    public static Object loadObject(URL uRL) throws JRException {
        Object object = null;
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            inputStream = uRL.openStream();
            objectInputStream = new ObjectInputStream(inputStream);
            object = objectInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new JRException("Error loading object from URL : " + uRL, iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JRException("Class not found when loading object from URL : " + uRL, classNotFoundException);
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return object;
    }

    public static Object loadObject(InputStream inputStream) throws JRException {
        Object object = null;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(inputStream);
            object = objectInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new JRException("Error loading object from InputStream", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JRException("Class not found when loading object from InputStream", classNotFoundException);
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return object;
    }

    public static Object loadObjectFromLocation(String string) throws JRException {
        return JRLoader.loadObjectFromLocation(string, null, null);
    }

    public static Object loadObjectFromLocation(String string, ClassLoader classLoader) throws JRException {
        return JRLoader.loadObjectFromLocation(string, classLoader, null);
    }

    public static Object loadObjectFromLocation(String string, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) throws JRException {
        URL uRL = JRResourcesUtil.createURL(string, uRLStreamHandlerFactory);
        if (uRL != null) {
            return JRLoader.loadObject(uRL);
        }
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            return JRLoader.loadObject(file);
        }
        uRL = JRResourcesUtil.findClassLoaderResource(string, classLoader, b == null ? (b = JRLoader.a("net.sf.jasperreports.engine.util.JRLoader")) : b);
        if (uRL != null) {
            return JRLoader.loadObject(uRL);
        }
        throw new JRException("Could not load object from location : " + string);
    }

    public static byte[] loadBytes(File file) throws JRException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[10000];
            int n2 = 0;
            while ((n2 = fileInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new JRException("Error loading byte data : " + file, iOException);
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] loadBytes(URL uRL) throws JRException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[10000];
            int n2 = 0;
            while ((n2 = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new JRException("Error loading byte data : " + uRL, iOException);
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] loadBytes(InputStream inputStream) throws JRException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[10000];
            int n2 = 0;
            while ((n2 = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new JRException("Error loading byte data from input stream.", iOException);
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] loadBytesFromLocation(String string) throws JRException {
        return JRLoader.loadBytesFromLocation(string, null, null);
    }

    public static byte[] loadBytesFromLocation(String string, ClassLoader classLoader) throws JRException {
        return JRLoader.loadBytesFromLocation(string, classLoader, null);
    }

    public static byte[] loadBytesFromLocation(String string, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) throws JRException {
        URL uRL = JRResourcesUtil.createURL(string, uRLStreamHandlerFactory);
        if (uRL != null) {
            return JRLoader.loadBytes(uRL);
        }
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            return JRLoader.loadBytes(file);
        }
        uRL = JRResourcesUtil.findClassLoaderResource(string, classLoader, b == null ? (b = JRLoader.a("net.sf.jasperreports.engine.util.JRLoader")) : b);
        if (uRL != null) {
            return JRLoader.loadBytes(uRL);
        }
        throw new JRException("Byte data not found at location : " + string);
    }

    public static InputStream getLocationInputStream(String string) throws JRException {
        InputStream inputStream = null;
        inputStream = JRLoader.getResourceInputStream(string);
        if (inputStream == null) {
            inputStream = JRLoader.getFileInputStream(string);
        }
        if (inputStream == null) {
            inputStream = JRLoader.getURLInputStream(string);
        }
        return inputStream;
    }

    public static InputStream getFileInputStream(String string) throws JRException {
        FileInputStream fileInputStream = null;
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new JRException("Error opening file " + string);
            }
        }
        return fileInputStream;
    }

    public static InputStream getResourceInputStream(String string) {
        InputStream inputStream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            inputStream = classLoader.getResourceAsStream(string);
        }
        if (inputStream == null) {
            classLoader = (b == null ? (b = JRLoader.a("net.sf.jasperreports.engine.util.JRLoader")) : b).getClassLoader();
            if (classLoader != null) {
                inputStream = classLoader.getResourceAsStream(string);
            }
            if (inputStream == null) {
                inputStream = (a == null ? (a = JRLoader.a("net.sf.jasperreports.engine.util.JRProperties")) : a).getResourceAsStream("/" + string);
            }
        }
        return inputStream;
    }

    public static InputStream getURLInputStream(String string) throws JRException {
        InputStream inputStream = null;
        try {
            URL uRL = new URL(string);
            inputStream = uRL.openStream();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            throw new JRException("Error opening URL " + string);
        }
        return inputStream;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

