/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRDefaultImageEncoder;
import net.sf.jasperreports.engine.util.JRImageEncoder;
import net.sf.jasperreports.engine.util.JRImageReader;
import net.sf.jasperreports.engine.util.JRJdk13ImageReader;
import net.sf.jasperreports.engine.util.JRLoader;

public class JRImageLoader {
    public static final byte NO_IMAGE = 1;
    public static final byte SUBREPORT_IMAGE = 2;
    public static final byte CHART_IMAGE = 3;
    public static final byte CROSSTAB_IMAGE = 4;
    private static final String str_NO_IMAGE = "net/sf/jasperreports/engine/images/noimage.GIF";
    private static final String str_SUBREPORT_IMAGE = "net/sf/jasperreports/engine/images/subreport.GIF";
    private static final String str_CHART_IMAGE = "net/sf/jasperreports/engine/images/chart.GIF";
    private static final String str_CROSSTAB_IMAGE = "net/sf/jasperreports/engine/images/crosstab.GIF";
    private static Image img_NO_IMAGE;
    private static Image img_SUBREPORT_IMAGE;
    private static Image img_CHART_IMAGE;
    private static Image img_CROSSTAB_IMAGE;
    private static JRImageReader imageReader;
    private static JRImageEncoder imageEncoder;
    public static Class a;

    public static byte[] loadImageDataFromFile(File file) throws JRException {
        return JRLoader.loadBytes(file);
    }

    public static byte[] loadImageDataFromURL(URL uRL) throws JRException {
        return JRLoader.loadBytes(uRL);
    }

    public static byte[] loadImageDataFromInputStream(InputStream inputStream) throws JRException {
        return JRLoader.loadBytes(inputStream);
    }

    public static byte[] loadImageDataFromLocation(String string) throws JRException {
        return JRLoader.loadBytesFromLocation(string);
    }

    public static byte[] loadImageDataFromLocation(String string, ClassLoader classLoader) throws JRException {
        return JRLoader.loadBytesFromLocation(string, classLoader);
    }

    public static byte[] loadImageDataFromLocation(String string, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) throws JRException {
        return JRLoader.loadBytesFromLocation(string, classLoader, uRLStreamHandlerFactory);
    }

    public static byte[] loadImageDataFromAWTImage(Image image, byte by2) throws JRException {
        return imageEncoder.encode(image, by2);
    }

    public static byte[] loadImageDataFromAWTImage(BufferedImage bufferedImage) throws JRException {
        return JRImageLoader.loadImageDataFromAWTImage(bufferedImage, (byte)2);
    }

    public static byte[] loadImageDataFromAWTImage(Image image) throws JRException {
        return JRImageLoader.loadImageDataFromAWTImage(image, (byte)2);
    }

    public static Image getImage(byte by2) throws JRException {
        Image image = null;
        switch (by2) {
            case 1: {
                if (img_NO_IMAGE == null) {
                    img_NO_IMAGE = JRImageLoader.loadImage(str_NO_IMAGE);
                }
                image = img_NO_IMAGE;
                break;
            }
            case 2: {
                if (img_SUBREPORT_IMAGE == null) {
                    img_SUBREPORT_IMAGE = JRImageLoader.loadImage(str_SUBREPORT_IMAGE);
                }
                image = img_SUBREPORT_IMAGE;
                break;
            }
            case 3: {
                if (img_CHART_IMAGE == null) {
                    img_CHART_IMAGE = JRImageLoader.loadImage(str_CHART_IMAGE);
                }
                image = img_CHART_IMAGE;
                break;
            }
            case 4: {
                if (img_CROSSTAB_IMAGE == null) {
                    img_CROSSTAB_IMAGE = JRImageLoader.loadImage(str_CROSSTAB_IMAGE);
                }
                image = img_CROSSTAB_IMAGE;
            }
        }
        return image;
    }

    public static Image loadImage(byte[] byArray) throws JRException {
        return imageReader.readImage(byArray);
    }

    public static Image loadImage(String string) throws JRException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            classLoader = (a == null ? (a = JRImageLoader.a("net.sf.jasperreports.engine.util.JRImageLoader")) : a).getClassLoader();
        }
        InputStream inputStream = classLoader == null ? (a == null ? (a = JRImageLoader.a("net.sf.jasperreports.engine.util.JRImageLoader")) : a).getResourceAsStream("/" + string) : classLoader.getResourceAsStream(string);
        return imageReader.readImage(JRLoader.loadBytes(inputStream));
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz;
        img_NO_IMAGE = null;
        img_SUBREPORT_IMAGE = null;
        img_CHART_IMAGE = null;
        img_CROSSTAB_IMAGE = null;
        imageReader = null;
        imageEncoder = null;
        try {
            JRClassLoader.loadClassForRealName("javax.imageio.ImageIO");
            clazz = JRClassLoader.loadClassForRealName("net.sf.jasperreports.engine.util.JRJdk14ImageReader");
            imageReader = (JRImageReader)clazz.newInstance();
        }
        catch (Exception exception) {
            imageReader = new JRJdk13ImageReader();
        }
        try {
            JRClassLoader.loadClassForRealName("javax.imageio.ImageIO");
            clazz = JRClassLoader.loadClassForRealName("net.sf.jasperreports.engine.util.JRJdk14ImageEncoder");
            imageEncoder = (JRImageEncoder)clazz.newInstance();
        }
        catch (Exception exception) {
            imageEncoder = new JRDefaultImageEncoder();
        }
    }
}

