/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import com.keypoint.PngEncoderB;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRAbstractImageEncoder;

public class JRDefaultImageEncoder
extends JRAbstractImageEncoder {
    public byte[] encode(BufferedImage bufferedImage, byte by2) throws JRException {
        byte[] byArray = null;
        switch (by2) {
            case 3: {
                byArray = new PngEncoderB(bufferedImage).pngEncode();
                break;
            }
            case 2: {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)byteArrayOutputStream);
                    JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
                    jPEGEncodeParam.setQuality(1.0f, true);
                    jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
                }
                catch (IOException iOException) {
                    throw new JRException(iOException);
                }
                byArray = byteArrayOutputStream.toByteArray();
                break;
            }
            default: {
                throw new JRException("Image type \"" + by2 + "\" not supported by this image encoder.");
            }
        }
        return byArray;
    }
}

