/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileBufferedOutputStream
extends OutputStream {
    private static final Log log = LogFactory.getLog(a == null ? (a = FileBufferedOutputStream.a("net.sf.jasperreports.engine.util.FileBufferedOutputStream")) : a);
    public static final String PROPERTY_MEMORY_THRESHOLD = "net.sf.jasperreports.file.buffer.os.memory.threshold";
    public static final int INFINIT_MEMORY_THRESHOLD = -1;
    public static final int DEFAULT_INITIAL_MEMORY_BUFFER_SIZE = 65536;
    public static final int DEFAULT_INPUT_BUFFER_LENGTH = 16384;
    private final int memoryThreshold;
    private final int initialMemoryBufferSize;
    private final int inputBufferLength;
    private final ByteArrayOutputStream memoryOutput;
    private int size;
    private File file;
    private BufferedOutputStream fileOutput;
    private boolean closed;
    private boolean disposed;
    public static Class a;

    public FileBufferedOutputStream() {
        this(JRProperties.getIntegerProperty(PROPERTY_MEMORY_THRESHOLD, -1), 65536, 16384);
    }

    public FileBufferedOutputStream(int n2) {
        this(n2, 65536, 16384);
    }

    public FileBufferedOutputStream(int n2, int n3) {
        this(n2, n3, 16384);
    }

    public FileBufferedOutputStream(int n2, int n3, int n4) {
        this.memoryThreshold = n2;
        this.initialMemoryBufferSize = n3;
        this.inputBufferLength = n4;
        this.size = 0;
        if (this.memoryThreshold == 0) {
            this.memoryOutput = null;
        } else {
            int n5 = this.initialMemoryBufferSize;
            if (n5 > this.memoryThreshold) {
                n5 = this.memoryThreshold;
            }
            this.memoryOutput = new ByteArrayOutputStream(n5);
        }
    }

    public void write(int n2) throws IOException {
        this.checkClosed();
        if (this.availableMemorySpace() > 0) {
            this.memoryOutput.write(n2);
        } else {
            this.ensureFileOutput().write(n2);
        }
        ++this.size;
    }

    public int availableMemorySpace() {
        int n2 = this.memoryOutput != null && (this.memoryThreshold < 0 || this.memoryOutput.size() < this.memoryThreshold) ? this.memoryThreshold - this.memoryOutput.size() : 0;
        return n2;
    }

    public BufferedOutputStream ensureFileOutput() throws IOException, FileNotFoundException {
        if (this.fileOutput == null) {
            this.file = File.createTempFile("file.buff.os.", ".tmp");
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            this.fileOutput = new BufferedOutputStream(fileOutputStream);
        }
        return this.fileOutput;
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.checkClosed();
        int n4 = this.availableMemorySpace();
        if (n3 < n4) {
            n4 = n3;
        }
        if (n4 > 0) {
            this.memoryOutput.write(byArray, n2, n4);
        }
        if (n4 < n3) {
            this.ensureFileOutput().write(byArray, n2 + n4, n3 - n4);
        }
        this.size += n3;
    }

    public void checkClosed() {
        if (this.closed) {
            throw new JRRuntimeException("Output stream already closed.");
        }
    }

    public void close() throws IOException {
        if (!this.closed && this.fileOutput != null) {
            this.fileOutput.flush();
            this.fileOutput.close();
        }
        this.closed = true;
    }

    public void flush() throws IOException {
        if (this.fileOutput != null) {
            this.fileOutput.flush();
        }
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(OutputStream outputStream) throws IOException {
        if (!this.closed) {
            this.close();
        }
        if (this.memoryOutput != null) {
            this.memoryOutput.writeTo(outputStream);
        }
        if (this.file != null) {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            boolean bl2 = false;
            try {
                int n2;
                byte[] byArray = new byte[this.inputBufferLength];
                while ((n2 = fileInputStream.read(byArray)) > 0) {
                    outputStream.write(byArray, 0, n2);
                }
                fileInputStream.close();
                bl2 = true;
            }
            finally {
                if (!bl2) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        log.warn("Could not close file input stream", iOException);
                    }
                }
            }
        }
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        boolean bl2 = true;
        if (!this.closed && this.fileOutput != null) {
            try {
                this.fileOutput.close();
            }
            catch (IOException iOException) {
                log.warn("Error while closing the temporary file output stream", iOException);
                bl2 = false;
            }
        }
        if (this.file != null && !this.file.delete()) {
            log.warn("Error while deleting the temporary file");
            bl2 = false;
        }
        this.disposed = bl2;
    }

    public void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public InputStream getDataInputStream() throws IOException {
        if (!this.closed) {
            this.close();
        }
        return new DataStream(this);
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static ByteArrayOutputStream a(FileBufferedOutputStream fileBufferedOutputStream) {
        return fileBufferedOutputStream.memoryOutput;
    }

    public static File b(FileBufferedOutputStream fileBufferedOutputStream) {
        return fileBufferedOutputStream.file;
    }

    protected class DataStream
    extends InputStream {
        private int memoryIdx;
        private final byte[] memoryData;
        private final FileInputStream fileInput;
        private final FileBufferedOutputStream this$0;

        public DataStream(FileBufferedOutputStream fileBufferedOutputStream) throws FileNotFoundException {
            this.this$0 = fileBufferedOutputStream;
            this.memoryIdx = 0;
            this.memoryData = FileBufferedOutputStream.a(fileBufferedOutputStream) == null ? new byte[]{} : FileBufferedOutputStream.a(fileBufferedOutputStream).toByteArray();
            this.fileInput = FileBufferedOutputStream.b(fileBufferedOutputStream) == null ? null : new FileInputStream(FileBufferedOutputStream.b(fileBufferedOutputStream));
        }

        public synchronized int read() throws IOException {
            int n2;
            if (this.memoryIdx < this.memoryData.length) {
                n2 = this.memoryData[this.memoryIdx];
                ++this.memoryIdx;
            } else {
                n2 = this.fileInput != null ? this.fileInput.read() : -1;
            }
            return n2;
        }

        public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4;
            int n5;
            if (n3 <= 0) {
                return 0;
            }
            if (this.memoryIdx < this.memoryData.length) {
                n5 = n3;
                if (n5 > this.memoryData.length - this.memoryIdx) {
                    n5 = this.memoryData.length - this.memoryIdx;
                }
                System.arraycopy(this.memoryData, this.memoryIdx, byArray, n2, n5);
                this.memoryIdx += n5;
            } else {
                n5 = 0;
            }
            if (n5 < n3 && this.fileInput != null && (n4 = this.fileInput.read(byArray, n2 + n5, n3 - n5)) > 0) {
                n5 += n4;
            }
            return n5 == 0 ? -1 : n5;
        }

        public void close() throws IOException {
            if (this.fileInput != null) {
                this.fileInput.close();
            }
        }

        public synchronized int available() throws IOException {
            int n2 = this.memoryData.length - this.memoryIdx;
            if (this.fileInput != null) {
                n2 += this.fileInput.available();
            }
            return n2;
        }

        public synchronized long skip(long l2) throws IOException {
            long l3;
            if (l2 <= 0L) {
                return 0L;
            }
            if (this.memoryIdx < this.memoryData.length) {
                l3 = l2;
                if (l3 > (long)(this.memoryData.length - this.memoryIdx)) {
                    l3 = this.memoryData.length - this.memoryIdx;
                }
                this.memoryIdx = (int)((long)this.memoryIdx + l3);
            } else {
                l3 = 0L;
            }
            if (l3 < l2 && this.fileInput != null) {
                l3 += this.fileInput.skip(l2 - l3);
            }
            return l3;
        }
    }
}

