/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.print;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;

public class JRPrinterAWT
implements Printable {
    private JasperPrint jasperPrint = null;
    private int pageOffset = 0;

    public JRPrinterAWT(JasperPrint jasperPrint) throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
        this.jasperPrint = jasperPrint;
    }

    public static boolean printPages(JasperPrint jasperPrint, int n2, int n3, boolean bl2) throws JRException {
        JRPrinterAWT jRPrinterAWT = new JRPrinterAWT(jasperPrint);
        return jRPrinterAWT.printPages(n2, n3, bl2);
    }

    public static Image printPageToImage(JasperPrint jasperPrint, int n2, float f2) throws JRException {
        JRPrinterAWT jRPrinterAWT = new JRPrinterAWT(jasperPrint);
        return jRPrinterAWT.printPageToImage(n2, f2);
    }

    private boolean printPages(int n2, int n3, boolean bl2) throws JRException {
        boolean bl3 = true;
        if (n2 < 0 || n2 > n3 || n3 >= this.jasperPrint.getPages().size()) {
            throw new JRException("Invalid page index range : " + n2 + " - " + n3 + " of " + this.jasperPrint.getPages().size());
        }
        this.pageOffset = n2;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        JRPrinterAWT.initPrinterJobFields(printerJob);
        PageFormat pageFormat = printerJob.defaultPage();
        Paper paper = pageFormat.getPaper();
        printerJob.setJobName("JasperReports - " + this.jasperPrint.getName());
        switch (this.jasperPrint.getOrientation()) {
            case 2: {
                pageFormat.setOrientation(0);
                paper.setSize(this.jasperPrint.getPageHeight(), this.jasperPrint.getPageWidth());
                paper.setImageableArea(0.0, 0.0, this.jasperPrint.getPageHeight(), this.jasperPrint.getPageWidth());
                break;
            }
            default: {
                pageFormat.setOrientation(1);
                paper.setSize(this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
                paper.setImageableArea(0.0, 0.0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
            }
        }
        pageFormat.setPaper(paper);
        Book book = new Book();
        book.append(this, pageFormat, n3 - n2 + 1);
        printerJob.setPageable(book);
        try {
            if (bl2) {
                if (printerJob.printDialog()) {
                    printerJob.print();
                } else {
                    bl3 = false;
                }
            } else {
                printerJob.print();
            }
        }
        catch (Exception exception) {
            throw new JRException("Error printing report.", exception);
        }
        return bl3;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n2) throws PrinterException {
        if (Thread.currentThread().isInterrupted()) {
            throw new PrinterException("Current thread interrupted.");
        }
        if ((n2 += this.pageOffset) < 0 || n2 >= this.jasperPrint.getPages().size()) {
            return 1;
        }
        try {
            JRGraphics2DExporter jRGraphics2DExporter = new JRGraphics2DExporter();
            jRGraphics2DExporter.setParameter(JRExporterParameter.JASPER_PRINT, this.jasperPrint);
            jRGraphics2DExporter.setParameter(JRGraphics2DExporterParameter.GRAPHICS_2D, graphics);
            jRGraphics2DExporter.setParameter(JRExporterParameter.PAGE_INDEX, new Integer(n2));
            jRGraphics2DExporter.exportReport();
        }
        catch (JRException jRException) {
            jRException.printStackTrace();
            throw new PrinterException(jRException.getMessage());
        }
        return 0;
    }

    private Image printPageToImage(int n2, float f2) throws JRException {
        BufferedImage bufferedImage = new BufferedImage((int)((float)this.jasperPrint.getPageWidth() * f2) + 1, (int)((float)this.jasperPrint.getPageHeight() * f2) + 1, 1);
        JRGraphics2DExporter jRGraphics2DExporter = new JRGraphics2DExporter();
        jRGraphics2DExporter.setParameter(JRExporterParameter.JASPER_PRINT, this.jasperPrint);
        jRGraphics2DExporter.setParameter(JRGraphics2DExporterParameter.GRAPHICS_2D, ((Image)bufferedImage).getGraphics());
        jRGraphics2DExporter.setParameter(JRExporterParameter.PAGE_INDEX, new Integer(n2));
        jRGraphics2DExporter.setParameter(JRGraphics2DExporterParameter.ZOOM_RATIO, new Float(f2));
        jRGraphics2DExporter.exportReport();
        return bufferedImage;
    }

    public static void initPrinterJobFields(PrinterJob printerJob) {
        Class<?> clazz = printerJob.getClass();
        try {
            Class<?> clazz2 = Class.forName("javax.print.PrintService");
            Method method = clazz.getMethod("getPrintService", null);
            Object object = method.invoke((Object)printerJob, (Object[])null);
            method = clazz.getMethod("setPrintService", clazz2);
            method.invoke((Object)printerJob, object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static long getImageSize(JasperPrint jasperPrint, float f2) {
        int n2 = (int)((float)jasperPrint.getPageWidth() * f2) + 1;
        int n3 = (int)((float)jasperPrint.getPageHeight() * f2) + 1;
        return n2 * n3;
    }
}

