/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRCommonText;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.fill.JRMeasuredText;
import net.sf.jasperreports.engine.fill.JRTextMeasurer;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.MaxFontSizeFinder;

public class TextMeasurer
implements JRTextMeasurer {
    private static final FontRenderContext FONT_RENDER_CONTEXT = TextRenderer.LINE_BREAK_FONT_RENDER_CONTEXT;
    private JRCommonText textElement;
    private JRPropertiesHolder propertiesHolder;
    private MaxFontSizeFinder maxFontSizeFinder = null;
    private int width = 0;
    private int height = 0;
    private int topPadding = 0;
    private int leftPadding = 0;
    private int bottomPadding = 0;
    private int rightPadding = 0;
    private float lineSpacing = 0.0f;
    private float formatWidth = 0.0f;
    private int maxHeight = 0;
    private boolean canOverflow;
    private Map globalAttributes;
    private TextMeasuredState measuredState;
    private TextMeasuredState prevMeasuredState;

    public TextMeasurer(JRCommonText jRCommonText) {
        this.textElement = jRCommonText;
        this.propertiesHolder = jRCommonText instanceof JRPropertiesHolder ? (JRPropertiesHolder)((Object)jRCommonText) : null;
    }

    public void initialize(JRStyledText jRStyledText, int n2, boolean bl2) {
        this.width = this.textElement.getWidth();
        this.height = this.textElement.getHeight();
        this.topPadding = this.textElement.getLineBox().getTopPadding();
        this.leftPadding = this.textElement.getLineBox().getLeftPadding();
        this.bottomPadding = this.textElement.getLineBox().getBottomPadding();
        this.rightPadding = this.textElement.getLineBox().getRightPadding();
        switch (this.textElement.getRotation()) {
            case 1: {
                this.width = this.textElement.getHeight();
                this.height = this.textElement.getWidth();
                int n3 = this.topPadding;
                this.topPadding = this.leftPadding;
                this.leftPadding = this.bottomPadding;
                this.bottomPadding = this.rightPadding;
                this.rightPadding = n3;
                break;
            }
            case 2: {
                this.width = this.textElement.getHeight();
                this.height = this.textElement.getWidth();
                int n4 = this.topPadding;
                this.topPadding = this.rightPadding;
                this.rightPadding = this.bottomPadding;
                this.bottomPadding = this.leftPadding;
                this.leftPadding = n4;
                break;
            }
            case 3: {
                int n5 = this.topPadding;
                this.topPadding = this.bottomPadding;
                this.bottomPadding = n5;
                n5 = this.leftPadding;
                this.leftPadding = this.rightPadding;
                this.rightPadding = n5;
                break;
            }
        }
        switch (this.textElement.getLineSpacing()) {
            case 0: {
                this.lineSpacing = 1.0f;
                break;
            }
            case 1: {
                this.lineSpacing = 1.5f;
                break;
            }
            case 2: {
                this.lineSpacing = 2.0f;
                break;
            }
            default: {
                this.lineSpacing = 1.0f;
            }
        }
        this.maxFontSizeFinder = MaxFontSizeFinder.getInstance(this.textElement.isStyledText());
        this.formatWidth = this.width - this.leftPadding - this.rightPadding;
        this.formatWidth = this.formatWidth < 0.0f ? 0.0f : this.formatWidth;
        this.maxHeight = this.height + n2 - this.topPadding - this.bottomPadding;
        this.maxHeight = this.maxHeight < 0 ? 0 : this.maxHeight;
        this.canOverflow = bl2;
        this.globalAttributes = jRStyledText.getGlobalAttributes();
        this.measuredState = new TextMeasuredState();
        this.prevMeasuredState = null;
    }

    public JRMeasuredText measure(JRStyledText jRStyledText, int n2, int n3, boolean bl2) {
        this.initialize(jRStyledText, n3, bl2);
        AttributedCharacterIterator attributedCharacterIterator = jRStyledText.getAttributedString().getIterator();
        int n4 = n2;
        int n5 = n2;
        String string = null;
        String string2 = jRStyledText.getText().substring(n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n", true);
        boolean bl3 = true;
        while (stringTokenizer.hasMoreTokens() && bl3) {
            String string3 = stringTokenizer.nextToken();
            if ("\n".equals(string3)) {
                bl3 = this.renderParagraph(attributedCharacterIterator, n5, string);
                n5 = n4 + (stringTokenizer.hasMoreTokens() || n4 == 0 ? 1 : 0);
                string = null;
            } else {
                n5 = n4;
                string = string3;
            }
            n4 += string3.length();
        }
        if (bl3 && n5 < n2 + string2.length()) {
            this.renderParagraph(attributedCharacterIterator, n5, string);
        }
        return this.measuredState;
    }

    public boolean renderParagraph(AttributedCharacterIterator attributedCharacterIterator, int n2, String string) {
        AttributedCharacterIterator attributedCharacterIterator2 = null;
        attributedCharacterIterator2 = string == null ? new AttributedString(" ", new AttributedString(attributedCharacterIterator, n2, n2 + 1).getIterator().getAttributes()).getIterator() : new AttributedString(attributedCharacterIterator, n2, n2 + string.length()).getIterator();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator2, FONT_RENDER_CONTEXT);
        this.measuredState.textOffset = n2;
        boolean bl2 = true;
        boolean bl3 = false;
        while (lineBreakMeasurer.getPosition() < attributedCharacterIterator2.getEndIndex() && bl2) {
            bl2 = this.renderNextLine(lineBreakMeasurer, attributedCharacterIterator2);
            bl3 = bl3 || bl2;
        }
        if (!bl2 && this.prevMeasuredState != null && !this.canOverflow) {
            this.processLastTruncatedRow(attributedCharacterIterator, string, n2, bl3);
        }
        return bl2;
    }

    public void processLastTruncatedRow(AttributedCharacterIterator attributedCharacterIterator, String string, int n2, boolean bl2) {
        if (bl2 && this.isToTruncateAtChar()) {
            this.truncateLastLineAtChar(attributedCharacterIterator, string, n2);
        }
        this.appendTruncateSuffix(attributedCharacterIterator);
    }

    public void truncateLastLineAtChar(AttributedCharacterIterator attributedCharacterIterator, String string, int n2) {
        this.measuredState = this.prevMeasuredState.cloneState();
        AttributedCharacterIterator attributedCharacterIterator2 = new AttributedString(attributedCharacterIterator, this.measuredState.textOffset, n2 + string.length()).getIterator();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator2, BreakIterator.getCharacterInstance(), FONT_RENDER_CONTEXT);
        this.renderNextLine(lineBreakMeasurer, attributedCharacterIterator2);
    }

    public void appendTruncateSuffix(AttributedCharacterIterator attributedCharacterIterator) {
        String string = this.getTruncateSuffix();
        if (string == null) {
            return;
        }
        int n2 = this.prevMeasuredState.textOffset;
        StringBuffer stringBuffer = new StringBuffer();
        attributedCharacterIterator.setIndex(n2);
        while (attributedCharacterIterator.getIndex() < this.measuredState.textOffset && attributedCharacterIterator.current() != '\n') {
            stringBuffer.append(attributedCharacterIterator.current());
            attributedCharacterIterator.next();
        }
        int n3 = attributedCharacterIterator.getIndex() - n2;
        boolean bl2 = false;
        do {
            this.measuredState = this.prevMeasuredState.cloneState();
            String string2 = stringBuffer.substring(0, n3) + string;
            AttributedString attributedString = new AttributedString(string2);
            AttributedCharacterIterator attributedCharacterIterator2 = new AttributedString(attributedCharacterIterator, this.measuredState.textOffset, this.measuredState.textOffset + n3).getIterator();
            this.setAttributes(attributedString, attributedCharacterIterator2, 0);
            this.setAttributes(attributedString, this.globalAttributes, string2.length() - string.length(), string2.length());
            AttributedCharacterIterator attributedCharacterIterator3 = attributedString.getIterator();
            BreakIterator breakIterator = this.isToTruncateAtChar() ? BreakIterator.getCharacterInstance() : BreakIterator.getLineInstance();
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator3, breakIterator, FONT_RENDER_CONTEXT);
            if (this.renderNextLine(lineBreakMeasurer, attributedCharacterIterator3)) {
                int n4 = lineBreakMeasurer.getPosition();
                if (n4 == n3 + string.length()) {
                    this.measuredState.textOffset -= string.length();
                    this.measuredState.textSuffix = string;
                    bl2 = true;
                    continue;
                }
                if ((n3 = breakIterator.preceding(n3)) != -1) continue;
                String string3 = string.substring(0, this.measuredState.textOffset - this.prevMeasuredState.textOffset);
                if (this.prevMeasuredState.textOffset > 0 && attributedCharacterIterator.setIndex(this.prevMeasuredState.textOffset - 1) != '\n') {
                    string3 = '\n' + string3;
                }
                this.measuredState.textSuffix = string3;
                this.measuredState.textOffset = this.prevMeasuredState.textOffset;
                bl2 = true;
                continue;
            }
            bl2 = true;
        } while (!bl2);
    }

    public boolean isToTruncateAtChar() {
        return JRProperties.getBooleanProperty(this.propertiesHolder, "net.sf.jasperreports.text.truncate.at.char", false);
    }

    public String getTruncateSuffix() {
        String string = JRProperties.getProperty(this.propertiesHolder, "net.sf.jasperreports.text.truncate.suffix");
        if (string != null) {
            string = string.trim();
        }
        if (string.length() == 0) {
            string = null;
        }
        return string;
    }

    public boolean renderNextLine(LineBreakMeasurer lineBreakMeasurer, AttributedCharacterIterator attributedCharacterIterator) {
        boolean bl2;
        int n2 = lineBreakMeasurer.getPosition();
        TextLayout textLayout = lineBreakMeasurer.nextLayout(this.formatWidth);
        float f2 = this.measuredState.textHeight + textLayout.getLeading() + this.lineSpacing * textLayout.getAscent();
        boolean bl3 = bl2 = f2 + textLayout.getDescent() <= (float)this.maxHeight;
        if (bl2) {
            this.prevMeasuredState = this.measuredState.cloneState();
            this.measuredState.isLeftToRight = this.measuredState.isLeftToRight && textLayout.isLeftToRight();
            this.measuredState.textHeight = f2;
            ++this.measuredState.lines;
            this.measuredState.fontSizeSum += this.maxFontSizeFinder.findMaxFontSize(new AttributedString(attributedCharacterIterator, n2, n2 + textLayout.getCharacterCount()).getIterator(), this.textElement.getFontSize());
            if (this.measuredState.lines == 1) {
                this.measuredState.firstLineLeading = this.measuredState.textHeight;
                this.measuredState.firstLineMaxFontSize = this.measuredState.fontSizeSum;
            }
            this.measuredState.textHeight += textLayout.getDescent();
            this.measuredState.textOffset += lineBreakMeasurer.getPosition() - n2;
        }
        return bl2;
    }

    public JRPropertiesHolder getTextPropertiesHolder() {
        return this.propertiesHolder;
    }

    public void setAttributes(AttributedString attributedString, AttributedCharacterIterator attributedCharacterIterator, int n2) {
        char c2 = attributedCharacterIterator.first();
        while (c2 != '\uffff') {
            Iterator<Map.Entry<AttributedCharacterIterator.Attribute, Object>> iterator = attributedCharacterIterator.getAttributes().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<AttributedCharacterIterator.Attribute, Object> entry = iterator.next();
                AttributedCharacterIterator.Attribute attribute = entry.getKey();
                if (attributedCharacterIterator.getRunStart(attribute) != attributedCharacterIterator.getIndex()) continue;
                Object object = entry.getValue();
                attributedString.addAttribute(attribute, object, attributedCharacterIterator.getIndex() + n2, attributedCharacterIterator.getRunLimit(attribute) + n2);
            }
            c2 = attributedCharacterIterator.next();
        }
    }

    public void setAttributes(AttributedString attributedString, Map map, int n2, int n3) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)entry.getKey();
            Object v2 = entry.getValue();
            attributedString.addAttribute(attribute, v2, n2, n3);
        }
    }

    protected static class TextMeasuredState
    implements JRMeasuredText,
    Cloneable {
        public int textOffset = 0;
        public int lines = 0;
        public int fontSizeSum = 0;
        public int firstLineMaxFontSize = 0;
        public float textHeight = 0.0f;
        public float firstLineLeading = 0.0f;
        public boolean isLeftToRight = true;
        public String textSuffix = null;

        public boolean isLeftToRight() {
            return this.isLeftToRight;
        }

        public int getTextOffset() {
            return this.textOffset;
        }

        public float getTextHeight() {
            return this.textHeight;
        }

        public float getLineSpacingFactor() {
            if (this.lines > 0) {
                return this.textHeight / (float)this.fontSizeSum;
            }
            return 0.0f;
        }

        public float getLeadingOffset() {
            return this.firstLineLeading - (float)this.firstLineMaxFontSize * this.getLineSpacingFactor();
        }

        public String getTextSuffix() {
            return this.textSuffix;
        }

        public TextMeasuredState cloneState() {
            try {
                return (TextMeasuredState)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new JRRuntimeException(cloneNotSupportedException);
            }
        }
    }
}

