/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;
import net.sf.jasperreports.engine.util.JRSwapFile;

public class JRSwapFileVirtualizer
extends JRAbstractLRUVirtualizer {
    private final JRSwapFile swap;
    private final boolean swapOwner;
    private final Map handles;

    public JRSwapFileVirtualizer(int n2, JRSwapFile jRSwapFile) {
        this(n2, jRSwapFile, true);
    }

    public JRSwapFileVirtualizer(int n2, JRSwapFile jRSwapFile, boolean bl2) {
        super(n2);
        this.swap = jRSwapFile;
        this.swapOwner = bl2;
        this.handles = Collections.synchronizedMap(new HashMap());
    }

    public void pageOut(JRVirtualizable jRVirtualizable) throws IOException {
        if (!this.handles.containsKey(jRVirtualizable.getUID())) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(3000);
            this.writeData(jRVirtualizable, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            JRSwapFile.SwapHandle swapHandle = this.swap.write(byArray);
            this.handles.put(jRVirtualizable.getUID(), swapHandle);
        } else if (!this.isReadOnly(jRVirtualizable)) {
            throw new IllegalStateException("Cannot virtualize data because the data for object UID \"" + jRVirtualizable.getUID() + "\" already exists.");
        }
    }

    public void pageIn(JRVirtualizable jRVirtualizable) throws IOException {
        JRSwapFile.SwapHandle swapHandle = (JRSwapFile.SwapHandle)this.handles.get(jRVirtualizable.getUID());
        byte[] byArray = this.swap.read(swapHandle, !this.isReadOnly(jRVirtualizable));
        this.readData(jRVirtualizable, new ByteArrayInputStream(byArray));
        if (!this.isReadOnly(jRVirtualizable)) {
            this.handles.remove(jRVirtualizable.getUID());
        }
    }

    public void dispose(String string) {
        JRSwapFile.SwapHandle swapHandle = (JRSwapFile.SwapHandle)this.handles.remove(string);
        if (swapHandle != null) {
            this.swap.free(swapHandle);
        }
    }

    public void cleanup() {
        this.handles.clear();
        if (this.swapOwner) {
            this.swap.dispose();
        }
    }
}

