/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRIntegerIncrementerFactory;

public class JRIntegerCountIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRIntegerCountIncrementer mainInstance = new JRIntegerCountIncrementer();

    private JRIntegerCountIncrementer() {
    }

    public static JRIntegerCountIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRCalculable jRCalculable, Object object, AbstractValueProvider abstractValueProvider) {
        Number number = (Number)jRCalculable.getIncrementedValue();
        if (number == null || jRCalculable.isInitialized()) {
            number = JRIntegerIncrementerFactory.ZERO;
        }
        if (object == null) {
            return number;
        }
        return new Integer(number.intValue() + 1);
    }

    public Object combine(JRCalculable jRCalculable, JRCalculable jRCalculable2, AbstractValueProvider abstractValueProvider) {
        Number number = (Number)jRCalculable.getIncrementedValue();
        Number number2 = (Number)jRCalculable2.getValue();
        if (number == null || jRCalculable.isInitialized()) {
            number = JRIntegerIncrementerFactory.ZERO;
        }
        if (number2 == null) {
            return number;
        }
        return new Integer(number.intValue() + number2.intValue());
    }

    public Object initialValue() {
        return JRIntegerIncrementerFactory.ZERO;
    }
}

